;
; GRDP
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
;
; DRIVE.ASM
;
; Function: Handle logical drive functions
;
	;MASM MODE
	.MODEL SMALL
	.386


include  eprints.inc 
include  einput.inc 
include  emtrap.inc 

	PUBLIC drive

	.data
int24ParmBlock	dd	0	;int 24/24 parameter block
		dw	0
		dd	0

	.CODE
drive	PROC
	lodsb
	cmp	al,'r'		; verify subcommand
	jz	ok
	cmp	al,'w'
	jz	ok
	stc
	ret
ok:
	cmp	al,'r'
	pushf
	call	WadeSpace
	cmp	al,'a'		; get drive
	jc	err1
	cmp	al,'z'
	ja	err1
	sub	al,'a'
	inc	si
	push	ax
	cmp	byte ptr [si],':'
	jnz	noinc
	inc	si
noinc:
	call	WadeSpace
	jz	err2
	call	ReadAddress	; get buffer address
	jc	err2
	call	defDS		; get DS
	mov	word ptr [int24ParmBlock+6],bx	; set up parameter block
	mov	word ptr [int24ParmBlock+8],dx
	call	WadeSpace
	jz	err2
	call	ReadNumber		; get start
	jc	err2
	mov	dword ptr [int24ParmBlock],eax
	mov	word ptr [int24ParmBlock+4],1
	call	WadeSpace
	jz	nosize
	call	ReadNumber		; get size
	jc	err2
	mov	word ptr [int24ParmBlock+4],ax
	call	WadeSpace
	jnz	err2
nosize:
	pop	ax
	mov	cx,-1
	mov	bx,offset int24ParmBlock
	popf                 		; figure out what to do
	jz	doread
	int	26h
	jmp	combine
doread:
	int	25h
combine:
	jnc	noerr
	push	ax
	PRINT_MESSAGE	<13,10,"Error: ">
	pop	ax
	call	printword
noerr:
	add	sp,2      		; stupid INT 25/26 leaves flags on stack
	clc
	ret
err2:
	pop	ax
err1:
	popf
	stc
	ret
drive	endp
end