;
; GRDP
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
;
; Entry.asm
;
; Function: handle hex data entry
;
	;MASM MODE
	.model small
	.386


include  eprints.inc 
include  einput.inc 
include  emtrap.inc 
include eoptions.inc

	PUBLIC	entry

	.data
InsideQuote	db	0	;flag if we're inside a quote

	.code
;
; Input function for a number
;
InputNumber	PROC	
	mov	[InsideQuote],0
	push	dx
	push	cx
	push	bx
	sub	cx,cx 		; Number of digits = 0
	sub	bx,bx			; Data = 0
lp:
	call	GetKey
	mov	ah,al			; AH = data
	cmp	al,' '			; Space, data is complete
	jz	space		;
	cmp	al,13			;
	jz	isenter		; ENTER = quit entering data
	cmp	al,8			; BACKSPACE or RUBOUT, handle it
	jz	bckspc		;
	cmp	al,7fh			;
	jz	bckspc		;
	cmp	al,'"'
	jz	quote
	cmp	al,"'"
	jz	quote
	test	[InsideQuote],1
	jnz	isquote
	cmp	al,60h
	jc	notlower
	and	al,NOT 20h
notlower:
	sub	al,'0'			; Convert to binary, ignore if not valid
	jc	lp			;
	cmp	al,10			;
	jc	gotdigit		;
	sub	al,7			;
	cmp	al,10			;
	jc	lp			;
	cmp	al,16			;
	jnc	lp			;
gotdigit:
	cmp	cl,2			; If got two digits don't accept
	jz	lp
	shl	bl,4			; Add in the digit
	or	bl,al			;
writechar:
	mov	dl,ah			;
	call	PutChar
	inc	ecx			; Inc digit count
	jmp	lp			; Next digit
isquote:
	cmp	cl,2
	jz	lp
	mov	bl,al
	jmp	writechar
bckspc:
	or	cx,cx			; Get next digit if nothing in buffer
	jz	lp			;
	test	[InsideQuote],1
	jz	delnoquote
	cmp	cl,2
	jz	delnoquote
	xor	[InsideQuote],1
delnoquote:
	shr	bl,4
	mov	dl,8			; Erase echoed char
	call	PutChar
	mov	dl,' '			;
	call	PutChar
	mov	dl,8			; Point at next echo space
	call	PutChar
	dec	cx			; Dec digit count
	jmp	lp
isenter:
	or	cx,cx			; Enter key, set carry and get out
	stc				;
	jmp	getout
quote:
	test	[InsideQuote],1
	jnz	lp
	xor	[InsideQuote],1
	jmp	writechar
space:
	or	cl,cl			; Space key, clear carry and get out
getout:
	pushf
	mov	al,3			; Space to line up in columns
	sub	al,cl			;
	mov	cl,al			;
pslp:			
	call	printspace		;
	loop	pslp			;
	popf				;
	mov	ax,bx			; AX = number input
	pop	bx
	pop	cx
	pop	dx
	ret
InputNumber	ENDP	
;
; Number entry with prompt
;
entry	PROC	
	call	WadeSpace		; Wade through commad spaces
	jz	enterr
	call	ReadAddress		; Read the address
	jc	enterr			; Bad address ,error
	test	[optdwordcommand],0ffh
	jnz	oklarge
	movzx	ebx,bx
oklarge:
	call	defDS			; get DS
	mov	fs,dx
	mov	edi,ebx
	mov	cx,-1			;
	call	WadeSpace		; Wade through spaces
	jz	promptx		; Go do prompt version
readlp:
	call	ReadNumber		; Else read number off command line
	jc	enterr2			; Quit if error
	mov	fs:[edi],al		; Save value
	inc	edi			; Point to next input pos
	call	WadeSpace		; Wade through spaces
	jz	retok		;
	jmp	readlp			; Else get next value
promptx:
	call	crlf
	mov	ax,dx			; Print segment
	call	PrintWord		;
	push	dx			;
	mov	dl,':'			; Print ':'
	call	PutChar
	pop	dx			;
	mov	eax,ebx                 ;
	test	[optdwordcommand],0ffh
	jz	adrword
	call	PrintdWord	; Print address
	jmp	adrcmb
adrword:
	call	PrintWord
adrcmb:
elp:
	call	printspace		; Space over two spaces
	call	printspace		;
	mov	al,fs:[edi]		; Print current value
	call	printbyte		;
	push	dx			;
	mov	dl,'.'			; Print '.'
	call	PutChar
	pop	dx			;
	push	cx
	call	InputNumber		; Get a number
	pop	cx
	jz	nextitem		; No number, go do next
	mov	fs:[edi],al		; Save value
nextitem:
	jc	retok		; Quit if ENTER key pressed
	dec	cx			; Quit if end of segment
	jz	retok		;
	inc	edi			; Point at next value
	inc	ebx			; Next address
	test	[optdwordcommand],0ffh
	jnz	cont
	cmp	ebx,10000h
	jz	retok
cont:
	test	ebx,7			; If address mod 7 = 0
	jz	promptx			; Do another prompt
	jmp	elp
retok:
	clc				; No errors
	ret
enterr2:
enterr:		
	stc     			; Errors
dudone:
	ret
entry	ENDP	
END