;
; GRDB
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
;
; MOVE.ASM
;
; Function: move memory regions
;
	;MASM MODE
	.MODEL SMALL
	.386


include  eprints.inc 
include  einput.inc 
include  emtrap.inc 
include eoptions.inc

	PUBLIC move


	.CODE
mra	PROC
	call	ReadAddress		; read source address
	jc	mrax
	test	[optdwordcommand],1
	jnz	nomvz
	movzx	ebx,bx
nomvz:
	call	defDS			; get DS
mrax:
	ret
mra	ENDP
;
; move command
;
move	PROC
	call	WadeSpace
	jz	errx
	call	mra 			; read source
	jc	errx
	push	dx
	push	ebx
	call	WadeSpace
	jz	errx2
	call	ReadNumber		; read end of source
	jc	errx2
	mov	ecx,eax
	sub	ecx,ebx
	jb	errx2
	call	WadeSpace
	jz	errx2
	call	mra			; read dest
	jc	errx2
	call	WadeSpace
	jnz	errx2
	test	[optdwordcommand],1
	jnz	gotsz
	movzx	ebx,bx
	movzx	ecx,cx
	movzx	eax,word ptr [esp]
	mov	[esp],eax
gotsz:
	movzx	eax,dx			; ok no compare the args
	shl	eax,4
	add	eax,ebx
	push	eax    			; TOS = dest
	movzx	eax,word ptr [esp+8]		; EAX = source
	shl	eax,4
	add	eax,[esp+4]
	cmp	eax,[esp]
	jz	noop
	jl	sld
sgd:
	push	es   			; when source greater than dest
	push	ds			; do a move down
	mov	edi,ebx
	mov	es,dx
	mov	esi,[esp+4+4]
	mov	ds,[esp+8+4]
	db	67h
	rep	movsb
	pop	ds
	pop	es
	jmp	noop
sld:
	push	es			; when dest greater than source
	push	ds			; do a move up
	mov	edi,ebx
	mov	es,dx
	mov	esi,[esp+4+4]
	mov	ds,[esp+8+4]
	lea	esi,[esi+ecx-1]
	lea	edi,[edi+ecx-1]
	std
	db	67h
	rep	movsb
	cld
	pop	ds
	pop	es
noop:
	add	sp,10			; come here when done
	clc				; to clean up stack
	ret
errx2:
	add	sp,8
errx:
	stc
	ret
move	endp
end