.MODEL	SMALL,C

.CODE

;-----------------------------------------------------------------------;
; This procedure clears the entire screen.				;
;-----------------------------------------------------------------------;
CLEAR_SCREEN	PROC
	XOR	AL,AL			;Blank entire window
	XOR	CX,CX			;Upper left corner is at (0,0)
	MOV	DH,24			;Bottom line of screen is line 24
	MOV	DL,79			;Right side is at column 79
	MOV	BH,7			;Use normal attribute for blanks
	MOV	AH,6			;Call for SCROLL-UP function
	INT	10h			;Clear the window
	RET
CLEAR_SCREEN	ENDP

;-----------------------------------------------------------------------;
; This procedure writes a string of characters to the screen.  The	;
; string must end with		DB	0				;
;									;
;	write_string(string);						;
;	char	*string;						;
;-----------------------------------------------------------------------;
WRITE_STRING	PROC	USES SI, STRING:PTR BYTE
	PUSHF				;Save the direction flag
	CLD				;Set direction for increment (forward)
	MOV	SI,STRING		;Place address into SI for LODSB

STRING_LOOP:
	LODSB				;Get a character into the AL register
	OR	AL,AL			;Have we found the 0 yet?
	JZ	END_OF_STRING		;Yes, we are done with the string
	MOV	AH,14			;Ask for write character function
	XOR	BH,BH			;Write to page 0
	INT	10h			;Write one character to the screen
	JMP	STRING_LOOP

END_OF_STRING:
	POPF				;Restore direction flag
	RET
WRITE_STRING	ENDP

;-----------------------------------------------------------------------;
; This procedure moves the cursor					;
;									;
;	goto_xy(x, y);							;
;	int	x, y;							;
;-----------------------------------------------------------------------;
GOTO_XY		PROC	X:WORD, Y:WORD
	MOV	AH,2			;Call for SET CURSOR POSITION
	MOV	BH,0			;Display page 0
	MOV	DH,BYTE PTR (Y)		;Get the line number (0..N)
	MOV	DL,BYTE PTR (X)		;Get the column number (0..79)
	INT	10h			;Move the cursor
	RET
GOTO_XY		ENDP

;-----------------------------------------------------------------------;
; This procedure reads on key from the keyboard.			;
;									;
;	key = read_key();						;
;-----------------------------------------------------------------------;
READ_KEY	PROC
	XOR	AH,AH			;Ask for keyboard read function
	INT	16h			;Read character/scan code from keyboard
	OR	AL,AL			;Is it an extended code?
	JZ	EXTENDED_CODE		;Yes
NOT_EXTENDED:
	XOR	AH,AH			;Return just the ASCII code
	JMP	DONE_READING

EXTENDED_CODE:
	MOV	AL,AH			;Put scan code into AL
	MOV	AH,1			;Signal extended code
DONE_READING:
	RET
READ_KEY	ENDP

	END
