; This program uses FILE and ARGC to copy one file to another.

%include "pmode.inc"
%include "file.inc"
%include "argc.inc"

input_fnm       times 80h db    0
output_fnm      times 80h db    0

msg0            db      'SYNTAX: EXAMPLE5 <input filename> <output filename>$'
msg1            db      'Not enough low memory to allocate low file buffer.$'
msg2            db      'Could not open input file.$'
msg3            db      'Not enough memory to load input file.$'
msg4            db      'Error reading from input file.$'
msg5            db      'Output file already exists, will not overwrite.$'
msg6            db      'Could not create output file.$'
msg7            db      'Error writing to output file.$'
msg8            db      'File copied successfully.$'

_main:
        sti

        mov al,1                        ; get 2nd string on command line if
        mov edx,output_fnm              ;  present
        call _cchekstr
        jc done0
        xor al,al                       ; 2nd string present, so the first is
        mov edx,input_fnm               ;  definately there
        call _cchekstr

        movzx eax,WORD [_filebuflen]    ; allocate low memory for file buffer
        call _getlomem                  ;  it will only be used if high memory
        jc done1                        ;  is needed to load in the full input
        mov [_filebufloc],eax           ;  file

        mov edx,input_fnm               ; try to open input file
        call _openfile
        jc done2

        call _filesize                  ; opened, get its size

        mov ebp,eax                     ; preserve size for later use
        call _getmem                    ; allocate that much mem, low or high
        jc done3

        mov edi,eax                     ; preserve ptr for later use
        mov edx,eax                     ; read in whole file
        mov ecx,ebp
        call _readfile
        jc done4

        call _closefile                 ; close input file

        mov edx,output_fnm              ; try to open output file, if it opens
        call _openfile                  ;  then its already present and we
        jnc done5                       ;  will not overwrite it

        call _createfile                ; does not exist, create it
        jc done6

        mov edx,edi                     ; write data from input file to output
        mov ecx,ebp
        call _writefile
        jc done7

        call _closefile                 ; close output file

        mov edx,msg8
        jmp done

done0:
        mov edx,msg0
        jmp short done
done1:
        mov edx,msg1
        jmp short done
done2:
        mov edx,msg2
        jmp short done
done3:
        mov edx,msg3
        jmp short done
done4:
        call _closefile
        mov edx,msg4
        jmp short done
done5:
        call _closefile
        mov edx,msg5
        jmp short done
done6:
        mov edx,msg4
        jmp short done
done7:
        call _closefile
        mov edx,msg5
done:
        add edx,[_code32a]              ; put message with INT 21h AH=9
        shld eax,edx,28
        and edx,0fh
        mov [v86r_ds],ax
        mov [v86r_dx],dx
        mov BYTE [v86r_ah],9
        mov al,21h
        int 33h

        jmp _exit
