; This program is made by Daniel Horchner.
; email: dbjh@gmx.net

        .386p
        locals

code32  segment para public use32
        assume cs:code32, ds:code32, ss:code32

include raw32.inc

;32-bit data
palette         dd      0               ; pointer to palette buffer
font            dd      0               ; pointer to font table
oldX            dw      0
oldY            dw      0
moved           db      0               ; flag that indicates if mouse moved
Xmsg            db      'x coordinate=',0
Ymsg            db      'y coordinate=',0
nomouse_msg     db      'No mouse (driver) installed.$'
bgforx          db      3*8 * 8 dup(0)  ; coordinate # has 3 digits, 8x8 font
bgfory          db      3*8 * 8 dup(0)
cursor  label                           ; mouse cursor
db      4, 4, 4, 4, 4, 4, 0, 0
db      4, 4, 4, 4, 4, 0, 0, 0
db      4, 4, 4, 4, 0, 0, 0, 0
db      4, 4, 4, 4, 4, 0, 0, 0 
db      4, 4, 0, 4, 4, 4, 0, 0
db      4, 0, 0, 0, 4, 4, 4, 0
db      0, 0, 0, 0, 0, 4, 4, 4
db      0, 0, 0, 0, 0, 0, 4, 4
bgforcursor     db      8*8 dup(0)

;32-bit code
main:
        mov v86r_ax,0                   ; ax=0 -> Mouse reset/Mouse installed
        mov al,33h                      ;  check
        int RMCALL_VECT
        cmp v86r_ax,0ffffh              ; ax=ffffh -> mouse installed
        je short @@hide
        mov edx,offset nomouse_msg
        call dosprint
        jmp exit

@@hide:
        mov v86r_ax,2                   ; ax=2 -> Hide mouse cursor
        int RMCALL_VECT

        call setfont                    ; Set font variable (for put funcs)

        mov v86r_ax,13h
        mov al,10h
        int RMCALL_VECT

        mov eax,256*3                   ; 256 palette entries; for each entry
        call getlomem                   ;  3 bytes: red, green and blue
        jc @exit                        ;  intensity of color
        mov palette,eax

        push ds
        pop es

        mov edi,palette
        add edi,(256-64)*3              ; Use last 64 palette entries
        mov ecx,64*3/4                  ; 64 red, green and blue byte values
        xor eax,eax
        rep stosd                       ; Clear palette entries (set to black)

        mov edi,palette
        add edi,(256-64)*3 + 2          ; blue component of color is 3rd byte
        mov ecx,63                      ; cl=intensity of blue (63 at start;
@@next_entry:                           ;  standard VGA has a 6-bit DAC -> 64
        mov [edi],cl                    ;  intensities possible for red, green
        add edi,3                       ;  and blue each)
        loop @@next_entry               ; Decrease blue intensity one step
                                        ; 64th intensity is omitted; already
                                        ;  set to black when clearing palette
                                        ;  entries
        cli
        mov al,256-64                   ; al=base pal entry that rgb values
        mov edx,3c8h                    ;  are written for; last 64 entries
        out dx,al
        mov esi,palette
        add esi,(256-64)*3
        mov ecx,64*3
        mov edx,3c9h
        rep outsb                       ; Output byte at ds:esi to port dx
        sti

        @rlp edi,0a0000h
        mov al,256-64                   ; al=palette entry
        mov ah,al
        mov dx,ax
        shl eax,16
        mov ax,dx                       ; eax=4 bytes with palette entry
        xor dl,dl                       ;  (draw 4 pixels at once; stos_d_)
@@next_color:
        mov ecx,320/4                   ; 320 pixels per line
        rep stosd                       ; Draw line
        mov ecx,320/4 
        rep stosd                       ; Draw line
        mov ecx,320/4
        rep stosd                       ; Draw line
        add eax,01010101h               ; 1 dword = 4 pixels; next pal entry
        inc dl
        cmp dl,64                       ; All intensities drawn?
        jb short @@next_color
        mov ecx,(200-192)*320/4
        mov eax,0ffffffffh
        rep stosd                       ; Draw remaining lines the same color
;
        mov esi,offset Xmsg
        mov ecx,0
        mov edx,0
        mov bl,0fh
        call gputstr
        mov esi,offset Ymsg
        add edx,8
        call gputstr

        mov edi,offset bgforx           ; Save background for x coordinate #
        mov ecx,3*8 shl 16 + 13*8       ; 3 chars, strlen("x coordinate=")=13
        mov edx,8 shl 16
        call getbitmap
        mov edi,offset bgfory           ; Save background for y coordinate #
        add edx,8                       ; y message 8 pixels below x message
        call getbitmap
                                        ; Save background of cursor 1st time
        mov v86r_ax,3                   ; ax=3 -> Get mouse pos and but stat
        mov al,33h
        int RMCALL_VECT
        mov edi,offset bgforcursor
        mov ecx,8 shl 16
        mov cx,v86r_cx
        shr cx,1                        ; mouse x range=640 video x range=320
        mov edx,8 shl 16
        mov dx,v86r_dx
        call getbitmap

        mov esi,offset cursor           ; necessary for putbitmap
main_loop:
        mov v86r_ax,3                   ; ax=3 -> Get mouse pos and but stat
        mov al,33h
        int RMCALL_VECT

        cmp v86r_bx,2                   ; Right mouse button pressed?
        je @exit

        movzx eax,v86r_cx
        cmp oldX,ax
        je short @@x_done
        call update_x
        mov moved,1
@@x_done:

        movzx eax,v86r_dx
        cmp oldY,ax
        je short @@y_done
        call update_y
        mov moved,1
@@y_done:

        cmp moved,0
        je short @@cursordone
        push esi
        mov esi,edi                     ; esi=address of saved background
        call putbitmap                  ; Restore background
        pop esi
        mov cx,oldX
        shr cx,1
        mov dx,oldY
        call getbitmap                  ; Save background
        call putbitmap                  ; Draw mouse cursor
        mov moved,0
@@cursordone:

        mov v86r_ah,1                   ; ah=1 -> Get keystroke status
        mov al,16h
        int RMCALL_VECT
        test v86r_flags,64              ; Zero Flag is bit 6 in flag register
        jnz main_loop                   ; ZF=0 if key pressed
        mov v86r_ah,0
        mov al,16h
        int RMCALL_VECT                 ; Remove key from keyboard buffer

@exit:
        mov v86r_ax,3                   ; Set video mode 3 (text 80x25x16)
        mov al,10h
        int RMCALL_VECT
        mov v86r_ax,0                   ; ax=0 -> Mouse reset
        mov al,33h
        int RMCALL_VECT
        jmp exit                        ; Return to real/V86 mode

;
update_x:
        push ecx edx esi
        mov oldX,ax

        mov esi,offset bgforx
        mov ecx,3*8 shl 16 + 13*8       ; 3 chars, strlen("x coordinate=")=13
        mov edx,8 shl 16
        call putbitmap

        mov ebx,30fh
        call gputnumdec
        pop esi edx ecx
        ret

;
update_y:
        push ecx edx esi
        mov oldY,ax

        mov esi,offset bgfory
        mov ecx,3*8 shl 16 + 13*8       ; 3 chars, strlen("y coordinate=")=13
        mov edx,8 shl 16 + 8
        call putbitmap

        mov ebx,30fh
        call gputnumdec
        pop esi edx ecx
        ret

;
; Draw a picture element on the output screen ;) (macro)
; In:
;   gs = zerosel
;
;   x = x coordinate (dword)
;   y = y coordinate (dword)
;   color = palette entry (byte)
;   reg1 = 1st temporary register (dword)
;   reg2 = 2nd temporary register (dword)
; Out:
;   reg1 = ?
;   reg2 = ?
;
putpixel        macro   x, y, color, reg1, reg2
        mov reg1,y
        mov reg2,y
        shl reg1,8                      ; y * 256
        shl reg2,6                      ; y * 64
        add reg1,reg2                   ; y * 320
        add reg1,x                      ; reg1 = y * 320 + x
        mov byte ptr gs:[0a0000h+reg1],color
endm

;
; Set font variable to linear address of 8x8 font in RAM
; In:
;   ds = data32sel
; Out:
;   font = linear address of font
;   eax = ?
;   ecx = ?
;   esi = ?
;   edi = ?
;
setfont:
        push es
        mov v86r_ax,1130h               ; al=30 -> Get cur char table info
        mov v86r_bh,3                   ; ROM 8x8 character table pointer
        mov al,10h
        int RMCALL_VECT
        movzx eax,v86r_es               ; es:bp=pointer to table
        shl eax,4
        and v86r_ebp,0ffffh             ; Clear high word for "add eax,..."
        add eax,v86r_ebp
        sub eax,code32a                 ; offset of font in ROM from 'code32'
                                        ; Copy char table to RAM -> faster
        mov esi,eax                     ;  access -> faster writing of text
        mov eax,8*256                   ; 256 diff chars; 1 byte per scanline
        mov ecx,8*256/4
        call gethimem
        mov es,data32sel
        mov edi,eax
        rep movsd
        add eax,code32a
        mov font,eax                    ; Linear address of font in RAM
        pop es
        ret

;
; Graphically put 0 terminated string to screen
; In:
;   ds:esi = address of 0 terminated string
;   gs = zerosel
;   bl = character color
;   cx = x coordinate to put top left corner of string
;   dx = y coordinate to ,,  ,,   ,,    ,,   ,,   ,,
;   font = linear address of 8x8 font
;   video mode = 8 bits per pixel
;
gputstr:
        pushad
        shl ecx,16
        mov cx,dx                       ; ecx=x:y coordinates to put string
        push ecx
        push es
        mov ax,ds                       ; First, get string length
        mov es,ax                       ; es=ds for scasb
        mov edi,esi
        mov ecx,0ffffffffh              ; Search max 4GB
        mov al,0                        ; Scan for 0 (=end of string)
        cld
        repne scasb                     ; Compare al with es:edi
        not ecx
        dec ecx                         ; When scasb stops, edi points 1 byte
                                        ;  past the 0; that's 1 byte too far
        pop es                          ; ecx=string length

        pop edx                         ; edx=x:y coordinates to put string
        mov ah,bl                       ; bl=character color

        push esp                        ; Minor adjustment for 'gputnumdec'
        push esi
putchar:
        pop esi
        mov al,[esi]                    ; al=ASCII # of character to print
        mov ebp,0                       ; ebp=scanline in character to print
        inc esi
        push esi                        ; Save pointer to string
        push ecx                        ; Save counter of chars left to print
@@next_scanline:
        movzx edi,al
        shl edi,3
        add edi,cs:font                 ; edi=font address + ASCII # * 8
        mov cl,gs:[edi+ebp]             ; cl=1 scanline of char (_8_x8...)
        mov ch,0                        ; ch=pixel # in scanline of char to
@@next_pixel:                           ;  print
        test cl,80h                     ; The font is a character bit mask ->
        jz short @@pixel_done           ;  Draw only the character itself
        mov edi,edx                     ; edx=x:y coordinates
        and edi,0ffffh                  ; edi=y coordinate
        mov esi,edx
        shr esi,16                      ; esi=x coordinate
        add edi,ebp                     ; edi=y + scanline # in character
        movzx ebx,ch
        add esi,ebx                     ; esi=x + pixel # in scanline of char
        putpixel esi,edi,ah, ebx,edi    ; edi= y==temp reg2 -> Is allowed
@@pixel_done:
        shl cl,1                        ; Shift next bit to test position
        inc ch
        cmp ch,8                        ; Last pixel in char scanline printed?
        jb short @@next_pixel
        inc ebp
        cmp ebp,8                       ; Last scanline printed?
        jb short @@next_scanline
        add edx,80000h                  ; x=x+8 -> following char will be
        pop ecx                         ;  printed next to last one
        dec ecx
        jnz short putchar               ; Print next character

        pop esi
        pop esp                         ; Minor adjustment for 'gputnumdec'
        popad
        ret

;
; Graphically put number in eax to screen in decimal
; In:
;   eax = number
;   ds = data32sel; Add ds=ss code and ds-restore code if ds!=data32sel
;   gs = zerosel
;   bl = character color
;   bh = minimal number of characters to write (1 dword on stack per char)
;   cx = x coordinate to put top left corner of string
;   dx = y coordinate to ,,  ,,   ,,    ,,   ,,   ,,
;   font = linear address of font
;   video mode = 8 bits per pixel
;
gputnumdec:
        pushad
        mov ebp,esp                     ; Save stack pointer
        mov esi,ebx                     ; Save bl (color)
        shl ecx,16
        mov cx,dx                       ; ecx=x:y coordinates to put string
        mov edi,ecx                     ; Save coordinates

        mov cl,bh
        mov ebx,10                      ; Divide by 10
        xor ch,ch                       ; count of numbers pushed on stack
@@push_digit:
        xor edx,edx                     ; Reset edx: eax = _edx_:eax / ebx
        div ebx
        push edx                        ; remains in edx
        inc ch
        cmp eax,0                       ; Are there any digits left?
        jne short @@push_digit
        sub cl,ch                       ; If cl > ch add zero's
        jbe short @@start_pop_digit
@@extra_digit:
        push 0
        inc ch
        dec cl
        jnz short @@extra_digit
@@start_pop_digit:
        mov edx,esp                     ; Save esp
        mov ebx,esp                     ; String has to 'grow' up in mem
        movzx eax,ch
        push eax                        ; Save string length
@@pop_digit:
        mov eax,ss:[edx]                ; Get next digit, but don't give up
        add edx,4                       ;  stack space (POP would)
        add al,'0'                      ; Convert to ASCII
        mov ss:[ebx],al                 ; Store character on stack
        inc ebx
        dec ch
        jnz short @@pop_digit           ; ch=count of numbers pushed on stack

        mov eax,esi
        mov ah,al                       ; ah=color
        mov edx,edi                     ; edi=x:y coordinates
        pop ecx                         ; ecx=string length
        mov esi,esp                     ; esp=start of string
;       mov bx,ss                       ; Already done in extender (ss=ds);
;       mov ds,bx                       ;  str ptr at [esp] must point in ds
                                        ; Avoid redundant POPAD (see note)
        push ebp                        ; Provide ptr to PUSHAD stack frame
        push esi                        ; 'putchar' expects a ptr to the
        jmp putchar                     ;  string at [esp]
                                        ; The RET of gputstr returns to the
                                        ;  calling code

;
; Draw a pixel from a buffer to the screen (macro)
; In:
;   gs = zerosel
;   ds:source = address of buffer to get pixel from ('source' must be a reg)
;
;   x = x coordinate (dword)
;   y = y coordinate (dword)
;   reg1 = 1st temporary register (dword)
;   reg2 = 2nd temporary register (dword)
;   reg3 = 3rd temporary register (byte); can be the same as reg2
; Out:
;   reg1 = ?
;   reg2 = ?
;   reg3 = ?
;
; Note:
;   Multiple statements of this macro have to be separated by a global label,
;   because this macro contains a local label.
;
putpixelfrombuf macro   x, y, source, reg1, reg2, reg3
        cmp x,320                       ; Clip x coordinate
        jae short @@exitm
        cmp y,200                       ; Clip y coordinate
        jae short @@exitm
        mov reg1,y
        mov reg2,y
        shl reg1,8                      ; y * 256
        shl reg2,6                      ; y * 64
        add reg1,reg2                   ; y * 320
        add reg1,x                      ; reg1 = y * 320 + x
        mov reg3,byte ptr [source]
        mov byte ptr gs:[0a0000h+reg1],reg3
@@exitm:
endm

;
; Put a bitmap to the screen
; In:
;   gs = zerosel (for putpixelfrombuf)
;   ecx = bitmap width:x coordinate of top left (high word:low word)
;   edx = bitmap height:y coordinate of top left
;   ds:esi = address of bitmap
;
; Note:
;   This routine doesn't draw pixels in the buffer that have a value of 0.
;
putbitmap:
        pushad
        mov ebp,edx
        shr ebp,16
        and edx,0ffffh                  ; edx=y coordinate to start with
        add ebp,edx                     ; ebp=y maximum

        mov edi,ecx
        shr edi,16
        and ecx,0ffffh
        add edi,ecx                     ; edi=x maximum
        push ecx                        ; [esp]=x coordinate to start with
@@next_y:
        cmp edx,ebp
        jge short @@exit
        mov ecx,[esp]
@@next_x:
        cmp ecx,edi
        jge short @@linedone
        cmp byte ptr [esi],0            ; Enable 'transparent' bitmaps
        je short @@putpixeldone
        putpixelfrombuf ecx,edx,esi, ebx,eax,al
@@putpixeldone:
        inc esi
        inc ecx
        jmp short @@next_x
@@linedone:
        inc edx
        jmp short @@next_y

@@exit:
        add esp,4
        popad
        ret

;
; Get a pixel from the screen and put it in a buffer (macro)
; In:
;   gs = zerosel
;   ds:dest = address of buffer to put pixel to ('dest' must be a reg)
;
;   x = x coordinate (dword)
;   y = y coordinate (dword)
;   reg1 = 1st temporary register (dword)
;   reg2 = 2nd temporary register (dword)
;   reg3 = 3rd temporary register (byte); can be the same as reg2
; Out:
;   reg1 = ?
;   reg2 = ?
;   reg3 = ?
;
; Note:
;   Multiple statements of this macro have to be separated by a global label,
;   because this macro contains a local label.
;
getpixeltobuf   macro   x, y, dest, reg1, reg2, reg3
        cmp x,320                       ; Clip x coordinate
        jae short @@exitm
        cmp y,200                       ; Clip y coordinate
        jae short @@exitm
        mov reg1,y
        mov reg2,y
        shl reg1,8                      ; y * 256
        shl reg2,6                      ; y * 64
        add reg1,reg2                   ; y * 320
        add reg1,x                      ; reg1 = y * 320 + x
        mov reg3,byte ptr gs:[0a0000h+reg1]
        mov byte ptr [dest],reg3
@@exitm:
endm

;
; Get a bitmap from the screen
; In:
;   gs = zerosel (for getpixeltobuf)
;   ecx = bitmap width:x coordinate of top left (high word:low word)
;   edx = bitmap height:y coordinate of top left
;   ds:edi = address of buffer to store bitmap
;
getbitmap:
        pushad
        mov ebp,edx
        shr ebp,16
        and edx,0ffffh                  ; edx=y coordinate to start with
        add ebp,edx                     ; ebp=y maximum

        mov esi,ecx
        shr esi,16
        and ecx,0ffffh
        add esi,ecx                     ; esi=x maximum
        push ecx                        ; [esp]=x coordinate to start with
@@next_y:
        cmp edx,ebp
        jge short @@exit
        mov ecx,[esp]
@@next_x:
        cmp ecx,esi
        jge short @@linedone
        getpixeltobuf ecx,edx,edi, ebx,eax,al
@@getpixeldone:
        inc edi
        inc ecx
        jmp short @@next_x
@@linedone:
        inc edx
        jmp short @@next_y

@@exit:
        add esp,4
        popad
        ret

code32  ends
        end
