.nolist
ifndef	STDERRF_INC

comment 
	STDERRF.INC						V1.00
==========================================================================
NAME
	STDERRF.INC		 Basic include file for STDERRF source files

DESCRIPTION
	This include file is used as the basic include file for the STDERRF
	source files.  This file includes information that is used by two or
	more STDERRF source files.  These are:
		Basic equates
		Macros
		Externdefs

PROGRAMMING NOTES
	Listing is turned off so that include files do not lengthen source
	file listings.

AUTHOR
	Raymond Moon - 5 Feb 95
	Copyright 1995 - Raymond Moon
	ALL RIGHTS RESERVED

HISTORY
	Version - Date		- Remarks
	1.00	-  5 Feb 95	- Orginal

	 End of Comment

;----------------------------
;	Define equate to identify this include file to preclude being
;	included more than once.

STDERRF_INC	equ	1

;----------------------------
;	Define the standard equates

CR	equ	13
LF	equ	10
TAB	equ	 9
STDERR	equ	 2
STDOUT	equ	 1
BELL	equ	 7

;----------------------------
;	Error equates

eqUSAGE 	equ	 0
eqUSERTERM	equ	 1
eqBADDOSVER	equ	 2
eqDUPERR	equ	 3
eqCREATEERR	equ	 4
eqFORCEDUPERR	equ	 5
eqEXECERR	equ	 6
eqRESTOREERR	equ	 7
eqCLOSEERR	equ	 8

eqMINDOSERR	equ	eqDUPERR

;----------------------------
;	Exterdefs

externdef	STACK_BOTTOM:word	; Offset of Stack bottom in DGROUP
externdef	DGRP:word		; Value of DGROUP
externdef	PSP:word		; Segment address of PSP
externdef	ENVIRON:word		; Segment address of ENVIRON
externdef	OSMAJOR:byte		; Integer part of OS system
externdef	OSMINOR:byte		; Decimal part of OS system

;----------------------------
;	Define any Macros

@WRITE	macro	WHAT:req, WHERE:req	; Write String to device or file
	mov	dx, offset WHAT 	; DS:DX => WHAT - DS assumed by macro
	mov	cx, sizeof WHAT 	; CX = String length
	mov	bx, WHERE		; BX = Filehandle
	mov	ah, 40h 		; Request write to device or file
	int	21h			; Call DOS
endm

;----------------------------
;	Define EXTERNDEFs for any variables used in more than one source
;	file.  Segment and Source file are identified.

externdef	DupStdErr:word		; STDERRF.ASM - .DATA

;----------------------------
;	Clean up

endif					; Close opening ifndef
.list					; Turn list back on
