	page 60, 132
	title	START_UP DATA - Common Data for Startup Procedures
	name	SUDATA
comment 
	START_UP DATA						V1.00
==========================================================================
NAME
	START_UP DATA

SYNOPSIS
	None

DESCRIPTION
	This code contains the common data for the startup procedure.
	These are
		DGRP	     - Value of DGROUP
		ENVIRON      - Segment address of ENVIRON
		NEXTPARA     - Segment address of next memory paragraph
		OSMAJOR      - Integer part of OS system
		OSMINOR      - Decimal part of OS system
		PSP	     - Segment address of PSP
		STACK_BOTTOM - Offset to stack bottom in DGROUP

CAUTION
	None

RETURNS
	NA

PROGRAMMING NOTES
	This module is assembled and stored in the alib? libraries so that
	storage for the common startup variables will be linked into the
	program by the linker.

	Assembled with Microsoft MASM V6.11d

	There is no memory model dependent code.

REGISTER USAGE
	None

MEMORY UTILIZATION
	12 bytes for all memory models

EXTERNAL LIBRARIES
	None
	
EXTERNAL PROCEDURES
	None

INTERUPTS CALLED
	None

GLOBAL NAMES
	Following data is global
		DGRP	     - Value of DGROUP
		STACK_BOTTOM - Offset to stack bottom in DGROUP
		PSP	     - Segment address of PSP
		ENVIRON      - Segment address of ENVIRON
		NEXTPARA     - Segment address of next memory paragraph
		OSMAJOR      - Integer part of OS system
		OSMINOR      - Decimal part of OS system

AUTHOR
	Raymond Moon - 17 Dec 95

	Copyright (c) 1995 - Raymond Moon
	ALL RIGHTS RESERVED

HISTORY
	Version	- Date		- Remarks
	1.00	- 17 Dec 95	- Orginal

==========================================================================
		End of Comment

;----------------------------
;	Make the small memory model the default.

ifndef	memmod
memmod	equ	<small>
endif

;----------------------------
;	Specify processor, memory model, language and ES register assume. 

	include procesor.inc			; Specify target processor
%	.model memmod, fortran
	assume es:DGROUP

;----------------------------
;	Include Files

	include startup.inc

;=========================================================================
;	DATA
;=========================================================================

	.DATA?

DGRP		dw	?	; Value of DGROUP
ENVIRON 	dw	?	; Segment address of ENVIRON
NEXTPARA	dw	?	; Segment address of next memory address
OSMAJOR 	db	?	; Integer part of OS system
OSMINOR 	db	?	; Decimal part of OS system
PSP		dw	?	; Segment address of PSP
STACK_BOTTOM	dw	?	; Offset to stack bottom in DGROUP

@CurSeg ends
	end
