
 Title 'Wolfware Assembler Sample', 'Binary Type'

;===============================================;
;           Binary Type Version 2.00            ;
;                                               ;
; Displays files to screen as ASCII             ;
; characters.  Once assembled, to display a     ;
; file, type:                                   ;
;                                               ;
; BTYPE <filespec>                              ;
;                                               ;
; There is no translation of any codes, all     ;
; are displayed as characters.  The BIOS screen ;
; functions are used.  The number of bytes to   ;
; display are determined by the size of the     ;
; file in the directory.                        ;
;===============================================;

 Proc Far
 Call Open              ;open file
 Mov File_Handle, Ax    ;save handle

 Call Allocate_Mem      ;get segment of buffer
 Mov Read_Seg, Ax       ;save segment
 Mov Cl, 4
 Shl Bx, Cl             ;make byte form, times 16
 Mov Read_Size, Bx      ;save bytes

 Call Display_Stat      ;get display status
 Mov Col_Size, Ah       ;save columns
 Mov Act_Page, Bh       ;save page

;----- read a buffer full

More
 Mov Ax, Read_Seg       ;segment
 Mov Bx, File_Handle    ;handle
 Mov Cx, Read_Size      ;bytes to read
 Call Read              ;read into buffer
 Mov Cx, Ax

;----- display a buffer full

 Push Cx
 Mov Ax, Read_Seg       ;segment
 Call Display           ;display bytes to screen
 Pop Cx

 Cmp Cx, Read_Size      ;check if full buffer read
 Je More                ;jump if so, more to read

;----- finished, close file and exit

 Call Close             ;close file
 Mov Ax, 4c00h          ;function
 Int 21h                ;execute

;----- data

File_Handle Dw ?        ;file handle
Read_Size Dw ?          ;bytes to read
Read_Seg Dw ?           ;segment of read buffer
Col_Size Db ?           ;number of columns in a line
Act_Page Db ?           ;active screen page

;===============================================;
;                      Open                     ;
; Open file named on the parameter line.  Exit  ;
; with error code 1 if could not open,          ;
; otherwise AX returns file handle.             ;
;===============================================;

Open Proc Near

;----- set up file name and open file

 Mov Bl, [Com_Line]     ;input length
 Sub Bh, Bh
 Mov Byte [Bx+Com_Line+1], 0 ;string terminator

 Mov Ax, 3d00h          ;open file for read
 Mov Dx, Com_Line + 2   ;start of name, skip length and leading space
 Int 21h                ;execute
 Jc Bterror             ;jump if error (file not found)
 Ret

;----- couldn't open file, error

Bterror
 Mov Dx, Offset Emess   ;error message location
 Mov Ah, 9              ;string display function
 Int 21h                ;execute

;----- exit with error code one

 Mov Ax, 4c01h          ;function
 Int 21h                ;execute

;----- data

Com_Line Equ 80h        ;offset of command line
Emess Db 'File not found or error in parameter', 13, 10,'$'
 Endp                   ;Open

;===============================================;
;                  Allocate_Mem                 ;
; Allocate memory for a buffer to read the      ;
; file. FFF0H bytes will be allocated, or       ;
; what's available. AX returns the buffer       ;
; segment and BX returns the size in            ;
; paragraphs.                                   ;
;===============================================;

Allocate_Mem Proc Near

;----- reduce present segment (assume ES = CS)

 Mov Bx, $Size          ;size of program
 Add Bx, 100h           ;include PSP
 Mov Cl, 4
 Shr Bx, Cl             ;make paragragh form, divide by 16
 Inc Bx                 ;allow for fraction

 Mov Ah, 4ah            ;function
 Int 21h                ;execute

;----- allocate new block

 Mov Ah, 48h            ;function
 Mov Bx, 0800h          ;paragraphs to allocate
 Int 21h                ;execute
 Jc Smallmem            ;jump if insufficient memory
 Ret

;----- not enough memory, do it with available memory

Smallmem
 Mov Ah, 48h            ;function
 Int 21h                ;execute
 Ret
 Endp                   ;Allocate_Mem

;===============================================;
;                 Display_Stat                  ;
; Get display status.  AH returns the number of ;
; columns and BH returns the active page.       ;
;===============================================;

Display_Stat Proc Near
 Mov Ah, 15             ;get video state function
 Int 10h                ;execute
 Ret
 Endp                   ;Display_Stat

;===============================================;
;                     Read                      ;
; Read CX bytes to AX:0000 using the file       ;
; handle in BX.  AX returns the number of bytes ;
; read.                                         ;
;===============================================;

Read Proc Near
 Push Ds
 Mov Ds, Ax

 Mov Ah, 3fh            ;function
 Sub Dx, Dx             ;read location is DS:DX (DS:0000)
 Int 21h                ;execute

 Pop Ds
 Ret
 Endp                   ;Read

;===============================================;
;                    Display                    ;
; Display CX bytes at AX:0000.                  ;
;===============================================;

Display Proc Near
 Push Ds
 Mov Ds, Ax             ;set to buffer segment
 Sub Si, Si             ;start at offset 0

;----- check if no bytes

 Or Cx, Cx              ;check if zero bytes
 Jz Nobtd               ;jump if so

;---- loop for each byte

Btdloop
 Lodsb                  ;load next byte
 Push Cx
 Push Si
 Call Display_Char      ;display
 Call Inc_Cursor        ;move cursor
 Pop Si
 Pop Cx
 Loop Btdloop

Nobtd
 Pop Ds
 Ret
 Endp                   ;Display

;===============================================;
;                 Display_Char                  ;
; Display character in AL. Uses ACT_PAGE        ;
; defined outside of this routine.              ;
;===============================================;

Display_Char Proc Near
 Mov Ah, 10             ;function
 Seg Cs
 Mov Bh, Act_Page       ;active screen page
 Mov Cx, 1              ;one character
 Int 10h                ;execute
 Ret
 Endp                   ;Display_Char

;===============================================;
;                   Inc_Cursor                  ;
; Increment cursor. Switch to new line if at    ;
; end of line. Uses ACT_PAGE and COL_SIZE       ;
; defined outside of this routine.              ;
;===============================================;

Inc_Cursor Proc Near

;----- get present cursor position

 Mov Ah, 3              ;function
 Seg Cs
 Mov Bh, Act_Page       ;page
 Int 10h                ;execute

 Inc Dl                 ;advance column
 Seg Cs
 Cmp Dl, Col_Size       ;check if on last column
 Je Newline             ;if too far then jump

;----- move cursor right one

 Mov Ah, 2              ;function
 Int 10h                ;execute
 Ret

;----- new line

Newline
 Mov Bl, 0              ;forground color if graphics (don't matter)
 Mov Ax, 0e0dh          ;CR with teletype function
 Int 10h                ;execute
 Mov Ax, 0e0ah          ;LF with teletype function
 Int 10h                ;execute
 Ret
 Endp                   ;Inc_Cursor

;===============================================;
;                     Close                     ;
; Close file using the handle in BX.            ;
;===============================================;

Close Proc Near
 Mov Ah, 3eh            ;function
 Int 21h                ;execute
 Ret
 Endp                   ;Close

 Endp                   ;main program

