;
; *** Listing 9-26 ***
;
; Performs addition of the ASCII decimal value "00001"
; to an ASCII decimal count variable.
;
DECIMAL_INCREMENT	macro
	local	DigitLoop
	std		;we'll work from least-significant
			; to most-significant
	mov	si,offset ASCIIOne+VALUE_LENGTH-1
	mov	di,offset Count+VALUE_LENGTH-1
	mov	ax,ds
	mov	es,ax	;ES:DI points to Count for STOSB
	mov	cx,VALUE_LENGTH
	clc		;there's no carry into the least-
			; significant digit
DigitLoop:
	lodsb		;get the next increment digit
	adc	al,[di]	;add it to the next Count digit
	aaa		;adjust to an unpacked BCD digit
	lahf		;save the carry, in case we just
			; turned over 9
	add	al,'0'	;make it an ASCII digit
	stosb
	sahf		;get back the carry for the next adc
	loop	DigitLoop
	endm
;
	jmp	Skip
;
Count	db	'00000'
VALUE_LENGTH	equ	$-Count
ASCIIOne db	'00001'
;
Skip:
	call	ZTimerOn
	rept	100
	DECIMAL_INCREMENT
	endm
	call	ZTimerOff
