;
; *** Listing 14-5 ***
;
; Copies the standard input to the standard output,
; converting all characters to uppercase. Does so in
; blocks of 256 characters.
;
	jmp	Skip
; Storage for the characters we're processing.
CHARACTER_BLOCK_SIZE	equ	256
CharacterBlock	db	CHARACTER_BLOCK_SIZE dup (?)
ErrorMsg	db	'An error occurred', 0dh, 0ah
ERROR_MSG_LENGTH equ	$-ErrorMsg
;
Skip:
	call	ZTimerOn
CopyLoop:
	mov	ah,3fh	;DOS read fn
	sub	bx,bx	;handle 0 is the standard input
	mov	cx,CHARACTER_BLOCK_SIZE
			;we want to get a block
	mov	dx,offset CharacterBlock
			;the characters go here
	int	21h	;get the characters
	jc	Error	;check for an error
	mov	cx,ax	;get the count where it does us the
			; most good
	jcxz	Done	;if we didn't read anything, we've
			; hit the end of the file
	mov	dx,cx	;remember how many characters we read
	mov	bx,offset CharacterBlock
			;point to the first character to
			; convert
ConvertLoop:
	mov	al,[bx]		;get the next character and
	cmp	al,'a'		; convert it to uppercase
	jb	ConvertLoopBottom ; if it's lowercase
	cmp	al,'z'
	ja	ConvertLoopBottom
	and	al,not 20h	;it's uppercase-convert to
	mov	[bx],al		; uppercase and save
ConvertLoopBottom:
	inc	bx		;point to the next character
	loop	ConvertLoop
	mov	cx,dx	;get back the character count in
			; this block, to serve as a count of
			; bytes for DOS to write
	mov	ah,40h	;DOS write fn
	mov	bx,1	;handle 1 is the standard output
	mov	dx,offset CharacterBlock
			;point to the characters to write
	push	cx	;remember # of characters read
	int	21h	;write the character
	pop	ax	;get back the # of characters in
			; this block
	jc	Error	;check for an error
	cmp	ax,CHARACTER_BLOCK_SIZE
			;was it a partial block?
	jz	CopyLoop ;no, so we're not done yet
	jmp	short Done ;it was a partial block, so that
			   ; was the end of the file
Error:
	mov	ah,40h	;DOS write fn
	mov	bx,2	;handle 2 is standard error
	mov	cx,ERROR_MSG_LENGTH ;# of chars to display
	mov	dx,offset ErrorMsg ;error msg to display
	int	21h	;notify of error
Done:
	call	ZTimerOff
