#if UNK

DOUBLE DTR = (DOUBLE )1.74532925199432957692E-2;
DOUBLE RTD = (DOUBLE )5.72957795130823208768E1;
DOUBLE RTS = (DOUBLE )2.06264806247096355156E5; /* arc seconds per radian */
DOUBLE STR = (DOUBLE )4.84813681109535993590E-6; /* radians per arc second */
DOUBLE PI  = (DOUBLE )3.14159265358979323846;
/* Standard epochs.  Note Julian epochs (J) are measured in
 * years of 365.25 days.
 */
DOUBLE J2000 = (DOUBLE )2451545.0;	/* 2000 January 1.5 */
DOUBLE B1950 = (DOUBLE )2433282.423;	/* 1950 January 0.923 Besselian epoch */
DOUBLE J1900 = (DOUBLE )2415020.0;	/* 1900 January 0, 12h UT */
DOUBLE B1900 = (DOUBLE )2415020.313;

DOUBLE Jcentury = (DOUBLE )3.6525e4; /* 1 Julian century */
DOUBLE Jmillenium = (DOUBLE )3.6525e5;
DOUBLE Jtmillenium = (DOUBLE )3.6525e6;

#if !(LDOUBLE)
double Zero = 0.0;
double Fourth = 0.25;
double Half = 0.5;
double One = 1.0;
double OneandaHalf = 1.5;
double Two = 2.0;
double Three = 3.0;
double ThreeandaHalf = 3.5;
double Four = 4.0;
double Five = 5.0;
double Six = 6.0;
double Ten = 10.0;
#endif

/* Solar system barycentric velocity and position
 * state of Mercury, Venus, EMB, ..., Pluto, MOON, Sun
 * in the order dx/dt, x, dy/dt, y, dz/dt, z for each object.
 *
 * EMB is the arithmetic average of Earth and Moon, weighted by
 * their masses. The coordinates of the Moon variable are the
 * the solar system barycentric coordinates of the Moon
 * minus those of the Earth.
 */

/* Note, these particular numbers are derived from the heliocentric
 * planet states and barycentric Sun state given in the
 * documentation for the DE118.
 */

/* June 28.0, 1969 */
DOUBLE JD0 = ((DOUBLE )2440400.50);

DOUBLE yn0[6*NTOTAL] = {
/* Lunar librations */
 1.00015500951082782e-4,
 6.03343019729665792e-3,
 1.49039876740924137e-5,
 3.82393007236771923e-1,
-1.19434270765326686e-4,
 1.28120436555489181e0,
/* Mercury */
 3.7085069798210382186e-003,
 3.6030663368975339466e-001,
 2.4854958767430945324e-002,
-9.4812876741771684223e-002,
 1.2929109014677844626e-002,
-8.7466840117233140436e-002,
/* Venus */
 1.1156645711264016669e-002,
 6.0786466491731583464e-001,
 1.5494075513638794325e-002,
-3.5518362463675619232e-001,
 6.2773904546696609267e-003,
-1.9824142909855515515e-001,
 /* EMB */
 1.6833251020051496668e-002,
 1.0820747754938311664e-001,
 1.5602036176919105255e-003,
-9.2711110739430602933e-001,
 6.7646174015847273137e-004,
-4.0209347855944090112e-001,
/* Mars */
 1.4481919298277924969e-002,
-1.2796408611369531836e-001,
 8.0528538390447499843e-005,
-1.3262618005333617013e+000,
-3.5188931029397090065e-004,
-6.0530808652523961512e-001,
/* Jupiter */
 1.0053452569924098185e-003,
-5.3896824544609061333e+000,
-6.5298425191689416643e-003,
-7.7026549518616593034e-001,
-2.8258787532429609536e-003,
-1.9866431165907522014e-001,
/* Saturn */
-3.1594662504012930114e-003,
 7.9527768530257360864e+000,
 4.3714634278372622354e-003,
 4.5078822184006553686e+000,
 1.9441395169137103763e-003,
 1.5201955253183338898e+000,
/* Uranus */
 1.7108310564806817248e-004,
-1.8278236586353147533e+001,
-3.7646704682815900043e-003,
-9.5764572881482056433e-001,
-1.6519678610257000136e-003,
-1.6132190397271035415e-001,
/* Neptune */
 2.6225242764289213785e-003,
-1.6367191358770888335e+001,
-1.5277473123858904045e-003,
-2.3760896725373076342e+001,
-6.9183197562182804864e-004,
-9.3213866179497290101e+000,
/* Pluto */
 2.8177758090360373050e-004,
-3.0447680255169362534e+001,
-3.1469590804946202045e-003,
-5.3177934960261367037e-001,
-1.0794238049289112837e-003,
 9.0596584886274922101e+000,
#if MOON
 5.98752118417335956e-4,
-8.35703164195952601e-4,
-1.74153713527242722e-4,
-1.98543915768166071e-3,
-8.84771962437116281e-5,
-1.08326877048661754e-3,
#endif
/* Sun */
-2.8369446340813151639e-007,
 4.5144118714356666407e-003,
 5.1811944086463255444e-006,
 7.2282841152065867346e-004,
 2.2306588340621263489e-006,
 2.4659100492567986271e-004,
/* Asteroid states follow */
};



/* Test state, 100 days later: */
#if 0
DOUBLE JD1 = ((DOUBLE )2440500.50);

DOUBLE yn1[6*NTOTAL] = {
-3.85893930164594646e-5,
 1.29694398195755468e-2,
 1.14905257263582262e-5,
 3.82508699238156682e-1,
 4.75391383166468672e-5,
 1.27428371119265801e0,

-2.43015281791706444e-002,
 2.40773527079857565e-001,
 1.87910251556777273e-002,
 1.96954621939863219e-001,
 1.25591312851252066e-002,
 8.10048178490518384e-002,

-1.63440955802718280e-002,
-4.21860322028048782e-001,
-1.14246422850682140e-002,
 5.17869026250609690e-001,
-4.11622909296383714e-003,
 2.60203829195766570e-001,

-3.94484632235194096e-003,
 9.81177706008309405e-001,
 1.53727031456690289e-002,
 1.96484576859672724e-001,
 6.66612671337020014e-003,
 8.51297144135776147e-002,

 8.50596535330489333e-003,
 1.14162585220489816e+000,
 1.16329928693268469e-002,
-7.02290330317807430e-001,
 5.11130674190038601e-003,
-3.52984793305744779e-001,

 1.97739891612302323e-003,
-5.24031415190823051e+000,
-6.33006771988879063e-003,
-1.41424053721658884e+000,
-2.76393462026492719e-003,
-4.78580847895956282e-001,

-3.45070902605290058e-003,
 7.62218572268596801e+000,
 4.19480008161587867e-003,
 4.93634138197818904e+000,
 1.88368464231530789e-003,
 1.71165065659011950e+000,

 2.59339002502375430e-004,
-1.82567140746315272e+001,
-3.75914213576224408e-003,
-1.33385143258585295e+000,
-1.65079191573496991e-003,
-3.26466517509008289e-001,

 2.63977839373647663e-003,
-1.61040739057229584e+001,
-1.50241016013489575e-003,
-2.39124059584972814e+001,
-6.81887221476645979e-004,
-9.39007319300685950e+000,

 3.09967640221318611e-004,
-3.04180939220586550e+001,
-3.14632190270354497e-003,
-8.46445850516399332e-001,
-1.08776892324236050e-003,
 8.95129835863062695e+000,

#if MOON
-4.22681402426694080e-4,
-1.72474926563029233e-3,
-3.21609581451700993e-4,
 1.82647356024942241e-3,
-1.82676776570974036e-4,
 9.67995005426182924e-4,
#endif
-9.96208174079740373e-007,  /* rotated from DE200 */
 4.45122038203489470e-003,
 5.06057698826071977e-006,
 1.23363163514498492e-003,
 2.19376032512757903e-006,
 4.67156762898216060e-004,
};
#endif /* 0 */

#if 1
DOUBLE JD1 = ((DOUBLE )2440800.50);

DOUBLE yn1[6*NTOTAL] = {
 1.19798509852348462e-4,
 3.26749396278042651e-2,
-6.85863913398886621e-5,
 3.85255316277713118e-1,
-9.87921606265917336e-5,
 1.25594900035445747e0,

 1.1640059959070938016e-002,
-3.4350297408563828055e-001,
-1.7964875644231269124e-002,
-2.5118910315168408963e-001,
-1.0817311005210173814e-002,
-9.9170891227838064646e-002,

 1.8597282203783061216e-002,
-2.6914630075961837156e-001,
-6.5864799228651037249e-003,
-6.1655661757510340864e-001,
-4.1428517490915759141e-003,
-2.6070731202257053265e-001,

 1.3083581197550196016e-002,
 6.4260215465460413745e-001,
 9.8846107560980890857e-003,
-7.2083597294516633464e-001,
 4.2862797207098424858e-003,
-3.1263839868006851566e-001,

-1.0289202815795734684e-002,
-1.0394941428468679346e+000,
-7.0723334989418045152e-003,
 1.1522403836312279294e+000,
-2.9703138309275424941e-003,
 5.5677401157133424433e-001,

 4.6228653666202124358e-003,
-4.2373615722355993645e+000,
-5.0555918692615562352e-003,
-3.1464733091277224306e+000,
-2.2818455722493645242e-003,
-1.2462241659031373286e+000,

-4.2556740044874090445e-003,
 6.4633979534971069954e+000,
 3.5633047172379600052e-003,
 6.1037564142437140792e+000,
 1.6573768541155527860e-003,
 2.2444618449141959815e+000,

 5.2274776790945661154e-004,
-1.8139340904007687965e+001,
-3.7317457890160985748e-003,
-2.4578888288247007605e+000,
-1.6425078479167742140e-003,
-8.2063943185823257564e-001,

 2.6898588576179062356e-003,
-1.5304564931392374665e+001,
-1.4254385368896515149e-003,
-2.4351618762495032811e+001,
-6.5161737589378315099e-004,
-9.5901150170962550989e+000,

 3.9518201228036738355e-004,
-3.0312344985766555864e+001,
-3.1426251869952901448e-003,
-1.7898553889579568107e+000,
-1.1124350707669052540e-003,
 8.6212535443336042115e+000,

#if MOON
-4.58408893102436927e-4,
-1.60130208907259920e-3,
-2.78697065392994499e-4,
 1.95720839700677492e-3,
-1.70697259101564644e-4,
 9.68483037769266028e-4,
#endif
 /* rotated from DE200 */
/*
-3.44322101864905357e-006,
 3.77983010651375442e-003,
 4.03605242892639870e-006,
 2.63055823065286220e-003,
 1.81002374725178528e-006,
 1.08188006521861207e-003,
*/
-3.4432210186490844452e-006,
 3.7798301065137354516e-003,
 4.0360524289263751236e-006,
 2.6305582306528893588e-003,
 1.8100237472517860139e-006,
 1.0818800652186113487e-003,
};
#endif /* 1 */


/* Speed of light.
 */
/* DOUBLE CLIGHT = (DOUBLE)2.99792458e5; */
DOUBLE C = ((DOUBLE ) 173.144632720536344565);

/* Earth's mass divided by Moon's mass
 */
#define EMRATd ((DOUBLE ) 8.13005869999999999376E1)
DOUBLE EMRAT = EMRATd;

/* Gaussian gravitational constant */
DOUBLE KG = 0.01720209895;

/* GM's of the solar system bodies
 * These are scaled such that GMsun = k^2
 * (k = Gaussian gravitational constant).
 */
DOUBLE GMs[] = {
#if LIBRAT
 0.0, /*place holder for libration */
#endif
 4.91254745145081175785E-11, /* Mercury */
 7.24345620963276523095E-10, /* Venus */

#if MOON
/* (GMB*EMRAT)/(1.0+EMRAT), Earth only */
 8.88769273403302327042E-10,
#else
 8.99701165855730774179E-10, /* EMB */
#endif
 9.54952894222405763492E-11, /* Mars */
 2.82534210344592625472E-7, /* Jupiter */
 8.45946850483065929285E-8, /* Saturn */
 1.28881623813803488851E-8, /* Uranus */
 1.53211248128427618918E-8, /* Neptune */
 2.27624775186369921644E-12, /* Pluto */
#if MOON
/* (GMB)/(1.0+EMRAT),  Moon only */
 1.09318924524284471369E-11,
#endif
 2.95912208285591102582E-4, /* Sun */
#if AROIDS
 1.746e-13, /* Ceres */
 3.2e-14,   /* Pallas */
 4.08e-14,  /* Vesta */
 1.6e-15,   /* Iris */
 2.6e-15    /* Bamberga */
#endif
};


/* Astronomical unit */
DOUBLE AU = 1.4959787066e11;
/* kilometers: */
DOUBLE RADS = 6.96e5;
DOUBLE RADM = 1738.0;
DOUBLE RADE = 6378.14;



DOUBLE Je[] = {
1.08263e-3, /* J2E */
-2.54e-6,   /* J3E */
-1.61e-6    /* J4E */
};

DOUBLE Jm[] = {
2.02150907893e-4,  /* J2M */
1.21260448837e-5,  /* J3M */
-1.45383007072e-7, /* J4M */
};

DOUBLE Cnm[8] = {
 2.230351309e-5,   /* C22 */
 3.07082741328e-5, /* C31 */
 4.88840471683e-6, /* C32 */
 1.43603108489e-6, /* C33 */
-7.17780149806e-6, /* C41 */
-1.43951838385e-6, /* C42 */
-8.54788154819e-8, /* C43 */
-1.5490389313e-7   /* C44 */
};

DOUBLE Snm[8] = {
 0.0,             /* S22 */
 5.61066891941e-6, /* S31 */
 1.68743052295e-6, /* S32 */
-3.343544677e-7,   /* S33 */
 2.94743374914e-6, /* S41 */
-2.8843721272e-6,  /* S42 */
-7.88967312839e-7, /* S43 */
 5.6404155572e-8   /* S44 */
};


DOUBLE K2M = 2.22160557154e-2;
DOUBLE LOVENO  = 0.30;
DOUBLE PHASE = 4.0700012e-2;

/* DE118 initial psidot: */
DOUBLE PSLP1 = 2.29971502189818919e-1;
/* PSLPI = 2 pi / PSLP1 = period in days */
DOUBLE PSLPI =  27.32158222801637949485;
/* PSLPA + PSLPB = PSLPI */
DOUBLE PSLPIA =  27.3215820789337158203125; /* only top 26 bits are nonzero */
DOUBLE PSLPIB =  1.490826636745416323896386e-7;
DOUBLE JDEPOCH = 2440400.5;

/* (C-A)/B */
#define LBETd 6.31686773468e-4
DOUBLE LBET = LBETd;
/* (B-A)/C */
#define LGAMd 2.28022183594e-4
DOUBLE LGAM = LGAMd;
/* C/MR^2 */
/*
DOUBLE CMRSQ 0.3906895261319410091
DOUBLE LGAMBET = (LGAMd - LBETd)/(1.0-LBETd*LGAMd);
DOUBLE CMR2 = CMRSQ*AMd*AMd;
DOUBLE BMR2 = CMRSQ*AMd*AMd*(1.0 + LGAMd)/(1.0 + LBETd);
DOUBLE AMR2 = CMRSQ*AMd*AMd*(1.0 - LBETd * LGAMd)/(1.0 + LBETd);
*/
DOUBLE LGAMBET = -4.03664648017289733947E-4;
/* equatorial radius of Earth, in au */
DOUBLE AE =  4.26352325064817808471E-5;
/* equatorial radius of Moon, in au */
#define AMd  1.16178124180819699985E-5
DOUBLE AM = AMd;

DOUBLE CMRSQ = 0.3906895261319410091;
DOUBLE CMR2 = 5.2732758299330413853212309E-11;
DOUBLE BMR2 = 5.2711485389894113965222358E-11;
DOUBLE AMR2 = 5.2699461151199766018387453E-11;
#endif /* UNK */
#if IBMPC
short DTR[] = {0x9d39,0xa252,0xdf46,0x3f91};
short RTD[] = {0xc1f8,0x1a63,0xa5dc,0x404c};
short RTS[] = {0xad7b,0x7331,0x2dc6,0x4109};
short STR[] = {0x8f9d,0xb2ff,0x55a5,0x3ed4};
short PI[] = {0x2d18,0x5444,0x21fb,0x4009};
short J2000[] = {0x0000,0x8000,0xb42c,0x4142};
short B1950[] = {0xdd2f,0x3624,0x9081,0x4142};
short J1900[] = {0x0000,0x0000,0x6cd6,0x4142};
short B1900[] = {0x624e,0x2810,0x6cd6,0x4142};
short Jcentury[] = {0x0000,0x0000,0xd5a0,0x40e1};
short Jmillenium[] = {0x0000,0x0000,0x4b08,0x4116};
short Jtmillenium[] = {0x0000,0x0000,0xddca,0x414b};
short Zero[] = {0x0000,0x0000,0x0000,0x0000};
short Fourth[] = {0x0000,0x0000,0x0000,0x3fd0};
short Half[] = {0x0000,0x0000,0x0000,0x3fe0};
short One[] = {0x0000,0x0000,0x0000,0x3ff0};
short OneandaHalf[] = {0x0000,0x0000,0x0000,0x3ff8};
short Two[] = {0x0000,0x0000,0x0000,0x4000};
short Three[] = {0x0000,0x0000,0x0000,0x4008};
short ThreeandaHalf[] = {0x0000,0x0000,0x0000,0x400c};
short Four[] = {0x0000,0x0000,0x0000,0x4010};
short Five[] = {0x0000,0x0000,0x0000,0x4014};
short Six[] = {0x0000,0x0000,0x0000,0x4018};
short Ten[] = {0x0000,0x0000,0x0000,0x4024};

short JD0[] = {0x0000,0x4000,0x9e68,0x4142};
short yn0[4*6*NTOTAL] = {
0xa479,0x3903,0x37ed,0x3f1a,
0xd720,0x9614,0xb682,0x3f78,
0xc10e,0x77ee,0x4184,0x3eef,
0x4406,0x8513,0x7920,0x3fd8,
0x7f80,0x25d8,0x4f19,0xbf1f,
0xcf9f,0x2618,0x7fd0,0x3ff4,
0x0dd3,0x8640,0x614d,0x3f6e,
0xad8d,0x8e0e,0x0f43,0x3fd7,
0xbbc3,0x0c32,0x7394,0x3f99,
0x787c,0x1cd8,0x45a8,0xbfb8,
0x5fd5,0xa313,0x7a93,0x3f8a,
0xb8df,0x11c9,0x643a,0xbfb6,
0x18a2,0xa3b4,0xd94b,0x3f86,
0xd806,0x9906,0x73a0,0x3fe3,
0x1500,0x9ce7,0xbb5b,0x3f8f,
0xef55,0x18f8,0xbb54,0xbfd6,
0xfd65,0x2b4f,0xb652,0x3f79,
0x657d,0xa358,0x5ff9,0xbfc9,
0x467c,0x5a77,0x3cbc,0x3f91,
0xdb72,0x3941,0xb37c,0x3fbb,
0x6d8d,0xe0d6,0x8ff7,0x3f59,
0x8a59,0xe9c0,0xaae4,0xbfed,
0x60c3,0x8686,0x2a92,0x3f46,
0x4052,0x4916,0xbbe6,0xbfd9,
0xc307,0x4e27,0xa8b2,0x3f8d,
0xde62,0x8e75,0x6120,0xbfc0,
0xfa3e,0xc14f,0x1c2d,0x3f15,
0x990b,0x4b33,0x385e,0xbff5,
0xb969,0x145b,0x0fb9,0xbf37,
0x2af2,0x1074,0x5eaf,0xbfe3,
0x86d9,0x3fff,0x78b9,0x3f50,
0xf03b,0xead6,0x8f08,0xc015,
0xf544,0x4115,0xbf09,0xbf7a,
0xfa7f,0xd2e1,0xa603,0xbfe8,
0x0667,0x1a7c,0x264c,0xbf67,
0xa25a,0x08ba,0x6dd5,0xbfc9,
0x39d8,0x86fc,0xe1e1,0xbf69,
0x867d,0xbc40,0xcfa4,0x401f,
0xdfa5,0xc754,0xe7cf,0x3f71,
0x00c3,0x46b9,0x0812,0x4012,
0x635e,0xe937,0xda4f,0x3f5f,
0x48d8,0x8b0c,0x52b8,0x3ff8,
0xc0dd,0xaff3,0x6c98,0x3f26,
0xeffd,0x834e,0x473a,0xc032,
0xdb5c,0x1153,0xd716,0xbf6e,
0x3d5a,0xa7cd,0xa508,0xbfee,
0x3d83,0xfbfa,0x10da,0xbf5b,
0x7aaa,0x36d8,0xa632,0xbfc4,
0xdebd,0x0001,0x7bd5,0x3f65,
0x4b76,0x40bd,0x5e00,0xc030,
0x657e,0x2f91,0x07d6,0xbf59,
0x1c61,0x20b7,0xc2ca,0xc037,
0xebac,0xdad4,0xab81,0xbf46,
0xeea9,0xc96a,0xa48c,0xc022,
0x6d46,0x7ea6,0x7771,0x3f32,
0x0471,0x2c57,0x729b,0xc03e,
0x738a,0xcaa4,0xc7a6,0xbf69,
0x676f,0x2067,0x0456,0xbfe1,
0x52c0,0x7c34,0xaf6e,0xbf51,
0x2af1,0x8eb3,0x1e8b,0x4022,
0x7ce0,0x622d,0x9eb2,0x3f43,
0x89e4,0xe133,0x6262,0xbf4b,
0x4f4f,0x0216,0xd3a1,0xbf26,
0x9bd6,0x8803,0x43c4,0xbf60,
0x7dd2,0xa840,0x319a,0xbf17,
0x0681,0xfc4a,0xbf8e,0xbf51,
0x48a5,0x71ec,0x09d5,0xbe93,
0x6a9d,0x3593,0x7db4,0x3f72,
0x746b,0xdfe0,0xbb43,0x3ed5,
0x49f8,0x31ad,0xaf86,0x3f47,
0xfbb2,0xa9ae,0xb64d,0x3ec2,
0x8354,0x4d38,0x291c,0x3f30,
};
short JD1[] = {0x0000,0x4000,0x9f30,0x4142};
short yn1[4*6*NTOTAL] = {
0xa4f1,0xba4a,0x678a,0x3f1f,
0x4c98,0x0a33,0xbac5,0x3fa0,
0x409d,0x3b24,0xfac1,0xbf11,
0x776e,0xea01,0xa805,0x3fd8,
0x42dd,0x655e,0xe5d4,0xbf19,
0x75ea,0xfa9f,0x185d,0x3ff4,
0x110e,0x66c8,0xd6be,0x3f87,
0xb307,0xe5f1,0xfbf3,0xbfd5,
0x8750,0x6579,0x6562,0xbf92,
0x79b6,0x75c9,0x137b,0xbfd0,
0xfba7,0xe7fb,0x2762,0xbf86,
0xeab8,0x7689,0x6343,0xbfb9,
0x5d56,0x7b70,0x0b2a,0x3f93,
0x8633,0x67e6,0x39b1,0xbfd1,
0xda89,0xbdd4,0xfa6c,0xbf7a,
0xc222,0xf193,0xbad4,0xbfe3,
0x7407,0x4c64,0xf818,0xbf70,
0xc2b1,0xb8bd,0xaf6d,0xbfd0,
0x4358,0x8add,0xcb90,0x3f8a,
0x94c2,0x64d2,0x9032,0x3fe4,
0xf4e0,0xff72,0x3e61,0x3f84,
0x8df8,0x9a32,0x1116,0xbfe7,
0x228f,0x738d,0x8e7d,0x3f71,
0x8045,0x7c73,0x0244,0xbfd4,
0x1a91,0x6cc4,0x1281,0xbf85,
0x92d8,0x9c3e,0xa1c4,0xbff0,
0x8a30,0x1159,0xf7e1,0xbf7c,
0x39d3,0x9ccd,0x6f93,0x3ff2,
0xf56c,0x1867,0x5533,0xbf68,
0xc57a,0xbb5e,0xd117,0x3fe1,
0xdec3,0xf903,0xef6c,0x3f72,
0x50f0,0xe978,0xf30e,0xc010,
0xafa7,0x1bd8,0xb52c,0xbf74,
0x8613,0x32c3,0x2bfa,0xc009,
0x4682,0x836f,0xb160,0xbf62,
0x9f24,0xc040,0xf088,0xbff3,
0x53cd,0xcabf,0x6e65,0xbf71,
0x36af,0xfe3d,0xda84,0x4019,
0x30d1,0xa73d,0x30ca,0x3f6d,
0xb53a,0x1f17,0x6a3f,0x4018,
0x3d27,0xd8ad,0x278a,0x3f5b,
0x35db,0x6968,0xf4a8,0x4001,
0xee4c,0x489a,0x2120,0x3f41,
0xb546,0xd871,0x23ab,0xc032,
0xaca3,0xc3dd,0x9209,0xbf6e,
0x0bf2,0x9e48,0xa9c1,0xc003,
0xdc66,0x5f5f,0xe92d,0xbf5a,
0x73c0,0xa034,0x42ad,0xbfea,
0xde76,0xfa60,0x090a,0x3f66,
0xad6e,0xef47,0x9bef,0xc02e,
0x5f1e,0xf97f,0x5ab8,0xbf57,
0x937f,0xafed,0x5a03,0xc038,
0xfb0f,0xa8d3,0x5a29,0xbf45,
0x9d22,0x8e36,0x2e23,0xc023,
0x162a,0xd197,0xe60d,0x3f39,
0xefdb,0xd74a,0x4ff5,0xc03e,
0xfa3f,0x0cda,0xbe90,0xbf69,
0x4cf0,0x6782,0xa33f,0xbffc,
0x0ed3,0x0fdd,0x39e4,0xbf52,
0xdfb3,0xf1ce,0x3e14,0x4021,
0xf74e,0x343d,0x0ad3,0xbf3e,
0x1bd1,0x06a1,0x3c59,0xbf5a,
0xd241,0xc806,0x43c2,0xbf32,
0xac3c,0x41cf,0x0890,0x3f60,
0x5f17,0x4a6c,0x5fa6,0xbf26,
0x6280,0x7caa,0xbc39,0x3f4f,
0x5695,0xc604,0xe242,0xbecc,
0x2615,0xd624,0xf6e0,0x3f6e,
0xd7aa,0xa4db,0xedad,0x3ed0,
0xa17d,0x3244,0x8cae,0x3f65,
0x7a70,0x281a,0x5dfe,0x3ebe,
0x486d,0xdfe4,0xb9bb,0x3f51,
};

short CLIGHT[] = {0xf3b6,0xd4fd,0x4c41,0x4112};
short C[] = {0x9453,0xd4cc,0xa4a0,0x4065};
short EMRAT[] = {0xa693,0xd141,0x533c,0x4054};
short KG[] = {0xb69a,0x51a6,0x9d6d,0x3f91};
short GMs[] = {
0x0000,0x0000,0x0000,0x0000,
0x30a7,0xbfef,0x01cb,0x3dcb,
0x9305,0x5596,0xe369,0x3e08,
0x614e,0x7bf8,0x89b2,0x3e0e,
0xe19b,0x330d,0x3fe2,0x3dda,
0x594a,0x991b,0xf5e6,0x3e92,
0xa2cf,0x700f,0xb54d,0x3e76,
0xddff,0x9a62,0xad57,0x3e4b,
0xf7c8,0x4ffd,0x7370,0x3e50,
0xde3d,0x7dd0,0x05a7,0x3d84,
0x5e14,0xbc9f,0x0a1b,0x3da8,
0x95e6,0x41cf,0x6495,0x3f33,
0x5b6d,0xc1f4,0x92a0,0x3d48,
0x5616,0x9ee7,0x03af,0x3d22,
0x8dc2,0x5100,0xf7e6,0x3d26,
0x89bc,0x97d8,0xd2b2,0x3cdc,
0xefe9,0x1b5f,0x6b31,0x3ce7,
};
short AU[] = {0x0000,0x2d22,0x6a5d,0x4241};
short RADS[] = {0x0000,0x0000,0x3d80,0x4125};
short RADM[] = {0x0000,0x0000,0x2800,0x409b};
short RADE[] = {0x3d71,0xd70a,0xea23,0x40b8};
short AE[] = {0x85dd,0x6f26,0x5a67,0x3f06};
short Je[] = {
0x107b,0x1c65,0xbce1,0x3f51,
0x2b21,0xc46c,0x4e9b,0xbec5,
0x1061,0xb881,0x02e5,0xbebb,
};

short AM[] = {0xde5a,0xfaf9,0x5d43,0x3ee8};

short Jm[] = {
0x70b6,0x1396,0x7f0f,0x3f2a,
0x6b20,0xeb27,0x6e1e,0x3ee9,
0xdbeb,0x743c,0x8352,0xbe83,
};
short Cnm[] = {
0x2d4f,0xbfb9,0x630d,0x3ef7,
0xd5a6,0x43d2,0x1998,0x3f00,
0x9b68,0x74f4,0x80e2,0x3ed4,
0xd94e,0xe02c,0x17b4,0x3eb8,
0x0276,0x0d60,0x1b1b,0xbede,
0x98f0,0x3391,0x26af,0xbeb8,
0x6738,0x398d,0xf20f,0xbe76,
0x72ec,0x0db0,0xca75,0xbe84,
};
short Snm[] = {
0x0000,0x0000,0x0000,0x0000,
0x0433,0xeddb,0x8868,0x3ed7,
0xf086,0x7b25,0x4f75,0x3ebc,
0x2d26,0x8009,0x702a,0xbe96,
0x9be9,0xd6f2,0xb990,0x3ec8,
0x0bce,0x58aa,0x3224,0xbec8,
0x7ebf,0x7803,0x792d,0xbeaa,
0x4c3e,0xcc08,0x4820,0x3e6e,
};
short K2M[] = {0x9b68,0x42f9,0xbfce,0x3f96};
short LOVENO[] = {0x3333,0x3333,0x3333,0x3fd3};
short PHASE[] = {0x3ed7,0xc8f9,0xd6a1,0x3fa4};
short PSLP1[] = {0x68ee,0xc875,0x6fb4,0x3fcd};
short PSLPI[] = {0x4e1f,0x3680,0x5253,0x403b};
short PSLPIA[] = {0x0000,0x3400,0x5253,0x403b};
short PSLPIB[] = {0x397b,0xfa49,0x0270,0x3e84};
short JDEPOCH[] = {0x0000,0x4000,0x9e68,0x4142};
short LBET[] = {0x2ad9,0x0445,0xb2f9,0x3f44};
short LGAM[] = {0x44a6,0xa481,0xe327,0x3f2d};
short LGAMBET[] = {0x94f0,0x7637,0x745e,0xbf3a};
short CMRSQ[] = {0x1755,0xa468,0x010e,0x3fd9};
short CMR2[] = {0x0314,0xd853,0xfd79,0x3dcc};
short BMR2[] = {0xc125,0x685d,0xfa7b,0x3dcc};
short AMR2[] = {0xdbbe,0x3056,0xf8ca,0x3dcc};
#endif
#if MIEEE
short DTR[] = {0x3f91,0xdf46,0xa252,0x9d39};
short RTD[] = {0x404c,0xa5dc,0x1a63,0xc1f8};
short RTS[] = {0x4109,0x2dc6,0x7331,0xad7b};
short STR[] = {0x3ed4,0x55a5,0xb2ff,0x8f9d};
short PI[] = {0x4009,0x21fb,0x5444,0x2d18};
short J2000[] = {0x4142,0xb42c,0x8000,0x0000};
short B1950[] = {0x4142,0x9081,0x3624,0xdd2f};
short J1900[] = {0x4142,0x6cd6,0x0000,0x0000};
short B1900[] = {0x4142,0x6cd6,0x2810,0x624e};
short Jcentury[] = {0x40e1,0xd5a0,0x0000,0x0000};
short Jmillenium[] = {0x4116,0x4b08,0x0000,0x0000};
short Jtmillenium[] = {0x414b,0xddca,0x0000,0x0000};
short Zero[] = {0x0000,0x0000,0x0000,0x0000};
short Fourth[] = {0x3fd0,0x0000,0x0000,0x0000};
short Half[] = {0x3fe0,0x0000,0x0000,0x0000};
short One[] = {0x3ff0,0x0000,0x0000,0x0000};
short OneandaHalf[] = {0x3ff8,0x0000,0x0000,0x0000};
short Two[] = {0x4000,0x0000,0x0000,0x0000};
short Three[] = {0x4008,0x0000,0x0000,0x0000};
short ThreeandaHalf[] = {0x400c,0x0000,0x0000,0x0000};
short Four[] = {0x4010,0x0000,0x0000,0x0000};
short Five[] = {0x4014,0x0000,0x0000,0x0000};
short Six[] = {0x4018,0x0000,0x0000,0x0000};
short Ten[] = {0x4024,0x0000,0x0000,0x0000};

short JD0[] = {0x4142,0x9e68,0x4000,0x0000};
short yn0[4*6*NTOTAL] = {
0x3f1a,0x37ed,0x3903,0xa479,
0x3f78,0xb682,0x9614,0xd720,
0x3eef,0x4184,0x77ee,0xc10e,
0x3fd8,0x7920,0x8513,0x4406,
0xbf1f,0x4f19,0x25d8,0x7f80,
0x3ff4,0x7fd0,0x2618,0xcf9f,
0x3f6e,0x614d,0x8640,0x0dd3,
0x3fd7,0x0f43,0x8e0e,0xad8d,
0x3f99,0x7394,0x0c32,0xbbc3,
0xbfb8,0x45a8,0x1cd8,0x787c,
0x3f8a,0x7a93,0xa313,0x5fd5,
0xbfb6,0x643a,0x11c9,0xb8df,
0x3f86,0xd94b,0xa3b4,0x18a2,
0x3fe3,0x73a0,0x9906,0xd806,
0x3f8f,0xbb5b,0x9ce7,0x1500,
0xbfd6,0xbb54,0x18f8,0xef55,
0x3f79,0xb652,0x2b4f,0xfd65,
0xbfc9,0x5ff9,0xa358,0x657d,
0x3f91,0x3cbc,0x5a77,0x467c,
0x3fbb,0xb37c,0x3941,0xdb72,
0x3f59,0x8ff7,0xe0d6,0x6d8d,
0xbfed,0xaae4,0xe9c0,0x8a59,
0x3f46,0x2a92,0x8686,0x60c3,
0xbfd9,0xbbe6,0x4916,0x4052,
0x3f8d,0xa8b2,0x4e27,0xc307,
0xbfc0,0x6120,0x8e75,0xde62,
0x3f15,0x1c2d,0xc14f,0xfa3e,
0xbff5,0x385e,0x4b33,0x990b,
0xbf37,0x0fb9,0x145b,0xb969,
0xbfe3,0x5eaf,0x1074,0x2af2,
0x3f50,0x78b9,0x3fff,0x86d9,
0xc015,0x8f08,0xead6,0xf03b,
0xbf7a,0xbf09,0x4115,0xf544,
0xbfe8,0xa603,0xd2e1,0xfa7f,
0xbf67,0x264c,0x1a7c,0x0667,
0xbfc9,0x6dd5,0x08ba,0xa25a,
0xbf69,0xe1e1,0x86fc,0x39d8,
0x401f,0xcfa4,0xbc40,0x867d,
0x3f71,0xe7cf,0xc754,0xdfa5,
0x4012,0x0812,0x46b9,0x00c3,
0x3f5f,0xda4f,0xe937,0x635e,
0x3ff8,0x52b8,0x8b0c,0x48d8,
0x3f26,0x6c98,0xaff3,0xc0dd,
0xc032,0x473a,0x834e,0xeffd,
0xbf6e,0xd716,0x1153,0xdb5c,
0xbfee,0xa508,0xa7cd,0x3d5a,
0xbf5b,0x10da,0xfbfa,0x3d83,
0xbfc4,0xa632,0x36d8,0x7aaa,
0x3f65,0x7bd5,0x0001,0xdebd,
0xc030,0x5e00,0x40bd,0x4b76,
0xbf59,0x07d6,0x2f91,0x657e,
0xc037,0xc2ca,0x20b7,0x1c61,
0xbf46,0xab81,0xdad4,0xebac,
0xc022,0xa48c,0xc96a,0xeea9,
0x3f32,0x7771,0x7ea6,0x6d46,
0xc03e,0x729b,0x2c57,0x0471,
0xbf69,0xc7a6,0xcaa4,0x738a,
0xbfe1,0x0456,0x2067,0x676f,
0xbf51,0xaf6e,0x7c34,0x52c0,
0x4022,0x1e8b,0x8eb3,0x2af1,
0x3f43,0x9eb2,0x622d,0x7ce0,
0xbf4b,0x6262,0xe133,0x89e4,
0xbf26,0xd3a1,0x0216,0x4f4f,
0xbf60,0x43c4,0x8803,0x9bd6,
0xbf17,0x319a,0xa840,0x7dd2,
0xbf51,0xbf8e,0xfc4a,0x0681,
0xbe93,0x09d5,0x71ec,0x48a5,
0x3f72,0x7db4,0x3593,0x6a9d,
0x3ed5,0xbb43,0xdfe0,0x746b,
0x3f47,0xaf86,0x31ad,0x49f8,
0x3ec2,0xb64d,0xa9ae,0xfbb2,
0x3f30,0x291c,0x4d38,0x8354,
};
short JD1[] = {0x4142,0x9f30,0x4000,0x0000};
short yn1[4*6*NTOTAL] = {
0x3f1f,0x678a,0xba4a,0xa4f1,
0x3fa0,0xbac5,0x0a33,0x4c98,
0xbf11,0xfac1,0x3b24,0x409d,
0x3fd8,0xa805,0xea01,0x776e,
0xbf19,0xe5d4,0x655e,0x42dd,
0x3ff4,0x185d,0xfa9f,0x75ea,
0x3f87,0xd6be,0x66c8,0x110e,
0xbfd5,0xfbf3,0xe5f1,0xb307,
0xbf92,0x6562,0x6579,0x8750,
0xbfd0,0x137b,0x75c9,0x79b6,
0xbf86,0x2762,0xe7fb,0xfba7,
0xbfb9,0x6343,0x7689,0xeab8,
0x3f93,0x0b2a,0x7b70,0x5d56,
0xbfd1,0x39b1,0x67e6,0x8633,
0xbf7a,0xfa6c,0xbdd4,0xda89,
0xbfe3,0xbad4,0xf193,0xc222,
0xbf70,0xf818,0x4c64,0x7407,
0xbfd0,0xaf6d,0xb8bd,0xc2b1,
0x3f8a,0xcb90,0x8add,0x4358,
0x3fe4,0x9032,0x64d2,0x94c2,
0x3f84,0x3e61,0xff72,0xf4e0,
0xbfe7,0x1116,0x9a32,0x8df8,
0x3f71,0x8e7d,0x738d,0x228f,
0xbfd4,0x0244,0x7c73,0x8045,
0xbf85,0x1281,0x6cc4,0x1a91,
0xbff0,0xa1c4,0x9c3e,0x92d8,
0xbf7c,0xf7e1,0x1159,0x8a30,
0x3ff2,0x6f93,0x9ccd,0x39d3,
0xbf68,0x5533,0x1867,0xf56c,
0x3fe1,0xd117,0xbb5e,0xc57a,
0x3f72,0xef6c,0xf903,0xdec3,
0xc010,0xf30e,0xe978,0x50f0,
0xbf74,0xb52c,0x1bd8,0xafa7,
0xc009,0x2bfa,0x32c3,0x8613,
0xbf62,0xb160,0x836f,0x4682,
0xbff3,0xf088,0xc040,0x9f24,
0xbf71,0x6e65,0xcabf,0x53cd,
0x4019,0xda84,0xfe3d,0x36af,
0x3f6d,0x30ca,0xa73d,0x30d1,
0x4018,0x6a3f,0x1f17,0xb53a,
0x3f5b,0x278a,0xd8ad,0x3d27,
0x4001,0xf4a8,0x6968,0x35db,
0x3f41,0x2120,0x489a,0xee4c,
0xc032,0x23ab,0xd871,0xb546,
0xbf6e,0x9209,0xc3dd,0xaca3,
0xc003,0xa9c1,0x9e48,0x0bf2,
0xbf5a,0xe92d,0x5f5f,0xdc66,
0xbfea,0x42ad,0xa034,0x73c0,
0x3f66,0x090a,0xfa60,0xde76,
0xc02e,0x9bef,0xef47,0xad6e,
0xbf57,0x5ab8,0xf97f,0x5f1e,
0xc038,0x5a03,0xafed,0x937f,
0xbf45,0x5a29,0xa8d3,0xfb0f,
0xc023,0x2e23,0x8e36,0x9d22,
0x3f39,0xe60d,0xd197,0x162a,
0xc03e,0x4ff5,0xd74a,0xefdb,
0xbf69,0xbe90,0x0cda,0xfa3f,
0xbffc,0xa33f,0x6782,0x4cf0,
0xbf52,0x39e4,0x0fdd,0x0ed3,
0x4021,0x3e14,0xf1ce,0xdfb3,
0xbf3e,0x0ad3,0x343d,0xf74e,
0xbf5a,0x3c59,0x06a1,0x1bd1,
0xbf32,0x43c2,0xc806,0xd241,
0x3f60,0x0890,0x41cf,0xac3c,
0xbf26,0x5fa6,0x4a6c,0x5f17,
0x3f4f,0xbc39,0x7caa,0x6280,
0xbecc,0xe242,0xc604,0x5695,
0x3f6e,0xf6e0,0xd624,0x2615,
0x3ed0,0xedad,0xa4db,0xd7aa,
0x3f65,0x8cae,0x3244,0xa17d,
0x3ebe,0x5dfe,0x281a,0x7a70,
0x3f51,0xb9bb,0xdfe4,0x486d,
};

short CLIGHT[] = {0x4112,0x4c41,0xd4fd,0xf3b6};
short C[] = {0x4065,0xa4a0,0xd4cc,0x9453};
short EMRAT[] = {0x4054,0x533c,0xd141,0xa693};
short KG[] = {0x3f91,0x9d6d,0x51a6,0xb69a};
short GMs[] = {
0x0000,0x0000,0x0000,0x0000,
0x3dcb,0x01cb,0xbfef,0x30a7,
0x3e08,0xe369,0x5596,0x9305,
0x3e0e,0x89b2,0x7bf8,0x614e,
0x3dda,0x3fe2,0x330d,0xe19b,
0x3e92,0xf5e6,0x991b,0x594a,
0x3e76,0xb54d,0x700f,0xa2cf,
0x3e4b,0xad57,0x9a62,0xddff,
0x3e50,0x7370,0x4ffd,0xf7c8,
0x3d84,0x05a7,0x7dd0,0xde3d,
0x3da8,0x0a1b,0xbc9f,0x5e14,
0x3f33,0x6495,0x41cf,0x95e6,
0x3d48,0x92a0,0xc1f4,0x5b6d,
0x3d22,0x03af,0x9ee7,0x5616,
0x3d26,0xf7e6,0x5100,0x8dc2,
0x3cdc,0xd2b2,0x97d8,0x89bc,
0x3ce7,0x6b31,0x1b5f,0xefe9,
};
short AU[] = {0x4241,0x6a5d,0x2d22,0x0000};
short RADS[] = {0x4125,0x3d80,0x0000,0x0000};
short RADM[] = {0x409b,0x2800,0x0000,0x0000};
short RADE[] = {0x40b8,0xea23,0xd70a,0x3d71};
short AE[] = {0x3f06,0x5a67,0x6f26,0x85dd};
short Je[] = {
0x3f51,0xbce1,0x1c65,0x107b,
0xbec5,0x4e9b,0xc46c,0x2b21,
0xbebb,0x02e5,0xb881,0x1061,
};
short AM[] = {0x3ee8,0x5d43,0xfaf9,0xde5a};
short Jm[] = {
0x3f2a,0x7f0f,0x1396,0x70b6,
0x3ee9,0x6e1e,0xeb27,0x6b20,
0xbe83,0x8352,0x743c,0xdbeb,
};
short Cnm[] = {
0x3ef7,0x630d,0xbfb9,0x2d4f,
0x3f00,0x1998,0x43d2,0xd5a6,
0x3ed4,0x80e2,0x74f4,0x9b68,
0x3eb8,0x17b4,0xe02c,0xd94e,
0xbede,0x1b1b,0x0d60,0x0276,
0xbeb8,0x26af,0x3391,0x98f0,
0xbe76,0xf20f,0x398d,0x6738,
0xbe84,0xca75,0x0db0,0x72ec,
};
short Snm[] = {
0x0000,0x0000,0x0000,0x0000,
0x3ed7,0x8868,0xeddb,0x0433,
0x3ebc,0x4f75,0x7b25,0xf086,
0xbe96,0x702a,0x8009,0x2d26,
0x3ec8,0xb990,0xd6f2,0x9be9,
0xbec8,0x3224,0x58aa,0x0bce,
0xbeaa,0x792d,0x7803,0x7ebf,
0x3e6e,0x4820,0xcc08,0x4c3e,
};
short K2M[] = {0x3f96,0xbfce,0x42f9,0x9b68};
short LOVENO[] = {0x3fd3,0x3333,0x3333,0x3333};
short PHASE[] = {0x3fa4,0xd6a1,0xc8f9,0x3ed7};
short PSLP1[] = {0x3fcd,0x6fb4,0xc875,0x68ee};
short PSLPI[] = {0x403b,0x5253,0x3680,0x4e1f};
short PSLPIA[] = {0x403b,0x5253,0x3400,0x0000};
short PSLPIB[] = {0x3e84,0x0270,0xfa49,0x397b};
short JDEPOCH[] = {0x4142,0x9e68,0x4000,0x0000};
short LBET[] = {0x3f44,0xb2f9,0x0445,0x2ad9};
short LGAM[] = {0x3f2d,0xe327,0xa481,0x44a6};
short LGAMBET[] = {0xbf3a,0x745e,0x7637,0x94f0};
short CMRSQ[] = {0x3fd9,0x010e,0xa468,0x1755};
short CMR2[] = {0x3dcc,0xfd79,0xd853,0x0314};
short BMR2[] = {0x3dcc,0xfa7b,0x685d,0xc125};
short AMR2[] = {0x3dcc,0xf8ca,0x3056,0xdbbe};
#endif /* MIEEE */
#if DEC
short DTR[] = {0036616,0175065,0011224,0164711};
short RTD[] = {0041545,0027340,0151436,0007676};
short RTS[] = {0044511,0067063,0114615,0065726};
short STR[] = {0033642,0126455,0113774,0076351};
short PI[] = {0040511,0007732,0121041,0064302};
short J2000[] = {0045425,0120544,0000000,0000000};
short B1950[] = {0045424,0102011,0130446,0164571};
short J1900[] = {0045423,0063260,0000000,0000000};
short B1900[] = {0045423,0063261,0040203,0011157};
short Jcentury[] = {0044016,0126400,0000000,0000000};
short Jmillenium[] = {0044662,0054100,0000000,0000000};
short Jtmillenium[] = {0045536,0167120,0000000,0000000};
short Zero[] = {0000000,0000000,0000000,0000000};
short Fourth[] = {0037600,0000000,0000000,0000000};
short Half[] = {0040000,0000000,0000000,0000000};
short One[] = {0040200,0000000,0000000,0000000};
short OneandaHalf[] = {0040300,0000000,0000000,0000000};
short Two[] = {0040400,0000000,0000000,0000000};
short Three[] = {0040500,0000000,0000000,0000000};
short ThreeandaHalf[] = {0040540,0000000,0000000,0000000};
short Four[] = {0040600,0000000,0000000,0000000};
short Five[] = {0040640,0000000,0000000,0000000};
short Six[] = {0040700,0000000,0000000,0000000};
short Ten[] = {0041040,0000000,0000000,0000000};

short JD0[] = {0045424,0171502,0000000,0000000};
short yn0[4*6*NTOTAL] = {
0034721,0137551,0144035,0021713,
0036305,0132024,0130246,0134404,
0034172,0006043,0137566,0004160,
0037703,0144404,0024232,0020055,
0134772,0074311,0027303,0176000,
0040243,0177201,0030306,0076374,
0036163,0005154,0031000,0067224,
0037670,0075034,0070165,0066146,
0036713,0116240,0060625,0157031,
0137302,0026500,0163303,0141735,
0036523,0152235,0014232,0177246,
0137263,0020720,0107115,0143366,
0036466,0145135,0016640,0142422,
0040033,0116404,0144066,0140060,
0036575,0155334,0163470,0124001,
0137665,0155240,0143707,0075252,
0036315,0131221,0055177,0165446,
0137512,0177715,0015303,0025746,
0036611,0162742,0151672,0031742,
0037335,0115741,0145016,0155617,
0035714,0077677,0003263,0066153,
0140155,0053447,0047004,0051311,
0035461,0052224,0032063,0003026,
0137715,0157462,0044262,0001222,
0036555,0042622,0070476,0014073,
0137403,0004404,0071656,0171423,
0034650,0160556,0005177,0150761,
0140251,0141362,0054634,0144127,
0135270,0076710,0121335,0145512,
0140032,0172570,0101641,0053621,
0035603,0142711,0177774,0033314,
0140654,0074107,0053267,0100732,
0136325,0174112,0004257,0125042,
0140105,0030036,0113417,0151767,
0136071,0031140,0151740,0031466,
0137513,0067250,0042725,0011320,
0136117,0007414,0033741,0147276,
0040776,0076445,0161004,0031746,
0036217,0037176,0035246,0176452,
0040620,0040222,0032710,0003031,
0035776,0151177,0044673,0015363,
0040302,0112704,0054142,0043277,
0035063,0062305,0077636,0003353,
0141222,0034724,0015167,0077745,
0136166,0134260,0105236,0155337,
0140165,0024105,0037151,0165317,
0135730,0103327,0157721,0166030,
0137445,0030621,0133303,0152523,
0036053,0157250,0000016,0172753,
0141202,0170002,0002752,0055657,
0135710,0037261,0076213,0025756,
0141276,0013121,0002670,0161411,
0135465,0056016,0153247,0056536,
0141025,0022146,0045527,0072510,
0035223,0135613,0172463,0065057,
0141363,0112331,0061270,0021607,
0136116,0036466,0052443,0116123,
0140010,0021261,0001473,0035572,
0135615,0075563,0160642,0113003,
0041020,0172134,0072631,0053605,
0035434,0172623,0010553,0163377,
0135533,0011427,0004634,0047444,
0135066,0116410,0010262,0075172,
0136002,0017044,0040034,0157263,
0134671,0106325,0041003,0167217,
0135615,0176167,0161120,0032011,
0132630,0047253,0107542,0042451,
0036223,0166641,0126233,0052345,
0033655,0155036,0177403,0121527,
0035475,0076061,0106552,0047675,
0033425,0131155,0046567,0156615,
0035201,0044342,0064704,0015237,
};
short JD1[] = {0045424,0174602,0000000,0000000};
short yn1[4*6*NTOTAL] = {
0034773,0036125,0151125,0023612,
0037005,0153050,0050632,0062276,
0134617,0153011,0154442,0002351,
0037705,0040057,0050013,0135554,
0134717,0027243,0025362,0013345,
0040240,0141357,0152373,0127515,
0036476,0132763,0033100,0104156,
0137657,0157637,0027615,0114067,
0136623,0025423,0025714,0035174,
0137600,0115733,0127113,0146662,
0136461,0035427,0037737,0156470,
0137313,0015033,0132117,0052700,
0036630,0054523,0155602,0165264,
0137611,0146613,0037464,0030630,
0136327,0151545,0167246,0152106,
0140035,0153247,0106236,0010422,
0136207,0140302,0061443,0120073,
0137605,0075555,0142756,0012611,
0036526,0056204,0053352,0015303,
0040044,0100623,0023224,0123021,
0036441,0171417,0175627,0123401,
0140070,0104264,0150624,0067701,
0036214,0071753,0116151,0012173,
0137640,0011043,0161634,0001044,
0136450,0112013,0063040,0152204,
0140205,0007044,0160764,0113275,
0136347,0137410,0105314,0050577,
0040223,0076234,0163151,0147234,
0136102,0124630,0141477,0125540,
0040016,0104275,0155366,0025722,
0036227,0075547,0144036,0173025,
0140607,0114167,0045702,0103601,
0136245,0124540,0157305,0076473,
0140511,0057721,0113034,0030231,
0136025,0105404,0015572,0032022,
0140237,0102106,0001004,0174444,
0136213,0071456,0052772,0117152,
0040716,0152047,0170751,0132573,
0036151,0103125,0034751,0103204,
0040703,0050770,0174275,0124723,
0035731,0036126,0142551,0164473,
0040417,0122503,0045501,0127324,
0035411,0004402,0042327,0071143,
0141221,0016536,0141615,0125056,
0136164,0110116,0017355,0062433,
0140435,0047014,0171100,0057615,
0135727,0044552,0175376,0161460,
0140122,0012555,0000643,0116774,
0036060,0044127,0151406,0171660,
0141164,0157577,0075075,0065563,
0135672,0152707,0145772,0174362,
0141302,0150035,0077554,0115770,
0135452,0150515,0043237,0154166,
0141031,0070434,0070664,0164414,
0035317,0030156,0106270,0130522,
0141362,0077656,0135127,0077334,
0136115,0172200,0063327,0150774,
0140345,0014773,0036022,0063604,
0135621,0147440,0077350,0073226,
0041011,0170247,0107166,0176634,
0135360,0053231,0120757,0135156,
0135721,0161310,0032410,0157214,
0135222,0017026,0040066,0111005,
0036000,0042202,0007175,0060741,
0135062,0176462,0051542,0174267,
0035575,0160713,0162523,0012000,
0133547,0011026,0030042,0132250,
0036167,0133406,0130441,0030251,
0033607,0066555,0023336,0136516,
0036054,0062561,0111045,0005747,
0033362,0167761,0040323,0151603,
0035615,0146736,0177442,0041544,
};

short CLIGHT[] = {0044622,0061016,0123757,0116662};
short C[] = {0042055,0022406,0123144,0121226};
short EMRAT[] = {0041642,0114746,0105015,0032234};
short KG[] = {0036614,0165552,0106465,0132315};
short GMs[] = {
0000000,0000000,0000000,0000000,
0027530,0007135,0177571,0102467,
0030507,0015512,0126264,0114046,
0030564,0046623,0157703,0005155,
0027721,0177421,0114157,0006325,
0032627,0127464,0144332,0145115,
0032265,0125153,0100175,0013174,
0031535,0065274,0151426,0167765,
0031603,0115602,0077757,0137100,
0026440,0026473,0167206,0170745,
0027100,0050335,0162372,0170240,
0035233,0022252,0007174,0127461,
0025504,0112406,0007642,0155545,
0025020,0016574,0173472,0130255,
0025067,0137462,0104004,0067020,
0023746,0112624,0137304,0046741,
0024073,0054610,0155377,0077507,
};
short AU[] = {0051413,0051351,0064420,0000000};
short RADS[] = {0045051,0166000,0000000,0000000};
short RADM[] = {0042731,0040000,0000000,0000000};
short RADE[] = {0043307,0050436,0134121,0165605};
short AE[] = {0034462,0151473,0074464,0027350};
short Je[] = {
0035615,0163410,0161450,0101730,
0133452,0072336,0021541,0054413,
0133330,0013455,0142010,0101406,
};

short AM[] = {0034102,0165037,0153716,0171321};

short Jm[] = {
0035123,0174170,0116263,0102663,
0034113,0070367,0054473,0054401,
0132434,0015223,0120746,0157531,
};
short Cnm[] = {
0034273,0014155,0176711,0065164,
0034400,0146302,0017226,0126456,
0033644,0003423,0123644,0155476,
0033300,0136647,0000546,0145162,
0133760,0154330,0065400,0011661,
0133301,0032571,0116214,0143603,
0132267,0110171,0146153,0034675,
0132446,0051650,0066603,0113540,
};
short Snm[] = {
0000000,0000000,0000000,0000000,
0033674,0041507,0067330,0020625,
0033342,0075653,0154457,0102055,
0132663,0100524,0000111,0064455,
0033505,0146206,0133624,0157510,
0133501,0110442,0142520,0057164,
0133123,0144553,0140033,0172770,
0032162,0040406,0060102,0060761,
};
short K2M[] = {0036665,0177162,0013714,0155474};
short LOVENO[] = {0037631,0114631,0114631,0114632};
short PHASE[] = {0037046,0132416,0043711,0173267};
short PSLP1[] = {0037553,0076646,0041653,0043554};
short PSLPI[] = {0041332,0111231,0132002,0070372};
short PSLPIA[] = {0041332,0111231,0120000,0000000};
short PSLPIB[] = {0032440,0011607,0151111,0145731};
short JDEPOCH[] = {0045424,0171502,0000000,0000000};
short LBET[] = {0035445,0113710,0021051,0053304};
short LGAM[] = {0035157,0014475,0022012,0022456};
short LGAMBET[] = {0135323,0121363,0130674,0123574};
short CMRSQ[] = {0037710,0004165,0021500,0135246};
short CMR2[] = {0027547,0165716,0141230,0014243};
short BMR2[] = {0027547,0151733,0041356,0004454};
short AMR2[] = {0027547,0143121,0101266,0156762};
#endif /* DEC */
