/* Configuration settings for ssystem.c
 */
#define DE200 0
#define DE102 0
#define DE118 1

/* Compute relativity corrections, or not: */
#define DOREL 1

/* Include the Moon as a separate body, or not: */
#define MOON 1
#define LIBRAT 1

/* Include the five asteroids that are in JPL's model, or not: */
#define AROIDS 1

/* Index to first mass. The lunar librattion angles
 * are the first items in the array.
 */
#if LIBRAT
#define FMASS 1
#else
#define FMASS 0
#endif

#if MOON
#define NBODY 11
#define IMOON (9+FMASS)
#else
#undef LIBRAT
#define LIBRAT 0
#undef FMASS
#define FMASS 0
#define NBODY 10
#endif

#define IAROIDS (NBODY+FMASS)
#if AROIDS
#define NTOTAL (NBODY+FMASS+5)
#endif

#ifndef NTOTAL
#define NTOTAL (NBODY+FMASS)
#endif

#define IEARTH (2+FMASS)
#define ISUN (NBODY+FMASS-1)

#define NEQ (6*NTOTAL)

#define NEQC (6*(NBODY+FMASS))

