/***************************************************
   N-Body Globular Cluster MAIN PROGRAM/ FUNCTIONS
   This File (C) Copyright 1998 Graeme Fenwick 
***************************************************/ 

#include "gl.h"                                      /* typedef for SETTINGS */
#include "gl_arg.h"
#include "gl_inter.h"
#include "gl_gfx.h"
#include <stdio.h>
#include <stdlib.h>

int mem_allocate(int n, double ***pos, double ***vel, double ***frc);

int main(int argc, char **argv)
{
   int        n = 150;                                           /* defaults */
   SETTINGS   config = {0, 0, 0, 1, 0.02, 25, 250, 3.0, 2.0};
   double     vbar[3], ke = 1110, pe, **pos, **vel, **frc;

   argparse(argc, argv, &n, &config);
   if (mem_allocate(n, &pos, &vel, &frc) != 1) {
      printf("\nUnable to allocate required memory. Exiting Program.\n");
      exit(EXIT_FAILURE);
   }
   initialize(n, config.seed, pos, vel, vbar, &ke);
   pe = calc_pe(n, pos, config);
   initialize_screen();                          /* indirectly calls allegro */
   interact(n, pe, ke, frc, pos, vel, config);
   return 0;                             
}

/********** ALLOCATE MEMory for body attributes */

int mem_allocate(int n, double ***pos, double ***vel, double ***frc)
{
   *pos = malloc(sizeof(double *) * n);
   *vel = malloc(sizeof(double *) * n);
   *frc = malloc(sizeof(double *) * n);
   if (*pos == NULL || *vel == NULL || *frc == NULL)
      return 0;                                      /* zero = malloc failed */
   for (--n; n >= 0; --n) {
      ((*pos)[n]) = malloc(sizeof(double) * 3);
      ((*vel)[n]) = malloc(sizeof(double) * 3);
      ((*frc)[n]) = malloc(sizeof(double) * 3);
      if ((**pos + n) == NULL || (**vel + n) == NULL || (**frc + n) == NULL)
         return 0;
   } 
   return 1;
}

/********** Supress globbing under DJGPP */

char **__crt0_glob_function(char *_arg)
{
   return NULL;          /* provision of function overrides default globbing */
}
