/****************************************************************

	ui_icon.c       Icon-based Selection routines for
			The Bywater Graphical User Interface

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

****************************************************************/

#include "stdio.h"
#include "gr.h"
#include "dr.h"
#include "kb.h"
#include "ui.h"

#define USESMALLFONT
#define SMALLFONTSIZE   35

/****************************************************************

   ui_ficon()   File selection -- icon-based

****************************************************************/

ui_ficon( x1, y1, x2, y2, specifier, title, m_box,
   d_entries, max_entries,
   background, foreground, highlight )
   int x1, y1, x2, y2, background, foreground, highlight, max_entries;
   struct menu_box *m_box;
   char *specifier, *title;
   struct dir_ent **d_entries;
   {
   register int c, test;
   int carry_on, mo_xsrc, mo_ysrc;
   static int x_pos, y_pos, b_stat, item;

   uii_draw( x1, y1, x2, y2, specifier, title, m_box,
      d_entries, max_entries,
      background, foreground, highlight );

   uii_activate( m_box, 0 );

   test = FALSE;
   carry_on = TRUE;
   while( carry_on == TRUE )
      {
      if ( kb_rxstat() == TRUE )
	 {
	 c = kb_rx();
	 test = TRUE;
	 }
      else if ( gr_ismouse == TRUE )
	 {
	 if ( gr_mouse( SAMPLE, &x_pos, &y_pos, &b_stat )
	    == TRUE )
	    {
	    c = 0;
	    test = TRUE;
	    gr_mouse( WAIT, &x_pos, &y_pos, &b_stat );
	    mo_xsrc = x_pos;
	    mo_ysrc = y_pos;
	    gr_mouse( WAIT, &x_pos, &y_pos, &b_stat );
	    }
	 }

      if ( test == TRUE )
	 {
	 c = uii_event( m_box, c, mo_xsrc, mo_ysrc, x_pos, y_pos, &item );
	    switch( c )
	    {
	    case EVENT_SELECTED:
	       carry_on = FALSE;
	       break;
	    case EVENT_EXIT:
	       item = TK_EXIT;
	       carry_on = FALSE;
	       break;
	    case EVENT_ERROR:
	       bw_error( "Error return from uil_event()" );
	       carry_on = FALSE;
	       break;
	    case EVENT_NULL:
	    default:
	       test = FALSE;
	       break;
	    }
	 }

      ui_poll();

      }

   uii_deactivate( m_box );

   return item;

   }

/****************************************************************

	uii_draw()      - draw file selection icon area

****************************************************************/

uii_draw( x1, y1, x2, y2, specifier, title, m_box,
   d_entries, max_entries,
   background, foreground, highlight )
   int x1, y1, x2, y2, background, foreground, highlight, max_entries;
   struct menu_box *m_box;
   char *specifier, *title;
   struct dir_ent **d_entries;
   {
   register int number, c;
   int x, y;
   int carry_on;

#ifdef  OLD_DEBUG
   sprintf( ui_tbuf, "uii_draw(): %d %d %d %d", x1, y1, x2, y2 );
   bw_debug( ui_tbuf );
   sprintf( ui_tbuf, "uii_draw(): is_drawn = %d", m_box->is_drawn );
   bw_debug( ui_tbuf );
#endif

   /* First check for existence of the file */

   number = 0;
   if ( dr_first( specifier, d_entries[ number ] ) == FALSE )
      {
      return TK_ERROR;
      }

   /* Find all entries */

   number = 1;
   while( ( dr_next( d_entries[ number ] ) == TRUE )
      && ( number < max_entries ))
      {
      ++number;
      }
   m_box->number = number;

   /* the following are performed only if the window has not been
      redrawn -- programmer may force redrawing of the whole menu
      box by setting the is_drawn int to 0 (FALSE) */

   if ( m_box->is_drawn != TRUE )
      {

      /* draw the menu window */

      if ( m_box->window == NULL )
         {

#ifdef  OLD_DEBUG
   sprintf( ui_tbuf, "uii_draw(): ready to draw window" );
   bw_debug( ui_tbuf );
#endif

	 m_box->window = ui_window( x1, y1, x2, y2,
            TRUE, highlight, foreground,
            title, TRUE, BLACK,
	    FALSE, BLACK, background, SOLID,
	    BUT_CLOSE | BUT_MOVE | BUT_RESIZE );
         }
      else
         {

#ifdef  OLD_DEBUG
   sprintf( ui_tbuf, "uii_draw(): redraw window" );
   bw_debug( ui_tbuf );
#endif

	 ui_rewindow( m_box->window, title );
         }
      }

   /* on the other hand, if the menu box is not to be redrawn,
      it should in any case be retitled */

   else
      {
      ui_wtitle( m_box->window, title );
      }

#ifdef  OLD_DEBUG
   sprintf( ui_tbuf, "uii_draw() found %d entries", m_box->number );
   bw_debug( ui_tbuf );
#endif

   /* save font style and size, then attempt to set small font */

#ifdef  USESMALLFONT
   m_box->save_font = ui_grwind->font;
   m_box->save_fysize = ui_grwind->fysize;
   gr_font( ui_screen, F_DEFAULT, ui_grwind->ymax / SMALLFONTSIZE );
#endif

#ifdef OLD_DEBUG
   sprintf( ui_tbuf, "uii_draw(): font_set" );
   bw_debug( ui_tbuf );
#endif

   /* assign colors to structure */

   m_box->fore = foreground;
   m_box->back = background;
   m_box->high = highlight;

   /* save d_titles */

   m_box->d_entries = d_entries;
   m_box->max_entries = max_entries;
   m_box->type = MENU_ICON;

   /* calculate icon size */

   m_box->xsize = gr_strlen( "123456789012345" );
   m_box->ysize = ui_grwind->fysize * 4;

#ifdef  OLD_DEBUG
   sprintf( ui_tbuf, "ui_ficon(): icon size calculated" );
   bw_debug( ui_tbuf );
#endif

   /* the sliders have to be redrawn only if the is_drawn int
      is 0 (FALSE) */

   if ( m_box->is_drawn != TRUE )
      {
      uil_sliders( m_box );
      }

#ifdef  OLD_DEBUG
   sprintf( ui_tbuf, "ui_ficon(): sliders drawn" );
   bw_debug( ui_tbuf );
#endif

   /* abort if a single icon will not fit */

   if ( ( m_box->i_x2 - m_box->i_x1 ) < m_box->xsize )
      {
#ifdef  USESMALLFONT
   gr_font( ui_screen, m_box->save_font,
      m_box->save_fysize );
#endif
      return TK_ERROR;
      }

   if ( ( m_box->i_y2 - m_box->i_y1 ) < m_box->ysize )
      {
#ifdef  USESMALLFONT
   gr_font( ui_screen, m_box->save_font,
      m_box->save_fysize );
#endif
      return TK_ERROR;
      }

   /* calculate total number of icon spaces */

   m_box->x_items = m_box->x_logical =
      ( m_box->i_x2 - m_box->i_x1 ) / m_box->xsize;
   m_box->y_items =
      ( m_box->i_y2 - m_box->i_y1 ) / m_box->ysize;

   /* set roughly equal x and y items if all cannot be shown */

   if ( ( m_box->x_items * m_box->y_items ) < m_box->number )
      {
      for ( x = m_box->x_items + 2; (x * x) < m_box->number; ++x )
         {
         }
      --x;
      m_box->x_logical = x;
      }

   m_box->y_logical = m_box->number / m_box->x_logical;
   if (( m_box->number % m_box->x_logical ) > 0 )
      {
      ++m_box->y_logical;
      }

#ifdef  OLD_DEBUG
   sprintf( ui_tbuf, "ui_ficon() point 2" );
   bw_debug( ui_tbuf );
#endif

   /* calculate increments for elevators */

   x = ui_grwind->ymax / 15;
   y = ( x * gr_pxsize ) / gr_pysize;

   if ( m_box->y_logical <= m_box->y_items )
      {
      m_box->vel_inc = 1;
      }
   else
      {
      m_box->vel_inc = ((( m_box->ve_y2 - ( m_box->ve_y1 + y ))
         * INC_ACCURACY )
         / ( m_box->y_logical - m_box->y_items ));
      }

   if ( m_box->x_logical <= m_box->x_items )
      {
      m_box->hel_inc = 1;
      }
   else
      {
      m_box->hel_inc = ((( m_box->he_x2 - ( m_box->he_x1 + x ))
         * INC_ACCURACY )
         / ( m_box->x_logical - m_box->x_items ));
      }

#ifdef  OLD_DEBUG
   sprintf( ui_tbuf, "window:  x1 = %d, y1 = %d, x2 = %d, y2 = %d, \nicon_xsize = %d, icon_ysize = %d, number = %d, x_items = %d, y_items = %d",
      m_box->i_x1, m_box->i_y1, m_box->i_x2,
      m_box->i_y2,
      m_box->xsize, m_box->ysize, number, m_box->x_items, m_box->y_items );
   bw_debug( ui_tbuf );
   sprintf( ui_tbuf, "ui_ficon() point 3" );
   bw_debug( ui_tbuf );
#endif

   /* set initial values */

   m_box->current = m_box->x_start 
      = m_box->y_start = m_box->x_pos = m_box->y_pos = 0;

   /* Display each icon */

   uii_display( m_box );

   /* note that the menu box is now drawn */

   m_box->is_drawn = TRUE;

#ifdef  USESMALLFONT
   gr_font( ui_screen, m_box->save_font,
      m_box->save_fysize );
#endif

/*   uil_exit( m_box ); */

   }

/****************************************************************

   uii_activate()   Activate an icon menu box

****************************************************************/

uii_activate( m_box, item )
   struct menu_box *m_box;
   int item;
   {
   register int x, y;
   int carry_on;
   
#ifdef  OLD_DEBUG
   if ( m_box->d_entries == NULL )
      {
      bw_error( "Programmer error: menu box has not been drawn!" );
      return FALSE;
      }
#endif

#ifdef  USESMALLFONT
   m_box->save_font = ui_grwind->font;
   m_box->save_fysize = ui_grwind->fysize;
   gr_font( ui_screen, F_DEFAULT, ui_grwind->ymax / SMALLFONTSIZE );
#endif

   if ( item > m_box->number )
      {
      item = 0;
      }

   if ( item == 0 )
      {
      m_box->x_start = m_box->y_start = m_box->x_pos = m_box->y_pos
         = m_box->current = 0;
      }
   else if ( item != m_box->current )
      {

      m_box->current = item;
      
      /* calculate y_start */

      y = 0;
      carry_on = TRUE;
      if ( m_box->y_logical <= m_box->y_items )
         {
         y = 0;
         }
      else while( ( y < m_box->y_logical ) && ( carry_on == TRUE ))
         {
         if ( (( m_box->x_logical * y ) +
            ( m_box->x_logical * m_box->y_items )) > item )
            {
            carry_on = FALSE;
            }
         else
            {
            ++y;
            }
         }

      /* calculate x_start */

      x = 0;
      carry_on = TRUE;
      if ( m_box->x_logical <= m_box->x_items )
         {
         x = 0;

#ifdef OLD_DEBUG
      sprintf( ui_tbuf, "x_logical <= x_items" );
      ui_wtitle( m_box->window, ui_tbuf );
      ui_wait();
#endif
         }
      else while( ( x < m_box->x_logical ) && ( carry_on == TRUE ))
         {

#ifdef OLD_DEBUG
      sprintf( ui_tbuf, "item <> x_logical = %d",  item % m_box->x_logical );
      ui_wtitle( m_box->window, ui_tbuf );
      ui_wait();
      
      sprintf( ui_tbuf, "trying %d", x );
      ui_wtitle( m_box->window, ui_tbuf );
      ui_wait();
#endif

         if (( m_box->x_items + x ) > ( item % m_box->x_logical ))
            {
            carry_on = FALSE;
            }
         else
            {
            ++x;
            }
         }

#ifdef OLD_DEBUG
      sprintf( ui_tbuf, "i %d; x %d; y %d", item, x, y );
      ui_wtitle( m_box->window, ui_tbuf );
#endif

      m_box->y_start = y;
      m_box->x_start = x;
      m_box->y_pos = ( item / m_box->x_logical ) - m_box->y_start;
      m_box->x_pos = ( item % m_box->x_logical ) - m_box->x_start;

      uii_display( m_box );
      }

   /* show current item selected */

   uii_icon( m_box, m_box->current, TRUE );

#ifdef  USESMALLFONT
   gr_font( ui_screen, m_box->save_font,
      m_box->save_fysize );
#endif

   }

/****************************************************************

   uii_deactivate()   Deactivate an icon menu box

****************************************************************/

uii_deactivate( m_box )
   struct menu_box *m_box;
   {

#ifdef  USESMALLFONT
   m_box->save_font = ui_grwind->font;
   m_box->save_fysize = ui_grwind->fysize;
   gr_font( ui_screen, F_DEFAULT, ui_grwind->ymax / SMALLFONTSIZE );
#endif

   uii_icon( m_box, m_box->current, FALSE );

#ifdef  USESMALLFONT
   gr_font( ui_screen, m_box->save_font,
      m_box->save_fysize );
#endif

   }

/****************************************************************

   uii_event()   Query if keyboard or mouse actions affect an icon
                menu box

****************************************************************/

uii_event( m_box, key, mo_xsrc, mo_ysrc, mo_xdest, mo_ydest, item )
   struct menu_box *m_box;
   int key, mo_xsrc, mo_ysrc, mo_xdest, mo_ydest;
   int *item;
   {
   static int how_far, x_sel, y_sel;
   int carry_on;
   register int c;

   how_far = 0;
   x_sel = 0;
   y_sel = 0;
   c = ui_event( m_box, key, mo_xsrc, mo_ysrc, mo_xdest, mo_ydest,
      &how_far, &x_sel, &y_sel );

   switch( c )
      {

      case CR:
      case LF:
         *item = m_box->current;
         return EVENT_SELECTED;
	 break;

      case ESCAPE:
      case TK_EXIT:
      case MO_EXIT:
	 *item = m_box->current = TK_EXIT;
         return EVENT_EXIT;
	 break;

      case KB_DOWN:

	 /* First test to see if it is possible to move
	    down one line on the y axis */

	 if ( m_box->current <
	    ( m_box->number - m_box->x_logical ))
	    {

#ifdef  USESMALLFONT
   m_box->save_font = ui_grwind->font;
   m_box->save_fysize = ui_grwind->fysize;
   gr_font( ui_screen, F_DEFAULT, ui_grwind->ymax / SMALLFONTSIZE );
#endif

	    /* show current item unselected */

	    uii_icon( m_box, m_box->current, FALSE );

	    /* advance current item and m_box->y_pos */

	    m_box->current += m_box->x_logical;
	    ++m_box->y_pos;

	    /* check to see if this will advance
	       past the visible lines in the icon
	       area */

	    if ( m_box->y_pos == m_box->y_items )
	       {
	       ++m_box->y_start;
	       --m_box->y_pos;
	       uii_display( m_box );
	       }

	    /* show current item selected */

	    uii_icon( m_box, m_box->current, TRUE );


#ifdef  USESMALLFONT
   gr_font( ui_screen, m_box->save_font,
      m_box->save_fysize );
#endif

	    }

	 *item = m_box->current;
	 return EVENT_CHANGE;
	 break;

      case KB_UP:

	 /* First test to see if it is possible to move
	    up one line on the y axis */

	 if ( m_box->current >=  m_box->x_logical )
	    {

#ifdef  USESMALLFONT
   m_box->save_font = ui_grwind->font;
   m_box->save_fysize = ui_grwind->fysize;
   gr_font( ui_screen, F_DEFAULT, ui_grwind->ymax / SMALLFONTSIZE );
#endif

	    /* show current item unselected */

	    uii_icon( m_box, m_box->current, FALSE );

	    /* decrement current item and m_box->y_pos */

	    m_box->current -= m_box->x_logical;
	    --m_box->y_pos;

	    /* check to see if this will decrement
	       past the visible lines in the icon
	       area */

	    if ( m_box->y_pos < 0 )
	       {
	       --m_box->y_start;
	       ++m_box->y_pos;
	       uii_display( m_box );
	       }

	    /* show current item selected */

	    uii_icon( m_box, m_box->current, TRUE );

#ifdef  USESMALLFONT
   gr_font( ui_screen, m_box->save_font,
      m_box->save_fysize );
#endif

	    }

	 *item = m_box->current;
	 return EVENT_CHANGE;
	 break;

      case KB_LEFT:

	 /* First test to see if it is possible to move
	    left one column on the x axis */

	 if ( ( m_box->current % m_box->x_logical ) > 0 )
	    {

#ifdef  USESMALLFONT
   m_box->save_font = ui_grwind->font;
   m_box->save_fysize = ui_grwind->fysize;
   gr_font( ui_screen, F_DEFAULT, ui_grwind->ymax / SMALLFONTSIZE );
#endif

	    /* show current item unselected */

	    uii_icon( m_box, m_box->current, FALSE );

	    /* decrement current item and m_box->x_pos */

	    --m_box->current;
	    --m_box->x_pos;

	    /* check to see if this will decrement
	       past the visible lines in the icon
	       area */

	    if ( m_box->x_pos < 0 )
	       {
	       --m_box->x_start;
	       ++m_box->x_pos;
	       uii_display( m_box );
	       }

	    /* show current item selected */

	    uii_icon( m_box, m_box->current, TRUE );


#ifdef  USESMALLFONT
   gr_font( ui_screen, m_box->save_font,
      m_box->save_fysize );
#endif

	    }

	 *item = m_box->current;
	 return EVENT_CHANGE;
	 break;

      case KB_RIGHT:

	 /* First test to see if it is possible to move
	    right one column on the x axis */

	 if ( (( m_box->current % m_box->x_logical ) <
	    ( m_box->x_logical - 1 )) &&
	    ( m_box->current < ( m_box->number-1 ) ))
	    {

#ifdef  USESMALLFONT
   m_box->save_font = ui_grwind->font;
   m_box->save_fysize = ui_grwind->fysize;
   gr_font( ui_screen, F_DEFAULT, ui_grwind->ymax / SMALLFONTSIZE );
#endif

	    /* show current item unselected */

	    uii_icon( m_box, m_box->current,
	       FALSE );

	    /* increment current item and m_box->x_pos */

	    ++m_box->current;
	    ++m_box->x_pos;

	    /* check to see if this will increment
	       past the visible lines in the icon
	       area */

	    if ( m_box->x_pos >= m_box->x_items )
	       {
	       ++m_box->x_start;
	       --m_box->x_pos;
	       uii_display( m_box );
	       }

	    /* show current item selected */

	    uii_icon( m_box, m_box->current,
	       TRUE );


#ifdef  USESMALLFONT
   gr_font( ui_screen, m_box->save_font,
      m_box->save_fysize );
#endif

	    }

	 *item = m_box->current;
	 return EVENT_CHANGE;
	 break;

      case MO_UP:

	 /* first see if it is possible to move up
	    at all */

	 if (( m_box->y_start > 0 ) && ( how_far > 0 ))
	    {

#ifdef  USESMALLFONT
   m_box->save_font = ui_grwind->font;
   m_box->save_fysize = ui_grwind->fysize;
   gr_font( ui_screen, F_DEFAULT, ui_grwind->ymax / SMALLFONTSIZE );
#endif

	    /* decrement how_far to an acceptable
	       number */

	    while ( ( m_box->y_start - how_far ) < 0 )
	       {
	       --how_far;
	       }

	    /* assign new values to m_box->y_start and
	       m_box->current */

	    m_box->y_start -= how_far;
	    m_box->current -= how_far * m_box->x_logical;

	    /* display all icons visible */

	    uii_display( m_box );

	    /* display currently selected icon */

	    uii_icon( m_box, m_box->current,
	       TRUE );


#ifdef  USESMALLFONT
   gr_font( ui_screen, m_box->save_font,
      m_box->save_fysize );
#endif

	    }

	 *item = m_box->current;
	 return EVENT_CHANGE;
	 break;

      case MO_DN:

	 /* first see if it is possible to move down
	    at all */

	 if (( m_box->y_start <
	    ( m_box->y_logical - m_box->y_items ) )
	    && ( how_far > 0 ))
	    {

#ifdef  USESMALLFONT
   m_box->save_font = ui_grwind->font;
   m_box->save_fysize = ui_grwind->fysize;
   gr_font( ui_screen, F_DEFAULT, ui_grwind->ymax / SMALLFONTSIZE );
#endif

	    /* increment how_far to an acceptable
	       number */

	    while ( ( m_box->y_start + how_far ) >
	       ( m_box->y_logical
	       - m_box->y_items ))
	       {
	       --how_far;
	       }

	    /* assign new values to m_box->y_start and
	       m_box->current */

	    m_box->y_start += how_far;
	    m_box->current += how_far * m_box->x_logical;

	    /* display all icons visible */

	    uii_display( m_box );

	    /* display currently selected icon */

	    uii_icon( m_box, m_box->current,
	       TRUE );


#ifdef  USESMALLFONT
   gr_font( ui_screen, m_box->save_font,
      m_box->save_fysize );
#endif

	    }

	 *item = m_box->current;
	 return EVENT_CHANGE;
	 break;

      case MO_RIGHT:

	 /* first see if it is possible to move right
	    at all */

	 if (( m_box->x_start <
	    ( m_box->x_logical - m_box->x_items ) )
	    && ( how_far > 0 ))
	    {

#ifdef  USESMALLFONT
   m_box->save_font = ui_grwind->font;
   m_box->save_fysize = ui_grwind->fysize;
   gr_font( ui_screen, F_DEFAULT, ui_grwind->ymax / SMALLFONTSIZE );
#endif

	    /* increment how_far to an acceptable
	       number */

	    while ( ( m_box->x_start + how_far ) >
	       ( m_box->x_logical
	       - m_box->x_items ))
	       {
	       --how_far;
	       }

	    /* assign new values to m_box->x_start and
	       m_box->current */

	    m_box->x_start += how_far;
            m_box->current += how_far;

            /* display all icons visible */

	    uii_display( m_box );

            /* display currently selected icon */

	    uii_icon( m_box, m_box->current,
               TRUE );


#ifdef  USESMALLFONT
   gr_font( ui_screen, m_box->save_font,
      m_box->save_fysize );
#endif

            }

	 *item = m_box->current;
	 return EVENT_CHANGE;
         break;

      case MO_LEFT:

         /* first see if it is possible to move left
            at all */

         if (( m_box->x_start > 0 ) && ( how_far > 0 ))
            {

#ifdef  USESMALLFONT
   m_box->save_font = ui_grwind->font;
   m_box->save_fysize = ui_grwind->fysize;
   gr_font( ui_screen, F_DEFAULT, ui_grwind->ymax / SMALLFONTSIZE );
#endif

            /* decrement how_far to an acceptable
               number */

            while ( ( m_box->x_start - how_far ) < 0 )
               {
               --how_far;
               }

            /* assign new values to m_box->x_start and
               m_box->current */

            m_box->x_start -= how_far;
            m_box->current -= how_far;

            /* display all icons visible */

	    uii_display( m_box );

            /* display currently selected icon */

	    uii_icon( m_box, m_box->current,
               TRUE );


#ifdef  USESMALLFONT
   gr_font( ui_screen, m_box->save_font,
      m_box->save_fysize );
#endif

            }

	 *item = m_box->current;
	 return EVENT_CHANGE;
         break;

      case MO_SEL:
         if ( ((( y_sel + m_box->y_start ) * m_box->x_logical )
            + x_sel + m_box->x_start ) == m_box->current )
            {
            *item = m_box->current;
            return EVENT_SELECTED;
            }
         else
            {

#ifdef  USESMALLFONT
   m_box->save_font = ui_grwind->font;
   m_box->save_fysize = ui_grwind->fysize;
   gr_font( ui_screen, F_DEFAULT, ui_grwind->ymax / SMALLFONTSIZE );
#endif

	    uii_icon( m_box, m_box->current, FALSE );
            m_box->current = (( y_sel + m_box->y_start )
               * m_box->x_logical )
               + m_box->x_start + x_sel;
            m_box->x_pos = x_sel;
            m_box->y_pos = y_sel;
	    uii_icon( m_box, m_box->current, TRUE );

#ifdef  USESMALLFONT
   gr_font( ui_screen, m_box->save_font,
      m_box->save_fysize );
#endif

            }
	 *item = m_box->current;
	 return EVENT_CHANGE;
         break;

      case MO_SRC:

          *item = (( y_sel + m_box->y_start ) * m_box->x_logical )
               + m_box->x_start + x_sel;
         return EVENT_SOURCE;
         break;

      default:
         *item = 0;
         return EVENT_NULL;
         break;

      }
   }

/****************************************************************

   uii_source()   Query if keyboard or mouse actions indicate a
		  source within a menu box

****************************************************************/

uii_source( m_box, key, mo_xsrc, mo_ysrc, mo_xdest, mo_ydest, item )
   struct menu_box *m_box;
   int key, mo_xsrc, mo_ysrc, mo_xdest, mo_ydest;
   int *item;
   {
   static int how_far, x_sel, y_sel;
   int carry_on;
   register int c;

   how_far = 0;
   x_sel = 0;
   y_sel = 0;
   c = ui_event( m_box, key, mo_xsrc, mo_ysrc, mo_xdest, mo_ydest,
      &how_far, &x_sel, &y_sel );

   if ( c == MO_SRC )
      {
      *item = (( y_sel + m_box->y_start ) * m_box->x_logical )
	 + m_box->x_start + x_sel;
      return TRUE;
      }
   else
      {
      return FALSE;
      }
   }

/****************************************************************

   uii_display()      Show all file icons

****************************************************************/

uii_display( m_box )
   struct menu_box *m_box;
   {
   register int c;

   /* blank the entire icon area */

   ui_fbox( m_box->i_x1, m_box->i_y1, m_box->i_x2, m_box->i_y2,
      m_box->back, SOLID );

   /* attempt to show each icon */

   for ( c = 0; c < m_box->number; ++c )
      {
      uii_icon( m_box, c,
         FALSE );
      }

   /* show elevators */

   uil_vel( m_box, m_box->y_start );            /* show vertical elevator */
   uil_hel( m_box, m_box->x_start );            /* show horizontal elevator */

   }

/****************************************************************

   uii_icon()   Draw file icon

****************************************************************/

uii_icon( m_box, n, selected )
   int n, selected;
   struct menu_box *m_box;
   {
   register int x, y;
   int x1, y1, x2, y2, textxpos;
   int restore_clip, clx1, cly1, clx2, cly2;
   static char buf[ 20 ];

#ifdef  OLD_DEBUG
   sprintf( ui_tbuf, "uii_icon() called; item %d ", n );
   ui_wtitle( m_box->window, ui_tbuf );
   ui_wait();
#endif

   x = ( n % m_box->x_logical ) - m_box->x_start;
   y = ( n / m_box->x_logical ) - m_box->y_start;

#ifdef  OLD_DEBUG
   sprintf( ui_tbuf, "x = %d, y = %d", x, y );
   ui_text( m_box->i_x1, m_box->i_y1, m_box->i_x2,
      m_box->i_y2, 35, m_box->back, m_box->fore, ui_tbuf );
   ui_wait();
#endif

   if ( ( x < 0 ) || ( y < 0 ))
      {
      return FALSE;
      }

   if ( ( x >= ( m_box->x_items + gr_clipping ))
      || ( y >= ( m_box->y_items + gr_clipping )))
      {
      return FALSE;
      }

   x1 = m_box->i_x1 + ( x * m_box->xsize );
   y1 = m_box->i_y2 - ( ( 1 + y ) * m_box->ysize ) - 1;
   x2 = m_box->i_x1 + ( ( 1 + x ) * m_box->xsize ) - 1;
   y2 = m_box->i_y2 - ( y * m_box->ysize );

   /* see if cliiping is in effect */

   if ( ( gr_clipping == TRUE ) && ( ui_grwind->clipping == TRUE ))
      {
      restore_clip = TRUE;
      clx1 = ui_grwind->cl_x1;
      cly1 = ui_grwind->cl_y1;
      clx2 = ui_grwind->cl_x2;
      cly2 = ui_grwind->cl_y2;
      }
   else
      {
      restore_clip = FALSE;
      }

   if ( gr_clipping == TRUE )
      {
      gr_clip( ui_screen, TRUE, m_box->i_x1, m_box->i_y1,
         m_box->i_x2, m_box->i_y2 );
      }

   /* blank the icon area */

   ui_fbox( x1, y1, x2, y2, m_box->back, SOLID );

   /* add two blanks if the name is small */

   if ( strlen( m_box->d_entries[ n ]->filename ) < 6 )
      {
      sprintf( buf, " %s ", m_box->d_entries[ n ]->filename );
      }
   else
      {
      strcpy( buf, m_box->d_entries[ n ]->filename );
      }

   /* calculate centered text position */

   textxpos = ( x1 + ( m_box->xsize / 2 ))
      - ( gr_strlen( buf ) / 2 );

   /* print the text */

   if ( selected == TRUE )
      {
      gr_text( ui_screen, textxpos, y1 + 2,
          buf, m_box->back, m_box->fore );
      }
   else
      {
      gr_text( ui_screen, textxpos, y1 + 2,
         buf, m_box->fore, m_box->back );
      }

   /* increment y1 out of text area */

   y1 += ui_grwind->fysize;

   /* draw the icon */

   switch( m_box->d_entries[ n ]->type )
      {

      case    FILE_DIRECTORY:
	 uii_folder( x1, y1, x2, y2, m_box->fore );
         break;

      case    FILE_EXECUTABLE:
	 uii_exec( x1, y1, x2, y2, m_box->fore );
         break;

      case    FILE_NORMAL:
      default:
	 uii_default( x1, y1, x2, y2, m_box->fore );
         break;
      }

   /* restore clipping or turn off clipping */

   if ( restore_clip == TRUE )
      {
      gr_clip( ui_screen, TRUE, clx1, cly1, clx2, cly2 );
      }
   else if ( gr_clipping == TRUE )
      {
      gr_clip( ui_screen, FALSE, 0, 0, 0, 0 );
      }
   }

/****************************************************************

   uii_default()   Default (blank or generic) file icon

****************************************************************/

uii_default( x1, y1, x2, y2, color )
   int x1, y1, x2, y2, color;
   {
#ifdef USE_ICONS
   ui_pbmcenter( ui_screen, x1, y1, x2, y2, &ui_deficon );
#else
   int x, y, y_center, x_center;

   /* calculate the center of the icon area */

   y_center = y1 + (( y2 - y1 ) / 2 );
   x_center = x1 + (( x2 - x1 ) / 2 );

   /* calculate appropriate sizes for the icon */

   y = ( y2 - y1 ) / 3;
   x = ((( y * gr_pysize ) / gr_pxsize ) * 3 ) / 4;

   /* draw the icon rectangle */

   gr_rectangle( ui_screen, x_center - x,
      y_center - y,
      x_center + x,
      y_center + y, color, HOLLOW );

   /* draw demarking line across the top */

   gr_line( ui_screen, x_center - x, ( y_center + y ) - 3,
      x_center + x, ( y_center + y ) - 3, color, SOLID );

#endif

   }

/****************************************************************

   uii_folder()    File folder (directory) icon

****************************************************************/

uii_folder( x1, y1, x2, y2, color )
   int x1, y1, x2, y2, color;
   {
#ifdef USE_ICONS
   ui_pbmcenter( ui_screen, x1, y1, x2, y2, &ui_foldicon );
#else
   int x, y, y_center, x_center;

   /* calculate the center of the icon area */

   y_center = y1 + (( y2 - y1 ) / 2 );
   x_center = x1 + (( x2 - x1 ) / 2 );

   /* calculate appropriate sizes for the folder */

   y = ( y2 - y1 ) / 4;
   x = ((( y * gr_pysize ) / gr_pxsize ) * 3 ) / 2;

   /* draw left side of folder */

   gr_line( ui_screen, x_center - x, y_center - y,
      x_center - x, y_center + y, color, SOLID );

   /* draw bottom of folder */

   gr_line( ui_screen, x_center - x, y_center - y,
      x_center + x, y_center - y, color, SOLID );

   /* draw right side of folder */

   gr_line( ui_screen, x_center + x, y_center - y,
      x_center + x, y_center + y, color, SOLID );

   /* draw file tab (upper) */

   gr_line( ui_screen, x_center + x, y_center + y,
      x_center + x - 4, y_center + y + 2, color, SOLID );
   gr_line( ui_screen, x_center + x - 4, y_center + y + 2,
      x_center + 4, y_center + y + 2, color, SOLID );
   gr_line( ui_screen, x_center + 4, y_center + y + 2,
      x_center, y_center + y, color, SOLID );

   /* draw top of folder (upper) */

   gr_line( ui_screen, x_center - x, y_center + y,
      x_center, y_center + y, color, SOLID );

   /* draw file tab (lower) */

   gr_line( ui_screen, x_center + x, y_center + y - 4,
      x_center + 4, y_center + y - 4, color, SOLID );
   gr_line( ui_screen, x_center + 4, y_center + y - 4,
      x_center, y_center + y - 2, color, SOLID );

   /* draw top of folder (lower) */

   gr_line( ui_screen, x_center - x, y_center + y - 2,
      x_center, y_center + y - 2, color, SOLID );

#endif

   }

/****************************************************************

   uii_exec()      Icon for executable files

****************************************************************/

uii_exec( x1, y1, x2, y2, color )
   int x1, y1, x2, y2, color;
   {
#ifdef USE_ICONS
   ui_pbmcenter( ui_screen, x1, y1, x2, y2, &ui_exicon );
#else
   int x, y, y_center, x_center;

   /* calculate the center of the icon area */

   y_center = y1 + (( y2 - y1 ) / 2 );
   x_center = x1 + (( x2 - x1 ) / 2 );

   /* calculate appropriate sizes for the icon */

   y = ( y2 - y1 ) / 4;
   x = ( y * gr_pysize ) / gr_pxsize;

   /* draw the icon rectangle */

   gr_rectangle( ui_screen, x_center - x,
      y_center - y,
      x_center + x,
      y_center + y, color, HOLLOW );

   /* show circle to indicate executable */

   gr_circle( ui_screen, x_center, y_center,
      y / 3, color, GRID );

#endif

   }

