 /***************************************************************

	ui_rband.c      rubber-band routine for ui

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

***************************************************************/

#include "stdio.h"
#include "ctype.h"

#include "bw.h"
#include "kb.h"
#include "gr.h"
#include "ui.h"

#ifdef __STDC__
#include "malloc.h"
#else
extern char * malloc();
#endif

#ifndef   __STDC__
#define   time_t    long
#define   size_t   int
#endif

#define ERR_RBAND       "Memory error in ui_rband() routine"

ui_rband( mode, x1, y1, x2, y2 )
   int mode;
   int *x1, *y1, *x2, *y2;
   {
   static int left, right, top, bottom;
   static int b, k;
   static int y, x;             /* current position */
   static int yy, xx;           /* dummy arguments */
   int start_x, start_y;        /* start x, y, position */
   int prev_x, prev_y;          /* previous x, y position */
   int rxstat;                  /* receive status (keyboard or mouse) */

   /* Check mode */

   if ( mode != TRUE )
      {
      goto movebox;
      }

   /*** RBAND FUNCTION TRUE: RUBBERBAND FOR VARIABLE_SIZED BOX ****/

   /* save initial screen areas */

   x = *x2;
   y = *y1;
   gr_imsave( GR_PRIMARY, TRUE, *x1, *y1, *x1, *y2, &left );
   gr_imsave( GR_PRIMARY, TRUE, *x2, *y1, *x2, *y2, &right );
   gr_imsave( GR_PRIMARY, TRUE, *x1, *y2, *x2, *y2, &top );
   gr_imsave( GR_PRIMARY, TRUE, *x1, *y1, *x2, *y1, &bottom );

   /* reposition mouse to begin sizing */

   if ( gr_ismouse == TRUE )
      {
      gr_mouse( POSITION, &x, &y, &b );
      }

   /* draw the initial box */

   gr_line( GR_PRIMARY, *x1, *y1, *x1, *y2, BLACK, SOLID );               /* left */
   gr_line( GR_PRIMARY, *x2, *y1, *x2, *y2, BLACK, SOLID );               /* right */
   gr_line( GR_PRIMARY, *x1, *y2, *x2, *y2, BLACK, SOLID );               /* top */
   gr_line( GR_PRIMARY, *x1, *y1, *x2, *y1, BLACK, SOLID );               /* bottom */

#ifdef  OLD_DEBUG
   sprintf( bw_ebuf, "gr_mouse( SAMPLE ) == %d     ",
      gr_mouse( SAMPLE, x2, y1, &b ) );
   bw_message( bw_ebuf );
#endif

   /* main rband loop: wait until first mouse click or RETURN */

   if ( gr_ismouse == TRUE )
      {
      bw_message( " Use Mouse to Size Window, Click to Fix Size " );
      }
   else
      {
      bw_message( " Use Arrow Keys to Size Window, RETURN to Fix Size " );
      }

   rxstat = FALSE;
   while ( rxstat != TRUE )
      {

      if (( x != *x2 ) || ( y != *y1 ))
	 {

	 /* restore old screen areas */

	 gr_imsave( GR_PRIMARY, FALSE, *x1, y, *x1, *y2, &left );
	 gr_imsave( GR_PRIMARY, FALSE, x, y, x, *y2, &right );
	 gr_imsave( GR_PRIMARY, FALSE, *x1, *y2, x, *y2, &top );
	 gr_imsave( GR_PRIMARY, FALSE, *x1, y, x, y, &bottom );

	 /* release memory */

	 gr_imfree( top );
	 gr_imfree( left );
	 gr_imfree( bottom );
	 gr_imfree( right );

	 /* check for position above or left of point */

	 if ( *x2 < *x1 )
	    {
	    *x2 = *x1;
	    }

	 if ( *y1 > *y2 )
	    {
	    *y1 = *y2;
	    }

	 /* save new screen areas */

	 gr_imsave( GR_PRIMARY, TRUE, *x1, *y1, *x1, *y2, &left );
	 gr_imsave( GR_PRIMARY, TRUE, *x2, *y1, *x2, *y2, &right );
	 gr_imsave( GR_PRIMARY, TRUE, *x1, *y2, *x2, *y2, &top );
	 gr_imsave( GR_PRIMARY, TRUE, *x1, *y1, *x2, *y1, &bottom );

	 /* draw lines */

#ifdef OLD_DEBUG
         bw_message( "Drawing...      " );
#endif

	 gr_line( GR_PRIMARY, *x1, *y1, *x1, *y2, BLACK, SOLID );               /* left */
	 gr_line( GR_PRIMARY, *x2, *y1, *x2, *y2, BLACK, SOLID );               /* right */
	 gr_line( GR_PRIMARY, *x1, *y2, *x2, *y2, BLACK, SOLID );               /* top */
	 gr_line( GR_PRIMARY, *x1, *y1, *x2, *y1, BLACK, SOLID );               /* bottom */

	 x = *x2;
	 y = *y1;
	 }
#ifdef OLD_DEBUG
      else
         {
         bw_message( "No change...      " );
         }
#endif

      /* check keyboard or mouse status */

      if ( gr_ismouse == TRUE )
	 {
	 rxstat = gr_mouse( SAMPLE, x2, y1, &b );
	 }
      else
	 {
	 if ( kb_rxstat() == TRUE )
	    {
	    k = kb_rx();
	    switch (k)
	       {
	       case '\n':
	       case '\r':
		  rxstat = TRUE;
		  break;
	       case KB_UP:
		  ++(*y1);
		  break;
	       case KB_DOWN:
		  --(*y1);
		  break;
	       case KB_LEFT:
		  --(*x2);
		  break;
	       case KB_RIGHT:
		  ++(*x2);
		  break;
	       }
	    }
	 }

      }                         /* end main rband loop */

   /* wait until the mouse is released */

   if ( gr_ismouse == TRUE )
      {
      gr_mouse( WAIT, &xx, &yy, &b );                /* down */
      gr_mouse( WAIT, &xx, &yy, &b );                /* up */
      }

#ifdef  OLD_DEBUG
   bw_message( "Loop Finished     " );
#endif

   /* restore old screen areas */

   gr_imsave( GR_PRIMARY, FALSE, *x1, y, *x1, *y2, &left );
   gr_imsave( GR_PRIMARY, FALSE, x, y, x, *y2, &right );
   gr_imsave( GR_PRIMARY, FALSE, *x1, *y2, x, *y2, &top );
   gr_imsave( GR_PRIMARY, FALSE, *x1, y, x, y, &bottom );

   /* release memory */

   gr_imfree( top );
   gr_imfree( left );
   gr_imfree( bottom );
   gr_imfree( right );

   goto end;

   /*** RBAND FUNCTION NOT TRUE: MOVE FIXED_SIZE BOX ***/

   movebox:

   /* reposition the mouse */

   start_x = x = *x2;
   start_y = y = *y1;

   if ( gr_ismouse == TRUE )
      {
      gr_mouse( POSITION, &x, &y, &b );
      }

   /* save the initial area */

   gr_imsave( GR_PRIMARY, TRUE, *x1, *y1, *x1, *y2, &left );
   gr_imsave( GR_PRIMARY, TRUE, *x2, *y1, *x2, *y2, &right );
   gr_imsave( GR_PRIMARY, TRUE, *x1, *y2, *x2, *y2, &top );
   gr_imsave( GR_PRIMARY, TRUE, *x1, *y1, *x2, *y1, &bottom );

   /* show the initial rectangle */

   gr_line( GR_PRIMARY, *x1, *y1, *x1, *y2, BLACK, SOLID );
   gr_line( GR_PRIMARY, *x2, *y1, *x2, *y2, BLACK, SOLID );
   gr_line( GR_PRIMARY, *x1, *y2, *x2, *y2, BLACK, SOLID );
   gr_line( GR_PRIMARY, *x1, *y1, *x2, *y1, BLACK, SOLID );

   /* main rband loop */

   prev_x = x = start_x;
   prev_y = y = start_y;

   if ( gr_ismouse == TRUE )
      {
      bw_message( " Use Mouse to Move Window, Click to Fix Position " );
      }
   else
      {
      bw_message( " Use Arrow Keys to Move Window, RETURN to Fix Position " );
      }

   rxstat = FALSE;
   while( rxstat != TRUE )
      {

      if ( ( x != prev_x ) || ( y != prev_y ))
	 {

	 /* restore the old area */

	 gr_imsave( GR_PRIMARY, FALSE, *x1 + ( prev_x - start_x ), *y1 + ( prev_y - start_y ), *x1 + ( prev_x - start_x ), *y2 + ( prev_y - start_y ), &left );
	 gr_imsave( GR_PRIMARY, FALSE, *x2 + ( prev_x - start_x ), *y1 + ( prev_y - start_y ), *x2 + ( prev_x - start_x ), *y2 + ( prev_y - start_y ), &right );
	 gr_imsave( GR_PRIMARY, FALSE, *x1 + ( prev_x - start_x ), *y2 + ( prev_y - start_y ), *x2 + ( prev_x - start_x ), *y2 + ( prev_y - start_y ), &top );
	 gr_imsave( GR_PRIMARY, FALSE, *x1 + ( prev_x - start_x ), *y1 + ( prev_y - start_y ), *x2 + ( prev_x - start_x ), *y1 + ( prev_y - start_y ), &bottom );

	 /* release memory */

	 gr_imfree( top );
	 gr_imfree( left );
	 gr_imfree( bottom );
	 gr_imfree( right );

	 /* check for position out of bounds */

	 if ( ( *x1 + ( x - start_x )) < 0 )
	     {
	     x = prev_x;
	     }
	 else if ( ( *x2 + ( x - start_x )) > ui_grwind->xmax )
	     {
	     x = prev_x;
	     }

	 if ( ( *y1 + ( y - start_y )) < 0 )
	     {
	     y = prev_y;
	     }
	 else if ( ( *y2 + ( y - start_y )) > ui_grwind->ymax )
	     {
	     y = prev_y;
	     }

	 /* save the new area */

	 gr_imsave( GR_PRIMARY, TRUE, *x1 + ( x - start_x ), *y1 + ( y - start_y ), *x1 + ( x - start_x ), *y2 + ( y - start_y ), &left );
	 gr_imsave( GR_PRIMARY, TRUE, *x2 + ( x - start_x ), *y1 + ( y - start_y ), *x2 + ( x - start_x ), *y2 + ( y - start_y ), &right );
	 gr_imsave( GR_PRIMARY, TRUE, *x1 + ( x - start_x ), *y2 + ( y - start_y ), *x2 + ( x - start_x ), *y2 + ( y - start_y ), &top );
	 gr_imsave( GR_PRIMARY, TRUE, *x1 + ( x - start_x ), *y1 + ( y - start_y ), *x2 + ( x - start_x ), *y1 + ( y - start_y ), &bottom );

	 /* draw the new area */

	 gr_line( GR_PRIMARY, *x1 + ( x - start_x ), *y1 + ( y - start_y ), *x1 + ( x - start_x ), *y2 + ( y - start_y ), BLACK, SOLID );
	 gr_line( GR_PRIMARY, *x2 + ( x - start_x ), *y1 + ( y - start_y ), *x2 + ( x - start_x ), *y2 + ( y - start_y ), BLACK, SOLID );
	 gr_line( GR_PRIMARY, *x1 + ( x - start_x ), *y2 + ( y - start_y ), *x2 + ( x - start_x ), *y2 + ( y - start_y ), BLACK, SOLID );
	 gr_line( GR_PRIMARY, *x1 + ( x - start_x ), *y1 + ( y - start_y ), *x2 + ( x - start_x ), *y1 + ( y - start_y ), BLACK, SOLID );

	 prev_x = x;
	 prev_y = y;
	 }

      /* check keyboard or mouse status */

      if ( gr_ismouse == TRUE )
	 {
	 rxstat = gr_mouse( SAMPLE, &x, &y, &b );
	 }
      else
	 {
	 if ( kb_rxstat() == TRUE )
	    {
	    k = kb_rx();
	    switch (k)
	       {
	       case '\n':
	       case '\r':
		  rxstat = TRUE;
		  break;
	       case KB_UP:
		  ++y;
		  break;
	       case KB_DOWN:
		  --y;
		  break;
	       case KB_LEFT:
		  --x;
		  break;
	       case KB_RIGHT:
		  ++x;
		  break;
	       }
	    }
	 }

      }                                 /* end of main rband loop */

   /* restore the old area */

   gr_imsave( GR_PRIMARY, FALSE, *x1 + ( prev_x - start_x ), *y1 + ( prev_y - start_y ), *x1 + ( prev_x - start_x ), *y2 + ( prev_y - start_y ), &left );
   gr_imsave( GR_PRIMARY, FALSE, *x2 + ( prev_x - start_x ), *y1 + ( prev_y - start_y ), *x2 + ( prev_x - start_x ), *y2 + ( prev_y - start_y ), &right );
   gr_imsave( GR_PRIMARY, FALSE, *x1 + ( prev_x - start_x ), *y2 + ( prev_y - start_y ), *x2 + ( prev_x - start_x ), *y2 + ( prev_y - start_y ), &top );
   gr_imsave( GR_PRIMARY, FALSE, *x1 + ( prev_x - start_x ), *y1 + ( prev_y - start_y ), *x2 + ( prev_x - start_x ), *y1 + ( prev_y - start_y ), &bottom );

   /* release memory */

   gr_imfree( top );
   gr_imfree( left );
   gr_imfree( bottom );
   gr_imfree( right );

   /* get final mouse position */

   if ( gr_ismouse == TRUE )
      {
      gr_mouse( WAIT, &x, &y, &b );        /* click down */
      gr_mouse( WAIT, &xx, &yy, &b );        /* click up */
      }

   *x1 = *x1 + ( x - start_x );
   *x2 = *x2 + ( x - start_x );
   *y1 = *y1 + ( y - start_y );
   *y2 = *y2 + ( y - start_y );

   end:

   bw_message( " " );

   return TRUE;

   }

