/*
   Module:  input.h
   Date:    3/9/92
   Version: 1.0b
   Author:  Dave Lutz
   Email:   lutz@psych.rochester.edu
   Copyright: 1992 University of Rochester, Psychology Dept.

   Disclaimer:  This software is distributed free of charge.  As such, it
                comes with ABSOLUTELY NO WARRANTY.  The user of the software
                assumes ALL RISKS associated with its use.

                Your rights to modify and/or distribute this software are
                outlined in the file SEND7221.DOC.

   Purpose: This module provides the function prototypes for the input
            routines for the PC -> HP7221 controller.  It provides the 
            routines needed by the controller to open the input file and 
            read data.

            A datatype (PLTFILE) is also provided by this module.  This
            datatype is the basic structure used by all of the functions in
            this module.

   Functions Provided:

            openin
            closein
            fillbuff

*/


  /* BUFFSIZE has been set to get the maximum number of 2048 byte clusters
     and still be less than 32767
  */
#define BUFFSIZE 30720
#define PLTFILE struct _pltfile

PLTFILE {
   char *buf;     /* start of file buffer */
   int  fd,       /* file descriptor for the file */
        buf_ctr,  /* number of bytes currently in buffer */
        eof;      /* BOOLEAN flag */
};



/*
   Function: openin
   Purpose:  Allocate the input buffer and open the input file for reading.

   Pre: name is a pointer to an ascii string containing the name of the 
        input file.
        pltfpp is a pointer to storage for a pointer to a PLTFILE.

   Post:  The input buffer is allocated.
          The input file is opened for reading.
          If the buffer can't be allocated, *pltfpp is set to NULL and
          NOBUFF is returned.
          If the input file can't be opened, *pltfpp is set to NULL and
          BADOPEN is returned.
          Otherwise, TRUE is returned.
*/

int openin (char *name, PLTFILE **pltfpp);



/*
   Function: closein
   Purpose:  Discard the input buffer, close the input file, and deallocate 
             the input buffer.

   Pre:  pltfpp is a pointer to a pointer to a PLTFILE.
         If *pltfpp does not point to an open PLTFILE, it is NULL.

   Post:  If *pltfpp = NULL, TRUE is returned.
          Otherwise, the contents of the input buffer are discarded, the 
          input file is closed, and the input buffer is deallocated.
          If an error occurs during the above process, FALSE is returned.
*/

int closein(PLTFILE **pltfpp);



/*
   Function: fillbuff
   Purpose:  Read a block of data from the input file, filling the buffer
             in the PLTFILE.

   Pre:  pltfp is a pointer to a PLTFILE that has been opened for reading.

   Post: The input file is read to refill the buffer in PLTFILE.
         If end_of_file has already been reached, 0 is returned.
         If an error occures, -1 is returned.
         Otherwise, the number of bytes read from the file is returned.
*/

int fillbuff (PLTFILE *pltfp);
