;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; File: MORPH.LSP  Copyright (C) Ben Olasov 1994 olasov@cs.columbia.edu ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 
(defun c:morph (/ state1 state2 morphsteps shp1-vts shp2-vts op1 op2 
                  state1-nodes state2-nodes state1* state2*)
       (setvar "blipmode" 0)
       (setvar "cmdecho" 0)
       (setq state1 (_user_ent (list "POLYLINE" "LINE") "\nbeginning state: "))
       (setq state2 (_user_ent (list "POLYLINE" "LINE") "\nfinal state: "))
       (setq morphsteps (userint (if morphsteps morphsteps 100)
                          "\nnumber of transform steps"))
       (setq shp1-vts (count_vrts state1))
       (setq shp2-vts (count_vrts state2))
       (if (/= shp1-vts shp2-vts)
           (princ "\n**unequal vertex counts**"))
       (princ (strcat "\n1st shape has " (itoa shp1-vts)
                      " vertices & 2nd shape has " (itoa shp2-vts)
                      " vertices."))
       (if (= shp1-vts shp2-vts)
           (setq dvd_shps?
                 (strcase (userstr (if dvd_shps? dvd_shps? "N")
                          "\nchange resolution of contours [Y N]")))
           (setq dvd_shps? "Y"))
       (if (equal dvd_shps? "Y")
           (progn (setq op1 (trans (origin_pt state1) state1 1)
                        op2 (trans (origin_pt state2) state2 1)
                        res (userint (if (and res
                                              (> res (max shp1-vts shp2-vts)))
                                          res (max shp1-vts shp2-vts))
                                     "\nnew number of vertices in each shape")
                        state1-nodes (divide_pline state1 res op1)
                        state2-nodes (divide_pline state2 res op2))
                  (entdel state1)
                  (entdel state2)
                  (setq state1* (3dpoly state1-nodes))
                  (setq state2* (3dpoly state2-nodes)))
            (setq state1* state1 state2* state2))
       (setq surface?
             (strcase (userstr (if surface? surface? "Y")
                      "\nconnect transform steps with surface patches [Y N]")))
       (morph state1* state2* morphsteps)
       'done)
 
(defun extract_value (key enm) 
       (if enm (cdr (assoc key (entget enm)))))
 
(defun origin_pt (pln)
       (if (equal (cdr (assoc 0 (entget pln))) "POLYLINE")
           (cdr (assoc 10 (entget (entnext pln))))
           (cdr (assoc 10 (entget pln)))))
 
(defun centroid (verts / _verts num_verts x_avg y_avg z_avg centrd z_coords)
       (cond ((or (null verts)
                  (null (listp verts))
                  (member nil (mapcar 'listp verts)))
               nil)
             (T (if (setq z_coords (mapcar 'caddr _verts))
                    (setq z_avg (apply '+ z_coords))
                    (setq z_avg nil))
                (setq _verts (unique_atoms verts)
                      num_verts (length _verts)
                      x_avg (/ (apply '+ (mapcar 'car _verts)) num_verts)
                      y_avg (/ (apply '+ (mapcar 'cadr _verts)) num_verts)
                      centrd (if z_avg
                                 (list x_avg y_avg z_avg)
                                 (list x_avg y_avg))))) centrd)
 
(defun midpt (p1 p2)
        (polar p1 (angle p1 p2) (/ (distance p1 p2) 2.000000)))
 
(defun RAD2DEG (ang)
       (* ang (/ 360 (* pi 2.000000))))
 
(defun blockp (blockname)
       (if (null blockname) nil
           (if (member (strcase blockname) (listify_blocks))
               'T nil)))
 
(defun listify_blocks (/ block blocks nam)
       (setq block (cdr (assoc 2 (tblnext "block" T))) ;;rewind block table
             blocks (list  block))
       (while (setq block (tblnext "block")) ;;construct block list
              (setq nam (cdr (assoc 2 block))
                    blocks (cons nam blocks))) blocks)
 
(defun ss2ptlist (sset)
       (mapcar '(lambda (enm)
                        (cdr (assoc 10 (entget enm))))
               (ss2enamlist sset)))
 
(defun ss2enamlist (ss / entlist ctr)
       (if ss (progn
           (setq ctr 0)
           (repeat (sslength ss)
                   (progn (setq entlist (cons (ssname ss ctr) entlist))
                          (setq ctr (1+ ctr)))))) (if entlist entlist))
 
(defun usrdist (dflt prmpt / var)
       (if (setq var
                 (getdist (if dflt (strcat prmpt " <" (rtos dflt 4 4) ">: ")
                          (strcat prmpt ": ")))) var dflt))
 
;; PLINE takes a vertex list of arbitrary length as its argument
;; and creates a polyline entity comprised of straight segments
;; connecting the vertices by using ENTMAKE.
(defun pline (vtxlist) 
       (entmake (list (quote (0 . "POLYLINE")))) ; entmake polyline header
       (foreach vtx vtxlist                      ; construct polyline vertices
                (entmake (list (quote (0 . "VERTEX"))
                (cond ((null vtx) nil)
                      ((< (length vtx) 3)
                       (list 10 (car vtx) (cadr vtx)))
                     (T (list 10 (car vtx) (cadr vtx) (caddr vtx)))))))
       (entmake '((0 . "SEQEND"))))
 
(defun closedp (pl)
       (equal (cdr (assoc 70 (entget pl))) 1))
 
(defun connect_plines (pl1 pl2 / i_ pl_pts1 pl_pts2 pl_pts_l)
       (setq i_ 0
             pl_pts1 (collect_vertices pl1)
             pl_pts2 (collect_vertices pl2))
       (if (and pl_pts1 pl_pts2)
           (progn (setq pl_pts_l (length pl_pts1))
                  (command "_3dmesh" pl_pts_l 2)
                  (repeat pl_pts_l
                          (command (trans (nth i_ pl_pts1) pl1 1)
                                   (trans (nth i_ pl_pts2) pl2 1))
                          (setq i_ (1+ i_))))))
 
(defun morph (polyl1 polyl2 iterations / i_ polyl_pts1 polyl_pts2 polyl_pts_l)
       (setq i_ 0 i__ 0 new-polyline nil last-polyline polyl1
             polyl_pts1 (collect_vertices polyl1)
             polyl_pts2 (collect_vertices polyl2))
       (if (and polyl_pts1 polyl_pts2)
           (progn (setq last_pts polyl_pts1
                        polyl_pts_l (length polyl_pts1))
                  (repeat iterations
                          (setq i__ 0 intrmdt_pts nil)
                          (repeat polyl_pts_l
                                  (setq node1 (nth i__ polyl_pts1)
                                        node2 (nth i__ polyl_pts2)
                                        dist_tot (distance node1 node2)
                                        dist_unit (/ dist_tot iterations)
                                        ang1 (angle node1 node2)
                                        intrmdt_pt (polar node1 ang1
                                                          (* dist_unit (- iterations (- iterations (1+ i_)))))
                                        intrmdt_pts (if intrmdt_pts
                                                        (cons intrmdt_pt intrmdt_pts)
                                                        (list intrmdt_pt))
                                        i__ (1+ i__)))
                            (setq i__ 0
                                  new-polyline (3dpoly intrmdt_pts))
                            (if (equal surface? "Y")
                                (connect_plines last-polyline new-polyline))
                             (setq last-polyline new-polyline
                                   last_pts intrmdt_pts)
                        (setq i_ (1+ i_))))))
 
(defun collect_vertices (polyln / __ent *polyln* ##pt ##pts)
       (if (= (cdr (assoc 0 (setq *polyln* (entget polyln)))) "POLYLINE")
           (progn (setq __ent (entnext polyln))
                  (while (setq *ent* (entget __ent)
                               ##pt (cdr (assoc 10 *ent*)))
                         (setq ##pts (cons ##pt ##pts)
                               __ent (entnext __ent)))
                         (if (and (equal (cdr (assoc 70 (entget polyln))) 1)
                                  (not (equal (car ##pts) (last ##pts))))
                             (setq ##pts (reverse (cons (car ##pts) (reverse ##pts))))))
           (if (= (cdr (assoc 0 (setq *polyln* (entget polyln)))) "LINE")
               (setq ##pts (list (extract_value 10 polyln)
                                 (extract_value 11 polyln)))
               (princ "\ncollect_vertices: not a POLYLINE.")))
       (if ##pts (setq np (length ##pts)))
       ##pts)
 
(defun count_vrts (plyln / #ent# ##plyln ##pt vi) 
       (if (= (cdr (assoc 0 (setq ##plyln (entget plyln)))) "POLYLINE") 
           (progn (setq #ent# (entnext plyln)
                        vi 0)
                  (terpri)
                  (while (setq #entlist (entget #ent#)
                               ##pt (cdr (assoc 10 #entlist)))
                         (princ ".")
                         (setq vi (1+ vi)
                               #ent# (entnext #ent#)))
                   (gc)))
       vi)
 
(defun divide_pline (enm n_vrts_ _pt_  / node-1 node-n node1 noden pt_ss pt_l$$)
       (setq enm-nodes (collect_vertices enm)
             node-1 (car enm-nodes)
             node-n (last enm-nodes))
       (command "_undo" "_c" "_one")
       (setq clayer (getvar "clayer"))
       (make_la "$PT$")
       (command "_divide" _pt_ (1+ n_vrts_))
       (setq pt_ss (ssget "x" (list (cons 0 "POINT")
                                    (cons 8 "$PT$")))
             pt_l$$ (ss2nodelist pt_ss)
             pt_ss nil)
       (gc)
       (setq node1 (car pt_l$$)
             noden (last pt_l$$)
             *node1 (closest node1 (list node-1 node-n))
             *noden (closest noden (list node-1 node-n))
             pt_l$$ (append (list *node1) pt_l$$ (list *noden)))
       (command "_undo" "1")
       (command "_undo" "1")
       (command "_undo" "1")
       (command "_layer" "_s" clayer "")
       pt_l$$)
 
(defun ss2nodelist (ss / *ent* pt pts &i ssl)
       (if (or (null ss) (/= (type ss) 'PICKSET)) nil
           (progn (setq &i 0
                        ssl (sslength ss))
                  (repeat ssl
                         (setq ent (ssname ss &i)
                               *ent* (entget ent)
                               pt (cdr (assoc 10 *ent*))
                               pts (cons pt pts))
                         (setq &i (1+ &i))))) pts)
 
(defun make_la (%nam%)
       (if %nam%
           (progn (setq %clay (getvar "clayer"))
                  (if (layerp %nam%)
                      (if (not (equal %clay %nam%))
                          (command "_layer""_t"%nam%"_on"%nam%"_s"%nam%""))
                      (command "_layer" "_m" %nam% "")))))
 
(defun 3dpoly (pnts)
       (if (and pnts (listp pnts))
           (progn (command "_3dpoly")
                  (foreach pt pnts (if pt (command pt)))
                  (command "")))
       (entlast))
 
(defun layerp (layername)
       (if (null layername) nil
           (if (member (strcase layername) (listify_layers))
               'T nil)))
 
(defun unique_atoms (lst / tmp unique_lst)
       (setq tmp lst)
       (repeat (length lst)
               (if (null unique_lst)
                   (setq unique_lst (list (car tmp)))
                   (if (not (member (car tmp) (cdr tmp)))
                       (if unique_lst
                           (if (not (member (car tmp) unique_lst))
                               (setq unique_lst (cons (car tmp) unique_lst))))))
                (setq tmp (cdr tmp)))
        (reverse unique_lst))
 
(defun _user_ent (ent_type_lst _prm / __ent)
      (while (not (member (extract_value 0 
                                         (setq __ent (car (entsel _prm))))
                ent_type_lst))) __ent)
 
(defun listify_layers (/ layer layers nam)
       (setq layer (cdr (assoc 2 (tblnext "layer" T))) ;;rewind layer table
             layers (list  layer))
       (while (setq layer (tblnext "layer")) ;;construct layer list
              (setq nam (cdr (assoc 2 layer))
                    layers (cons nam layers))) layers)
 
(defun userdist (refpt dflt prmpt / var)
       (if (setq var
                 (getdist (if refpt refpt)
                          (if dflt (strcat prmpt " <" (rtos dflt 4 2) ">: ")
                                   (strcat prmpt ": ")))) var dflt))
 
(defun userint (dflt prmpt / var)
       (if (setq var
                 (getint (if dflt (strcat prmpt " <" (itoa dflt) ">: ")
                                  (strcat prmpt ": ")))) var dflt))
 
(defun user_ent (_ent_type _prm / __ent)
      (while (not (equal (extract_value 0 
                                        (setq __ent (car (entsel _prm))))
                _ent_type))) __ent)
 
(defun userstr (dflt prmpt / var) ;;DFLT and PRMPT are strings
       (setq var (getstring t (if (and dflt (/= dflt ""))
                                (strcat prmpt " <" dflt ">: ")
                                (strcat prmpt ": "))))
       (cond ((/= var "") var)
             ((and dflt (= var "")) dflt)
             (T dflt)))
 
;; CLOSEST returns the closest point to point PT in vertex list NODES
(defun closest (pt nodes)
       (nth
          (pos_in_list
                 (apply 'min (mapcar '(lambda (node) (distance pt node)) nodes))
                             (mapcar '(lambda (node) (distance pt node)) nodes))
        nodes))
 
;; POS_IN_LIST returns sequence position of item ITEM in list LST
;; compatible with NTH
(defun pos_in_list (item lst) 
        (if (null (member item lst))
            nil
            (- (length lst) (length (member item lst)))))
 
(princ "\nC:MORPH loaded - type MORPH to use.")
(princ)
