'
' FINDER.BAS (12/16/97)
'
' Connect a modem to one of COM1 to COM4, and turn it on.
' FINDER will search for the modem.
'

$ERROR ALL ON
$LIB ALL OFF

DEFINT A-Z

$INCLUDE "PCL4PB.BI"
$LINK "PCL4PB.OBJ"

DECLARE SUB ErrorCheck(BYVAL Code AS INTEGER)

%True = 0
%False = NOT %True

%PC = 1
%DB = 2
%BB = 3

' Global Variables

DIM Port AS SHARED INTEGER
DIM RxBuf(512+16) AS BYTE
DIM TxBuf(512+16) AS BYTE
DIM BaudCode AS INTEGER
DIM BaudRate AS SINGLE
DIM C AS BYTE
DIM I AS INTEGER
DIM Code AS INTEGER
DIM RxBufSeg AS INTEGER
DIM TxBufSeg AS INTEGER
DIM Parms AS STRING
DIM Expect AS STRING
DIM Mark AS LONG

' initialize

BaudCode = %Baud19200
BaudRate = 19200

IF LEN(COMMAND$) > 0 THEN
   PRINT "Usage: FINDER"
   STOP
END IF

' compute RX buffer segment
RxBufSeg = 1 + VARSEG(RxBuf(0)) + (VARPTR(RxBuf(0)) \ 16)
IF SioInfo(ASC("I")) <> 0 THEN
  ' compute RX buffer segment
  TxBufSeg = 1 + VARSEG(TxBuf(0)) + (VARPTR(TxBuf(0)) \ 16)
ELSE
  TxBufSeg = 0
END IF

'search each port in turn
FOR Port = %COM1 TO %COM4
  ' set parmameters for the port
  CALL ErrorCheck( SioParms(Port,%NoParity,%OneStopBit,%WordLength8) )
  ' setup receive buffer
  CALL ErrorCheck( SioRxBuf(Port, RxBufSeg, %Size512) )
  IF TxBufSeg <> 0 THEN
     'setup transmit buffer
     CALL ErrorCheck( SioTxBuf(Port, TxBufSeg, %Size512) )
  END IF

  ' reset port
  Code = SioReset(Port, BaudCode)
  IF Port = %COM1 THEN
     CLS
     PRINT "FINDER: Searching for connected modem."
     PRINT
  END IF
  IF Code >= 0 THEN
     'found UART
     PRINT "COM";LTRIM$(STR$(1+Port))
     Code = SioDTR(Port,%SET.LINE)
     Code = SioRTS(Port,%SET.LINE)
     ' use FIFO if present
     Code = SioFIFO(Port,%LEVEL.4TH)
     'modem should set DSR
     Code = SioPutc(Port,13)
     IF SioDSR(Port) = 0 THEN
       'DSR not set
       PRINT "  DSR is not set."
       Code = SioDone(Port)
     ELSE
       'modem has set DSR
       PRINT "  DSR is set."
       'send "AT"
       Code = SioPutc(Port,13)
       Code = SioDelay(5)
       Code = SioPutc(Port,ASC("A"))
       Code = SioDelay(5)
       Code = SioPutc(Port,ASC("T"))
       Code = SioDelay(5)
       Code = SioPutc(Port,13)
       Code = SioDelay(5)
       'expect "OK" back
       Expect = "O"
       Mark = SioTimer + 30
       WHILE SioTimer < Mark
         Code = SioGetc(Port,0)
         IF Code = 13 THEN
           PRINT
         ELSEIF Code >= &H20 THEN
           PRINT CHR$(Code);
           IF CHR$(Code) = Expect THEN
             IF Expect = "O" THEN
               EXPECT = "K"
             ELSE
               PRINT "  Modem detected."
               Call ShutDown
             END IF
           END IF
         END IF
       WEND
       'modem does not respond
       Code = SioDone(Port)
     END IF
  ELSE
     PRINT "Error ";Code;
     Code = SioError(Code)
     PRINT
  END IF
NEXT Port
Call ShutDown
END

SUB ErrorCheck(BYVAL Code AS INTEGER)
' trap PCL error codes
IF Code < 0 THEN
   Code = SioError(Code)
   Call ShutDown
END IF
END SUB

SUB ShutDown
DIM Code AS INTEGER
Code = SioDone(Port)
STOP
END SUB

 