'
'  HOST.BAS
'
'  Example HOST Program for PowerBASIC
'
'  Answers incoming calls.
'  Caller quits by typing '$'. User quits by typing ESC.
'

$ERROR ALL ON
$LIB ALL OFF
$LINK "PCL4PB.OBJ"
$LINK "MODEM_IO.PBU"

DEFINT A-Z
$INCLUDE "PCL4PB.BI"
$INCLUDE "MODEM_IO.BI"
$INCLUDE "DEFINES.BI"
$INCLUDE "TIMING.BI"

DECLARE FUNCTION AnswerModem(BYVAL Port AS INTEGER) AS INTEGER
DECLARE FUNCTION MatchBaudRate(S AS STRING) AS INTEGER
DECLARE FUNCTION CaptureBaud(BYVAL Port AS INTEGER) AS STRING
DECLARE SUB AbortTest(BYVAL Port AS INTEGER)

%FALSE = 0
%TRUE = NOT %FALSE
%ESC = 27

'declare variables
DIM RxBuffer(512+16) AS BYTE
DIM TxBuffer(512+16) AS BYTE
DIM BufSeg AS WORD
DIM Port AS INTEGER
DIM Code AS INTEGER
DIM I AS INTEGER
DIM L AS INTEGER
DIM LibVer AS INTEGER
DIM BaudCode AS INTEGER
DIM InCode AS INTEGER
DIM AnyKey AS STRING

DIM Rates(9) AS STRING
DIM PARMS AS STRING
DIM ARG1 AS STRING
DIM ARG2 AS STRING

Rates$(1) = "300"
Rates$(2) = "1200"
Rates$(3) = "2400"
Rates$(4) = "4800"
Rates$(5) = "9600"
Rates$(6) = "19200"
Rates$(7) = "38400"
Rates$(8) = "57600"
Rates$(9) = "115200"

'get command line arguments
PARMS$ = RTRIM$(COMMAND$)
I = INSTR(PARMS$, " ")
IF I < 1 THEN
  PRINT "  Usage: HOST <Port> <BaudRate>"
  PRINT "Example: HOST 1 9600"
  END
END IF
L = LEN(PARMS$)
ARG1$ = LEFT$(PARMS$, I - 1)
ARG2$ = LTRIM$(RIGHT$(PARMS$, L - I))
BaudCode = -1

'Get COM port
Port = VAL(ARG1$) - 1

'Get baud code
FOR I = 1 TO 9
  IF Rates$(I) = ARG2$ THEN
     BaudCode = I
     EXIT FOR
  END IF
NEXT I

'Verify good baud rate
IF BaudCode = -1 THEN
  PRINT "Cannot recognize baud rate "; ARG2$
  STOP
END IF

'setup RX buffer
BufSeg = 1 + VARSEG(RxBuffer(0)) + (VARPTR(RxBuffer(0)) \ 16)
Code = SioRxBuf(Port, BufSeg, %Size512)
IF Code < 0 THEN
  PRINT "Error "; Code; " returned from SioRxBuf()"
  Code = SioError(Code)
  STOP
END IF

IF SioInfo(ASC("I")) <> 0 THEN
  'setup TX buffer
  BufSeg = 1 + VARSEG(TxBuffer(0)) + (VARPTR(TxBuffer(0)) \ 16)
  Code = SioTxBuf(Port, BufSeg, %Size512)
  IF Code < 0 THEN
    PRINT "Error "; Code; " returned from SioTxBuf()"
    Code = SioError(Code)
    STOP
  END IF
END IF

'reset port
Code = SioReset(Port, BaudCode)
IF Code < 0 THEN
  PRINT "Error "; Code; " returned from SioReset()"
  Code = SioError(Code)
  STOP
END IF
CLS

PRINT "HOST 12/17/97"
PRINT " "
PRINT "COM";LTRIM$(STR$(1+Port));" at ";Rates$(BaudCode)
LibVer = SioInfo(ASC("V"))
PRINT "Lib Ver: "; LTRIM$(STR$(LibVer \ 16)); ".";
PRINT LTRIM$(STR$(LibVer MOD 16))
Code = SioDTR(Port, %SET.LINE)
Code = SioRTS(Port, %SET.LINE)
Code = SioFIFO(Port, %LEVEL.4TH)

IF %AT.COMMAND.SET THEN
  PRINT "  <<Waiting for Modem DSR>>"
  DO
    IF SioDSR(Port) THEN
      EXIT DO
    ELSE
      CALL AbortTest(Port)
      Code = SioDelay(18)
      PRINT ".";
    END IF
  LOOP
  PRINT "  <<DSR on>>"
ELSE
  PRINT "Must set AT.COMMAND.SET to 1. See DEFINES.BI"
  Code = SioDone(Port)
  STOP
END IF

'waiting for modem CTS ?
IF %RTS.CTS.CONTROL THEN
  PRINT "  <<Waiting for Modem CTS>>"
  DO
    IF SioCTS(Port) THEN
      EXIT DO
    ELSE
      CALL AbortTest(Port)
      Code = SioDelay(18)
      PRINT ".";
    END IF
  LOOP
  PRINT "  <<CTS on>>"
END IF

'initialize (Hayes compatible) modem ?
IF %AT.COMMAND.SET THEN
  PRINT "  <<Initializing modem>>
  Code = ModemSendTo(Port,4,"AT!")
  Code = ModemEcho(Port,10)
  Code = ModemSendTo(Port,4,"AT E1 S7=60 S11=60 V1 X1 Q0 S0=1!")
  IF ModemWaitFor(Port,5*%ONE.SECOND,%TRUE,"OK") THEN
    'modem is ready
     PRINT
     PRINT "  <<MODEM READY>>"
  ELSE
     PRINT
     PRINT "  <<WARNING: Expected OK not received>>"
  END IF
END IF

DO
  PRINT
  PRINT "Awaiting next caller (type several ESCs to abort) ..."
  Code = SioDelay(10)
  CALL AbortTest(Port)
  IF AnswerModem(Port) THEN
    PRINT
    PRINT "Caller online on COM";STR$(Port+1)
    Code = ModemSendTo(Port,0,"!!Type '$' to quit!")
    DO
      'keyboard character ?
      AnyKey$ = INKEY$
      IF AnyKey$ = CHR$(27) THEN
        PRINT "Aborting..."
        Code = SioDone(Port)
        STOP
      END IF
      IF AnyKey$ <> "" THEN
        Code = SioPutc(Port,ASC(AnyKey$))
      END IF
      'get next incoming character
      InCode = SioGetc(Port, 1)
      IF InCode < -1 THEN
        Code = SioError(InCode)
        Code = SioDone(Port)
        STOP
      END IF
      'got incoming character
      IF InCode > -1 THEN
        IF InCode = ASC("$") THEN
          PRINT "Caller typed '$'..."
          PRINT
          EXIT DO
        END IF
        'display incoming character
        IF InCode < &H20 THEN
          PRINT "^";CHR$(InCode+&H40);
        ELSE
          PRINT CHR$(InCode);
        END IF
      END IF
    LOOP
  END IF
LOOP
END

FUNCTION AnswerModem(BYVAL Port AS INTEGER) AS INTEGER
DIM I AS INTEGER
DIM Code AS INTEGER
DIM BaudCode AS INTEGER
DIM AnyKey AS STRING
  'wait for RI
  DO
    CALL AbortTest(Port)
    IF SioRI(Port) THEN
      EXIT DO
    END IF
  LOOP
  'wait for RING
  IF ModemWaitFor(Port,60,%FALSE,"RING") THEN
    'wait for DCD
    DO
      CALL AbortTest(Port)
      IF SioDCD(Port) THEN
        EXIT DO
      END IF
    LOOP
    'wait for CONNECT
    IF ModemWaitFor(Port,600,%FALSE,"CONNECT") THEN
      'must delay after seeing CONNECT
      Code = ModemQuiet(Port,60)
      Code = SioRxClear(Port)
      AnswerModem = %TRUE
      EXIT FUNCTION
    ELSE
      PRINT "CONNECT not seen"
      AnswerModem = %FALSE
      EXIT FUNCTION
    END IF
  END IF
AnswerModem = %FALSE
END FUNCTION

SUB AbortTest(BYVAL Port AS INTEGER)
  DIM Code AS INTEGER
  ' User BREAK ?
  IF (INKEY$ = CHR$(%ESC) ) OR SioBrkKey THEN
    PRINT "User aborting..."
    Code = SioDone(Port)
    STOP
  END IF
END SUB

 