' -- XYPACKET.BAS --
'
' This program is donated to the Public
' Domain by MarshallSoft Computing, Inc.
' It is provided as an example of the use
' of the Personal Communications Library.
'
$CPU 8086          'make compatible with XT systems
$LIB ALL OFF       'turn off all PowerBASIC libraries
$ERROR ALL ON      'turn on all PowerBASIC error checking
$OPTIMIZE SIZE     'optimize for smaller code
$COMPILE UNIT      'compile to a UNIT (.PBU)

DEFINT A-Z         'Required for all numeric functions, forces PB to not
                   'include floating point routines in UNIT (makes it smaller)

$INCLUDE "DEFINES.BI"
$INCLUDE "TIMING.BI"
$INCLUDE "PCL4PB.BI"
$INCLUDE "TERM_IO.BI"
$INCLUDE "CRC16.BI"

%xyBufferSize = 1024
%MAXTRY       = 3
%LIMIT        = 20
%SOH          = &H01
%STX          = &H02
%EOT          = &H04
%ACK          = &H06
%NAK          = &H15
%CAN          = &H18
%FALSE        = 0
%TRUE         = NOT %FALSE

FUNCTION RxPacket(BYVAL Port       AS INTEGER, _
                  BYVAL PacketNbr  AS INTEGER, _
                        Buffer()   AS BYTE,    _
                        PacketSize AS INTEGER, _
                  BYVAL NCGbyte    AS BYTE,    _
                        EOTflag    AS INTEGER) PUBLIC

  'Port      : Port # [0..3)
  'PacketNbr : Packet # [0,1,2,...)
  'PacketSize: Packet size [128,1024) {returned}
  'NCGbyte   : NAK, "C", or "G"
  'EOTflag   : EOT was received       {returned}

  DIM I            AS INTEGER
  DIM CheckSum     AS WORD
  DIM RxCheckSum   AS WORD
  DIM RxCheckSum1  AS WORD
  DIM RxCheckSum2  AS WORD
  DIM Attempt      AS INTEGER
  DIM Code         AS INTEGER
  DIM PacketType   AS INTEGER
  DIM RxPacketNbr  AS INTEGER
  DIM RxPacketNbrC AS INTEGER

  PacketNbr = PacketNbr AND 255

  FOR Attempt = 1 TO %MAXTRY
    'wait FOR SOH / STX
    Code = SioGetc(Port, %LONG.WAIT * %ONE.SECOND)
    IF Code = -1 THEN
      PRINT "Timed out waiting for sender"
      RxPacket = %FALSE
      EXIT FUNCTION
    END IF
    SELECT CASE Code
      CASE %SOH
        '128 byte buffer incoming
        PacketType = %SOH
        PacketSize = 128
      CASE %STX
        '1024 byte buffer incoming
        PacketType = %STX
        PacketSize = 1024
      CASE %EOT
        'all packets have been sent
        Code = SioPutc(Port, %ACK)
        EOTflag = %TRUE
        RxPacket = %TRUE
        EXIT FUNCTION
      CASE %CAN
        'sender has canceled !
        PRINT "Canceled by remote"
        RxPacket = %FALSE
      CASE ELSE
        'error !
        PRINT "Expecting SOH/STX/EOT/CAN not "; Code
        RxPacket = %FALSE
    END SELECT

    'receive packet #
    Code = SioGetc(Port, %ONE.SECOND)
    IF Code = -1 THEN
      PRINT "Timed out waiting for packet #"
      EXIT FUNCTION
    END IF
    RxPacketNbr = Code AND 255

    'receive 1's complement
    Code = SioGetc(Port, %ONE.SECOND)
    IF Code = -1 THEN
      PRINT "Timed out waiting for complement of packet #"
      RxPacket = %FALSE
      EXIT FUNCTION
    END IF
    RxPacketNbrC = Code AND 255

    'receive data
    CheckSum = 0
    FOR I = 0 TO PacketSize-1
      Code = SioGetc(Port, %ONE.SECOND)
      IF Code = -1 THEN
        PRINT "Timed out waiting for data for packet #"
        RxPacket = %FALSE
        EXIT FUNCTION
      END IF
      Buffer(I) = Code
      'compute CRC or checksum
      IF NCGbyte <> %NAK THEN
        CheckSum = UpdateCrc(Code, CheckSum)
      ELSE
        CheckSum = (CheckSum + Code) AND 255
      END IF
    NEXT I

    'receive CRC/checksum
    IF NCGbyte <> %NAK THEN
      'receive 2 byte CRC
      Code = SioGetc(Port, %ONE.SECOND)
      IF Code = -1 THEN
        PRINT "Timed out waiting for 1st CRC byte"
        EXIT FUNCTION
      END IF
      RxCheckSum1 = Code AND 255
      Code = SioGetc(Port, %ONE.SECOND)
      IF Code = -1 THEN
        PRINT "Timed out waiting for 2nd CRC byte"
        RxPacket = %FALSE
        EXIT FUNCTION
      END IF
      RxCheckSum2 = Code AND 255
      RxCheckSum = (256 * RxCheckSum1) OR RxCheckSum2
    ELSE
      'receive one byte checksum
      Code = SioGetc(Port, %ONE.SECOND)
      IF Code = -1 THEN
        PRINT "Timed out waiting for checksum"
        RxPacket = %FALSE
        EXIT FUNCTION
      END IF
      RxCheckSum = Code AND 255
    END IF

    'don't send ACK IF "G"
    IF NCGbyte = ASC("G") THEN
      RxPacket = %TRUE
      EXIT FUNCTION
    END IF

    'packet # and checksum OK ?
    IF (RxCheckSum = CheckSum) AND (RxPacketNbr = PacketNbr) THEN
      'ACK the packet
      Code = SioPutc(Port, %ACK)
      RxPacket = %TRUE
      EXIT FUNCTION
    END IF

    'bad packet
    IF RxCheckSum = CheckSum THEN
      PRINT "Bad Packet. Received "; RxPacketNbr; ", expected "; PacketNbr
    ELSE
      PRINT "Bad Checksum. Received "; HEX$(RxCheckSum); _
            ", expected "; HEX$(CheckSum)
    END IF
    Code = SioPutc(Port, %NAK)
  NEXT Attempt

  'can't receive packet
  PRINT "RX packet timeout"
  RxPacket = %FALSE

END FUNCTION

FUNCTION RxStartup(BYVAL Port    AS INTEGER, _
                   BYVAL NCGbyte AS BYTE)    PUBLIC
  DIM I       AS INTEGER
  DIM Code    AS INTEGER
  DIM Code2   AS INTEGER
  DIM TheByte AS BYTE
  DIM AnyKey  AS STRING

  'clear Rx buffer
  Code = SioRxFlush(Port)

  'Send NAKs or "C"s
  FOR I = 1 TO %LIMIT
    AnyKey$ = INKEY$
    IF AnyKey$ <> "" THEN
      PRINT "Canceled by user"
      RxStartup = %FALSE
      EXIT FUNCTION
    END IF
    'stop attempting CRC after 1st 4 tries
    IF (NCGbyte <> %NAK) AND (I = 5) THEN NCGbyte = %NAK
    'tell sender that I am ready to receive
    Code = SioPutc(Port, NCGbyte)
    Code = SioGetc(Port, %SHORT.WAIT * %ONE.SECOND)
    IF Code <> -1 THEN
      'no error -- must be incoming byte -- push byte back onto queue !
      Code2 = SioUnGetc(Port, Code)
      RxStartup = %TRUE
      EXIT FUNCTION
    END IF
  NEXT I

  'no response
  PRINT "No response from sender"
  RxStartup = %FALSE

END FUNCTION

FUNCTION TxEOT(BYVAL Port AS INTEGER) PUBLIC

  DIM I    AS INTEGER
  DIM Code AS INTEGER

  FOR I = 0 TO 10
    Code = SioPutc(Port, %EOT)
    'await response
    Code = SioGetc(Port, %SHORT.WAIT * %ONE.SECOND)
    IF Code = %ACK THEN
      TxEOT = %TRUE
      EXIT FUNCTION
    END IF
  NEXT I

  TxEOT = %FALSE

END FUNCTION

FUNCTION TxPacket(BYVAL Port       AS INTEGER, _
                  BYVAL PacketNbr  AS INTEGER, _
                        Buffer()   AS BYTE,    _
                  BYVAL PacketSize AS INTEGER, _
                  BYVAL NCGbyte    AS BYTE)    PUBLIC

  'Port      : Port # [0..3)
  'PacketNbr : Packet # [0,1,2,...)
  'PacketSize: Packet size [128,1024)
  'NCGbyte   : NAK, "C", or "G"
  '
  'better be 128 or 1024 packet length

  DIM I          AS INTEGER
  DIM Code       AS INTEGER
  DIM CheckSum   AS WORD
  DIM PacketType AS INTEGER
  DIM Attempt    AS INTEGER
  DIM CS         AS BYTE
  DIM TheByte    AS BYTE

  IF PacketSize = 1024 THEN
    PacketType = %STX
  ELSE
    PacketType = %SOH
  END IF
  PacketNbr = PacketNbr AND 255

  'make up to MAXTRY attempts to send this packet
  FOR Attempt = 1 TO %MAXTRY
    'send SOH/STX
    Code = SioPutc(Port, PacketType)
    'send packet #
    Code = SioPutc(Port, PacketNbr)
    'send 1's complement of packet
    Code = SioPutc(Port, 255 - PacketNbr)
    'send data
    CheckSum = 0
    FOR I = 0 TO PacketSize-1
      TheByte = Buffer(I)
      Code = SioPutc(Port, TheByte)
      'update checksum
      IF NCGbyte <> %NAK THEN
        CheckSum = UpdateCrc(TheByte, CheckSum)
      ELSE
        CheckSum = CheckSum + TheByte
      END IF
    NEXT I
    'send checksum
    IF NCGbyte <> %NAK THEN
      'send 2 byte CRC
      CS = (CheckSum \ 256)
      Code = SioPutc(Port, CS)
      CS = (CheckSum AND 255)
      Code = SioPutc(Port, CS)
    ELSE
      'send one byte checksum
      CS = CheckSum
      Code = SioPutc(Port, CS)
    END IF
    'don't wait for ACK if "G"
    IF NCGbyte = ASC("G") THEN
      IF PacketNbr = 0 THEN Code = SioDelay(%SHORT.WAIT * %ONE.SECOND \ 2)
      TxPacket = %TRUE
      EXIT FUNCTION
    END IF
    'wait for receivers ACK
    Code = SioGetc(Port, %LONG.WAIT * %ONE.SECOND)
    IF Code = %CAN THEN
      PRINT "Canceled by remote"
      TxPacket = %FALSE
      EXIT FUNCTION
    END IF
    IF Code = %ACK THEN
      TxPacket = %TRUE
      EXIT FUNCTION
    END IF
    IF Code <> %NAK THEN
      PRINT "Out of sync. Expect ACK or NAK, not"; Code
      TxPacket = %FALSE
      EXIT FUNCTION
    END IF
  NEXT Attempt

  'can't send packet !
  PRINT 'Packet timeout for port ';Port
  TxPacket = %FALSE

END FUNCTION

FUNCTION TxStartup(BYVAL Port    AS INTEGER, _
                         NCGbyte AS BYTE) PUBLIC
  DIM I       AS INTEGER
  DIM Code    AS INTEGER
  DIM TheByte AS BYTE
  DIM AnyKey  AS STRING

  'clear Rx buffer
  Code = SioRxFlush(Port)

  'wait for receivers start up NAK or "C"
  FOR I = 1 TO %LIMIT
    AnyKey$ = INKEY$
    IF AnyKey$ <> "" THEN
      PRINT "Aborted by user"
      TxStartup = %FALSE
      EXIT FUNCTION
    END IF
    Code = SioGetc(Port, %SHORT.WAIT * %ONE.SECOND)
    IF Code <> -1 THEN
      'received a byte
      IF Code = %NAK THEN
        NCGbyte = %NAK
        TxStartup = %TRUE
        EXIT FUNCTION
      END IF
      IF Code = ASC("C") THEN
        NCGbyte = ASC("C")
        TxStartup = %TRUE
        EXIT FUNCTION
      END IF
      IF Code = ASC("G") THEN
        NCGbyte = ASC("G")
        TxStartup = %TRUE
        EXIT FUNCTION
      END IF
    END IF
  NEXT I

  'no response
  PRINT "no response from receiver"
  TxStartup = %FALSE

END FUNCTION

                                                                     