CR	EQU	0DH
LF	EQU	0AH

;Additional comments (hastily), reformatting, and small patching by 
;David Kirschbaum
;Toad Hall
;kirsch@braggvax.ARPA
;v1.1
; -	Tweaking to read banner in from file (STDIN)
;	Works for first screen-full, then stops.
;	Need to add a pause between screens.

CSEG	segment
	assume CS:CSEG , DS:CSEG
	org 100H

Enter:	jmp Begin
;---------------------------
buff	label	byte
	db CR,'BIGECHO, Vers. 1.1 copyright by R.M.Wilson and B. Simon, 1986'
	db CR,LF
	db 'Usage: BIGECHO message /FB',CR,LF
	db "Here 'message' is a string of at most 10 characters,"
	db ' F and B are characters',CR,LF
	db 'for the foreground and background'
	db ' (defaults to blank and solid, i.e. / [ ).',26

foreback db	0DBH,20H	;foreground/background chars (default)
hold	db	80 dup(0)	;Will hold the 8 bytes describing each
				; of 10 characters.
;---------------------------
Begin:
	mov	di,offset buff
Lod1:
	call	GetChar
	stosb			;stuff in buffer
	jz	Over1		;must be EOF

	cmp	al,CR		;msg end yet?
	je	Over1		; yep
	cmp	al,'/'		;look for switch char (fg/bg values)
	jne	Lod1		; no switch, keep looping

	call	GetChar		;read foreground value
	jz	Over1		;didn't get it
	mov	foreback,al	;stow it

	call	GetChar		;read background value
	jz	Over1		;didn't get it
	cmp	al,CR		;just foreground?
	je	Over1		; yep
	 mov	foreback[1],al	;save background also

Over1:	mov	si,0FA6EH	;Point DS:SI to table in ROM with dot
	mov	ax,0F000H	;patterns for ASCII characters 0
				; through 127.
	mov	DS,ax
	ASSUME	DS:NOTHING,ES:CSEG

	mov	di,offset hold	;ES:DI target=80H-byte buffer
	mov	bx,offset buff	;read text from here

Form:	mov	al,CS:[bx]	;Load byte of message text.
	or	al,al		;end of msg?			v1.1
	jz	Go_on		;yep, skip
	cmp	al,CR		;end of msg?
	je	Go_on		; yep, skip
	cmp	al,'/'		;switch char for foreground/background?
	je	Go_on		; yep, skip to there

	xor	ah,ah		;assume no parms, clear msb
	shl	ax,1		;*2
	shl	ax,1		;*4
	shl	ax,1		;*8 for char matrix
	push	si		;save ROM table offset
	add	si,ax		;bump to the char desired
	mov	cx,8		;8 chars in the screen matrix
	rep	movsb		;Get 8 bytes from ROM.
	pop	si		;from ROM
	inc	bx		;bump counter
	cmp	bx,offset buff + 10	;maxed out cmd line? (max 10 chars)
	jb	Form		; nope, loop for next cmd line char

;finished cmd line or hit switch char
Go_on:	mov	ax,CS
	mov	DS,ax

Output:
	mov	ah,2		;We'll be using Service 2 of DOS.
	xor	bp,bp		;vertical counter
Loop1:	mov	si, offset hold	;char buffer
	add	si,bp		;vertical offset
	mov	cx,10		;10 chars
Loop2:
	lodsb			;snarf the next msg char
	mov	bl,80H		;offset into msg buffer
Loop3:
	push	ax		;save the char a sec
	mov	dl,foreback[1]	;assume background
	and	al,bl		;? blank background ?
	jz	Over4		; yep
	 mov	dl,foreback[0]	;make it forground
Over4:	int	21H		;print the char
	ror	bl,1
	pop	ax
	cmp	bl,80H
	jne	Loop3
	add	si,7		;space between chars
	loop	Loop2		;for 10 cmd line chars

;vertical chars
	inc	bp		;vertical rows
	cmp	bp,8		;big chars 8 rows high?
	jl	Loop1		; not yet

; v1.1 Need a pause here, then a ClrScr before the next screen full.

Terminate:
	mov	ax,4C00H	;terminate properly			v1.1
	int	21H		;					v1.1

;v1.1
;Read char from StdIn
;Return ZF set (JZ nochar) if none avail, or EOF
;Else AL = char

GetChar	proc	near
	mov	ah,0BH		;check StdIn status
	int	21H
	or	al,al		;anything there?
	jz	NoChar		;nope, EOF

	mov	ah,8		;read kbd, no echo
	int	21H		;returns char in AL
	or	al,al		;set ZF (should be non-zero)
	jz	NoChar		;zero .. sigh
	cmp	al,1AH		;Ctrl Z?
	jnz	NoChar		;nope, it's ok
	 xor	al,al		;return 0, ZF clear
NoChar:
	ret			;with ZF set per char
				;AL = char (if any)
GetChar	endp

;-----------------------------------------------
CSEG	ENDS
	END	Enter
