CR	EQU	0DH
LF	EQU	0AH

;Additional comments (hastily), reformatting, and small patching by 
;David Kirschbaum
;Toad Hall
;kirsch@braggvax.ARPA

Cseg segment
	assume CS:Cseg , DS:Cseg
	org 100H

Enter:	jmp Begin
;---------------------------
	db CR,'BIGECHO, Vers. 1.0 copyright by R.M.Wilson and B. Simon, 1986'
	db CR,LF
	db 'Usage: BIGECHO message /FB',CR,LF
	db "Here 'message' is a string of at most 10 characters,"
	db ' F and B are characters',CR,LF
	db 'for the foreground and background'
	db ' (defaults to blank and solid, i.e. / [ ).',26

foreback db	0DBH,20H	;foreground/background chars (default)
hold	db	80 dup(0)	;Will hold the 8 bytes describing each
				; of 10 characters.
;---------------------------
Begin:
	mov	si,80H		;First, get characters for use
				; as fore and background.
	lodsb			;snarf cmd line length
	or	al,al		;anything there?
	jne	Lod1		; yep, go for it
	ret			; nope, just return to DOS

Lod1:
	lodsb			;snarf each cmd line char
	cmp	al,CR		;msg end yet?
	je	Over1		; yep
	cmp	al,'/'		;look for switch char (fg/bg values)
	jne	Lod1		; no switch, keep looping
;TH	lodsb			;snarf foreground value
;TH	mov	foreback,al	;stow it
;TH	lodsb			;snarf background value
	lodsw			;TH snarf foreground, possible background
	mov	foreback,al	;stow foreground
	cmp	al,CR		;just foreground?
	je	Over1		; yep
	mov	foreback[1],al	;save background also
Over1:	mov	si,0FA6EH	;Point DS:si to table in ROM with dot
	mov	ax,0F000H	;patterns for ASCII characters 0
				; through 127.
	mov	DS,ax
	mov	di,offset hold	;target=80H buffer
	mov	bx,82H

Form:	mov	al,CS:[bx]	;Load byte of cmd line message.
	cmp	al,CR		;end of msg?
	je	Go_on		; yep, skip
	cmp	al,'/'		;switch char for foreground/background?
	je	Go_on		; yep, skip to there
	xor	ah,ah		;assume no parms, clear msb
	shl	ax,1		;*2
	shl	ax,1		;*4
	shl	ax,1		;*8 for char matrix
	push	si		;save ROM table offset
	add	si,ax		;bump to the char desired
	mov	cx,8		;8 chars in the screen matrix
	rep	movsb		;Get 8 bytes from ROM.
	pop	si		;from ROM
	inc	bx		;bump counter
	cmp	bx,8CH		;maxed out cmd line? (max 10 chars)
	jl	Form		; nope, loop for next cmd line char

;finished cmd line or hit switch char
Go_on:	push	CS
	pop	DS		;DS=CS

Output:
	mov	ah,2		;We'll be using Service 2 of DOS.
	xor	bp,bp		;vertical counter
Loop1:	mov	si, offset hold	;char buffer
	add	si,bp		;vertical offset
	mov	cx,10		;10 chars
Loop2:
	lodsb			;snarf the next msg char
	mov	bl,80H		;offset into msg buffer
Loop3:
	push	ax		;save the char a sec
	mov	dl,foreback[1]	;assume background
	and	al,bl		;? blank background ?
	jz	Over4		; yep
	mov	dl,foreback[0]	;make it forground
Over4:	int	21H		;print the char
	ror	bl,1
	pop	ax
	cmp	bl,80H
	jne	Loop3
	add	si,7		;space between chars
	loop	Loop2		;for 10 cmd line chars

;vertical chars
	inc	bp		;vertical rows
	cmp	bp,8		;big chars 8 rows high?
	jl	Loop1		; not yet
	ret			;to DOS or calling program
;-----------------------------------------------
Cseg	ends
	end	Enter
