
                                
                                
                                
                                
                                
                               THE

                               RAP

                      PROGRAMMING LANGUAGE
                                
                                
                                
                                
                                
                                


                                
                      Richard A. Strangfeld
                                


                                


                                

Occasional Publications in Academic Computing

Number 10

                                


                                


                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                 Summer Institute of Linguistics
                          Dallas, Texas


This book is sold with the software it describes.  That software,
too, is  the copyrighted  property of  the  Summer  Institute  of
Linguistics.   However, in  the interest  of sharing the fruit of
our research  with the  larger academic community, the registered
owner of the RAP software is granted the right to share copies of
the distribution  diskette with  friends and associates, provided
this is  not done  for commercial  gain.   Such recipients of the
software, if  they decide  to use it in their research, should in
turn become registered owners by buying this book with its latest
version of the software.















                                  
                                
                                
      Copyright 1988 by the Summer Institute of Linguistics
                       All rights reserved

                            CONTENTS




             Part I:  A Tutorial Introduction to RAP


1. Introduction                                  3

1.1 What you need to run RAP                     4

1.2 Some history                                 5

1.3 The current version                          5

1.4 The READ.ME file                             6

1.5 About this book                              6


2. Getting started                               7

2.1 A one-line program:  the t command           8

2.2 Introducing variables:  the a command        9

2.3 Assigning values to variables               10

2.4 More on the screen:  cls, foot, and th      12


3. Flow of control                              15

3.1 Conditionals:  the if construct             16

3.2 Repeated execution:  the loop construct     19

3.3 Making choices:  the menu construct         21


4. Subprograms                                  25

4.1 Procedures:  an introduction                26

4.2 Procedures with arguments                   29

4.3 Returning a value:  functions               31

4.4 An aside:  comments                         34

4.5 Local and global variables                  35

4.6 Organizing a RAP program                    36


5. String operations                            37

5.1 String evaluation                           38

5.2 String comparison                           43

5.3 Pattern matching: has and contains          44

5.4 Advanced matching:  regular expressions     46


6. Numeric operations                           51

6.1 Arithmetic operations                       52

6.2 Comparing numbers                           52

6.3 Logical operations (and parentheses)        53

6.4 Converting between strings and numbers      54


7. Advanced dialogue features                   55

7.1 Special effects on the screen: using ANSI.SYS 56

7.2 Advanced input:  as, ah, and *keypress      57

7.3 Customized menus                            59


8. File operations                              63

8.1 Working with data files                     64

8.2 Getting information about files             69

8.3 Getting information about disks             71

8.4 Advanced file operations                    73


9. Calling other programs                       77

9.1 Using DOS commands from within RAP          78

9.2 Calling non-RAP programs from RAP           80

9.3 Chaining to another RAP program             81

9.4 Chaining with a batch file                  83

9.5 Getting information about the system        83


10. The programming environment                 85

10.1 Load, run, and related commands            86

10.2 Setting up your disks                      88

10.3 Debugging a RAP program:  debug and trace  89

10.4 The xi command                             93

10.5 The .include command                       94


11. Notes on programming style                  97

11.1 Writing better RAP programs                98

11.2 Writing faster RAP programs               102

                                

               Part II:  A Reference Guide to RAP


12. Elements of the language                   109

12.1 Lexical conventions                       110

12.2 Names                                     110

12.3 Variables                                 111

12.4 Built-in variables                        112

12.5 Arrays                                    115

12.6 Numeric expressions                       116

12.7 Strings and string expressions            117

12.8 Pattern matching                          119

12.9 Statements                                120

12.10 Flow of control                          121

12.11 Programs                                 124


13. The interpreter                            125

13.1 Loading and running                       126

13.2 File access                               129

13.3 Command-line arguments                    131

13.4 Limits                                    132

13.5 Normal, small, and large RAP              133

13.6 Memory usage                              134


14. Command descriptions                       135


15. Built-in function descriptions             179


16. Error and warning messages                 197


References                                     217


Glossary                                       219


Appendixes                                     227

A. Summary of commands, functions, and variables 228

B. Formal syntax definition                    231

C. ANSI screen-control codes                   238

D. Input codes for special keys                240

E. Differences between RAP models              242


Index                                          244

__________________________________________________

Chapter 1


INTRODUCTION


      1.1  What you need to run RAP

      1.2  Some history

      1.3  The current version

      1.4  The READ.ME file

      1.5  About this book


  RAP  is   a  programming   language  intended  to  help  put  a
"friendlier" layer  between "unfriendly" complicated programs and
their users.   An  experienced user of some complex program could
write  a  RAP  program  to  help  his  or  her  less  experienced
colleagues.  That RAP program might ask questions and offer menus
to the  user in  a "friendly" fashion, then pass the instructions
obtained to  the other program in whatever "unfriendly" format it
required.

  A typical  use of  RAP might  be with IT--the interlinear  text
processing system (Simons and Versaw 1988).  This system consists
of a  number of  programs for  manipulating interlinear annotated
text.   Most of these programs get their instructions on what the
user wants to do from a "control file."

  Without RAP,  the user  must use  a text  editor  to  type  the
control file  by hand.   This  file is written to rather exacting
specifications; the  user generally works with a book open to the
page giving  those specifications  in order to see what is needed
and in  what format.  After creating and saving the control file,
the  user   might  type   something  like    itprep  -f  prep.ctl
chumash.txt to run an IT program.

  With RAP,  you can  set up  a "friendly"  program to handle the
messy details  that the  IT programs require.  When run, this RAP
program would  present the  user with  a set  of  multiple-choice
menus and  other questions.   It  would provide  explanations and
extra helps  as needed.   It would ask all the questions required
for the operation selected, automatically write the control file,
and automatically run the proper IT program.

1.1 What you need to run RAP

  RAP runs  on any of the following computers, provided it has at
least 128K of memory[1] and is using DOS 2.0 or later:

       1. an IBM PC or compatible  
       2. a Sharp PC-5000     
       3. any MS-DOS computer that responds to IBM or ANSI  
          screen commands.

  The easiest  way to  start learning  RAP is to make a disk that
contains RAP.EXE, COMMAND.COM, and your favorite text editor, and
then do  everything on  that one  disk.   This  arrangement  will
suffice for  working through  the examples  in this book.  If you
find yourself  running out  of room  on that  disk, read  section
10.2.

1.2 Some history

  RAP is  derived from  the PILOT  programming  language  (Stark-
weather 1969).   PILOT  is a  computer-aided instruction language
intended for use by novice programmers.  RAP (whose name was once
Rational Pilot)  has many  of the  features of  PILOT,  but  adds
enhancements that  make the  language more  structured  and  more
powerful.   There are  three key  additions:   structured program
control constructs  (with the  removal of  jumps), parameters for
called subprograms,  and local  variables.  These changes make it
easier to write clear and useful programs in RAP.  Apart from the
enhancements, most RAP commands come from ordinary PILOT.

1.3 The current version

  This book  accompanies version  1.0 of RAP. We ask for feedback
in terms  of suggested  improvements, bug reports, and especially
ways that  you  have  been  able  to  use  RAP.    We  intend  to
incorporate good sample programs developed in the field in future
formal  releases  of  RAP.    Comments,  corrections,  questions,
suggestions, and  especially  sample  programs  are  welcome  and
encouraged. Please direct these to:

    Academic Computing -- RAP Development
    Summer Institute of Linguistics
    7500 W. Camp Wisdom Road
    Dallas, Texas 75236

  Before you contact us, please check the exact version number of
RAP that  you are using and include that in your report.  You can
find this out by starting RAP without giving it a program to run.
If you  are reporting  a bug, it can be very helpful to send us a
disk containing  the RAP  program you  wrote  that  revealed  the
problem, and even a copy of the RAP.EXE program file that you are
using.

  The RAP  distribution disk  includes the  normal version of RAP
(RAP.EXE) and  two variants.  The normal version will suffice for
learning RAP and for most ongoing use.  The variants are SmallRAP
(SMALLRAP.EXE) which has fewer features but uses less memory, and
LargeRAP (LARGERAP.EXE)  which allows  very large  RAP  programs.
The differences  between them  and normal  RAP are  discussed  in
section 13.5 and appendix E.

  Also included  on the  RAP  distribution  disk  is  the  COMMON
subroutine library  developed by  Kirk Parker  and  Gary  Simons.
This is a collection of predefined procedures and functions which
make it  easier to  write reliable  interactive programs.   It is
fully documented in a companion volume (Parker and Simons 1988).

1.4 The READ.ME file

  You may  find a  file called READ.ME on your RAP diskette along
with RAP.EXE  and related  program files.   READ.ME  contains any
additions or corrections to this book that relate to your version
of RAP,  and  explains  any  sample  programs  or  tools  on  the
diskette.   It would  be wise  to read or print it before reading
this book in detail.

1.5 About this book

  This book contains a tutorial section, a reference section, and
several appendixes.   The  tutorial, chapters  2 through 11, uses
examples to  explain the  more frequently-used  RAP commands.  It
leads from  simple statements  to  more  complex  statements  and
groups of statements.  The reference section, chapters 12 through
16, provides  a more concise and orderly description of RAP.  The
appendixes summarize the commands and syntax of the language, and
provide other reference material.

  As with any language, it is easier to learn RAP if you have had
some  experience   with  other  languages--in  this  case,  other
programming languages.   If you haven't, don't fear.  People have
learned to  write useful  RAP programs  using this  book with  no
prior experience.   We have tried to gear the tutorial section to
the novice  while aiming  the reference  section at  the somewhat
more experienced  programmer.   This  does  mean  that  the  book
contains  something   inappropriate  for   everyone.     Bear  it
patiently.


____________________

  1 If  your computer  only has 128K, you will not be able to run
some RAP  programs that  call other programs.  You'll have better
results with SmallRAP (see section 13.5), though there will still
be limitations.


----------------------------------------------------------------

Chapter 12


ELEMENTS OF THE LANGUAGE


      12.1  Lexical conventions

      12.2  Names

      12.3  Variables

      12.4  Built-in variables

      12.5  Arrays

      12.6  Numeric expressions

      12.7  Strings and string expressions

      12.8  Pattern matching

      12.9  Statements

      12.10  Flow of control

      12.11  Programs


  This chapter  describes the elements of RAP from the bottom up,
working from character-level concerns up to programs.

12.1 Lexical conventions

  RAP allows one statement per line.  A statement may occupy more
than one  line if  each line  but the  last has  a plus  sign (+)
appended as  its last  character.  A statement, including all its
continuations, may  be up  to 255 characters long.  When any line
ends with  a nonescaped  plus sign,  the next line is appended to
it.

  The use  of white  space (blanks,  blank lines,  and tabs) in a
program is  encouraged for readability.  The loader ignores blank
lines, leading blanks on any line (including continuation lines),
and blank  space between  keywords.  Trailing blanks are ignored.
White space is not allowed within a name or keyword, or before an
array subscript.

  Comments are  also encouraged  for readability.   There are two
kinds:  remarks and in-line comments.  The loader strips out both
kinds when it reads the program.

  A remark is a statement beginning with the r keyword; the whole
statement is  ignored.  An in-line comment can come at the end of
any statement or on a blank line.  It begins with white space and
a semicolon (or a semicolon at the beginning of a line), and runs
to the end of the line.  When a statement is continued on several
lines, only the last line may have a comment.

12.2 Names

  String variable  names start  with a dollar sign, followed by a
letter and  up to nineteen[1] additional  characters  (which  are
alphanumerics or  underscores).   All characters  in a  name  are
significant.   Case is  ignored.  Spaces are not allowed within a
name, or between an array name and its subscript.

  Numeric variable  names are  similar,  except  that  the  first
character is a pound sign (#) instead of a dollar sign.  There is
no conflict  if the  names of a string variable and a numeric one
have the same alphanumeric part, as in #line versus $line.

  An array  name (see  section 12.5)  is just  like  an  ordinary
string or  numeric variable  name, but it is immediately followed
by a numeric subscript expression in square brackets.

  Names of  functions are  similar to  variable names,  but begin
with an  asterisk (*).   Names  of  procedures  have  no  special
character at  the beginning;  they  just  start  with  a  letter.
Subprogram names  do not  conflict with  similar variable  names:
*line,  #line,   and  $line   can  all   coexist  peacefully  (if
confusingly).   However, functions  and procedures  with  similar
names will  conflict:   *line and line can't both be used.  Also,
RAP command names should not be used as procedure names.

  Symbolic constants  (defined  with  the  .define  command)  are
similar, but  begin with  a period.   As with variables, the full
name is  significant, case  is ignored,  and blanks within a name
are not  permitted.   You should  avoid using  .include, .define,
.undef, and  .undefine as  names of  constants, since  they  have
special meaning  to the loader.  The names .ifdef, .else, .endif,
and .pragma are reserved for future use.

12.3 Variables

  RAP has  two data  types:   string and  numeric.   Variables of
either type can be global, local, or built-in.

  A string  variable holds a stream of characters.  It is limited
to a maximum length of 255 characters, and may not contain nulls.
Normal printing  characters and  the upper  half of the character
set (through  ASCII 255)  may be used freely.  Control characters
(ASCII 31 and below) should only be used with caution.  A numeric
variable  holds   a  long   integer,  between   -2147483640   and
2147483640.   Numbers are  expressed in base ten when output, and
are assumed  to be  in that  form when input or when appearing in
expressions.  RAP does not provide built-in conversion to or from
octal or hexadecimal.

  Variables in  RAP are  local,  global,  or  built-in.    Global
variables are  known in  the main  procedure and everywhere else.
Local variables  are declared  in some  subprogram (procedure  or
function), and  are known  only in  that subprogram  and  in  any
subprograms that  it calls.   Programmers should take note:  this
is not  quite conventional.   The scope of a variable is dynamic,
is determined  at run  time, and depends entirely on the order in
which subprograms call one another.  The built-in variables are a
predefined set listed in the next section.

  The same  variable can be declared on several levels.  That is,
when a  main procedure  calls a  subprogram which  calls  another
program, variables  with the same name may be locally declared in
each of them.  When such a variable is referenced, the most local
(lowest level)  copy is  the one used.  Higher-level instances of
that variable  are preserved  and inaccessible  until the  lower-
level subprograms terminate.

  Declaration is  not required.   If  an assignment is made to an
undeclared  variable,  that  variable  is  created  as  a  global
variable.   Declaration assigns a value of 0 to numeric variables
and "" (nothing) to string ones.

12.4 Built-in variables

  RAP provides  a number  of special-purpose  built-in variables,
given in  alphabetical order  and described  below.   They may be
assigned new  values, though  as noted  below this  is  sometimes
unwise.   Local  copies  of  these  variables  will  be  used  if
declared.

$blank

  This variable  contains a  single space.   Sometimes  the  name
$blank is  easier to see in text than a literal space.  It can be
used to  provide trailing  blanks which the loader will not strip
off in  an assignment  or th  statement.   Assigning a  different
value to this variable is legal, but is apt to lead to confusion.

#case

  This determines  whether or  not case  is significant in string
comparison and  pattern matching  operations.   If #case is zero,
case is  ignored.   If #case is nonzero, case is considered.  The
default is 1.

$cmdline

  This variable  contains any  command-line  arguments  given  on
entering RAP,  except for  the program name and arguments used by
the RAP  interpreter.   Arguments are  separated by  blanks,  and
appear in  the order in which they were typed.  See section 13.3.
This variable  may be  assigned a  value.  The global instance of
$cmdline is  also used  in passing  information  to  another  RAP
program called with run.

$left

  When a  pattern matching  operation using  contains succeeds in
matching a  pattern to some portion of a string, this variable is
assigned the  portion of  the string  to the  left of the matched
section.   If the  match operation  fails, this  variable is  not
touched.   If there  has not yet been a match operation, $left is
not defined.   It is often a good idea to declare a local copy of
$left when using contains in a subprogram, to avoid affecting any
$left used in the main program.

$match

  When a  pattern matching  operation using  contains succeeds in
matching a  pattern to some portion of a string, this variable is
assigned the  portion of  the  string  matched.    If  the  match
operation fails,  this variable is not touched.  If there has not
yet been  a match  operation, $match is not defined.  Declaring a
local copy of $match is generally a good idea if you use contains
in a subprogram.

$newline

  This variable  contains the newline character (line feed, which
also triggers a return[2] when displayed).   It  is often  useful
embedded in  text  that  is  to  be  displayed  or  passed  to  a
subprogram.   As with  $space, this  variable can  be assigned  a
different value but at the risk of confusion.

#paged

  This variable  controls the  automatic  pausing  that  normally
occurs after each full screen[3] of output. If #paged is nonzero,
pausing will  occur.   The default is 1.  Assigning this variable
(or a local copy) a zero value will suppress the pausing.

$path

  This is  the directory path list used by RAP in accessing files
(for edit, *existf, *findpath, .include, load, *open, run, xcall,
and xchain)  when the  file specified is not found in the current
directory.   It is  initially given  the value  of the  DOS  path
environment variable, but it can be assigned a different value or
a local  copy can  be used.   Nothing  that is  done to this will
affect the path environment variable in DOS.

  To get  a single  backslash in a path, you must assign a double
backslash to  $path; thus  $path=C:\\RAP;C:\\BIN;  will  give  an
effective path  of C:\RAP;C:\BIN;  .   (When RAP reads in the DOS
path on startup, it handles this detail automatically.)  For best
results, put the path in all caps, and follow the last entry with
a semicolon.

$prompt

  This is  the prompt  displayed when RAP asks for input from the
user in  an a  or ah  statement.   It defaults  to ?  but can  be
assigned a  new value.  If a local copy of $prompt is declared in
a subprogram, it will be used.

#result

  This shows  the error  code returned  by the  most recent xcall
command.   If xcall  runs a program which returns a code, #result
is set  to that  code.   If xcall  is unable  to run the program,
#result is -1.  Otherwise, #result is set to 0.

$right

  When a  pattern matching  operation using  contains succeeds in
matching a  pattern to some portion of a string, this variable is
assigned the  portion of  the string  to the right of the matched
section.   If the  match operation  fails, this  variable is  not
touched.   If there has not yet been a match operation, $right is
not defined.   Declaring  a local  copy of  $right is generally a
good idea if you use contains in a subprogram.

$screentype

  This variable  shows what  kind of  computer is  in use.    The
current possibilities  are Sharp LCD, ANSI, and IBM.  On startup,
RAP does  some tests  to determine  the kind  of computer,[4] and
assigns this  variable a  value accordingly.   You  can assign  a
different  value,   but  this   will  not   affect  RAP's  screen
operations.

  The Sharp LCD  screentype is used for the Sharp PC-5000 with an
8-line LCD screen.  ANSI is any other system that responds to the
ANSI control  codes (see section 7.1), such as an IBM PC with the
ANSI.SYS driver  installed.   If the computer is  not a Sharp PC-
5000 and  does not  respond to  ANSI codes,  RAP assumes that you
have an IBM PC or close compatible, and uses the IBM screentype.[5]

#sstep

  This controls single-step tracing when LargeRAP is run with the
/trace option.   If  #sstep is nonzero, RAP displays and runs one
step at  a time.   If it is zero, RAP runs normally.  See section
10.3 for more details.

$tag

  When RAP is displaying a menu, this variable holds the response
tag (e.g.,  a, b,  etc.) of  the most  recently processed option.
This can  be embedded  in the text of an option, or in the prompt
text that is shown after the last option.

$version

  Identifies the  version of  RAP that is running, including both
the version number and the possible annotation Small or Large.

12.5 Arrays

  RAP supports arrays, though in a somewhat limited fashion.  Any
variable name  may be  immediately followed by a subscript, which
is a  numeric expression  in square  brackets.  The value of that
expression may be anything between 0 and 999.  Only one subscript
is allowed;  arrays are  one-dimensional.  A subscripted variable
name may  appear anywhere a normal scalar (ordinary) variable may
appear, except in a parameter in a proc or function statement.

  An explanation  of how  arrays are currently implemented in RAP
should shed  light on  their current limitations.  When RAP comes
across a  variable name  immediately followed  by a  square  left
bracket, it  evaluates the  subscript.  It attaches a three-digit
decimal number  representing that  subscript to the variable name
in place  of the  bracketed subscript, and from then on treats it
as the name of a scalar variable.

  Thus if #i is 7 and #j is 2, the statement:

    $line[#i] =$oldline[#j+1]

is converted on execution to (and treated internally as):

    $line007 =$oldline003

  Most of the time this behavior is fine; it really does give you
working arrays.   One  drawback is  the potential for conflict if
you already  have variables  with similar names.  Another is that
array names  are limited to 17 instead of 20 characters.  A third
is that  you can't  pass a  whole array  as an  argument to (or a
returned value from) a subprogram.

  The only  exception  to  the  above  description  is  in  RAP's
handling of subscripts in a declare statement.  There, RAP treats
the subscript  as a  maximum size and creates local variables for
each possible member. The statement

    declare $line[4]

is treated as

    declare $line000,$line001,$line002,$line003,$line004

  As  with   scalar  (nonarray)  variables,  declaration  is  not
required.   Declaring an  array in  a subprogram ensures that all
its members  will go  away on returning from that subprogram.  In
contrast, any  member assigned  a value in an undeclared array is
created as  a global  variable, and  these  will  all  remain  on
returning.   The problem  is no  different with scalars (ordinary
variables), but with array members there are likely to be more of
them.

  This description  of the  internal implementation  of arrays is
provided to  clarify their  current limitations.    It  would  be
unwise to  write code that depends on the equivalence of $line[7]
and $line007, since implementation details can change.

12.6 Numeric expressions

  As there  are two  kinds of  data in RAP, there are two sets of
operations:    those  involving  numeric  expressions  and  those
involving strings.

  The syntax for numeric expressions in RAP is very conventional,
and is  described in  detail in  appendix B.   The  precedence of
operators is as follows:

    1.  ( ), not, unary minus,[6] unary plus   (highest)
    2.  *,  /,  mod, rem
    3.  +, -
    4.  <,<=,==,<>,>,>=
    5.  and
    6.  or                                     (lowest)

  The operators  in groups  2 and  3 group  left-to-right.    The
division operator  (/) does integer division, mod is modulus, and
rem is  remainder.  Modulus and remainder are identical when they
have  positive   operands  but  differ  with  negative  ones,  as
illustrated in the following chart:
  
         #a     #b    #a/#b   #a mod #b   #a rem #b
         11      5       2         1          1
        -11      5      -2         4         -1
         11     -5      -2        -4          1
        -11     -5       2        -1         -1


  There are  no bitwise  operators.   The logical  and comparison
operators (not,  and, or,  and all  of group 4) treat zero-valued
arguments as logically false and anything else as logically true.
They return  zero for  false and  one for  true.   Unlike  the  C
language, RAP evaluates both operands in a logical operation even
when the value of the first one makes the second one moot.

  Conversion of  string to numeric data is done with the built-in
*value function;  the *isnumber  and *isnumexp functions test for
the  possibility  of  this  conversion.    Conversion  of  single
characters to  their ASCII  numeric equivalents  is done with the
*ascii function.

  The same  comparison operators  apply to string comparison, and
similarly result  in a  1 or  0 outcome.  In a string comparison,
the two arguments are string expressions as described below.  The
arguments are evaluated and then compared character-by-character.
As soon  as a  difference is  found, the  string with  the lesser
character (per the ASCII sequence, with case possibly ignored) is
treated as  the lesser  string.   If one  string ends  before the
other but  they match until that point, the shorter string is the
lesser.   If they  are the  same length and match fully, they are
equal.

  The distinction  between  upper  and  lower  case  is  normally
ignored in  string comparisons.   This can be changed by altering
the value  of the built-in variable #case, or a local variable of
the same name.  If #case is 0, case is ignored.  If it is 1, case
is taken into account.  The default is 0.

  Two  additional   string  comparison  operators  allow  pattern
matching; these  are has  and contains.   They  are described  in
section 12.8.

12.7 Strings and string expressions

  A string  is a  stream of  text, up  to 255 characters long.  A
string does  not normally  appear in quotes.  A string expression
is used  in string  comparisons, in arguments to subprograms, and
in the  return statement for a string function.  It may be either
a string in quotes, a string variable, or a string function call.
You can  include quotes in a quoted string by preceding them with
a backslash.

  RAP evaluates  a string  expression before using it.  There are
two kinds  of string  evaluation:   normal  and  final.    Normal
evaluation consists  of scanning  the string  once from  left  to
right, finding  any variable  names or function calls embedded in
the string,  and replacing  them with their values.  This happens
whenever a string is used; more specifically, when it:

    1. is on the right side of an assignment, or
    2. is an argument to virtually any command, or
    3. is an argument in a call to a subprogram.

  Final evaluation  takes care  of escaping backslashes and final
ones.   It occurs  after normal evaluation when a string is going
from RAP  to the  outside world,  and in  a few other situations.
More exactly, final evaluation occurs when a string:

    1. is output to a file or the screen (as in t and th,
       foot, option, and prompts), or
    2. is passed to DOS (as in dir, killf, load, run, xcall,
       xchain, xs, *envir, and edit), or
    3. is executed as a command (in xi), or
    4. is used in a contains or has pattern match as either
       the pattern or the target string, or
    5. is an argument in a call to any built-in function
       except *escape_symbols.

  In normal  evaluation, the string is scanned from left to right
until a variable name or function call is found.  If the variable
name has been assigned a value (even by declaration), the name is
replaced by  the value.  Otherwise the name remains.  In the case
of a  function call,  the arguments  (if any)  are evaluated, the
function is  performed,  and  the  returned  value  (if  any)  is
substituted for the name and arguments.

  In scanning  for a variable name, RAP takes the longest stretch
of characters  that could legally constitute a name, and does not
examine shorter subsets. Thus, if #chapter is 4 and #c is 186000,
evaluation of  the string   "Beginning of chapter #chapter" turns
it  into  "Beginning  of  chapter 4",  not  "Beginning of chapter
186000hapter". If there is no variable #chapter, no  substitution
takes  place,  and  the  string  remains  "Beginning  of  chapter
#chapter" after evaluation.

  As soon  as any  substitution has  occurred, the  scan  pointer
backs up  one character  from the  beginning of  the new material
(unless that  material is already at the beginning of the string)
and the  scan resumes.   This  process continues  until the  scan
pointer reaches the end of the string.

  If a  variable or  function name is preceded by a backslash, it
is not  evaluated.   More  precisely,  it  is  not  evaluated  if
immediately preceded by an odd number of backslashes.

  In final  evaluation, one pass is made through the string.  Any
unpaired  backslashes  are  removed;  pairs  of  backslashes  are
replaced by  single ones.   A  single backslash at the end of the
string in  a t or write argument is noted as a signal to suppress
the newline after the string, and is removed.

  Since output operations turn double backslashes to single ones,
input operations  do the reverse.  This applies in a, ah, as, and
read operations.   With  respect to backslashes, input and output
operations are  complementary.  The input process precedes any \,
$, #, or * symbol in the input string with a backslash.

  The *final_eval  and *escape_symbols  functions are provided to
allow  programmer   access  to   these  evaluation  and  escaping
processes.   *Final_eval takes  a string  and subjects  it to the
same normal  and  final  evaluation  processes  described  above.
*Final_eval returns  the same  thing that  a  t  statement  would
display.   Similarly, *escape_symbols takes a string and performs
the same escaping (of \, #, $, and * characters) as would be done
by an a statement.

12.8 Pattern matching

  Two special string comparison operators allow pattern matching;
these are has and contains.  Each one tests to see if a specified
pattern appears as part of a source string, and results in a 1 or
0 depending on the success of the match.

  The contains  operation also  has the  side-effect of assigning
the variables  $match, $left,  and $right  equal to  the  matched
string and its left- and right- context.  Both the pattern string
and the  source string  are fully  evaluated before matching, and
the  side-effect   strings  undergo   escaping  before  they  are
assigned.

  The patterns can be constructed of ordinary text characters and
the following  special characters,  which are  described in  more
detail in section 5.4:

      
      pattern                   matches
      -------                   -------
      .                         any character
      ^                         beginning of line
      $                         end of line
      x*                        zero or more occurrences of x
                                (or the specified character)
      [ ... ]  and  [^... ]     character classes
      \t                        a tab character
      \b                        a backslash

  In a contains operation, if the pattern matches the string, the
variables $match,  $left, and  $right are  set to  match the text
matched and  the pieces  on either  side.   These  variables  are
normally global,  but local copies will be used if they have been
declared.   These variables are only given values when a match is
successful.

  If the pattern is an empty string and the source string is not,
the match  fails.  If both are empty strings, the match succeeds.
If this  happens in  a contains  operation,  $left,  $right,  and
$match all get the empty string.

  As with other string comparisons, the distinction between upper
and lower case is normally ignored in match operations.  This can
be changed  by altering the value of the built-in variable #case,
or a  local variable  of the  same name.   If #case is 0, case is
ignored.  If it is 1, case is taken into account.  The default is
0.

12.9 Statements

  A simple  RAP statement typically consists of a command keyword
and zero  or more arguments.  Appendix B shows the syntax of each
statement, including  the required arguments.  The keyword may be
followed by  a colon;  this helps  separate the  keyword from its
arguments but  is otherwise ignored.  The colon may be omitted if
the break  between the keyword and argument is unambiguous.  If a
statement begins  with a  colon (with no keyword), the keyword of
the previous statement is assumed.

  The call  and assignment  statements do  not require  keywords.
Any statement beginning with a valid procedure name is assumed to
be a  call; any beginning with the name of a variable is taken as
an assignment.

two kinds of subprograms (procedures and functions) to manage fin
chapter 14 and summarized in appendix A.

12.10 Flow of control

  RAP  provides   two  kinds   of  subprograms   (procedures  and
functions) to  manage flow  of control on a high level.  Within a
subprogram, RAP  supports the  if construct,  the loop,  and  the
menu.  These three may be nested arbitrarily.

The if construct

  The if  construct is  conventional.    It  begins  with  an  if
statement, and  ends with  an end if.   The  if statement  may be
followed by  a then  statement, whose purpose is purely cosmetic,
and a  sequence of  statements constituting  an if clause.  There
may be  zero or  more else  if clauses,  and  zero  or  one  else
clauses.

  If the  conditional in  the if statement is true (nonzero), the
sequence in  the if  clause is  executed.  Otherwise each else if
conditional is examined in turn (if any are present) until one is
found to  be true;  its sequence is executed.  If none of them is
true, the else clause is executed.

The loop construct

  In its  simplest form,  the loop construct begins with loop and
ends with  end loop.  When RAP reaches the end loop statement, it
branches back  to the  top of  the loop.   Arbitrary exits can be
provided with  the exit statement, and arbitrary branches back to
the top with the repeat statement.

  You can  branch out  of nested  loops or  menus with the exit n
statement, where n is a number.  Exit 1 exits the innermost loop,
exit 2 the next one out, and so on.  Similarly, repeat n branches
to the top of nested loops or menus.  The default n is 1.

  The exit and repeat statements may be modified with conditions,
as in  exit if #n > 9, or  repeat 2 if not($line has  $pat).   In
this case, the exit or repeat is performed only if the expression
after the if is nonzero.

  The loop statement may also appear as loop while cond.  This is
exactly the same as loop followed by exit if not (cond); in fact,
this conversion is made by the loader.

  Similarly,  the   end loop  statement   may  be   replaced   by
until cond.  This is exactly the same as exit if cond followed by
end loop.   The loader  makes this  conversion too.    When  this
construction  is  used,  it  should  be  remembered  that  repeat
statements branch to the top of the loop, not to this test.

  Two  more   forms  of  the  loop  statement  are  loop for  and
loop #n times.  The sequence

    loop for #n = 0 to #linecount step 10
       ...
    end loop

is roughly equivalent to the following sequence:

    #n = 0
    loop while #n <= #linecount
       ...
       #n = #n + 10
    end loop

  The differences  are that  the loop for  form  is  clearer  and
faster, and  that it  evaluates its arguments before entering the
loop rather  than each  time through.  Only the initial values of
the final-value argument #linecount and the increment argument 10
matter. If  the statements  inside the  loop change  the value of
#linecount, this  does not  affect the  test used  in  the  loop.
Further, if  the statements  inside the  loop change the value of
the counter  variable #n, those changes are not considered in the
comparison, and  are discarded on the next pass through the loop.
A more  exact description  of what  RAP does  internally for  the
loop for fragment above would be:

    #counter = 0
    #limit = #linecount
    #stepval = 10
    
    if #counter > #limit
       #n = #counter
    else
       #counter = #counter - #stepval
    
       loop while #counter < #limit[7]
          #counter = #counter + #stepval
          #n = #counter
          ...
       end loop
    end if

where #counter,  #limit, and  #stepval are  all internal  working
variables kept by RAP and inaccessible to your program.

  A simpler  variation on  the loop takes the form loop #n times.
It evaluates  its argument,  and executes  the loop the specified
number of  times.   For a  negative or zero argument, it does not
execute the  loop at all.  The statement loop #linecount times is
equivalent to  the statement loop for #counter = 1 to #linecount,
where #counter is a working variable kept by RAP and inaccessible
to your program.

The menu construct

  The menu  construct asks  a  multiple-choice  question,  offers
several alternatives,  inputs  and  validates  a  selection,  and
performs a  sequence based  on the  selection.    This  construct
begins with a menu statement and a header sequence, followed by a
number of  option sequences  and an  optional help  sequence.  It
ends with end menu.

  When the  menu construct  is executed,  RAP first  executes the
statements in  the header sequence.  Then it displays each option
with a  tag letter  (unless otherwise  directed), and prompts the
user for  a selection.   It  validates the selection and performs
the sequence appropriate to that selection.

  As with  loops, the  sequences in a menu can contain repeat and
exit statements;  these cause  branching to  the top or bottom of
the menu.

  An option may include an if condition.  If this condition has a
nonzero value, the option will be displayed and used normally; if
the condition  is zero, the option is omitted and unused (and not
assigned a  tag letter).   This  condition is evaluated each time
the options are displayed.

  Usually, RAP assigns an option letter to each option in a menu.
This may  be overridden  with the  option accept  keyword,  which
specifies one  or more  user inputs that will select that option.
In this  case, RAP  will not  generate or display a single-letter
tag.   The text specified in this statement may contain wildcards
as used  in the pattern-matching operators has and contains.  The
first option to match the user input will be selected.  Unlike in
has and  contains, the  pattern must  match the  user's  complete
input (rather than just some part of it).

  Even if  RAP is generating an automatic tag for the option, the
option notag keyword  can be  used to stop RAP from automatically
prepending the  tag to  the option  text.  In this case, the text

  RAP normally  displays a  prompt of the form, "Please select an
option (a  through x)"  after the  last option.   If  a different
prompt text  is desired,  that text can appear as the argument to
the end menu statement.  If that text contains the $tag variable,
the  value  of  the  last  automatically-generated  tag  will  be
substituted.

Procedures and functions

  RAP  supports   two  kinds  of  subprograms:    procedures  and
functions.   A function  returns a  value; a  procedure does not.
There are  numeric and string functions, differing in the type of
value they return. RAP has special built-in functions in addition
to any  defined in  a user's  program;  these  are  described  in
chapter 15.

  A subprogram  may take  any number of arguments. Parameters are
passed by  value.   Each calling argument is evaluated[8] and the
result  is   assigned  to  the  corresponding  parameter  in  the
subprogram.   The number  of arguments  in the  calling line must
match the number of parameters in the proc or function statement,
and for  a numeric  parameter the  argument must  be numeric.  On
return from  the subprogram,  nothing happens  to the  arguments:
you cannot pass new values back out through the parameters.

  The  parameters   are  treated   as  local   variables  in  the
subprogram.   The subprogram  may declare  other local variables.
All of  these go away on termination of the subprogram, except in
the top-level  procedures (init__  and main, described in section
12.11).

  A function returns a value with the return statement.  The type
of value  returned (string  versus number) depends on the type of
the function.  A procedure may not return a value.

12.11 Programs

  A RAP  program consists  of an optional sequence of code at the
beginning of the file, followed by zero or more subprograms.  One
of these  may  be  a  procedure  named  main;  this  has  special
significance to  the interpreter.   Thus  a RAP  program  may  be
formed entirely  of subprograms  (including a main procedure), or
it may  consist entirely  of loose  code  not  contained  in  any
subprogram, or  it may  be a  mixture.  Loose code is not allowed
after or between subprograms.

  The loader  regularizes all  this, by  taking any loose code at
the beginning of the file and inventing a procedure called init__
to hold  it.    Thus  the  interpreter  sees  any  program  as  a
collection of  procedures and  functions.  The next chapter tells
what it does to run them.

____________________

  1 Sixteen for array names.

  2 That's the RETURN character, not the return command.

  3 Eight lines on a Sharp PC-5000, 25 lines on any other system.

  4 If you start RAP with the command-line argument /sharp, /ibm,
or /ansi,  RAP uses  the selected  screentype and does not do any
tests.

  5 SmallRAP does not support the IBM screentype.  It will run on
IBM PC's  and compatibles,  but it  doesn't use  the special  IBM
screen control  features; instead  it assumes  that  ansi.sys  is
installed.  On any computer that is not a Sharp PC-5000, SmallRAP
uses the ANSI screentype.

  6 The  minus sign  in -10  is a unary minus, in contrast to the
binary minus in 100 - 10.

  7 If  the increment  is negative,  the comparison operator used
here is  changed to  ">=" instead of "<=" (and the one earlier is
"<" instead of ">".  This allows counting down as well as up.
may contain  the built-in variable $tag, which is replaced by the
automatically-generated tag.

  8 There  is one  exception:  the argument to *escape_symbols is
used without evaluation.


----------------------------------------------------------------

Chapter 13


THE INTERPRETER


      13.1  Loading and running

      13.2  File access

      13.3  Command-line arguments

      13.4  Limits

      13.5  Normal, small, and large RAP

      13.6  Memory usage


13.1 Loading and running

  This chapter  describes use of the RAP interpreter (RAP.EXE and
its variants) and the associated programming environment.

  RAP operates  in three  distinct modes:   loading, running, and
immediate.  The loader reads a program from one or more files and
stores it  internally.   When a  program is run, this internally-
stored program  is used.   Immediate  commands are  typed by  the
user.

The loader

  The loader stores the program in a somewhat modified form.  All
comments, blank  lines, and  leading and trailing blanks and tabs
are removed.   Defined constants (in normal RAP and LargeRAP) are
replaced with  their values.    Lines  from  included  files  are
substituted for  .include lines.   Command keywords are stored as
single-byte tokens.  Arguments for the most part remain intact.

  The loader  checks syntax  on the  program and construct level:
that is,  it checks that for each if there is an end if, and that
any then,  else if,  or else  statements in  between are  legally
placed.     Similar  checks   are  done  for  loops,  menus,  and
subprograms.   Most of  the construct  statements are replaced by
special internal  instructions with the target addresses computed
for the  required branching.   (For  the curious, the c option in
RAP's debug  facility will  show  the  instructions  used.    See
section 10.3.)

  While the  program is  being loaded,  procedure calls that lack
the  call   keyword  cannot   be  distinguished  from  misspelled
keywords, since  RAP doesn't  know all  the legal procedure names
until loading  is complete.   Therefore the loader keeps track of
statements in  which it has not recognized a command keyword, and
comes back  to check  them after  loading is  done.  At that time
they are  identified either as call statements or as unrecognized
command errors.

  The loader  does not  parse most command arguments.  Therefore,
syntax errors in those arguments are not detected at load time.

  The .define, .undefine, and .include statements described below
have their effect at load time.  They are used by the loader, and
are not  themselves stored  as part  of the  internal form  of  a
loaded program.   Both  .define and .undefine may also be used in
immediate mode.

Defined names

  You can  define a symbolic constant name to be used at program-
loading time  as an  abbreviation for  a string,  by means of the
.define keyword.  Once a  name is defined, any appearance of that
name in  the program  being loaded will be replaced by the string
specified.  This is similar to the idea of a string variable, but
different in  that evaluation  takes place  while the  program is
being loaded,  instead of while it is being run.  By the time the
program has  been stored  internally, all  the symbolic  constant
names (also  called defined  names) have  been replaced  by their
values.

  Defined names  are used  to avoid  embedding "magic numbers" in
your  program.  For  example,  if  your  program  makes  repeated
reference to the width of a printed page, you might have repeated
occurrences of  the number 80 scattered around the program.  Some
future change  to a  132-column printer might require you to find
each occurrence  of 80  and change  it to 132, as well as perhaps
changing each 79 to a 131, and so on.

  If you  were to  use a defined name instead, you might have the
line

    .define .pagewidth 80

somewhere at  the beginning  of your program.  Then in the places
in your  program where  you would  have used  80, you  could  use
.pagewidth instead.   After  the .define, the loader will replace
every use  of .pagewidth,  so that  by the  time the  program  is
loaded, each  reference will  say 80  again.   This helps  in two
ways: first,  changing to a new page width only requires that you
change the number in one place.  Second, you don't have to figure
out which  occurrences of  80 refer  to the page width, and which
ones are there for some other reason and shouldn't be changed.

  The argument  to .define  is a  name followed by a text string.
The name  begins with  a period, followed by a letter and zero or
more letters, digits, or underscores, with a maximum length of 20
characters.   When a  string is  scanned for constant names to be
expanded, a  potential name  must match  the defined name for its
full length.   If  .TRUE is  defined as  1, .TRUER  will  not  be
converted to 1R.

  Symbolic constants  are only replaced as the code is loaded, or
as immediate  instructions are  typed.  If in the example above a
string that  is formed  at run time contains the name .pagewidth,
the name  will not  be replaced  with 80 when (at run time) it is
evaluated.

  You can  remove the  definition of  a name  with the  .undefine
directive, as  in .undefine .pagewidth.  It is legal to .undefine
a constant  that has not been defined; this has no effect.  It is
an error  to .define the same symbol twice without an intervening
.undefine.  .Define and .undefine are not supported in SmallRAP.

Including files

  The .include  keyword causes  the loader's  input stream  to be
diverted to  draw from  another file.  The loader reads and loads
lines from the second file until it reaches the end of that file,
then resumes  reading the  original file  at the  line after  the
.include statement.   This  is  one  way  of  organizing  program
portions in  different files,  and of  putting reusable  parts of
programs somewhere  so that  they can  easily be  used by several
different programs.

  For example, some portion of code which the programmer wants to
include in several programs could be stored in file COMMON.H, and
then referred  to in each of the programs with a statement of the
form   .include common.h.  .Include statements may be nested to a
total depth  of four  (one main file and three .include'd files).
The same  search rules are used for finding .include files as for
main program files.

Running a program:  the interpreter

  You can  cause RAP  to load  a program  without running  it, by
using the  load command.   RAP  will read and store your program,
and then  wait (in  the "immediate"  mode)  for  you  to  type  a
command.   Sometimes this is useful when debugging.  You can then
start your program by typing run.

  An easier  way is  to load  and start  your program in a single
command, by  specifying the program name in your run command.  As
soon as  RAP finishes  loading the  program, it moves directly to
the "running" mode and starts running it.

  The interpreter  runs a  program by  first clearing  the symbol
table of  any variables.   Then  it looks  for a procedure called
init__ (init  followed by two underscores), created by the loader
and holding  any "loose  code" found  before the first procedure.
If init__  is found,  it is  executed.   When init__ is done, any
variables it  used are  kept.    Next  the  loader  looks  for  a
procedure called  main, which  only exists  if the programmer has
created it.   If  this is  found, it  too is  run.  If neither an
init__ nor a main procedure can be found, RAP informs the user.

Immediate mode:  getting commands from the keyboard

  If a program finishes without sending control back to DOS (with
bye) or  on to  another RAP  program (with  run) or  an  external
program (with  xchain), the user sees an asterisk prompt.  RAP is
then in  immediate mode.    In  this  mode,  the  user  can  type
individual commands and RAP will execute them.

  In general, simple statements (as defined in appendix B) may be
used in immediate mode, while statements that form constructs may
not.   The exceptions  are r  (remark), return, and xi, which are
not allowed  in immediate  mode.  Note that a call to a procedure
is legal,  as is  a t  or  assignment  statement  whose  argument
includes an embedded function call.

13.2 File access

  RAP accesses  files in  the loading stage (for main program and
include files)  and during  execution (for data files and editing
of program files).  In both cases, RAP supports the use of a path
list, as  seen in  the DOS  path variable.   The  string variable
$path is assigned the current value of the DOS path variable when
RAP starts  up; this  string variable  is then  used in  any file
access attempts.   You  may assign $path a different value if you
want a  different path list, and a subprogram may declare a local
copy of $path different from the global one.

  The loader and the edit command use paths as follows:

1. If the file name provided contains a colon or a backslash, RAP
   doesn't use a path.  It assumes that the name contains its own
   directory information,  and attempts  to access  the  file  as
   named.

2. If the  file name  contains no  colon or  backslash, RAP first
   tries the  current directory,  then each directory in the path
   list until the file is found or the list is exhausted.

3. In either  case, in any directory where it searches, RAP first
   looks for a file with the exact name specified.  If it doesn't
   find it  and the name has no extension, it appends .RAP to the
   name and  looks again.   (In SmallRAP, it tries appending .RPS
   first, then  .RAP.   In LargeRAP,  it tries  .RPL first,  then
   .RAP)   If the  name ends  with a period and no extension, RAP
   does not append one.

Figure 13.1  shows several run statements and the files which RAP
would look for on each one, given a $path of C:\\RAP;C:\\BIN; .

     
                  Figure 13.1   Path searching

run statement       files tried (in the order shown)
                    where $path is C:\\RAP;C:\\BIN;

run hello           HELLO in current directory
                    HELLO.RPS in current directory
                            (SmallRAP  only)
                    HELLO.RPL in current directory
                            (LargeRAP only)
                    HELLO.RAP in current directory
                    C:\RAP\HELLO
                    C:\RAP\HELLO.RPS (SmallRAP only)
                    C:\RAP\HELLO.RPL (LargeRAP only)
                    C:\RAP\HELLO.RAP
                    C:\BIN\HELLO
                    C:\BIN\HELLO.RPS (SmallRAP only)
                    C:\BIN\HELLO.RPL (LargeRAP only)
                    C:\BIN\HELLO.RAP

run hello.          HELLO in current directory
                    C:\RAP\HELLO
                    C:\BIN\HELLO

run \\rap\\hello.rap              \RAP\HELLO.RAP on current drive

run .\\hello        HELLO in current directory[1]
                    HELLO.RPS in curr dir. (SmallRAP)
                    HELLO.RPL in curr dir. (LargeRAP)
                    HELLO.RAP in current dir.

run c:hello         HELLO in current dir. on C:
                    HELLO.RPS in curr dir. on C:
                            (SmallRAP only)
                    HELLO.RPL in current dir. on C:
                            (LargeRAP only)
                    HELLO.RAP in curr dir. on C:
     

  The use  of paths  is similar  for data  files accessed in read
mode by  *open, *existf,  and *findpath,  except that  the  .RAP,
.RPS, and  .RPL extensions are not appended.  In write and append
modes, *existf  and *findpath  search by  the same rules but only
look for  files which  are writable.  *Open does not use paths in
write or append mode.

  RAP uses  paths for  xcall and  xchain commands  as well.   For
these, it  tries appending  .COM or .EXE if the file is not found
as named.   RAP  tries the  file as  named, the  file with a .COM
extension, and  the file  with a .EXE extension in each directory
of the path in turn.

13.3 Command-line arguments

  The most  common form  of the command line for RAP has just one
argument, the name of the program to be run.  We see this in

    rap hello.rap

  In addition  to the  program name,  you  can  use  command-line
options to  control certain  aspects of the RAP interpreter or to
pass information  to the  RAP  program  you  are  running.    The
switches to control the interpreter include the following:

    /ansi         Specifies ANSI as the $screentype
    /ibm          Specifies IBM as the $screentype
                    (not applicable in SmallRAP)
    /sharp        Specifies Sharp LCD $screentype
    /trace        Enables single-step tracing
                    (in LargeRAP only)

  The first  command-line argument  that does  not begin  with  a
slash is assumed to be the program name.  Apart from that and the
options listed  above, any  other arguments  are treated  as user
arguments.   These are  passed to the RAP program by means of the
built-in $cmdline  variable.  Any white space (blanks or tabs) in
the command  line is  taken as  an argument  separator.  The user
arguments are  collected (with  single spaces  between them) into
one string, and the $cmdline variable is assigned this value.  If
there are  no user  arguments,  the  $cmdline  variable  contains
nothing.

  If the command used to start RAP is

    rap /ansi myprog one two three

then RAP  runs the  program MYPROG (or MYPROG.RAP, MYPROG.RPS, or
MYPROG.RPL),  using   ANSI  for  the  screentype,  and  assigning
$cmdline the  value  one  two  three.    The  interpreter-control
switches can  appear anywhere  in the  line; they will be removed
before $cmdline is assigned a value.  Thus

    rap myprog one /ansi two three

has exactly the same effect as the previous example.

  When one  RAP program  chains to another using run, it can pass
information to  it through  this same $cmdline variable by simply
assigning it the desired text value.  This value will survive the
loading process,  and will  be available  in $cmdline  to the new
program.

13.4 Limits

  Figure 13.2  summarizes  RAP's  limits.    While  there  is  no
specific limit  on the  depth of nested calls to subprograms, the
system stack  may quietly  overflow at  around 10-20  deep.   RAP
supports recursion,  but deep recursion is likely to overflow the
stack.  This is particularly true in SmallRAP and LargeRAP, which
use fixed-size stacks.

     
                    Figure 13.2   RAP Limits

    filename length               64 characters
    files open with *open         8 (4 in SmallRAP)[2]
    include-file nesting          3 deep
    menu options                  26
    normal variable names         20 characters
    array variable names          17 characters
    nested subprogram calls       No specific limit (but see text)
    numbers                       -2147483640 to 2147483640
    program length                varies (see section 13.5)
    line length when              255 characters
      reading files                 (Any more are left for the next
                                    read; this is not an error.)
    statement length              255 chars (with all continuations)
    string length                 255 characters
     

  There is  no specific  limit on  program size  other than  that
imposed by  memory.   In SmallRAP  and normal  RAP, up  to 64K is
available to  hold your  program, your  data,  and  the  internal
tables and  stacks that  RAP constructs.   If your program is too
big to  load, RAP  will tell you during loading.  If your program
loads but  RAP runs  out of  "heap" memory  (used for  variables)
during execution,  RAP will  tell you  it is out of space.  If it
runs  out  of  "stack"  memory  (used  internally  for  calls  to
subprograms), the results may vary.

  LargeRAP, described  in the next section, is not subject to the
64K limit.   It  can use  whatever memory  your system has, up to
640K.

13.5 Normal, small, and large RAP

  Three models  of RAP are provided on the RAP distribution disk.
These are  normal  RAP  (RAP.EXE),  SmallRAP  (SMALLRAP.EXE)  and
LargeRAP  (LARGERAP.EXE).     Normal  RAP  will  serve  for  most
purposes; the  other two models are provided for situations where
memory constraints are a problem.

SmallRAP

  SmallRAP is  a subset  of the  RAP language,  with some  of the
less-often-used features  removed but most of the good ones still
intact.   The SMALLRAP.EXE  interpreter is therefore smaller than
the normal  one.   It also uses memory differently.  As a result,
SmallRAP leaves  much more  memory unused and available for other
programs that  it may call.  This lets SmallRAP programs run on a
128K Sharp PC-5000 and use DOS commands and external programs, as
long as the external programs are not too large.

LargeRAP

  In contrast,  LargeRAP allows  larger programs than normal RAP.
LargeRAP programs  and data  can total more than 64K, though they
run somewhat  more slowly.   Few  programs should need to be this
big, and  most programs  that come close can be profitably broken
into two  or more  smaller programs.  Still, there are some giant
RAP programs and so there is an interpreter to handle them.

  Appendix E  lists the  differences between  normal RAP  and the
other two models.

13.6 Memory usage

  Normal RAP occupies about 105K bytes of memory.[3] This size is
fixed; it  does not vary with the size of the RAP program or data
you create.   This  space includes  the RAP.EXE interpreter and a
large (64K)  data area  which holds the user's RAP program, data,
and stack.   Most  of this  data area is usually empty, but it is
still reserved.

  SmallRAP occupies  a variable  amount of  memory, between about
50K and  100K bytes.   The  50K minimum  holds  the  SMALLRAP.EXE
interpreter and  stack; the  variable portion  holds  the  user's
program and  data.  It grows and shrinks as needed to accommodate
the RAP  program being  run; the  memory  it  does  not  need  is
available for  running other  programs called  from  RAP.    This
feature of SmallRAP allows the xs, xchain, and xcall functions to
be used on a 128K Sharp, provided the external programs they call
are not too large.

  Obviously, there  is still a limit.  If some program needs 128K
to run  all by  itself, it won't be able to run along with RAP in
128K.   Nevertheless, many small external programs, useful tools,
and DOS commands are usable with SmallRAP, even on a 128K Sharp.

  LargeRAP also  occupies a  variable amount  of memory,  ranging
from about  80K with  no program  loaded to  more than  500K with
really huge  programs and/or data.  For a small program, LargeRAP
will use  less total  memory than  ordinary RAP.   For  a  larger
program, it  will use  more.   For a very large program, LargeRAP
will work  where ordinary  RAP cannot  hold the  program.  That's
what it's for.


____________________

  1 Unfortunately, this will not work if the current directory is
the root.   Under  MS-DOS, period (.) means the current directory
only when in a subdirectory.

  2 Note  that DOS  also imposes  limits on  the number  of  open
files.   The default is eight, including five predefined ones for
the console,  aux, and  printer.   You can increase the DOS limit
with a  FILES= statement  in the  CONFIG.SYS file;  see your  DOS
manual.

  3 Or slightly less on a 128K Sharp.


----------------------------------------------------------------

Chapter 14


COMMAND DESCRIPTIONS


  Part I  described various  RAP commands  in a tutorial fashion.
This chapter  presents all  of the  RAP commands  in alphabetical
order, with  syntax descriptions  and examples.  A summary of the
commands appears  in appendix  A,  and  the  complete  syntax  in
appendix B.

  The syntax  descriptions shown  here for each command include a
colon after  the command.   The  colon is not required as long as
the argument  can be distinguished from the command keyword; thus
most  of  the  examples,  like  most  RAP  statements  in  actual
practice, do not include the colon.


_________________________________________________________________

a
_________________________________________________________________

Syntax

   a: var     
   a:

where var is the name of a a numeric or string variable.

Description

  The accept  statement is  used for input from the keyboard.  It
takes a  line of input and (usually) stores it in a variable.  If
the variable  name provided  is a string variable name, the input
is stored  as a  string (without  the newline).   If  that string
contains any  $, #,  *, or  \ characters,  RAP "escapes"  them by
prefixing them with backslashes.

  If the  argument to the a statement is a numeric variable name,
the input  from the  keyboard must  be a  number.   The specified
variable is then assigned its value.

  If the a statement has no argument, it gets a line of input and
discards it.

Examples

   a:$name    This inputs a line from the keyboard, and stores it
              as a string in $name.

   a:#pages   This inputs  a line,  parses it  as a  number,  and
              stores its value in #pages.

   a:         This inputs and discards a line from the keyboard.


_________________________________________________________________

ah                     (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   ah: var    
   ah:

where var is the name of a a numeric or string variable.

Description

  The accept-hanging  statement is  just like  a, except  that it
returns the  cursor to  the end  of the  typed input  text on the
screen when done.

Examples

   ah:$name   This inputs a line, stores it as a string in $name,
              and puts the cursor at the end of the typed input.

   ah:#pages  This inputs  a line  consisting of a number, stores
              its value in #pages, and puts the cursor at the end
              of the typed input.

   ah:        This inputs  a line,  discards  it,  and  puts  the
              cursor at the end of the typed input.


_________________________________________________________________

as
_________________________________________________________________

Syntax

   as: var    
   as:

where var is the name of a a numeric or string variable.

Description

  The accept-single statement reads a character from the keyboard
into a variable without waiting for an Enter.  The character read
is not echoed to the screen.

  If the  argument to as is a string variable name, the character
read is  placed in that variable.  When that character is a $, #,
*, or  \ ,  RAP  first  "escapes"  it  by  prefixing  it  with  a
backslash; the string then holds two characters.

  If the  argument is a numeric variable name, the ASCII code for
the character  read is  placed in  that variable.   If  as has no
argument, the character is discarded.

Examples

   as:$key    This gets  one character  from  the  keyboard,  and
              stores it in the variable $key.

   as:#key    This gets  one character  from  the  keyboard,  and
              stores its ASCII code in the variable #key.

   as:        This gets  one character  from  the  keyboard,  and
              discards it.


_________________________________________________________________

bye
_________________________________________________________________

Syntax

   bye:
   bye: exit-code

where exit-code is a numeric expression between 0 and 255.

Description

  This command  exits the  RAP interpreter.   It  closes any open
files, and  returns the user to the operating system (or whatever
program RAP  was started  from).   If you  provide  an  exit-code
argument, this  is used as the code returned to DOS.  If not, the
code 0 is returned.

Example

   bye        Exits the RAP interpreter with a return code of 0.

   bye 2      Exits the RAP interpreter with a return code of 2.


_________________________________________________________________

c, cs (also ++, --, +=, and -=)
_________________________________________________________________

Syntax

   c:num-var = num-expr     
   c:str-var = str-expr     
   num-var = num-expr  
   str-var = str-expr  
   
   cs:num-var = number 
   cs:str-var = unquoted-string    
   
   num-var ++ 
   num-var -- 
   num-var += num-expr 
   num-var -= num-expr

where num-var  and str-var are numeric and string variable names,
num-expr and  str-expr are  numeric and  string expressions,  and
number and unquoted-string are what they claim to be.

Description

  The  compute  statement  does  simple  assignment,  either  for
strings or  numeric variables.   The c keyword is optional and is
not normally  used; any  line beginning  with a  variable name is
interpreted as a compute statement.  For numeric assignments, the
right-hand side  of the  equals may  contain  any  valid  numeric
expression.   For string  assignments, the right-hand side (which
is not in quotes) is evaluated before assignment.

  Several variations  on the  compute statement  are provided  to
help make  RAP programs faster.  These include the cs keyword and
the ++,  --, +=,  and -=  operators.   They do  not  provide  any
additional  capabilities;   they  just  save  time  for  the  RAP
interpreter by  avoiding some  of  the  overhead  of  the  normal
assignment operation, as follows:

  If the  expression on the right side of the equals sign is just
a number  rather than a numeric expression needing evaluation, or
if it is a string that does not contain any variables or function
calls to  be evaluated, you can use the keyword cs.  This does an
assignment without  doing all the scanning, parsing, and checking
involved in evaluating expressions.

  For an  assignment statement that just increases or decreases a
numeric variable  by 1,  the special  ++ and  -- operators may be
used.   The statement  #n++ is exactly equivalent to #n = #n + 1,
but it  saves RAP  the overhead  of parsing  and  evaluating  the
expression after  the equals sign, and of looking up the variable
twice.   Statements of  this form are very common in loops, where
speed  is  often  particularly  important.    Likewise,  #n--  is
equivalent to #n = #n - 1.

  When increasing  or decreasing a numeric variable by some value
other than  1,  the  +=  and  -=  forms  may  be  used.    Saying
#count += #n is  equivalent to  #count = #count + #n, and the RAP
interpreter carries it out just a little faster.

Examples

   c:#n = 1   
   #n = 1     
   cs:#n = 1

Each of these assigns the variable #n the value 1.  The second is
the most  common form;  the c: keyword is never required.  The cs
form is slightly faster than the others.

   $color=blue

This assigns string variable $color the value blue.

   #e = #m * #c * #c

This computes  a value  using a famous equation and assigns it to
#e.

   #line = #line + 1   
   #line ++

These each increase #line by one.  The second form runs faster.

   #line = #line + *filesize($myfile) * 4    
   #line += *filesize($myfile) * 4

These each  increase #line  by four  times the  value returned by
*filesize.  Again, the second form runs faster.

   #line--

This decreases #line by one.

   #n -= #words

This decreases #n by the value of #words.


_________________________________________________________________

ca
_________________________________________________________________

Syntax

   ca: line,col   
   ca: line   
   ca: ,col   
   ca:

where line and col are both numeric expressions

Description

  The cursor-address  statement places the cursor anywhere on the
screen.   It takes  two optional  arguments separated by a comma.
The first  is the  desired line (between 1 and 25 on an IBM PC, 1
and 8  on a  Sharp PC-5000  with LCD  screen); the  second is the
column (between 1 and 80).  If the line or column is omitted, the
current line  or column is assumed.  If only a column argument is
desired, it should be preceded by a comma.

Examples

   ca 15,40

This moves the cursor to line 15, column 40.

   ca 15

This moves the cursor to line 15, the current column.

   ca ,40

This moves the cursor to column 40 of the current line.

   ca #headrow,#col[#n]

This moves  the cursor  to the line corresponding to the value of
#headrow and  the column corresponding to the value of element #n
of the #col array.

   ca

This has  no effect  (since  it  moves  the  cursor  its  current
position).


_________________________________________________________________

call
_________________________________________________________________

Syntax

   [call]  procedure-name ( expr { , expr } )     
   [call]  procedure-name   expr { , expr }  
   [call]  procedure-name   

where each expr is an expression (string or numeric)

Description

  This statement  calls a procedure.  Its argument is the name of
the procedure,  followed by  a list  of calling  arguments.   The
calling arguments  are numeric  and/or string expressions.  These
are evaluated  (strings undergo normal string evaluation) as they
are  assigned  to  the  procedure  parameters.    The  number  of
arguments must  match the  number of  parameters defined  for the
procedure, and  each argument  must have  the same  type  as  the
corresponding parameter.

  The call  keyword may be omitted.  Any statement beginning with
a procedure  name is  interpreted  as  a  call  statement.    The
parentheses around the argument list may also be omitted.

Examples

   call explain("markers")

This calls  the  procedure  named  explain,  and  passes  it  one
argument which is the string markers.

   explain "markers"

This does  the same.   The  call keyword is not required, nor are
the parentheses.

   printfile($filename,"oki",#firstpage,#last,#copies)
   printfile $filename,"oki",#firstpage,#last,#copies

Either of  these calls  the procedure named printfile, and passes
it  the   five  arguments  shown.    The  first  two  are  string
expressions; the last three are numeric ones.

   printfile "myfile", *envir("PRINTER"), #last-3, +   
     #last, #people

This again  calls the  printfile  procedure  and  passes  it  the
arguments shown.   Note  that the  arguments may include function
calls and  arithmetic expressions.  They are evaluated before the
printfile procedure is called.

A string  expression in quotes may not also contain quotes inside
it, even  in an  embedded function  call.   Thus  something  like
"*envir("PRINTER").prd" ,  which has  quotes both  around it  and
inside it, is not a legal quoted string expression.


_________________________________________________________________

ce, cls, cl
_________________________________________________________________

Syntax

   ce:                                   (ce is  not supported in
   SmallRAP)
   cl:        
   cls:

Description

  The clear-end  statement ce  clears the screen from the current
cursor position  to the  end of  the screen,  and also clears the
typeahead  buffer.    Clear-line  (cl)  clears  from  the  cursor
position to  the end  of the  current line.   Clear-screen  (cls)
clears the  entire screen  and places  the  cursor  in  the  home
position, in the top left corner of the screen.  These statements
take no arguments.

Examples

   cls        This clears the screen

   cl         This clears  everything from the cursor position to
              the end of the line

   ce         This clears from the current cursor position to the
              end of the screen.


_________________________________________________________________

close
_________________________________________________________________

Syntax

   close: descriptor   

where descriptor is a numeric expression

Description

  This statement  closes an  open file.   Its  argument is a file
descriptor as originally assigned by *open.

Example

   close #dictionary

This closes  a file  which was originally opened with a statement
like #dictionary = *open($dfile)


_________________________________________________________________

debug                  (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   debug:

Description

  This command  lets the  user examine the internal code area and
the symbol  table containing information on constants, variables,
labels, and  keywords.   Both can be helpful when debugging a RAP
program.   The user  is repeatedly  prompted to  type one  of the
following; typing  q  finally  exits  the  user  from  the  debug
subsystem.
    
    Type this:            For this effect:
    ----------            ----------------
    any variable name     show current value
    any (starred) label   show location in stored code
    .                     show all defined constants
    *                     show all labels
    #                     show all numeric variables
    $                     show all string variables
    a                     show all of symbol table
    c                     examine the code (the program)
    v                     show all variables
    q                     exit from debug subsystem
    

  If the  *, #,  $, a, or v option is preceded with a minus sign,
the items  shown  will  include  the  built-in  variables  and/or
function labels as well as the user-defined ones.

  While examining  the code area (with c), you might type 1,20 to
see lines 1-20 as stored internally, a to see all of the program,
or q to quit and return to the main debug menu.


_________________________________________________________________

declare
_________________________________________________________________

Syntax

   declare: var {, var}

where each var is a variable name

Description

  This  statement   is  used  to  create  local  variables  in  a
subprogram, or  global ones in the initial or main procedure, and
to give  them zero  or null-string initial values.  Its arguments
are variable  names separated  by commas.   If a variable name is
immediately followed  by a  subscript (a  numeric  expression  in
square brackets),  the members of an array with indexes from 0 to
that subscript are created.  Subscripts may not exceed 999.

Examples

   declare #students,#tests

This creates the two numeric variables shown, and gives them both
the value 0.

   declare $left,$match,$right

This creates  the three  variables shown,  and assigns  each  the
empty string  "" as  a value.   This  particular  declaration  is
highly recommended  in subprograms that use the contains facility
for pattern matching.

   declare #scores[50]

This declares  a 51-element  numeric  array  named  #scores  with
elements from #scores[0] thru #scores[50], all initialized to 0.

   declare $names[#classsize]

This declares  a string  array with  #classsize+1  elements  from
$names[0] through $names[#classsize], all set to zero.


_________________________________________________________________

.define                (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   .define constant-name text

where constant-name  is a  name beginning with a period, and text
is an unquoted string

Description

  This is  a directive  to the  RAP loader  to associate  a  text
string with  a name (technically, a symbolic constant name) while
loading a program.  Its argument is the name followed by the text
string.   Once the  name is  defined, any appearance of that name
while  the   program  is   being  loaded   (or  while   immediate
instructions are being typed) will be replaced by that string.  A
name may not be .defined twice without an intervening .undefine.

Examples

   .define .TRUE 1

This defines the constant .TRUE equal to 1 (a string)

   .define .MAX_WORDLENG 20

This defines the constant .MAX_WORDLENG  equal to the string 20.

   .define .WORKFILE temp1.dat

This  defines   the  constant   .WORKFILE  equal  to  the  string
temp1.dat.


_________________________________________________________________

dir                    (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   dir:       
   dir: directory-name

where directory-name is an unquoted string

Description

  This command  lists a  disk directory, using the dir command of
DOS.   If an  argument is  used, it is evaluated and passed on to
the system  for use  as the  dir argument.   This command assumes
that a copy of COMMAND.COM is accessible on the boot (or COMSPEC)
drive.   Note that  to pass  a backslash  on to DOS, the argument
must have a double backslash.

Examples

   dir        This lists contents of the current directory.

   dir *.rap  This lists  all files in the current directory with
              the extension .RAP.

   dir/w      This does the same, in wide format.

   dir \\bin  This lists contents of the \BIN directory.

   dir $mydir This evaluates  $mydir, and  passes its value as an
              argument to the DOS dir command.  If $mydir has the
              value \\bin,  this is  identical  to  the  previous
              example.


_________________________________________________________________

edit                   (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   edit:      
   edit: filename

where filename is an unquoted string

Description

  This command  invokes an  external editor.   If you provide the
name of a file as an argument, edit searches for that file (using
the current path and the normal search rules) and passes its full
pathname to  the editor.   If  you don't  specify a filename, the
name of  the current  main program  file is  used.  When the user
exits from  the editor, the (possibly modified) main program file
is reloaded  into RAP.   This  behavior allows  you  to  edit  an
include-file without  RAP then  trying to load it as the new main
program file.

  The edit  command assumes  that some  editor  is  present  (and
accessible with  the current path) with the name ED.COM or ED.EXE
(or even  ED.BAT).   If this  is not so, the user may so rename a
copy of  his or  her favorite  editor.    It  also  assumes  that
COMMAND.COM is  accessible on  the boot drive, or as specified in
the COMSPEC.

  Like load and run, the edit command will try appending the .RAP
extension (after  trying .RPS or .RPL in SmallRAP or LargeRAP) in
order to  find the  desired file.   See  section 13.2 for more on
this.

Examples

   edit

This edits and reloads the current main program file

   edit myfile.rap

This edits  MYFILE.RAP, and then reloads the current main program
file.   (This is reasonable behavior if MYFILE.RAP is an include-
file referenced by the current program file).


_________________________________________________________________

else, else if
_________________________________________________________________

Syntax

   else:      
   else if: condition

where condition is a numeric expression

Description

  These  statements   introduce  alternative  clauses  in  an  if
construct.   If the  if clause condition is not met, each else if
clause condition is examined in turn, and the first clause with a
true (nonzero)  condition is  executed.   If none  of the else if
conditions  is   satisfied,  the  else  clause  (if  present)  is
executed.

Examples

    if (#n == 1)              ; this test is made first
       t:one                  ; on success we just do this

    else if (#n == 2)         ; if it fails, try this test
       t:two                  ; if that succeeds, do this

    else if (#n == 3)         ; if both fail, try this
       t:three                ; if this succeeds, do this

    else                      ; if no test succeeded,
       t:many                 ;  then do this
    
    end if


_________________________________________________________________

end if, end loop, end menu
_________________________________________________________________

Syntax

   end if:    
   end loop:  
   end menu:  
   end menu: prompt-text

where prompt-text is an unquoted string

Description

  These statements  mark the  ends of  the  if,  loop,  and  menu
constructs  respectively.    On  encountering  an  end loop,  RAP
branches back  to the top of the loop.  On an end if or end menu,
RAP continues  to the  next statement.  The optional argument for
the end menu  statement specifies  a string to be used instead of
the standard menu prompt.

Examples

   end if            This marks the end of an if construct.

   end loop          This marks the end of a loop construct.

   end menu          This marks the end of a menu construct.

   end menu:Well?    This marks the end of a menu construct
                     which will use the (rude) prompt, "Well?"


_________________________________________________________________

end function
_________________________________________________________________

Syntax

   end function:

Description

  This marks the end of either a numeric or string function.

Example

   end function   This marks the end of a function


_________________________________________________________________

end proc
_________________________________________________________________

Syntax

   end proc:

Description

  This marks  the end of a procedure.  If it is not preceded by a
return statement, the loader inserts one.

Example

   end proc

This marks the end of a procedure.


_________________________________________________________________

exit
_________________________________________________________________

Syntax

   exit :     
   exit if : condition 
   exit levels :  
   exit levels if : condition

where levels is a number and condition is a numeric expression

Description

  This causes  a branch  to the  end of a menu or loop construct.
It may include a number showing how many nested menus or loops to
be  exited,  and  it  may  have  a  conditional  controlling  its
execution.

Examples

   exit

This causes an exit from the innermost surrounding loop or menu.

   exit 2

This causes an exit from the second-to innermost surrounding loop
or menu.

   exit if #n >= 10

This evaluates  the numeric  expression  shown;  if  it  is  true
(nonzero), this  causes an  exit from  the innermost  surrounding
loop or menu.

   exit 3 if #done

This evaluates  the variable shown; if it is true (nonzero), this
causes an exit from the third innermost surrounding loop or menu.


_________________________________________________________________

foot
_________________________________________________________________

Syntax

   foot:      
   foot: footer-text

where footer-text is an unquoted string

Description

  The foot  statement notes the cursor position, sends the cursor
to the  bottom of  the screen,  writes a message there, and waits
for the  user to  press an Enter.  If an argument is given, it is
used as  the message.   If  none is  given, the  message used  is
"Press ENTER  to continue."   After  the user  presses Enter, the
message is  cleared  and  the  cursor  returns  to  its  previous
position.

Examples

   foot:

This writes  "Press ENTER  to continue,"  waits for  the user  to
press Enter, then continues.

   foot:More...

This writes  More..., waits  for the  user to  press Enter,  then
continues.


_________________________________________________________________

help
_________________________________________________________________

Syntax

   help:

Description

  This statement  marks a  help-group in  a menu  construct.  The
help-group is executed if the user types ? or help in response to
the prompt.   If  RAP reaches  the end  of the help group without
encountering an exit or repeat statement, it branches back to the
top of the menu.

Example

   help

This marks  the sequence  that follows  as the  help group in the
current menu construct


_________________________________________________________________

if
_________________________________________________________________

Syntax

   if: condition

where condition is a numeric expression

Description

  This statement  begins an  if  construct.    If  the  condition
expression is  nonzero, the  clause following the if statement is
executed.   Otherwise the else if and else clauses are considered
(if present).

Examples

   if  #n == 10

This evaluates  the  numeric  comparison  expression  shown,  and
executes the  statements in  the if  clause only  if it  is  true
(nonzero)

   if  #n > 10 and #i == 0

This is similar, with a more complex expression.

   if  (#n > 10) and (#i == 0)

This is similar.  The parentheses are optional.

   if  #n

This executes the sequence only if the variable #n is nonzero.  A
possibly clearer equivalent is

   if  #n <> 0


_________________________________________________________________

.include
_________________________________________________________________

Syntax

   .include filename

where filename is an unquoted string

Description

  The .include  directive  tells  the  loader  to  begin  reading
statements from another program file.  On reaching the end of the
second file,  the loader  resumes reading the original program at
the point where it left off.

Example

   .include common.rap

This causes the RAP loader to temporarily draw its input from the
file COMMON.RAP, effectively placing the contents of that file at
this point in the current program as loaded.


_________________________________________________________________

killf
_________________________________________________________________

Syntax

   killf: filename

where filename is an unquoted string

Description

  This command  deletes a  file.   Its argument  (which is  fully
evaluated before  use) is  the name  of the file.  Killf does not
search the  path list  or append extensions to the filename.  The
file specified should not be open.

Examples

   killf tempfile

This deletes a file named TEMPFILE.

   killf $workfile

This evaluates  $workfile, comes  up with a string representing a
filename (say junk001), then deletes the file (JUNK001).


_________________________________________________________________

list                   (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   list:

Description

  This command lists the current main program file on the screen.
Note that  it lists the file as seen on the disk, not the program
as stored  internally by  RAP.  You can see the internally stored
version, with  RAP's internal  line numbers,  by using  the debug
command and the c (code) option.

Example

   list       This lists the current main program file.


_________________________________________________________________

load
_________________________________________________________________

Syntax

   load: filename

where filename is an unquoted string

Description

  This statement  reads a RAP program from a file into memory and
stores it  internally, ready  to run.   In  contrast to run, load
does not  automatically start  the program.   The argument is the
name of  the main program file.  If this is omitted or an invalid
name is supplied, the user is prompted for a valid name.

  Load will  search a  path list if the desired file is not found
in the current directory, and it will try appending the extension
.RAP (also .RPS or .RPL for SmallRAP or LargeRAP) if no extension
is provided.

Examples

   load myfile

This loads MYFILE, MYFILE.RPS, MYFILE.RPL, or MYFILE.RAP from the
current directory or some directory in the $path list, and stores
it in memory ready to run.

   load .\\myfile.rap

This loads MYFILE.RAP from the current directory into memory.

   load \\it\\itmain

This loads ITMAIN, ITMAIN.RPS, ITMAIN.RPL, or ITMAIN.RAP from the
\\IT directory.

   load it\\itmain

This loads ITMAIN, ITMAIN.RPS, ITMAIN.RPL, or ITMAIN.RAP from the
IT subdirectory in the current directory.


_________________________________________________________________

loop
_________________________________________________________________

Syntax

   loop:
   loop  while: condition   
   loop: count times   
   loop: for counter = start_value to end_value   
   loop: for counter = start_value to end_value step step_value

where condition,  count, start_value,  end_value, and  step_value
are all numeric expressions, and counter is a numeric variable.

Description

  This marks the beginning of a loop construct, which ends at the
matching end  loop  or  until  statement.    On  encountering  an
end loop or  repeat, RAP  branches back  to  this  point.    This
statement may  include a  while  test;  this  will  be  evaluated
initially and  on each  execution.   When the while expression is
zero, RAP branches to the statement following the end loop.

  The loop count times  form evaluates  its argument, and repeats
the loop  the specified  number of  times.    If  the  number  is
negative or zero, the loop is not executed.

  The first  loop for form begins  by evaluating  start_value and
end_value.  It sets an internal counter and the specified counter
variable equal to the start_value, and tests to ensure that it is
less than or equal to the end_value.  If so, it executes the body
of the  loop.   On each  subsequent pass  through  the  loop,  it
increases the  internal counter  by 1  and tests  it against  the
end_value.  If it is less, it sets the specified counter variable
to match the internal counter, and proceeds through the loop.

  The loop for  form with a step_value is similar, except that it
evaluates the  step_value before the first pass through the loop,
and uses  its value  instead of  1 as  the  amount  by  which  to
increase the counter.  If the step_value is negative, the test is
that the  counter is  greater than  or equal  to  the  end_value,
instead of less than or equal.  A zero step_value is not allowed.

Examples

   loop

This marks the beginning of a loop.

   loop while #n <= 10

This too  marks the  beginning of a loop, but this statement also
checks at  the beginning  of each pass through the loop to see if
the numeric  expression shown  is true  (nonzero).   If not,  RAP
exits from the loop.

   loop 10 times

This marks  the beginning  of a  loop which is to be executed ten
times.

   loop for #n = 1 to 2000000000

This marks a loop which may take some time to finish.

   loop for #n = 100 to 200 step 10

This marks the beginning of a loop where the variable #n is to be
varied from  an initial  value of  100 to  a final  value of 200,
increasing by 10 on each pass through the loop.


_________________________________________________________________

menu
_________________________________________________________________

Syntax

   menu:

Description

  This statement  marks the start of a menu construct, which ends
at the  matching end  menu statement..    It  is  followed  by  a
sequence of  code that is executed before the options in the menu
are displayed.  The menu statement takes no argument.

Example

   menu

This marks the start of a menu construct.


_________________________________________________________________

numeric function, num function
_________________________________________________________________

Syntax

   numeric function: function-name ( var { , var } )   
   numeric function: function-name  var { , var } 
   numeric function: function-name

where each  var is  a variable  name (string  or numeric) with no
subscript.  The keyword numeric can be abbreviated to num.

Description

  This statement marks the beginning of a numeric function, which
is a  subprogram that  returns a  number.   The arguments to this
statement are  the function  name (which begins with an asterisk)
and an  optional list  of parameters.   The  parameter list  is a
series  of   variable  names   separated  by  commas,  optionally
surrounded by  parentheses.   There is  no limit to the number of
parameters for a function.

  Parameter passing  is by  value.  On entry to the function, the
parameters are  declared as  local  variables  and  are  assigned
values corresponding to the values of the corresponding arguments
provided by  the caller.   On return from the function, these and
any other local variables are deleted, and nothing happens to the
calling arguments.

Examples

   numeric function *random

This marks  the beginning  of a  numeric function  named *random,
which takes no arguments.

   num function *random

This does the same.  The keyword "numeric" may be abbreviated.

   num function *square_root(#num)

This marks  the start  of a  numeric function named *square_root,
which expects  one argument  that is  a numeric  expression.  The
value of  that argument  will  be  assigned  to  the  "parameter"
variable #num.

   num function *triangle_area(#base,#side)

This begins  a numeric  function expecting two numeric arguments,
to be assigned to the parameter variables #base and #side.

   num function *wordcount($sentence)

This begins  a numeric  function expecting a single argument that
is a  string expression,  whose value  will be  assigned  to  the
parameter variable $sentence.

   num function *random()

This is the same as the first example.  For a function that takes
no arguments,  the parentheses  are not  required  but  they  are
allowed.


_________________________________________________________________

option
_________________________________________________________________

Syntax

   option [if (condition)]  [notag] : text   
   option [if (condition)]  [accept(pattern{,pattern})] : text

where condition  is a  numeric expression,  text is  an  unquoted
string, and  each pattern  is an  unquoted string with any commas
escaped with backslashes.  The parentheses are required as shown.

Description

  This statement marks an option group in a menu construct.  Each
option group  offers one  choice to  the user,  and contains  the
statements to be executed if that choice is taken.

  An option  statement may  contain a conditional expression.  If
this is  present, it  is evaluated and the option is only offered
when the  condition is  nonzero.   An option  may also contain an
accept clause  listing a number of responses that will select it.
It may  contain a  notag  keyword  that  will  prevent  RAP  from
assigning the  option a  letter.  It must contain some text to be
displayed to the user when the menu is shown.

  The following  examples assume  that the option statement shown
is part  of an  option group  in a menu construct, and that there
are a number of other options also to be displayed.  For the sake
of argument,  assume that the example is the second option in the
menu, so that the automatic tag letter, if assigned, is b.

Examples

   option:Sort the data by gloss

This introduces  an option  group which  would be  offered to the
user                                                          as,
"b - Sort the data by gloss," when the  menu is  displayed.   The
statements following  it in  the option group are executed if the
user types b in reply to the prompt.

   option:Save the data into $output_file_name

This introduces  an option  group.   The text following option is
evaluated  as   a  string   expression.     If   the   value   of
$output_file_name were  chumash.txt, then  the  option  would  be
displayed to  the user  as,  "b -Save the data into chumash.txt."
The option  group is executed if the user answers the menu prompt
with b.

   option accept("s","save"):Type S to save the data

This displays  an option labelled, "Type S to save the data," and
executes that group if the user answers the menu prompt with s or
save.

   option accept ("s.*"):Type S to save the data

This is  similar, but executes the group in response to any input
beginning with the letter s.

   option if (*existf($outfile,"w")):overwrite the old +    
                                         file $outfile

This evaluates  the expression  in parentheses.   If  it is  true
(nonzero), meaning  that the  file exists, RAP displays an option
with the  text, "b - Overwrite old file igbo.txt," (assuming that
$outfile  has   the  value  igbo.txt).    Note  the  use  of  the
continuation marker to spread this long statement over two lines.
If the  user answers  the menu  prompt with  b, RAP  executes the
option group.

If the  file does not exist, the value of the expression is zero,
and the  option is  not offered.   The  option group  will not be
executed regardless  of the  user's input,  and the b tag will be
assigned to the next option group.

   option notag:*chr(27)[1;40H$tag. Save the data

This example  is tricky.   The  notag keyword  prevents RAP  from
automatically prepending  the b tag on this option.  The *chr(27)
gives you an ASCII escape character, and the sequence <esc>[1;40H
tells the  ANSI driver  (for Sharp  or ANSI  screens) to move the
cursor to line 1 column 40.  The $tag variable is replaced by the
automatic tag  assigned to this line (b).  The result of all this
is that the text, "b. Save the data,"  appears on line one at the
40th column.   The  corresponding option group is executed on a b
input from the user.

This kind of trick lets you put multiple menu options on a single
line.   It also  depends completely  on having  a  computer  that
responds to  ANSI codes--either  a Sharp  PC-5000 or  an  IBM  PC-
compatible with  the ANSI  driver installed.  See section 7.1 for
more on the ANSI codes.

   option accept("s.*") *go(1,20) Save

This is  similar to  the preceding example, but this one presumes
that you  have written a string function named *go that takes two
arguments like  1 and  20 and  returns a string like <esc>[1;20H.
This example  does not  display or  respond to  an automatically-
generated tag,  but just  displays the  word Save at column 20 of
line 1, and responds to any input beginning with the letter s.

   option accept(".*")

Note that  there is  no text in this option statement.  You might
include this  as the last group in your menu.  RAP will then show
an extra  blank line at the end of the menu (that is, a line with
no text).   Since  the pattern  .* means  "zero or  more  of  any
character," this pattern matches anything.  RAP would select this
option group  in response to any input from the user that did not
match one of the earlier options.


_________________________________________________________________

pause                  (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   pause: interval

where interval is a numeric expression

Description

  This statement  stops the  program for  the specified interval,
between 1 and 60 seconds.  If the argument is absent or less than
one, the  interval used  will be  one second.  If the argument is
more than 60, the interval will be 60 seconds.

Example

   pause 5    stops for five seconds


_________________________________________________________________

poke                   (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   poke: address, value

where address and value are both numeric expressions

Description

  This statement  stores a value at a memory location.  Its first
argument is a number representing the absolute address of a byte;
the second  is a  value between  0 and  255 to  be stored  there.
Since you  generally have  no way  of knowing what is stored at a
given address  or what  effect changing it will have, use of poke
is technical,  risky, and  very rarely  needed.  But there it is.
Let the user beware.

Example

   poke 1047,64

This changes  the byte  at address 1047 (decimal) to the value 64
(decimal).   Even when you do know what effect it will have (this
one turns  on the  shift lock), such code tends to be nonportable
and hard to maintain.


_________________________________________________________________

proc
_________________________________________________________________

Syntax

   proc: proc-name ( var { , var } )    
   proc: proc-name  var { , var }  
   proc: proc-name

where each  var is  a variable  name (string  or numeric) with no
subscript

Description

  This statement  marks  the  beginning  of  a  procedure.    Its
arguments  are  the  procedure  name  and  an  optional  list  of
parameters.   The parameter  list (in parentheses) is a series of
variable names separated by commas.

  Parameter passing  is by value.  On entry to the procedure, the
parameters are  declared as  local  variables  and  are  assigned
values corresponding to the values of the corresponding arguments
provided by  the caller.  On return from the procedure, these and
any other local variables are deleted, and nothing happens to the
calling arguments.

Examples

   proc get_file_info

This introduces  a procedure  named get_file_info  which takes no
arguments.

   proc display_help($topic)

This introduces  a procedure named display_help which expects one
argument, a  string expression which will be evaluated and stored
in the parameter string variable $topic.


_________________________________________________________________

r (and ;)
_________________________________________________________________

Syntax

   r: comment-text     
   ; comment-text

where comment-text  is  an  unquoted  string,  not  ending  in  a
continuation mark  (plus sign).    In  the  semicolon  form,  the
semicolon must occur either at the beginning of the line or after
a blank or tab.

Description

  A remark  is a  form of  comment.  It is ignored by the loader.
RAP also supports same-line comments:  anything following a space
and a semicolon up to the end of the line is a comment.

Examples

   r: bib.rap Bibliography program - 5/88 - version 1.3

This entire line is ignored when the program is loaded.

   #length = 66  ; standard paper length is 66 lines

The white  space, semicolon,  and everything  after it is ignored
when  the  program  is  loaded.    The  statement  is  loaded  as
#length = 66.

   t:No comment here; this is all an ordinary t statement.

Here the  semicolon is  not preceded  by white space, so RAP does
not treat  it as  the start  of a  comment.   There is no comment
here; this is all an ordinary t statement.


_________________________________________________________________

read
_________________________________________________________________

Syntax

   read: descriptor, str-var

where descriptor  is a numeric expression and str-var is a string
variable

Description

  This statement reads a line from a file, and stores it (without
the newline)  in a  string variable.   The  first argument is the
descriptor number  of the  file; the  second is  the name  of the
string variable.   If  the string that is read contains any $, #,
\, or  * characters,  RAP "escapes"  them by  prefixing them with
backslashes.

  If the line to be read from a file exceeds 255 characters, read
will  get  255  characters  and  leave  the  file's  read-pointer
pointing to  just after  the last  character read.  The next read
operation will start reading at that point.  Likewise, if a *seek
operation puts the read-pointer in the middle of a line, the next
read will start at that point.

  If the  read-pointer is  at the  end of  the file (that is, the
last line  in the  file has  already been  read), each subsequent
read places  the words  End of file. in  the string variable.  If
DOS reports  an error  in reading  the file,  read puts the words
File read error. in the variable.

Examples

   read #datafile,$phrase

This statement  reads one  line from  the  file  whose  RAP  file
descriptor number  is stored  in #datafile,  escapes any reserved
characters it  contains as described above, and stores the string
in the variable $phrase.


_________________________________________________________________

repeat
_________________________________________________________________

Syntax

   repeat:
   repeat if: condition     
   repeat levels  
   repeat levels if: condition

where levels is a number and condition is a numeric expression

Description

  This statement  is used  to branch back to the top of a loop or
menu construct.   It  may include  a number  showing which of the
enclosing nested  menus or  loops to branch to the top of, and it
may have a conditional clause controlling its execution.

Examples

   repeat

This causes  an unconditional  branch to the top of the innermost
surrounding loop or menu.

   repeat 2

This causes  a branch  to  the  top  of  the  second-to-innermost
surrounding loop or menu.

   repeat if #n >= 10

This evaluates  the numeric  expression  shown;  if  it  is  true
(nonzero), this  causes a  branch to  the top  of  the  innermost
surrounding loop or menu.

   repeat 3 if #done

This evaluates  the numeric  expression  shown;  if  it  is  true
(nonzero), RAP  branches  to  the  top  of  the  third  innermost
surrounding loop or menu.


_________________________________________________________________

return
_________________________________________________________________

Syntax

   return: num-expr    in a numeric function 
   return: str-expr    in a string function  
   return:             in a procedure

Description

  The return  statement exits  from a  subprogram,  back  to  the
calling subprogram.   Returning  from the  main  procedure  of  a
program puts RAP in the immediate mode.

  A procedure  may have  any number of return statements, or none
at all.   Since  a procedure  may not  return a  value, a  return
statement in a procedure may not have an argument.

  A function  must have  at least  one return  statement, and may
have more.   The  value to be returned appears as the argument to
the return  statement.   In a  numeric function,  this must  be a
numeric expression.   In  a string  function, it must be a string
expression; that  is, a  string variable, a string function, or a
quoted string.

Examples

   return

In a  procedure, this  causes a return to the calling subprogram.
This is  the only  valid form  of  the  return  statement  for  a
procedure.   In a  function, this  statement would  be  erroneous
because no value is being returned.

   return 7

In a numeric function, this returns the value 7 to be used in the
calling subprogram.   In  a string  function or  procedure,  this
statement is erroneous.

   return "green"

In a string function, this returns the string green to be used in
the calling  subprogram.   In a  numeric function or a procedure,
this is an erroneous statement.

   return 5+2

In a  numeric function,  the numeric  expression is evaluated and
the resulting 7 is returned.

   return "*chr(27)[#line;#col\H"

In a  string function,  the string  expression shown is evaluated
and the  resulting string  is returned.  Note that the evaluation
process in  this example  involves calling  a numeric function as
well as  substituting two  variables.    This  statement  is  the
complete body  of the  *go function  referred to  in  the  option
description earlier in this section.

Note the use of the backslash to separate the H from the variable
name #col.   It  will be  removed in  final evaluation  when this
string is  displayed to  the screen, so that what is written will
be something  like <esc>[12,60H.    If  the  backslash  had  been
omitted, RAP  would have  looked for  a variable named #colh, and
would not have produced the desired results.


_________________________________________________________________

rewind
_________________________________________________________________

Syntax

   rewind: descriptor

where descriptor is a numeric expression

Description

  This statement  moves the  pointer for an open file back to the
beginning of  the file.   Its  argument is the descriptor of that
file, as assigned by *open.

Example

   rewind #glossfile

This resets  the pointer  for #glossfile  to the beginning of the
file.


_________________________________________________________________

run
_________________________________________________________________

Syntax

   run:
   run: filename

where filename is an unquoted string

Description

  The run command has two forms.  With a filename, it reads a RAP
program from  the specified  file into  memory and  executes  it.
Without a  filename, it  executes a program that has already been
loaded.

  To execute  a program,  this command  clears any user variables
from memory,  then calls  the init__ procedure if any exists (see
section 12.11)  and then  the main  procedure if any exists.  You
can run  the main  procedure without first clearing the variables
by saying call main.

  Run myfile is  equivalent to  load myfile followed by run.  The
latter combination  of commands  could not  be used in a program,
since once  the load  was completed the original program would be
gone (including  the run  command), and  the interpreter would be
back in immediate mode.

  Run with  a filename  tries the name first in its original form
and then  with .RAP  appended.   (SmallRAP also tries .RPS before
trying .RAP;  LargeRAP tries  .RPL and  .RAP). If  neither can be
found, each  directory in  the $path is searched in the same way.
If the  file is  not found anywhere, run prompts for a valid file
name.

Examples

   run

This just executes the current program.

   run myfile

This loads MYFILE, MYFILE.RPS, MYFILE.RPL, or MYFILE.RAP from the
current directory  or some  directory in the $path list, and runs
it.

   run .\\myfile.rap

This loads MYFILE.RAP from the current directory and runs it.

   run \\it\\itmain

This loads ITMAIN, ITMAIN.RPS, ITMAIN.RPL, or ITMAIN.RAP from the
\\IT directory, and runs it.

   run it\\itmain

This loads ITMAIN, ITMAIN.RPS, ITMAIN.RPL, or ITMAIN.RAP from the
IT subdirectory in the current directory, and runs it.


_________________________________________________________________

seek
_________________________________________________________________

Syntax

   seek: descriptor , offset  
   seek: descriptor , offset , bytes    
   seek: descriptor , offset , relbytes

where descriptor and offset are numeric expressions

Description

  This statement  moves the  read-pointer for a data file to just
before a  specified line  or byte in the file.  Its arguments are
the file  descriptor (assigned by *open) and the desired location
in the  file.   The location is a numeric expression. An optional
third argument may be the keyword bytes or relbytes.  Bytes makes
the seek measure its distances in characters instead of lines.  A
negative argument  in bytes  mode locates the pointer relative to
the end  of the  file.   The relbytes  keyword causes  a relative
seek, measured  in bytes,  up or  down from the current position.
If bytes or relbytes is not specified, the location is assumed to
be in terms of lines from the beginning of the file.

Examples

  The first  several examples  assume that  #myfile is  open  for
reading (as by open chumash.txt,#myfile).

   seek #myfile,4

This positions  the read  pointer for #myfile to be ready to read
the fourth line.

   seek #myfile,1400,bytes

This positions the pointer to read at the 1400th byte (character)
of the  file.   The next  read statement will get everything from
the 1400th byte through the end of the line on which that byte is
found.[1]

   seek #myfile,-60,bytes

This positions  the pointer  at the 60th byte from the end of the
file.

   seek #myfile,-10,relbytes

This moves the pointer backwards ten characters

   seek #myfile,#help_location[#topic],bytes

This evaluates the numeric expression, in this case a subscripted
numeric variable, and does a seek to the corresponding byte.  The
array #help_location  might contain  an  index  pointing  to  the
starting points of each help-topic in a text file.


_________________________________________________________________

string function, str function
_________________________________________________________________

Syntax

   string function: function-name ( var { , var } )    
   string function: function-name  var { , var }  
   string function: function-name

where each  var is  a variable  name (string  or numeric) with no
subscript.  The keyword string can be abbreviated to str.

Description

  This statement  marks the beginning of a string function, which
is a  subprogram that  returns a  string.   The arguments to this
statement are  the function name (beginning with an asterisk) and
an optional list of parameters.

  Parameter passing  is by  value.  On entry to the function, the
parameters are  declared as  local  variables  and  are  assigned
values corresponding to the values of the corresponding arguments
provided by  the caller.   On return from the function, these and
any other local variables are deleted, and nothing happens to the
calling arguments.

Examples

   string function *go(#line,#col)

This statement  introduces a  string function  named  *go,  which
expects two  arguments, both  numeric expressions.  The values of
the two arguments will be stored in the parameter variables #line
and #col.

   string function *get_input_file_name

This introduces a string function which expects no arguments.

   str function *get_input_file_name()

This does  the same.  Parentheses are not required when there are
no arguments,  but they  are allowed.   The string keyword may be
abbreviated.


_________________________________________________________________

t, th, ts, tsh
_________________________________________________________________

Syntax

   t: text    
   th: text   
   ts: text   
   tsh: text

where text is an unquoted string

Description

  The type  commands cause their arguments to be displayed on the
screen.   Plain t  normally adds a newline (return and line feed)
after the  line displayed.   Th, type and hang, leaves the cursor
at the  end of  the line.   If  the string to be displayed by a t
command ends  with a  single backslash,  the newline is not added
after the line.  The result is like a th.

  When a  full page  of material  has been  sent  to  the  screen
without any  user input,  output from the t command stops and the
message, "Press  ENTER  to  continue,"  appears.    The  built-in
variable #paged  can be  used to  control this feature:  if it is
assigned a  value of  zero, automatic  pausing is  disabled.  Its
default value  is one.   The  th command  is not  subject to this
full-page checking.

  The ts  form is  similar  to  t,  but  does  not  evaluate  its
argument.  It is (very slightly) faster than t, and is equivalent
if you  are displaying  plain text  with no  embedded  variables,
function calls,  or  backslashes.    Similarly,  tsh  is  a  non-
evaluating and slightly faster version of th.

Examples

   t:Hello, world

This evaluates  and displays  the text,  "hello, world,"  on  the
screen, and advances the cursor to the next line.

   t:*proper_greeting($location), $username.

This evaluates  the string  expression shown,  which in this case
involves a  function call  and  a  variable  substitution.    The
resulting string  is displayed,  with  a  newline  advancing  the
cursor to the next line.

   th:What is your name?

This evaluates  and displays  the string  expression  shown,  and
displays it  on the  screen.  This statement leaves the cursor on
the same  line as  the typed material, immediately following that
material.

   t:What is your name?\

This does  the same.   The single backslash at the end turns this
into a th statement.

   t:A variable named \$color.

The displayed  text for  this is, "A variable named $color."  The
backslash before  the $  prevents RAP from replacing the variable
name $color  with its  value, and  is then  removed in  the final
evaluation pass.

   t:A single backslash \\ like so.

The displayed  text for  this is, "A single backslash \ like so."
The double  backslash is  reduced to  a single  backslash in  the
final evaluation pass.

   t:The gloss marker is \\$gl_marker.

Assuming that  $gl_marker has the value gloss, the displayed text
for this  is The gloss marker is \gloss.   The  double  backslash
does not  prevent evaluation  of the  variable name,  but  it  is
reduced to a single backslash on the final evaluation pass.

   ts:Hello, world!

This displays  (without evaluating)  the text hello, world on the
screen, and advances the cursor to the next line.


_________________________________________________________________

then
_________________________________________________________________

Syntax

   then:

Description

  This statement  appears just  after the  if statement  in an if
construct.  Its only purpose is cosmetic; it may be omitted.

Example

    if  (#n mod 2) == 1
    then                  ; Here it is, doing nothing
       t:#n is odd
    else
       t:#n is even
    end if


_________________________________________________________________

.undefine, .undef      (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   .undefine constant-name  
   .undef constant-name

Description

  This directive removes a definition of a constant name that was
originally given by .define.  Subsequent appearances of that name
will then  be left  as they  are, rather  than being  replaced by
their value.  The two forms are equivalent.

Example

   .undefine .TRUE

This removes the definition of .TRUE.


_________________________________________________________________

until
_________________________________________________________________

Syntax

   until: condition    

where condition is a numeric expression.

Description

  This is  an alternative  to the  end loop statement.   An until
statement is  treated just  like an exit if statement followed by
end loop.

Example

    loop
       ca 1,70
       th:*time
    until *keypress       ; When the condition is true
                          ; the loop terminates

This program  displays and  updates the  time in  the upper right
corner of the screen until the user presses any key.


_________________________________________________________________

vnew                   (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   vnew: var { , var } 
   vnew: $    
   vnew: #    
   vnew:

where each var is a variable name

Description

  This command  allows the  user to  selectively delete variables
from the  symbol table  where they  are  stored.    Its  optional
argument can  be a list of variable names, a pound sign (#), or a
dollar sign.   When  a list is provided, each name on the list is
deleted from  the table.   Using a pound sign deletes all numeric
variables; a  dollar sign  deletes all string variables.  When no
argument is  used, all  entries are  deleted.   This  command  is
seldom used in any form.

Examples

   vnew             This deletes all variables.

   vnew #           This deletes all numeric variables.

   vnew $           This deletes all string variables.

   vnew $color      This deletes the $color variable.

   vnew #a,#b,$x    This deletes the three variables shown.


_________________________________________________________________

vsave, vrestore        (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   vsave: filename     
   vrestore: filename

where filename is an unquoted string

Description

  These commands  save the  current set  of global variables to a
file and  read such  a set  from a file.  Their arguments specify
the filename to be used.

  The variable  table is  not cleared before a vrestore.  You can
clear it,  if you  wish, by  using a  vnew before  the  vrestore.
Otherwise, the old table entries will be supplemented by the ones
read from  the file, and will only be replaced where the a global
variable has the same name as a variable in the file.

  The combination  of vsave,  run, and  vrestore  can  allow  one
program to  pass a  set of  variables and their values to another
program.   A simpler  way to  pass a small amount of data is with
the $cmdline  variable; for  larger amounts  of data  you can use
explicit writes to a file in one program and reads from that file
in the next.

  Vsave and  vrestore are  not supported  by SmallRAP.   Even  in
normal RAP and LargeRAP their use is not encouraged.

Examples

   vsave tempfile.vsv

This statement saves all the global variables to the TEMPFILE.VSV
file.

   vrestore tempfile.vsv

This restores them from that file.


_________________________________________________________________

write, wr
_________________________________________________________________

Syntax

   write: descriptor , text 
   wr: descriptor , text

where descriptor  is a numeric expression and text is an unquoted
string

Description

  This statement  writes text  to a  file.  Its arguments are the
file descriptor as assigned by *open, and the text to be written.
Normally, this command places a newline at the end of the text it
writes. The  newline can  be suppressed by ending the text with a
single  backslash.     The   two   forms   write   and   wr   are
interchangeable.

Examples

   write #out,Now is the time for all good men to etc.

This writes the text shown to the file whose descriptor is stored
in #out.

   wr #outfile,$marker $value

This evaluates  the text  shown and  writes it  to the file whose
descriptor is stored in #outfile.


_________________________________________________________________

xcall
_________________________________________________________________

Syntax

   xcall: program-name  [ argument-string ]

where program-name and argument-string are both unquoted strings.
The program-name  begins with  the first nonblank character after
the  xcall  keyword,  and  ends  with  the  first  blank  or  tab
following.

Description

  This statement  lets you call an external non-RAP program, with
arguments if  wanted.   The argument to xcall is the program name
with any  command-line arguments.    When  the  external  program
finishes, control  returns to  the RAP  program.  This command is
related to xchain, described below.

  Since xcall  and xchain  do not  use COMMAND.COM,  they do  not
require that  it be  present on the disk and they use less memory
to run.   Both  xcall and  xchain support path lists based on the
RAP $path  variable, and  both try  appending .COM or .EXE to the
program name if needed.

  Neither xcall  nor  xchain  supports  I/O  redirection  (as  in
sort <oldfile >newfile); you can use xs if you want this feature.
Likewise, neither  xcall nor  xchain can run batch programs; they
only run .COM and .EXE programs.  To run .BAT files from RAP, use
the xs command.

  If xcall  is unable  to call the program, the built-in variable
#result is  set to  -1.   If the  program called returns an error
code, #result is set to the value returned. Otherwise, #result is
set to zero.

Examples

   xcall arca gloss *.gly

This finds  and runs a program named ARCA.COM or ARCA.EXE, giving
it the  argument string gloss *.gly.  When ARCA finishes, control
returns to RAP at the next statement.

   xcall sort $arc_name $filespec

This is  similar, but the argument string is constructed from two
variables.   Everything after  the xcall  keyword  constitutes  a
string expression,  which is  fully evaluated  and then passed to
DOS.

   xcall command

This runs  a copy  of the COMMAND.COM command processor on top of
RAP.   This gives  you a normal DOS prompt, and lets you type DOS
commands interactively  and run  other programs, though with less
memory available because RAP is still loaded.  Typing exit at the
DOS prompt gets you back to the RAP program.


_________________________________________________________________

xchain
_________________________________________________________________

Syntax

   xchain: program-name     
   xchain: program-name  [ arguments ]

where program-name  and arguments are both unquoted strings.  The
program-name begins  with the  first nonblank character after the
xchain keyword, and ends at the first subsequent blank or tab, or
at the end of the line.

Description

  This statement lets you transfer control to an external non-RAP
program, with arguments if wanted.  The argument to xchain is the
program name  with any command-line arguments.  When the external
program finishes,  control does not return to the RAP program (in
contrast to xcall above).

Example

   xchain pacman

This transfers  control to  an external   non-RAP  program called
PACMAN.COM or  PACMAN.EXE,  accessible  via  the  current  $path.
Control does not return to RAP when PACMAN finishes.


_________________________________________________________________

xi
_________________________________________________________________

Syntax

   xi: text

where text is an unquoted string

Description

  Execute-immediate fully evaluates its argument as a string, and
then treats  the result as a RAP command to be executed.  Certain
commands cannot  be executed  on this  basis; these  include  the
statements that  begin and end procedures and functions, declare,
xi, and the statements that form constructs.

Example

   $name=color
   xi:\$$name=blue

The material  after the  colon undergoes  full string  evaluation
yielding $color=blue.   This is then executed as a RAP statement,
and the variable $color is given the string value blue.


_________________________________________________________________

xs
_________________________________________________________________

Syntax

   xs:text

where text is an unquoted string

Description

  The execute-system  command fully  evaluates its  argument as a
string, then  executes it  as a  DOS command  by invoking  a  new
instance of  the command  processor.  If memory permits, this may
call another  RAP program  (by invoking  another copy  of the RAP
interpreter), or  a program  in some  other  language.    The  xs
command requires  that a  copy of  COMMAND.COM be  present on the
boot drive, or accessible via COMSPEC.

Example

   xs copy *.dat $data_directory

The $data_directory  string variable is replaced with its value ,
and the  resulting string is passed to DOS for execution as a DOS
command.     For  instance,   if  $data_directory   were  set  to
\\data\\chumash,   the   command   passed   to   DOS   would   be
copy *.dat \data\chumash.

   xs sort <$file1 >$file2

Assuming that $file1 and $file2 hold the names of two files, this
command invokes  the DOS sort program to sort the contents of the
first, and  store the  results in the second.  Note that this I/O
redirection would not be possible with an xcall command.

____________________

  1 Subject to the 255-character limit.


----------------------------------------------------------------

Chapter 15


BUILT-IN FUNCTION DESCRIPTIONS


  RAP supports  a number  of  built-in  functions,  as  described
below.   The headings  for each  description show  the  arguments
required.   In these  headings, string1  and filename  are string
expressions which  are fully evaluated before use.  Filename is a
file name  (which may include a drive and/or path).  String2 is a
string expression  which is  not evaluated  at  all  before  use.
Num1, startpos, length, and address are numeric expressions.  All
of the  functions involving  filenames use paths in finding those
files.


_________________________________________________________________

*ascii
_________________________________________________________________

Syntax

   *ascii(string1)

Description

  This  function  converts  a  character  to  its  extended-ASCII
numeric equivalent,  returning a  number between  0 and 255.  Its
argument is  a string  expression.   This is fully evaluated; the
function then  returns the  numeric  ASCII  code  for  the  first
character.   If its  argument is the empty string, *ascii returns
0.  Any other characters are ignored.

Example

   #n = *ascii($yourname)

Suppose for  the example  that the  value of $yourname is Zaphod.
This call  evaluates $yourname, examines the first character, and
returns 90  (the ASCII  code for  capital Z).  The variable #n is
set to 90.


_________________________________________________________________

*chr
_________________________________________________________________

Syntax

   *chr(num1)

Description

  This function  converts a  numeric expression between 0 and 255
into its  extended-ASCII character equivalent.  It returns a one-
character string.    An  argument  outside  of  the  0-255  range
produces an error message.

Examples

   t:*chr(7)

This makes  the computer  beep.  In the ASCII code, 7 corresponds
to the "bell" character.

   $gohome=*chr(27)[1;1H

This statement assigns the variable $gohome the value <esc>[1;1H,
where <esc> is the escape character (ASCII 27).  This sequence of
characters sends the cursor home (to the top left) when displayed
on an ANSI or Sharp PC-5000 screen.


_________________________________________________________________

*currdir               (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   *currdir()

Description

  This function  reports the  current directory  (on the  current
drive).   It takes  no argument,  and  returns  a  string.    The
parentheses are  optional.   Backslashes in  the directory string
are escaped.   The  returned string always begins with a (double)
backslash.   If the  current  directory  is  the  root,  *currdir
returns just a double backslash.

Example

   $starting_dir=*currdir()

This determines  the current directory, and stores it in a string
variable named $starting_dir.


_________________________________________________________________

*currdriv              (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   *currdriv()

Description

  This function  reports the  current disk  drive.   It takes  no
argument; the  parentheses are  optional.    It  returns  a  one-
character string, consisting of a single upper-case letter.

Example

   $starting_drive=*currdriv

This determines  the current  drive, and  stores it  in a  string
variable named $starting_drive.


_________________________________________________________________

*date
_________________________________________________________________

Syntax

   *date()

Description

  This function  returns the  current date  as a  string, in  the
format   Thu Nov 20 1986.   It takes no argument; parentheses are
optional.

Example

   write #outfile, Phonology summary - $username - *date

The call  to *date  embedded in  the string  will be  replaced by
today's date before the line is written to the specified file.


_________________________________________________________________

*envir
_________________________________________________________________

Syntax

   *envir(string1)

Description

  This function  returns the  current value  of a DOS environment
variable (that  is, one  set using  the DOS  set  command.    Its
argument is  the name  of the  environment variable; the returned
value is  a string containing its value.  The name is promoted to
upper case before use, for consistency with DOS.  If the variable
is not  defined, an  empty string  is returned.   If  the  string
reported by  DOS contains backslashes, they are escaped (doubled)
when input;  any *,  $, or # character is likewise escaped with a
backslash.

Example

   $comspec=*envir("COMSPEC")

This  example   retrieves  the   current  value  of  the  COMSPEC
environment variable, if any.  It doubles any backslashes in that
string, and  stores it  in the RAP variable named (appropriately)
$comspec.


_________________________________________________________________

*escape_symbols
_________________________________________________________________

Syntax

   *escape_symbols(string2)

Description

  This function  returns a string which is a copy of the argument
with all  special characters  (#, $, \, or *) it contains escaped
by prefixing  them  with  a  backslash.    The  argument  is  not
evaluated at all.

  This function  is very seldom used.  Occasionally it is helpful
during debugging  when you  want to  show exactly  what a  string
contains before evaluation.

Example

   t:Trying pattern *escape_symbols("\\t\\t*")    
   
   if $lineread contains "\\t\\t*" 
      t:Found it!  Right is <$right>.   
   else
      t:Not found.     
   end if

This is  an example  of a t: statement added to aid in debugging.
The example  will display,  "Trying pattern  \\t\\t*,"   and then
proceed with  the string-matching comparison shown.  If the first
line  had   just  said   t:Trying pattern \\t\\t*,   the   double
backslashes would  have been  reduced to single ones during final
evaluation  before   displaying  the   string.     Instead,   the
*escape_symbols function  returned the string \\\\t\\\\t\* (which
we fortunately  never  had  to  see  or  deal  with),  and  final
evaluation in  the t:  reduced it  back to  the form  shown.    A
simpler alternative to the first line would be:

   ts:Trying pattern \\t\\t*

since the ts command does not evaluate its argument at all.


_________________________________________________________________

*existf
_________________________________________________________________

Syntax

   *existf(filename)
   *existf(filename,access)

Description

  *Existf reports  whether a  file exists,  accessible in a given
mode. The access-mode specified may be r, w, or a.[1] If there is
no file  with the specified name accessible in the specified mode
in the  current directory,  each directory  in the  $path list is
searched in  turn.   If a  suitable file  is found anywhere, this
function returns  a nonzero number.  If the file is not found, it
returns zero.   If  the  filename  begins  with  a  backslash  or
contains a colon, the $path list is not searched.

  The  nonzero   number  returned  depends  on  the  access  mode
specified and  the file's accessibility.  When the mode specified
is r,  the value  returned is 4 for a read-only file, and 2 if it
is both  readable and  writable.  When the specified mode is w, a
read-only file  will not  be reported;  the value  returned for a
writable file  is again  2.   In any  case,  failure  to  find  a
suitable file results in a 0 returned value.

Examples

   if *existf("temp1")

This statement marks the beginning of an if construct whose first
sequence will  be executed  only if  file  TEMP1  can  be  found.
(Recall that  the above is equivalent to if *existf("temp1") <> 0
.)

   if *existf("temp2","w")

This time,  the sequence  will be executed only if the file TEMP2
exists and is writable.


_________________________________________________________________

*filesize              (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   *filesize(filename)

Description

  This function  reports the  size of  a file  in bytes.   For an
invalid file,  it returns  -1.   If a  file has  been opened  for
writing, it  must be  closed before  the *filesize  function  can
correctly report the new length.

Example

   if *filesize($oldfile) <= *freesp("B")

This statement  tests whether  the file  whose name  is stored in
$oldfile will  fit in  the free space on the disk in drive B.  If
so, the  first sequence  of the  if construct  it begins  will be
executed.


_________________________________________________________________

*filetime              (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   *filetime(filename)

Description

  This function reports the date and time of last modification of
a   file.       It    returns   a    string   in    the    format
Thu Mar 26 17:10:38 1987 .   If no file exists with the specified
name, the string Invalid file is returned.

Example

   t:The file was last modified *filetime($old_file)

The function  call in this line is replaced with a string showing
the date  and time  of the  file specified.   The  resulting line
might be

    The file was last modified Sat Jan 31 21:03:00 1988


_________________________________________________________________

*fileymdt              (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   *fileymdt(filename)

Description

  This function reports the date and time of a file in a sortable
format.   It returns  a string  in the format 87-03-26 17:10:38 .
If  no   file  exists   with  the   specified  name,  the  string
Invalid file is returned.

Example

   if *fileymdt($text) > *fileymdt($wordlist)

This if  statement compares  the dates  of two files, whose names
are in  the variables  $text and $wordlist.  If the $text file is
newer than  the $wordlist  file,  the  first  clause  of  the  if
construct is executed.


_________________________________________________________________

*final_eval
_________________________________________________________________

Syntax

   *final_eval(string1)

Description

  This seldom-used  function forces  full string  evaluation of a
copy of  its argument.   Full evaluation includes substitution of
values  for   any  variable  names  and  function  calls  (normal
evaluation), then removal of single backslashes and conversion of
double backslashes  to  single  ones  (final  evaluation).    The
resulting string is returned.

Example

   $abc=*final_eval("The value of \$color is $color")

This statement causes the string in quotes to undergo full string
evaluation.  During normal evaluation, the backslash prevents the
first $color  from being  replaced with its value, but the second
$color is  replaced.   During final  evaluation, the backslash is
removed.       The   resulting    value   of   $abc   might   be,
"The value of $color is blue."

Note  however  that  a  subsequent  statement  like  t:$abc  will
display, "The value of blue is blue,"  since the  argument to a t
statement undergoes normal string evaluation.


_________________________________________________________________

*findpath
_________________________________________________________________

Syntax

   *findpath(filename)
   *findpath(filename,mode)

Description

  This function uses the current $path to find a file, then tells
you where it found it.  If it finds the file, it returns the full
pathname  of  the  file  (including  the  drive  letter  and  the
filename).   Backslashes in  that pathname  are doubled.   If the
file is not found, *findpath returns an empty string.

  This function  uses the  $path  list  and  access  mode  (which
defaults to r) in exactly the same way as *existf.

Example

   t:The gloss file used was *findpath($glossfile).

Here, RAP  evaluates $glossfile  to get a file name, and searches
the directories  named in the current path to find it.  If found,
the function call is replaced by the full path name.


_________________________________________________________________

*freesp                (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   *freesp(drive)

Description

  This function  reports free  space on  a drive,  in bytes.  The
argument is a string, whose first character is treated as a drive
designator.  This can either be a letter or a period (meaning the
current drive).   The  rest of the string is ignored.  An invalid
drive produces a -1 return value.

Example

   if *filesize($oldfile) <= *freesp($olddrive)

This statement  tests whether  the file  whose name  is stored in
$oldfile will  fit in  the free  space on  the disk  in the drive
named in  $olddrive.   If  so,  the  first  sequence  of  the  if
construct it begins will be executed.


_________________________________________________________________

*index
_________________________________________________________________

Syntax

   *index(string1,string2)

Description

  This function locates the first occurrence of a given character
in some  string.  The first argument is the string to search; the
first character of the second argument specifies the character to
search for.   The result is a number, showing the position in the
string where  the character  was found.  Both arguments are fully
evaluated prior to use.  If the character is not found, a zero is
returned.

Example

   #n = *index("Mississippi","s")

This sets  #n to 3, since s is the third character in the string.
Only the first occurrence matters.


_________________________________________________________________

*isnumber
_________________________________________________________________

Syntax

   *isnumber(string1)

Description

  This function  reports whether a string is a decimal number.  A
number consists  of an  optional sign  and a  string  of  digits.
There may  be space  before, after,  or between  these two parts.
The number  must be  between -2147483640  and  2147483640.    The
argument to  *isnumber is  a string  expression, which  is  fully
evaluated.   If the resulting string can be parsed as a number by
the above rules, *isnumber returns 1.  Otherwise it returns 0.

Example

   if  not *isnumber($response)

This if  statement checks  to see whether the string in $response
is a number.  If not, the first sequence in the if clause will be
executed.


_________________________________________________________________

*isnumexp              (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   *isnumexp(string1)

Description

  This rarely-used function reports whether a string is a numeric
expression, as  defined in  appendix B.  The argument is a string
expression, which  is fully  evaluated.   If the resulting string
can be  parsed as  a numeric  expression,  *isnumexp  returns  1.
Otherwise it returns 0.

  The *isnumexp  function suppresses  parser  error  messages  in
simple expressions.   Syntax  problems in complex expressions can
produce error messages as well as a zero return value.

Example

    if *isnumexp($response)
       #n = *value($response)
    else
       #n = 0
    end if

This if  construct checks  to see whether the string in $response
is a numeric expression.  If so, its value is computed and stored
in #n.  If not, #n becomes zero.


_________________________________________________________________

*keypress
_________________________________________________________________

Syntax

   *keypress()

Description

  This function  reports whether  there is  anything in the type-
ahead buffer.  It does not disturb the contents of the buffer, or
identify  the  character(s)  therein.    It  takes  no  argument.
*Keypress returns a nonzero number for yes, 0 for no.

Example

    loop
       th:*chr(7)
    until *keypress

This while-loop  makes the computer beep until the user presses a
key.


_________________________________________________________________

*memfree
_________________________________________________________________

Syntax

   *memfree()

Description

  This function reports the amount of memory (in bytes) available
for programs external to RAP.  It takes no argument.

Example

    if *memfree < #needed
       t:Sorry... there's not enough memory to run that
        :program.  It requires #needed bytes, and with RAP
        :loaded you only have *memfree available.
       return
    end if

This sequence  checks the available memory, and notifies the user
if there is less memory than the value noted in #needed.


_________________________________________________________________

*mid
_________________________________________________________________

Syntax

   *mid(string1,startpos,length)

Description

  This function takes a substring.  Its arguments are a string, a
starting position,  and a  length.   It returns  a portion of the
string,  starting  at  the  position  noted  and  of  the  length
specified.   If the  length is  zero or  the starting position is
beyond the  end of  the string, *mid returns an empty string.  If
the length is greater than the number of characters present after
the starting  point, everything  from the  starting point  on  is
taken.

  The *mid  function fully evaluates its argument before counting
the characters,  and escapes  special characters  in the returned
string.

Examples

   if *mid($filepath,2,1) == ":"

This if  statement checks  to see  if the second character of the
string stored  in $filepath is a colon; if so, the first sequence
of the if construct is executed.

   $rest=*mid($filepath,3,999)

This takes  everything from  the third  character to  the end  of
$filepath, and stores it in $rest.


_________________________________________________________________

*open
_________________________________________________________________

Syntax

   *open(filename)
   *open(filename,access)

Description

  This function  opens a file for reading, writing, or appending.
It takes  one or  two arguments.   The  first is  the name of the
file.   The second  argument, if  present, identifies the kind of
access desired.   This  is typically  r, w,  or  a  for  reading,
writing, or  appending.   A complete list of access modes appears
in figure  8.3.   If the  second argument is omitted, read access
only  is   assumed.    Both  arguments  undergo  complete  string
evaluation before they are used.

  This function  returns an  internal file  descriptor (a number)
assigned by  RAP when  the file  is opened.  Any reference to the
file while open will be done by means of that descriptor.

  When opening  a file  in read mode, *open searches for the file
first in  the current  directory.   If it  cannot be found there,
*open looks  in each  directory listed in the $path variable.  If
the file  is not  found in  any directory  on that list, an error
message results.

  When opening  a file  in any other mode, no paths are used.  If
the file  does not  exist in the current directory, it is created
there.

  If the  filename argument  contains a  colon or  begins with  a
backslash, (meaning  that  it  includes  drive  and/or  directory
information), then  no path  searching occurs.   The  argument is
used as provided.

Examples

   #b=*open("myfile","r")

This statement  opens a file named MYFILE for reading, associates
some file  descriptor number  with it,  and stores that number in
the variable  #b.    If  MYFILE  is  not  found  in  the  current
directory, RAP  searches the  current $path  list to look for it.
If the  file is  not found in any directory in the path list, RAP
displays an error message.

   #b=*open("myfile")

This does  exactly  the  same  thing.    If  no  access  type  is
specified, read-access is assumed.

   #phrasefile=*open($textfile,"w")

This opens  the file named in $textfile for writing, and stores a
descriptor for  it in  the variable  #phrasefile.  If the file is
not found  (without searching  a path), a file with the specified
name is  created in  the directory  specified in the argument (or
the current  directory as  a default).  Any prior contents of the
file are replaced.

   #phrasefile=*open("chumash.txt","a")

This statement opens CHUMASH.TXT for appending, and stores a file
descriptor for  it in  #phrasefile.   In append  mode, the  prior
contents of  the file  are not  replaced;  rather,  anything  new
written to  the file  will go  after the end of the old material.
As with  write-access, the  path is not used.  If the file is not
found in  the directory specified in the argument (or the current
directory as a default), it is created there.

   #phrasefile=*open("chumash.txt","x")

This statement  creates a  new  file  named  CHUMASH.TXT  in  the
current directory,  and opens  it for  writing.  Such a file must
not already exist, or an error message will result.


_________________________________________________________________

*peek                  (not supported in SmallRAP)
_________________________________________________________________

Syntax

   *peek(address)

Description

  This rare,  technical, and  seldom useful  function reports the
contents of  a byte in memory referenced by its absolute address.
Its argument is a number.  It returns a number between 0 and 255.

Example

   t:*peek(#loc)

This line reports the byte at absolute address #loc.


_________________________________________________________________

*strlen
_________________________________________________________________

Syntax

   *strlen(string1)

Description

  Reports the  length of  a string.   Its  argument is  a  string
expression.   This is  fully evaluated,  and the  length  of  the
resulting string is reported.  This function returns a number.

Examples

   #length = *strlen($yourname)

This sets #length to the number of characters in $yourname.


_________________________________________________________________

*tell
_________________________________________________________________

Syntax

   *tell(descriptor)

Description

  This function,  a complement  to the seek command,  reports the
position of  a read-pointer (or write-pointer), measured in bytes
from the  beginning  of  the  file.    Its  argument  is  a  file
descriptor number  as assigned by *open.  This function returns a
number.  An invalid descriptor argument gives an error message.

Example

   #position = *tell(#pfilnum)

This determines the position of the read-pointer in the file that
was opened  in some statement like #pfilnum = *open($phrasefile),
and stores this number in #position.


_________________________________________________________________

*time
_________________________________________________________________

Syntax

   *time()

Description

  This function returns the current time as a string, in the form
16:22:30 .  It takes no arguments.  The parentheses are optional.

Example

    loop
       ca 1,70
       th:*time
    until *keypress

This program  displays the  time in the upper right corner of the
screen, updating  it as  quickly as  it can,  until you press any
key.  The last line is equivalent to until *keypress <> 0 .


_________________________________________________________________

*value
_________________________________________________________________

Syntax

   *value(string1)

Description

  This rarely-used  function converts  a string  expression to  a
number.   Its argument  is a  string expression.   This  is fully
evaluated as  a string,  and then  parsed as a numeric expression
(as defined  in appendix  B).   This function  returns a  number.
Parsing errors are reported.

Example

   #n = *value("2 + 2")

This line evaluates the string 2 + 2 as a numeric expression, and
sets #n to the resulting value.


_________________________________________________________________

*volume                (Not supported in SmallRAP)
_________________________________________________________________

Syntax

   *volume(drive)

Description

  This function reports the volume label for the specified drive.
Its argument  is a  string, of  which only the first character is
used.   If that  character is  a period,  the  current  drive  is
assumed.   This function  returns a  string,  with  any  trailing
blanks removed.   For  an invalid  or unlabeled drive, it returns
Bad-drive or No-label.

Example

   $disklabel=*volume($drive) 
   if $disklabel == "No-label"     
     t:The disk in drive $drive is not labelled.  
   else if $disklabel == "Bad-drive"    
     t:Drive $drive is a bad drive.     
   else
     t:The disk in drive $drive is labelled $disklabel.     
   end if

This example  reports what it can find out about the label of the
disk in the specified drive.


____________________

  1 The other access modes of *open may be used, but they all are
treated the same as w.


----------------------------------------------------------------

Chapter 16


ERROR AND WARNING MESSAGES

  
  This chapter  lists the  error messages  that RAP  can produce,
along with some explanation of the circumstances under which they
appear and  some possible  mistakes to  look for in your program.
If you  get a  whole collection of error messages when you try to
run a  program, concentrate  on the  first few in the collection.
They are  more likely  to be  meaningful than the later ones; the
original problem  may confuse  RAP into  wrong diagnosis of later
errors.

  Also bear  in mind that the point where RAP discovers a problem
is not necessarily the point where your mistake is.  For example,
if you  leave out an if statement at point A in your program, but
still include  the end if at point B thirty lines later, RAP will
not know  there is  a problem until it reaches point B.  Up until
the unmatched  end if, the  program is  syntactically correct and
RAP has no reason to think anything is wrong.

  Even when  RAP reaches the unmatched end if, there is no way to
know (1)  whether the problem is a missing if or an extra end if,
or (2)  in the case of a missing if, where you intended it to be.
The best  RAP can  do is  to report an "unexpected end if" at the
line where  it was  encountered, and  suggest a "possible missing
if" as the cause.  This is just what RAP does.

  Sometimes the  best way  to isolate  an error  is to  cut  your
program into  smaller pieces  (cut so  that each piece is a valid
program, even  if it  doesn't do a complete useful task), and see
which pieces still give problems.

  One error  condition that  is hard  to track  down because  its
symptoms are  so variable  is the  unintended continuation.   RAP
treats any line that ends in a plus sign (+) as a continued line,
and appends  the following  line to  it.   If the  first line  is
something like a t or xs statement, the ill-effects won't be seen
there until run time.  If the second line is something like an if
statement, its  effective removal will cause trouble at load time
when an  else or  else if  for that statment is encountered.  The
source of  the trouble  won't be  obvious, since  you'll still be
able to see the second statement there in your program file.  The
real problem,  the "+" that triggers the continuation, is easy to
overlook. 


_________________________________________________________________
A number was expected... please try again.
A number less than 2147483640 was expected...
 please try again.
_________________________________________________________________

  RAP wants  to input  a number  (because of an a or ah statement
with a  numeric variable  as its  argument).    Either  of  these
messages means  that RAP  can't recognize  what you've typed as a
number.   Remember that  RAP only deals in whole numbers, between
-2147483640 and 2147483640, with no decimal point.


_________________________________________________________________
Arg (argnum) doesn't match parameter
_________________________________________________________________

  Some parameter  in a  procedure  or  function  statement  is  a
numeric variable  name, but  the corresponding  argument  in  the
calling statement  is not a numeric expression.  This message can
also result  if one  of the  entries in the parameter list in the
procedure or function statement is not a variable name.

  In calling  a procedure  or function,  RAP assigns the value of
the first  argument  to  the  first  parameter  variable  in  the
procedure or function statement, the second to the second, and so
on.  If the parameter in the procedure or function statement is a
numeric variable,  the  corresponding  argument  in  the  calling
statement must be a numeric expression.


_________________________________________________________________
Bad *chr arg (number)
_________________________________________________________________

  The *chr  function converts  a number  to its  (extended) ASCII
character equivalent.   Since  the extended  ASCII  set  is  only
defined from  0 to  255, the  argument to  *chr must be a numeric
expression whose  value is  between 0  and 255.   Otherwise  this
message results.


_________________________________________________________________
Bad constant name:  <input line>
_________________________________________________________________

  In a  .define or  .undefine statement, what follows the .define
or .undef  keyword must  be the  name of  a constant.   This must
begin with  a period  followed by  a letter  (followed by  up  to
nineteen additional letters, numbers, or underscores).  Otherwise
this message results.


_________________________________________________________________
Bad file specified
_________________________________________________________________

  This message  means that  RAP requested  a file  operation from
DOS, and  DOS reported  that the  operation failed  because of  a
problem in  the specification  of the  file.  Check the file name
(add a  t statement  to display  it), and  check the file on your
disk.  It might also be worthwhile to check your $path, PATH, and
COMSPEC settings.


_________________________________________________________________
Bad numeric expr in assignment
_________________________________________________________________

  In an  assignment statement  where the  variable being  given a
value is  a numeric  one, the  material on  the right side of the
equals (or  other assignment  operator) must  be a  valid numeric
expression.   If not,  this message results.  Usually there is an
additional message describing what is wrong with the expression.


_________________________________________________________________
Bad or missing argument in <built-in function name>
_________________________________________________________________

  The built-in  functions each  have specific  requirements about
the kinds  of arguments they take; these are described in chapter
15.   This message  means that  there were  too few  or too  many
arguments in  the calling statement, or that some argument was of
the wrong type.


_________________________________________________________________
Bad or missing argument in assignment
_________________________________________________________________

  The first  thing in an assignment statement must be the name of
a variable.   This  message means that the statement seemed to be
an assignment  statement, but  then didn't  start with a variable
name.   Check for  inadvertent use  of the  c or cs keyword, or a
colon that doesn't belong at the beginning of the line.


_________________________________________________________________
Bad or missing argument in declare
_________________________________________________________________

  The argument  in a  declare  statement  must  be  one  or  more
variable names  separated by  commas.    Otherwise  this  message
results.   Things to  look for  are an  extra  or  missing  comma
between names,  a comma  before the  first name or after the last
one, or a badly-formed variable name.


_________________________________________________________________
Bad or missing argument in exit/repeat if
_________________________________________________________________

  In an  exit if or repeat if statement, what follows the if must
be a  numeric expression  to be  evaluated as a test.  If this is
missing or  badly formed, or if something extra is present before
it, this  message results.   For a badly formed expression, there
is usually another error message identifying the problem.


_________________________________________________________________
Bad or missing argument in file operation (descriptor)
_________________________________________________________________

  A number  of file operations (close, read, rewind, seek, *tell,
and write)  expect as  their first  argument a numeric expression
representing the  file descriptor  that was assigned by the *open
function when  opening this file.  This message means either that
the numeric  expression was  missing or badly formed, or that its
value was not the number of a currently open file.


_________________________________________________________________
Bad or missing argument in if/elseif
_________________________________________________________________

  In an if or else if statement, what follows the command keyword
must be a numeric expression to be evaluated.  If this is missing
or badly  formed or  something extra  is present  before it, this
message results.  For a badly formed expression, there is usually
another error message identifying the problem.


_________________________________________________________________
Bad or missing argument in loop <numexp> times
_________________________________________________________________

  The loop  statement has three basic forms:  loop, loop for, and
loop n  times (where  n is  any valid  numeric expression).    If
anything other  than the  word for  follows the  word  loop,  RAP
assumes you  intend the  third form.  It checks that the material
after loop  consists of  a valid  numeric expression and the word
times.  This message means that the check failed.

  If you  did intend  a statement of the loop n times form, check
that the  numeric expression  is  good  and  the  word  times  is
present.   If you  didn't intend  loop n times, you have probably
included something extra after the loop keyword.


_________________________________________________________________
Bad or missing argument in loop for
_________________________________________________________________

  The loop for statement has two forms: loop for #n = a to b, and
loop for #n = a to b step c.   In either  case,  #n  may  be  any
numeric variable,  and a, b, and c are numeric expressions.  This
error message  means that  something was  wrong with  either  the
numeric variable,  one  of  the  three  terms,  or  the  keywords
separating them.  Check for missing or extraneous material.


_________________________________________________________________
Bad or missing argument in *open
_________________________________________________________________

  The first argument to the *open function is a string containing
a filename.   This message means either that no filename argument
was provided, or that one was provided which was not a string.


_________________________________________________________________
Bad or missing argument in *open (bad mode)
_________________________________________________________________

  The optional  second argument  to *open  is a string specifying
the access mode in which the file is to be opened.  Its value may
be r,  w, or  a, x, r+, w+, a+, or x+.  This message means that a
mode argument was provided which was not one of these.


_________________________________________________________________
Bad or missing argument in option accept
_________________________________________________________________

  In an  option statement  in a menu, the accept keyword lets you
specify the responses that will be accepted for this option.  The
accept keyword  should be  followed by a left parenthesis, then a
list of  response  patterns  (string  expressions)  separated  by
commas,  then   a  right  parenthesis.    Recall  that  a  string
expression may be a string variable name, a string function name,
or a  quoted string.   This  message means  that something is not
right.


_________________________________________________________________
Bad or missing argument in option if
_________________________________________________________________

  In an if or else if statement, what follows the command keyword
must be a numeric expression to be evaluated.  If this expression
is missing  or badly  formed, or  if something  extra is  present
before it,  this message results.  For a badly formed expression,
there is usually another error message identifying the problem.


_________________________________________________________________
Bad or missing argument in parentheses
_________________________________________________________________

  RAP is  attempting to parse a numeric expression, and has found
something illegal within parentheses.


_________________________________________________________________
Bad or missing argument in poke
_________________________________________________________________

  The (not-recommended)  poke command expects two arguments, both
numeric expressions,  separated by  a comma.   This message means
that it found something different.


_________________________________________________________________
Bad or missing argument in proc/function call
_________________________________________________________________

  The arguments  in a  procedure or function call must be numeric
expressions or  string expressions,  separated by  commas.   This
message means  that something  was encountered that was neither a
numeric expression  nor a  string one.    Recall  that  a  string
expression may be a string variable name, a string function call,
or a quoted string.  Check all your arguments, and check also for
missing or extra commas.


_________________________________________________________________
Bad or missing argument in read (string var)
_________________________________________________________________

  The second  argument in  a read  statement is a string variable
indicating where  the value  read is  to be  stored. This message
means that  RAP found  no  second  argument,  or  that  it  found
something there which was not a string variable name.


_________________________________________________________________
Bad or missing argument in seek
_________________________________________________________________

  The seek  command takes  as its  arguments a numeric expression
(usually just  a numeric  variable) identifying the number of the
file  where   the  seek   is  to   occur,  a  numeric  expression
representing the distance to seek, and an optional third argument
that is either the word bytes or relbytes.  The arguments must be
separated by  commas.   This message means that the statement did
not follow these rules.


_________________________________________________________________
Bad or missing argument in *tell
_________________________________________________________________

  The *tell  function must  have exactly one argument, which must
be a numeric expression (and is usually a numeric variable).  Its
value is  the descriptor  of  the  file  for  which  the  pointer
position is wanted.  Anything different gives this message.


_________________________________________________________________
Bad or missing argument in vrestore or vsave
_________________________________________________________________

  No filename was provided in a vsave or vrestore command.


_________________________________________________________________
Bad or missing argument in xcall/xchain (file not found)
_________________________________________________________________

  This message  can mean  one of  two things:  either no filename
was provided  in an  xcall or  xchain statement, or the file that
was named  in that  statement could  not be  found on  the  disk.
Check that:   (1) the name that you're providing really is right,
(2) it's  an executable  .EXE or  .COM file (you need xs to run a
.BAT batch file), (3) the file really is on the disk, and (4) the
directory it's  in is  either the  current directory or is on the
$path list.


_________________________________________________________________
Bad or missing name in proc/function statement
_________________________________________________________________

  In  a   procedure  or  function  statement,  the  name  of  the
subprogram must  follow the  procedure or function keyword.  This
message means  that RAP did not find it there.  This could be due
to a  missing name,  a  badly  formed  one,  or  something  extra
inserted before the name.


_________________________________________________________________
Bad or missing simple factor
_________________________________________________________________

  RAP was  parsing a numeric expression, and was at a point where
it required  either a  number,  a  numeric  variable,  a  numeric
function call,  or a  parenthesized numeric expression (or any of
these preceded  by a +, , or not operator).  It found none of the
above.   Check for extra or missing arithmetic operators, missing
pound signs  on numeric  variables, missing asterisks on function
calls,  mismatched   parentheses,  and  so  on.    If  a  numeric
expression is too complicated to check easily, you might split it
up and do the calculation in several statements.


_________________________________________________________________
Bad pattern
_________________________________________________________________

  There's something  wrong with the pattern in a pattern matching
operation using  has or  contains, or in an option accept clause.
Some things  that the match facility will balk at include ^*, $*,
**, and extremely long patterns.


_________________________________________________________________
Bad string comparison
_________________________________________________________________

  RAP was  parsing a  numeric expression, and in the process came
across something that looked like a string comparison.  RAP found
the first  string expression  (quoted string, string variable, or
string function  call) and  the  comparison  operator,  but  what
followed  the   comparison  operator   was  not   another  string
expression.   One possible  cause for  this error is the use of a
string function  where you intended to use a numeric function, or
vice-versa.  Other possible causes include extra or missing items
on the line.


_________________________________________________________________
Bad subscript
_________________________________________________________________

  A subscript,  if used,  must come  immediately after a variable
name.     It  consists  of  a  left  square  bracket,  a  numeric
expression, and a right square bracket.  If what follows the left
square bracket is not a valid numeric expression, or if its value
is not  between 0  and 999,  or if  there is  not a  right square
bracket following it, this message results.

  If you want a left square bracket as part of the text following
a variable  name in  a string,  and you  don't intend  it as  the
beginning marker  of a  subscript, you  can separate  the bracket
from the name by putting a single backslash between them.


_________________________________________________________________
Division, rem, or mod by 0
_________________________________________________________________

  RAP attempted  to evaluate  a numeric  expression  involving  a
division by  zero, or  a rem  or mod  operation with  zero as the
second operand.   One  mistake that  can lead to this error is to
divide by  a variable  which you  have declared but never given a
value.


_________________________________________________________________
DOS error <DOSerrnum>
_________________________________________________________________

  RAP attempted  to do  some operation  that required  the use of
DOS, and  DOS reported  an error.   For  many  such  errors,  RAP
recognizes the  error code returned by DOS, and interprets it for
you, as  for example,  "insufficient memory"  or "invalid  seek."
This message  is used  for the  less-common DOS  error codes  not
known to RAP.


_________________________________________________________________
Expanded string too long... truncated.
_________________________________________________________________

  This message  means that  a string  evaluation  step  tried  to
produce a string that was longer than 255 characters, the maximum
length allowed.  The string produced was cut off at 255.


_________________________________________________________________
Extra text in line
_________________________________________________________________

  This message  can appear in many different contexts; in general
it means  that there  is something  more on  the line (other than
valid comments)  after the allowed arguments.  One possible cause
is badly  formed comments;  remember that same-line comments must
begin with a semicolon after one or more tabs or spaces.  Another
possible cause  is a  line like if #n = 4, which incorrectly uses
the single-equals assignment operator where what was intended was
the double-equals equality comparison operator of if #n == 4. RAP
correctly sees  the first  part, if #n, as a valid statement, and
wonders what the part beginning with the single = is there for.


_________________________________________________________________
File is read-only
_________________________________________________________________

  You attempted to modify a file that is marked (by DOS) as read-
only.   Specify a  different file, or use the DOS copy command to
make a  writable copy  of the  file you're  interested in (with a
different name), or alter the file attributes to allow writing.


_________________________________________________________________
File not found
_________________________________________________________________

  RAP could  not find  the file  you  referred  to.    Check  the
spelling of  the filename  and extensions, and make sure that the
file is  in the current directory or in one of the subdirectories
named in the current $path.


_________________________________________________________________
INCLUDEs nested too deeply
_________________________________________________________________

  Your main  program may  include another  file by  means of  the
.include keyword,  and that file may include another, for a total
of three  levels.   If you  try to  .include down  to four levels
deep,  this  message  results.    Reorganizing  your  program  is
probably in order; it shouldn't be necessary to go that deep.


_________________________________________________________________
Insufficient memory for xcall/xchain
_________________________________________________________________

  RAP tried  to do  an xcall  or xchain, but there was not enough
memory to  hold RAP  and the other program at the same time.  Due
to bugs  in the  C compiler  we use, xchain in version 1.0 of RAP
just does  an xcall  and a  bye, so  it still  has to have enough
memory present  for both  RAP and the program you're chaining to.
See the "Out of memory..." message description for suggestions on
conservation.


_________________________________________________________________
Insufficient memory for DOS command
_________________________________________________________________

  RAP tried  to do  some DOS  command such  as required  for dir,
edit, list,  or xs,  and there  was not  enough memory to do that
function with RAP loaded too.  See the "Out of memory..." message
description for suggestions on conservation.


_________________________________________________________________
Invalid command
_________________________________________________________________

  This usually  means that  the immediate  command you have typed
doesn't begin  with any  keyword that RAP can recognize, nor does
it begin  with a  variable name  or a known procedure name.  This
could indicate  a misspelled  command  keyword,  a  badly  formed
variable or  procedure name,  a misspelled  procedure name,  or a
reference to  a procedure  that you inadvertently left out of the
program.  This message may also mean that you have used a command
in immediate mode which may not be used there.


_________________________________________________________________
Invalid exit/repeat
_________________________________________________________________

  This message may mean that an exit or repeat statement was used
outside of  any loop  or menu,  or it  may mean that an exit n or
repeat n statement  was used  where the  number n  was  negative,
zero, or greater than the number of enclosing loops and/or menus.


_________________________________________________________________
Invalid seek
_________________________________________________________________

  This message  means  that  something  was  wrong  with  a  seek
attempt.   The most  likely problem  is an offset which would put
the file pointer before the beginning of the file.


_________________________________________________________________
Invalid xi
_________________________________________________________________

  The xi  statement evaluates  its argument  as a  RAP  statement
(including a command keyword), and executes it.  Certain commands
are not  allowed as the command keyword in that argument, notably
xi itself.


_________________________________________________________________
Missing '(' in paramlist.
_________________________________________________________________

  A procedure  or function statement may end with the name of the
procedure/function, or  it may have a list of parameter variables
after the  name.   Such a  list is contained in parentheses, with
commas between  the variable  names.   This  message  means  that
something was  found after  the procedure/function  name that was
not a  left parenthesis.   Either  there's something  missing  or
something extra.


_________________________________________________________________
Missing ')' in paramlist
_________________________________________________________________

  If a  procedure or  function statement  does  have  a  list  of
parameter variables, that list must end with a right parenthesis.
This message means that something was found after a variable name
that was  neither a  comma (indicating  that another  name should
follow) nor a right parenthesis (indicating the end of the list).
Check for something missing or something extra.


_________________________________________________________________
Missing <item> in vrestore file
_________________________________________________________________

  The vrestore  command is reading from a file and is not finding
what should  be there.   If  the file  being read is one that RAP
wrote with  a vsave  command, then  this is  a RAP internal error
that we'd like to hear about.  If it is one that you have edited,
you're on  unsupported ground.   Make  sure you match the current
format of  vsave files, and good luck.  We don't encourage use of
vsave and vrestore, much less the hacking thereof.


_________________________________________________________________
Missing = in assignment
Missing = or assignment operator
_________________________________________________________________

  RAP  encountered  something  that  looked  like  an  assignment
statement but  had no  equals sign (or other assignment operator)
after the variable name.  RAP will recognize as an assignment any
statement that  (1) begins  with a variable name, (2) begins with
the keyword  c, or  (3) begins  with a  colon where  the previous
statement was  an assignment.  If you did intend the statement to
be an  assignment, the  problem could be a missing equals sign, a
badly formed  variable name,  or some extra garbage between them.
If an  assignment statement  was not what you intended, then make
sure that none of the three conditions listed is true.


_________________________________________________________________
Missing close quote
_________________________________________________________________

  RAP is  in the midst of some circumstance that expects a quoted
string.   The opening  quotes were  there, but no closing quotes.
This  could   be  a  symptom  of  a  too-long  string.    Another
possibility happens  if the  string ends  with a backslash before
the closing  quotes.   This will  cause the  closing quotes to be
taken as part of the string, instead of as an ending mark, and no
ending mark  will be  found.   Doubling the  backslash may be the
answer in this case.


_________________________________________________________________
Name too long: <name>
_________________________________________________________________

  The name  of the  indicated variable,  constant,  function,  or
procedure is  too long.   A  name can consist of a special symbol
(#,*,$, or  .) followed by a letter and up to nineteen additional
letters, digits,  and underscores.   Anything  longer produces an
error message.   If in some line of a program you have a variable
name  followed  by  a  series  of  other  letters,  numbers,  and
underscores, RAP will assume that the whole thing constitutes one
long variable  name which may violate the above limit.  You might
in this  case separate  the  variable  name  from  the  following
context by means of a backslash.


_________________________________________________________________
No main procedure
_________________________________________________________________

  If  your   program  is  entirely  composed  of  procedures  and
functions with  no loose  code,  one  of  the  procedures  (which
presumably calls  the others)  must be  named main  to serve as a
starting point.   This  message means  that no  main procedure is
present, so RAP does not know where to start.


_________________________________________________________________
Not enough args in proc/function call
_________________________________________________________________

  In a  call to  a procedure or function, the number of arguments
in the  calling statement  must match the number of parameters in
the procedure  or function  statement.   This message  says  they
don't match.


_________________________________________________________________
Number too big:  limit is 2147483640
_________________________________________________________________

  Numbers in  RAP can  be between -2147483640 and 2147483640.  If
you try to assign a numeric value that is out of this range, this
message results.   (Surely  two billion  of anything  has  to  be
enough.)


_________________________________________________________________
Out of memory in <some obscure description>
_________________________________________________________________

  There is  not enough  memory to  run the  current RAP  program.
Various forms  of this  message can  come up  during  loading  or
during execution.   Memory  is used  for storing the RAP program,
any variables  that it  uses, and internal stacks and tables used
by the interpreter in keeping track of what it's doing.

  If you're  running out  of memory  due  to  a  very  large  RAP
program, you  might consider  breaking it  into smaller pieces or
using LargeRAP.   If your program doesn't look like it should use
that much  memory, one thing to check for is excessive recursion.
That's where  a function  or procedure  calls itself,  which then
calls itself, and so on to many levels.  RAP has to keep track of
a lot  of information  for each  level, so that if there are many
levels RAP may run out of memory trying to store it all.

  Other ways  to deal  with out-of-memory  errors are to decrease
the size  of any  RAM disks  or other  resident programs  you are
using, or to use SmallRAP.


_________________________________________________________________
Possible missing <command>
_________________________________________________________________

  This message  appears together with an "unexpected <something>"
message.   It is  an educated guess, usually telling you what was
expected instead  of the  <something>.   Take it  as a suggestion
rather than  an authoritative diagnosis.  Sometimes this provides
a good  hint about what might be wrong earlier in your program to
give RAP different expectations.


_________________________________________________________________
Prefixed string too long... truncated.
_________________________________________________________________

  This is a rare message.  At loading time, it means that a call,
a loop while, or an until statement was too long.  RAP statements
can normally  be up  to 255  characters  long,  but  these  three
statements have  some material  added at  the  beginning  by  the
loader, so  their limits  are slightly less.  They can all handle
at least 240 characters.

  At run  time, this  message can  appear if  the text  on a menu
option is too long, and RAP cannot prepend the letter tag for the
option.


_________________________________________________________________
Proc/function name too long: <name>
_________________________________________________________________

  The name  of the  indicated procedure  or function is too long.
See  section   12.2,  and  the  "name  too  long"  error  message
explanation.


_________________________________________________________________
Program file <filename> not found
_________________________________________________________________

  A RAP  program file mentioned in a load, run, or .include could
not be  found.   Check that  the file is on the disk, the name is
correct in  the program,  and the  $path (or  DOS PATH) lists the
desired directory if the file is not in the current directory.


_________________________________________________________________
Quoted string too long
_________________________________________________________________

  This message  means that some string in quotes is more than 255
characters long.  Since the statement the string appears in can't
be over  255 characters  long, this  message should  never occur.
Send us a postcard if it does.


_________________________________________________________________
RAP internal error - <some obscure text or number>
_________________________________________________________________

  This means  that RAP  has detected  something that  it's  doing
wrong ...  whatever's happening  may not be your fault.  Messages
like this  shouldn't appear  no matter  what  you  do  with  your
program;[1] if they do they reflect bugs in RAP that we would like
to know  about and  fix.   If you can write down the message, and
send us  a disk  with a  copy of the program that produced such a
message and instructions on how to get it to that point again (if
it seems  to be repeatable), we will be most grateful.  Send your
report to the address on the back of the title page.


_________________________________________________________________
Redefined name <constant-name> (ignored)
_________________________________________________________________

  This message  means that the loader found more than one .define
statement defining  the same  constant  name.    Only  the  first
definition is  used; the second one is ignored, which is probably
bad news.


_________________________________________________________________
Sorry... there's no help info on this question.
_________________________________________________________________

  If a  menu does  not include  a help-group, typing "help" gives
you this message.  It means what it says.


_________________________________________________________________
String too long - truncated <string>
_________________________________________________________________

  If expanding  variable names  and function  calls in  a  string
forces it  to exceed  255 characters  in length, everything after
the 255th  character is  discarded and  this warning appears.  If
you weren't  expecting a  long string, add a t or ts statement to
see what  it contains.   Sometimes  a string variable or function
that contains itself embedded within itself can get out of hand.


_________________________________________________________________
Too many args in proc/function call
_________________________________________________________________

  In a  call to  a procedure or function, the number of arguments
in the  calling statement  must match the number of parameters in
the procedure  or function  statement.   This message  says  they
don't match.


_________________________________________________________________
Too many user files are open
_________________________________________________________________

  RAP only  allows a  limited number of files to be open at once:
four in  SmallRAP, eight  in RAP  and LargeRAP.   You may need to
close some files to open others.


_________________________________________________________________
Unable to do DOS command - command.com might not be on boot disk
_________________________________________________________________

  RAP failed at some DOS command, such as required for dir, edit,
list, and  xs, and  the cause  was probably not a lack of memory.
This is a general-purpose message, but the most frequent cause is
the one  mentioned in the message.  Make sure that COMMAND.COM is
accessible on  some drive and that the DOS COMSPEC variable tells
exactly where to find it.

  If finding  COMMAND.COM isn't  the problem,  make sure that the
syntax of your dir argument, edit or list filename, or xs command
is right.  Use a t statement to find out what is in the argument,
filename, or  command, then  exit to  DOS and see what happens if
you try to ask DOS to do what RAP couldn't get it to do.


_________________________________________________________________
Unable to open file (<filename>)
_________________________________________________________________

  RAP tried  to open  the specified  file but  was unable.   This
could be  because the  name  is  badly  formed,  or  because  you
attempted to  open a  read-only file for writing or a nonexistent
file for  reading, or because you are trying to create a new file
on a  completely full  disk, or  because you  have reached  DOS's
limit on the number of open files.  DOS's limit is different from
RAP's, and  is set  by the  FILES= statement  in a DOS CONFIG.SYS
file.  See your DOS manual for more on this topic.


_________________________________________________________________
Unable to read file
_________________________________________________________________

  This message  appears when  an error  occurs  while  reading  a
program file.   You may want to look through the file with a text
editor, to  run the  DOS chkdsk  command on that disk, or to copy
the file to another disk.


_________________________________________________________________
Unable to run with the errors described
_________________________________________________________________

  This message  means that  errors occurred during loading of the
program, with  the result  that RAP is unable to run the program.
The errors  should have  been reported  as they  were encountered
during loading.  Edit the program file to fix them and try again.


_________________________________________________________________
Undefined variable (<varname>)
_________________________________________________________________

  You have  apparently used  a  numeric  variable  without  first
assigning it  a value.   Recheck the logic in your program.  Also
check for  misspelled variable names or use of the wrong variable
name.


_________________________________________________________________
Unexpected <command-name>
_________________________________________________________________

  This is a general-purpose message that typically means that the
statement encountered was not legal at that point in the program.
An end if where there is no if statement would be a good example,
or an  end function statement  at the  end  of  a  procedure,  or
attempting to  begin a  procedure or  function before  ending its
predecessor.

  Often this message is the result of a missing statement earlier
in the  program, or  an extra  statement  inadvertantly  left  in
somewhere along the line.

  RAP will  usually accompany  this message with a hint about the
kind of  statement it  might have  considered more appropriate at
that point.   If the current statement looks appropriate where it
is, the  "possible missing  ..." message may help you identify an
earlier  point   in  your  program  where  some  error  gave  RAP
unreasonable expectations.

  Check  that   your  constructs   are  all  properly  formed  in
accordance with  the examples  (and the  syntax  descriptions  in
appendix B).  When all else fails, simplify.


_________________________________________________________________
Unexpected argument
_________________________________________________________________

  Certain commands take no arguments.  These include ce, cl, cls,
debug, endfunction,  endif, endloop,  endproc, and  then.    This
message means  that something  appeared on  the line after one of
these keywords, where nothing belongs.


_________________________________________________________________
Unexpected string found
Unexpected string or bad string comparison
_________________________________________________________________

  This message,  in either  form, identifies a syntax error in an
expression.   RAP was parsing a numeric expression, looking for a
factor, and  came across  a string  expression (either  a  quoted
string, a  string function,  or a  string variable).   So  far so
good: in  the context  of a  factor, a string is allowed if it is
the first  term in  a string comparison.  This message means that
what follows the string is not a comparison operator, so we don't
have a  string comparison.  RAP doesn't know what to make of what
it does have, but it knows that it's not legal RAP code.

  Either the  string expression doesn't belong where it is, or it
does belong  and a  comparison operator is missing.  One possible
cause of  this message  is  a  string  function  used  where  you
intended a numeric one.


_________________________________________________________________
Unknown command
_________________________________________________________________

  On loading  a program, RAP has found a line that does not begin
with a valid command keyword, a variable name (in an assignment),
a procedure name (in a call), or a colon (with a valid repeatable
command on  the  previous  line).    Those  are  the  only  legal
possibilities.  Check the spelling, if you have a command keyword
on the  line.  If it's an assignment, make sure you have the # or
$ on  the beginning  of the  variable name.   If it's a procedure
call, make  sure that  the procedure you're calling is present in
your program and that the name is spelled consistently.


_________________________________________________________________
Unknown proc/function name <name>
_________________________________________________________________

  In a call statement, this message means that RAP could not find
the procedure  requested.  This is usually due to spelling errors
or to omission of include-files.

  Where a  function call  is  embedded  in  an  expression,  this
message means  that RAP  could not  find that function.  The same
two main  causes apply.  A third possibility is that something in
the string  looks like  a function call when it isn't.  Watch out
for asterisks  followed by  letters; if necessary you can prevent
RAP from  treating something  as a  function call by preceding or
following the asterisk with a single backslash.


_________________________________________________________________
Unreachable statement(s) found after proc/function end
Unreachable statement(s)
_________________________________________________________________

  This message  (in either  form)  means  that  in  loading  your
program RAP  found one  or more  statements after  the end  of  a
procedure or function that were not contained in any procedure or
function.   This could  be between procedures/functions, or after
the last  one.   Loose code is allowed only before the very first
procedure or  function.   If you  use include-files,  check to be
sure that  their contents  may properly go in the place where the
.include statement is.


_________________________________________________________________
Unsuccessful xcall/xchain
_________________________________________________________________

  This message  means that  an xcall  or xchain  attempt  failed,
apparently for  some reason other than lack of memory.  Make sure
that  the   evaluated  argument  to  the  xcall  or  xchain  does
constitute a  valid request  to run  an executable (.EXE or .COM)
program.   You can't xcall or xchain to .RAP files, or .BAT ones,
or even .BAS programs.

  Use a  t statement to find out exactly what is in the argument,
then exit  to DOS  and see  what happens if you try to ask DOS to
run the program.

____________________

  1 Unless you use poke.


----------------------------------------------------------------


APPENDIXES


      A. Summary of commands, functions, and variables

      B. Formal syntax definition

      C. ANSI screen-control codes

      D. Input codes for special keys

      E. Differences between RAP models

                

                

A. Summary of commands, functions, and variables

                                   
                               Commands

Items marked with a plus sign (+) are not supported in SmallRAP.

   a                 input from the keyboard to a variable
+  ah                like a, but leave cursor at end
   as                input a single character from the keyboard
   bye               exit from RAP environment
   c                 assign a value to numeric or string variable
   ca                move cursor to a specified line and column
   call              call a procedure
+  ce                clear from cursor to end of screen
   cl                clear from cursor to end of line
   close             close a file
   cls               clear entire screen
   cs                faster form of c, but without evaluation
+  debug             examine internal code and tables
   declare           declare local variables
+  dir               list a directory on the screen
+  edit              edit a file and reload the program
   else              default alternative clause for if construct
   else if           alternative clause for if construct
   end function      marks end of a numeric or string function
   end if            end of if construct
   end loop          end of loop construct... branch back to top
   end menu          end of menu construct
   end proc          end of procedure... implies return
   exit              unconditional branch out of loop or menu
   exit if           conditional branch out of loop or menu
   foot              display text at bottom of screen and wait
   help              start of help group in menu construct
   if                conditional clause of if construct
   killf             delete a file
+  list              list main program file to screen or printer
   load              read in a program, but do not run it
   loop              start of loop construct
   menu              start of menu construct
   num function      abbreviation for numeric function
   numeric function  marks beginning of numeric function
   option            start of option group in menu construct
+  pause             delay for 1-60 seconds
+  poke              place a value in memory
   proc              marks beginning of procedure
   r                 marks remark (comment)
   read              read a line from a file to a string variable
   repeat            branch to top of loop or menu construct
   return            exit from subprogram, return to caller
   rewind            point file pointer to top of file
   run               run the program, or load and run a new one
   seek              move read/write pointer to place in a file
   str function      abbreviation for string function
   string function   marks beginning of string function
   t                 type (display) line to screen
   th                type line to screen, leave cursor at end
   then              follows if statement (not required)
   ts                faster form of t, but without evaluation
   tsh               faster form of th, but without evaluation
   until             end of loop construct with test
+  vnew              delete variables from symbol table
+  vrestore          read variables from file to symbol table
+  vsave             write variables from symbol table to file
   wr                abbreviation for write
   write             write a line to a file
   xcall             call an external program from within RAP
   xchain            chain to an external program
   xi                execute a string as a RAP statement
   xs                execute a string as a DOS command


                        Built-in functions

Items marked with a plus sign (+) are not supported in SmallRAP.

   *ascii(string1)          converts char to ASCII number
   *chr(num1)               converts number to ASCII char
+  *currdir()               reports the current directory
+  *currdriv()              reports the current disk drive
   *date()                  reports the current date
   *envir(string1)          gets value of DOS environment variable
   *escape_symbols(string2) escapes #, *, $, and \ in string
   *existf(file1,access)    does file1 exist?  is it accessible?
+  *filesize(file1)         file size in bytes
+  *filetime(file1)         time and date of a file
+  *fileymdt(file1)         sortable-form file time and date
   *final_eval(string1)     text evaluation of string
   *findpath(file1,access)  reports where a file is found
+  *freesp(drive)           free space on drive, bytes
   *index(string1,string2)  locate character in string1
   *isnumber(string1)       is string1 a number?
+  *isnumexp(string1)       is string1 a numeric expression?
   *keypress()              anything in the typeahead buffer?
   *memfree()               reports available memory
   *mid(string1,start,len)  takes a substring
   *open(file1,access)      opens a file
+  *peek(address)           examines a byte of memory
   *strlen(string1)         length of a string
   *tell(descriptor)        position within file
   *time()                  reports the current time
   *value(string1)          evaluate string as numeric expr
+  *volume(drive)           volume label on a disk drive


                        Built-in variables

Items marked with a plus sign (+) are not supported in SmallRAP.

   $blank            a single space
   #case             significance of case in character comparison
   $cmdline          holds user's command-line arguments
   $left             left-context of successful contains match
   $match            material matched in a successful contains
   $newline          a newline character (line feed)
   #paged            controls automatic pausing on full screen
   $path             directory path list used in accessing files
   $prompt           displayed by a or ah when asking for input
   #result           outcome of an xcall or xs command
   $right            right-context of successful contains match
   $screentype       Sharp LCD, IBM, or ANSI
+  #sstep            controls single-step tracing in /trace mode
                        (in LargeRAP only)
   $tag              response tag of most recent menu option
   $version          the version of RAP that is running


                         Loader commands

Items marked with a plus sign (+) are not supported in SmallRAP.

+  .define           define a symbolic constant name
   .include          insert another file into the input stream
+  .undef            abbreviation for .undefine
+  .undefine         remove a symbolic name definition

   .pragma           reserved for future use
   .ifdef            reserved for future use
   .else             reserved for future use
   .endif            reserved for future use



B. Formal syntax definition

[not included here, see printed book]



C. ANSI screen-control codes

                                
                       Display attributes

    Code          Effect
    <esc>[0m      normal text
    <esc>[1m      high-intensity
    <esc>[4m      underlined (MDA display only)
    <esc>[5m      blinking
    <esc>[7m      reverse video
    <esc>[8m      concealed text
                  color display only:
    <esc>[3xm        set foreground color:
    <esc>[4xm        set background color. x can be:
    
                       0 - black  4 - blue
                       1 - red    5 - magenta
                       2 - green  6 - cyan
                       3 - yellow 7 - white


                                
                         Cursor control

    Code          Effect
    <esc>[r;cH    move cursor to row r col c
                     (r and c are both numbers)
    <esc>[rA      move cursor up r rows
    <esc>[rB      move cursor down r rows
    <esc>[cC      move cursor right c columns
    <esc>[cD      move cursor left c columns
    <esc>[?7l     turn off line wrap
    <esc>[?7h     turn on line wrap
    <esc>[2J      clear screen and home cursor
    <esc>[K       clear to end of line
    <esc>[6n      report cursor position,
                     in form  <esc>[row,colR
    <esc>[s       save the cursor position
    <esc>[u       return cursor to saved position



             Video modes (IBM and compatibles only)

    Code          Effect -- selected mode
    <esc>[=0h     B&W 40x25 text
    <esc>[=1h     color 40x25 text
    <esc>[=2h     B&W 80x25 text
    <esc>[=3h     color 80x25 text
    <esc>[=4h     color 320x200 graphics
    <esc>[=5h     B&W 320x200 graphics
    <esc>[=6h     B&W 640x200 graphics
    <esc>[=8h     EGA 132x25 text (EGA only)
    <esc>[=9h     EGA 132x28 text (EGA only)
    <esc>[=10h    EGA 132x44 text (EGA only)



D. Input codes for special keys

  When a  special key  is pressed,  the first  character of input
received is  the null  character, so  that as  returns  an  empty
string the  first time  it is called.  This chart shows the ASCII
code corresponding to the second character of input.

                                
                          Function keys

                 normal   with    with    with
            key   code   shift  control   alt

             F1    59      84      94     104
             F2    60      85      95     105
             F3    61      86      96     106
             F4    62      87      97     107
             F5    63      88      98     108
             F6    64      89      99     109
             F7    65      90     100     110
             F8    66      91     101     111
             F9    67      92     102     112
            F10    68      93     103     113

                                
                           Cursor keys

                      normal       with
                  key  code      control

                PrtSc              114
                 Home   71         119
             up-arrow   72          --
                 PgUp   73         132
               gray -   74          --
           left-arrow   75         115
          right-arrow   77         116
               gray +   78          --
                  End   79         117
           down-arrow   80          --
                 PgDn   81         118
             shft-tab   15



                         Other Alt keys
                                
     Alt-1 120   Alt-Q 16   Alt-A 30   Alt-Z 44
     Alt-2 121   Alt-W 17   Alt-S 31   Alt-X 45
     Alt-3 122   Alt-E 18   Alt-D 32   Alt-C 46
     Alt-4 123   Alt-R 19   Alt-F 33   Alt-V 47
     Alt-5 124   Alt-T 20   Alt-G 34   Alt-B 48
     Alt-6 125   Alt-Y 21   Alt-H 35   Alt-N 49
     Alt-7 126   Alt-U 22   Alt-J 36   Alt-M 50
     Alt-8 127   Alt-I 23   Alt-K 37
     Alt-9 128   Alt-O 24   Alt-L 38
     Alt-0 129   Alt-P 25
Alt-hyphen 130
     Alt-= 131



E. Differences between RAP models

                             SmallRAP

1. SmallRAP  only uses the memory it needs, leaving the rest free
for xs and xcall applications.

2.  SmallRAP  does  not  support  these  commands  and  features:
ah, ce,  debug, dir,  edit, list,  pause, poke,  vnew,  vrestore,
vsave,  .define,   .undefine,  *currdir,   *currdriv,  *filesize,
*filetime, *fileymdt, *freesp, *isnumexp, *peek, and *volume.

3. The only screens supported in SmallRAP are ANSI and Sharp LCD.
IBM's and clones need ANSI.SYS installed to use screen functions.

4. SmallRAP  does not  check for  some less-common program errors
that normal RAP detects.

5. SmallRAP  has a  fixed stack  size, and  may not handle deeply
nested subprogram calls as well as normal RAP.

6. SmallRAP  is slightly slower than normal RAP.  SMALLRAP.EXE is
optimized more for size than speed.

                                
                            LargeRAP

1. LargeRAP  lets programs  and data  occupy  more  than  64K  of
memory.   This is  its reason for being:  to allow very large RAP
programs.

2. LargeRAP  needs and  uses more  space to  store programs  than
normal or  SmallRAP.   Since LargeRAP  only uses  the  memory  it
needs, this  may still  turn  out  to  be  less  than  the  fixed
allocation of  normal RAP.  For large programs, LargeRAP will use
more memory than normal RAP.

3. LargeRAP  is slower  than normal  or SmallRAP, because it must
use long pointers to access a program/data space which can exceed
64K.  Typical performance is probably about 20% slower, depending
on program size and other considerations.

4. LargeRAP  has a  fixed (though  large) stack size, and may not
handle deeply nested subprogram calls as well as normal RAP.

5. LargeRAP  includes a  /trace feature for debugging programs.
This is described in section 10.3 .

