Program runat;
{ Reads a list of (e.g.,) file names from StdIn, and creates a temporary     }
{ batch file which will execute the command specified on run@'s command line }
{ for each of the file names in the list, then destroy itself.               }
{ Usage:  run@ < listfile "foo ^ bar" [options]                              }
{ For a detailed explanation, call without arguments or see proc usage below.}
{                                                                            }
{ Free Software by TapirSoft Gisbert W.Selke, Aug 1991                       }
{$A+,B-,D+,E+,F-,I-,L+,N-,O-,R-,S-,V- }
{$M 16384,0,16384 }

  Uses Dos;

  Const progname  = 'Run@';
        version   = '1.0';
        copyright = 'Free Software by TapirSoft Gisbert W.Selke, Aug 1991';

        defaultbatch  = 'RUN@@.BAT';
        defaultmarker = '^';
        Tab           = #9;

  Var   batchname, fname, cmdproc, cmd, outcmd : string;
        batchfile : text;
        sr : SearchRec;
        i : byte;
        marker : char;
        zkeep, zmanual, zquiet : boolean;

  Procedure abort(msg : string; ierr : byte);
  { show error message and die                                               }
  Begin                                                              { abort }
    If msg <> '' Then writeln(progname,': ',msg);
    Halt(ierr);
  End;                                                               { abort }

  Procedure usage;
  { show usage hints and die                                                 }
  Begin                                                              { usage }
    writeln('Reads a list of (e.g.,) file names from StdIn (one per line),');
    writeln('writes a batch file (default name RUN@@.BAT) which will execute');
    writeln('the command specified on ',progname,'''s command line once for');
    writeln('each file.');
    writeln('By default, the batch file is automatically executed.');
    writeln;
    writeln('Usage:  run@ < filelist "foo ^ bar" [options]');
    writeln('where - "foo" is a valid DOS command or executable;');
    writeln('      - each occurrence of ^ is replaced by the file names ',
            'in turn;');
    writeln('      - options are: /k : keep batch file, don''t destroy it;');
    writeln('                     /m : request manual execution of batch',
            'file,');
    writeln('                          don''t run it automatically;');
    writeln('                     /q : quiet mode, don''t echo commands;');
    writeln('                     /s<char>: use different substitution ',
            'marker,');
    writeln('                          e.g., /s# (no spaces!);');
    writeln('                     /f<name>: specify different name for batch');
    writeln('                          file, e.g., /fDUMMY (no spaces!);');
    writeln('      - quotes may be single or double; no internal quotes of');
    writeln('        the same kind allowed.');
    writeln('Use manual execution if the command called installs a TSR part,');
    writeln('e.g., DOS PRINT, or modifies the environment.');
    abort('',1);
  End;                                                               { usage }

  Procedure init;
  { read command line etc                                                    }

    Var cmdline : string;
        cmdptr : ^string;
        i : byte;
        quote : char;
        zswitch, zquoted, zmarker, zbatchname : boolean;

  Begin                                                               { init }
    batchname  := '';
    marker     := defaultmarker;
    zkeep      := False;
    zmanual    := False;
    zquiet     := False;
    cmdptr     := Ptr(PrefixSeg,$80);
    cmdline    := cmdptr^;
    cmd        := '';
    zquoted    := False;
    zswitch    := False;
    zmarker    := False;
    zbatchname := False;
    For i := 1 To Length(cmdline) Do
    Begin
      If zquoted Then
      Begin
        If cmdline[i] = quote Then zquoted := False
                              Else cmd := cmd + cmdline[i];
      End
      Else
      Begin
        If (cmdline[i] = '''') Or (cmdline[i] = '"') Then
        Begin
          zquoted := True;
          quote := cmdline[i];
        End
        Else
        Begin
          If zswitch Then
          Begin
            Case UpCase(cmdline[i]) Of
              'M' : zmanual := True;
              'K' : zkeep   := True;
              'Q' : zquiet  := True;
              'S' : zmarker := True;
              'F' : Begin
                      zbatchname := True;
                      batchname:= '';
                    End;
              Else usage;
            End;
            zswitch := False;
          End
          Else
          Begin
            If zbatchname Then
            Begin
              If (cmdline[i] = ' ') Or (cmdline[i] = Tab) Then
                                                       zbatchname := false
                           Else batchname := batchname + UpCase(cmdline[i]);
            End
            Else
            Begin
              If zmarker Then
              Begin
                If Not ((cmdline[i] = ' ') Or (cmdline[i] = Tab)) Then
                                                      marker := cmdline[i];
                zmarker := False;
              End
              Else
              Begin
                If Not (cmdline[i] In [' ',Tab,'/','-']) Then usage;
                zswitch := (cmdline[i] = '/') Or (cmdline[i] = '-');
              End;
            End;
          End;
        End;
      End;
    End;
    If cmd = '' Then usage;
    If batchname = '' Then batchname := defaultbatch;
    If Pos('.',batchname) = 0 Then batchname := batchname + '.BAT';
    If Pos(marker,cmd) = 0 Then
                       writeln('Warning: no substitution marker found');
    cmdproc := GetEnv('COMSPEC');
    If cmdproc = '' Then cmdproc := 'COMMAND.COM';
  End;                                                                { init }

Begin                                                                 { main }
  writeln(progname,' ',version,' -- ',copyright);
  init;
  If (batchname = defaultbatch) And Not (zkeep Or zmanual) Then
  Begin
    outcmd := '';
    i := 0;
    FindFirst(outcmd+batchname,AnyFile,sr);
    While (DosError = 0) And (i < 255) Do
    Begin
      Str(i,outcmd);
      FindFirst(outcmd+batchname,AnyFile,sr);
      Inc(i);
    End;
    batchname := outcmd + batchname;
  End;
  Assign(batchfile,batchname);
  Rewrite(batchfile);
  If IOResult <> 0 Then abort('Cannot open '+batchname+' for output',3);
  If zquiet Then
  Begin
    If Swap(DosVersion) >= $0320 Then writeln(batchfile,'@Echo Off')
                                 Else writeln(batchfile,'Echo Off');
    If IOResult <> 0 Then abort('Error reading input',2);
  End;
  Assign(input,'');
  Reset(input);
  While Not EoF Do
  Begin
    readln(fname);
    If IOResult <> 0 Then abort('Error reading input',2);
    outcmd := '';
    For i := 1 To Length(cmd) Do
    Begin
      If cmd[i] = marker Then outcmd := outcmd + fname
                         Else outcmd := outcmd + cmd[i];
    End;
    writeln(batchfile,outcmd);
    If IOResult <> 0 Then abort('Error writing '+batchname,4);
  End;
  If Not zkeep Then write(batchfile,'Del ',batchname); { no CR/LF! }
  Flush(batchfile);
  Close(batchfile);
  If IOResult <> 0 Then abort('Error writing '+batchname,4);
  If zmanual Then writeln('Run commands now by executing      ',batchname)
  Else
  Begin
    SwapVectors;
    Exec(cmdproc,'/C ' + batchname);
    SwapVectors;
  End;
End.
