/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                     BinkleyTerm .FLO file Processor                      */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

#define rb_plus "r+b"

extern int WaZOO_callback (char *);

#define NUM_FLAGS 4

/*--------------------------------------------------------------------------*/
/* do_FLOfile (send files listed in .FLO files)                             */
/*   returns TRUE (1) for good xfer, FALSE (0) for bad                      */
/*--------------------------------------------------------------------------*/

int 
do_FLOfile (char *ext_flags, int (*callback) (char *))
{
	FILE *fp;
	char fname[80];
	char s[80];
	char *sptr;
	char *HoldName;
	int c;
	int i, j;
	struct stat buf;

	long current, last_start;

	HoldName = HoldAreaNameMunge (&called_addr);

	/*--------------------------------------------------------------------*/
	/* Send files listed in ?LO files (attached files)                    */
	/*--------------------------------------------------------------------*/

	for (c = 0; c < (int) strlen (ext_flags); c++)
	{
#ifndef JACK_DECKER
		if (caller && (ext_flags[c] == 'H'))
			continue;
#endif

		(void) sprintf (fname, "%s%s.%cLO",
			HoldName, Hex_Addr_Str (&called_addr), ext_flags[c]);

		if (!stat (fname, &buf))
		{
			if ((fp = share_fopen (fname, rb_plus, DENY_NONE)) == NULL)
			{
				(void) got_error (MSG_TXT (M_OPEN_MSG), fname);
				continue;
			}

			current = 0L;
			while (!feof (fp))
			{
				s[0] = 0;
				last_start = current;
				(void) fgets (s, 79, fp);

				sptr = s;

				for (i = 0; sptr[i]; i++)
					if (sptr[i] <= ' ')
						sptr[i] = 0;

				current = ftell (fp);

				if (sptr[0] == TRUNC_AFTER)
				{
					sptr++;
					i = TRUNC_AFTER;
				}
				else if (sptr[0] == SHOW_DELETE_AFTER)
				{
					sptr++;
					i = SHOW_DELETE_AFTER;
				}
				else
					i = NOTHING_AFTER;

				if ((!sptr[0]) || (sptr[0] == ';'))
				{
					continue;
				}

				if (sptr[0] != '~')
				{
					if (stat (sptr, &buf))	/* file exist? */
					{
						(void) got_error (MSG_TXT (M_FIND_MSG), sptr);
						continue;
					}
					else if (!buf.st_size)
					{
						continue;	/* 0 length? */
					}

					j = (*callback) (sptr);
					if (!j)
					{
						(void) fclose (fp);
						net_problems = 1;
						return FALSE;
					}

					/*--------------------------------------------*/
					/* File was sent.  Flag file name             */
					/*--------------------------------------------*/

					(void) fseek (fp, last_start, SEEK_SET);
					(void) putc ('~', fp);	/* flag it */
					(void) fflush (fp);
					rewind (fp);/* clear any eof flags */
					(void) fseek (fp, current, SEEK_SET);

					if (j == SPEC_COND)	/* if "Funny" success,   */
						continue;			/* don't delete/truncate */

					if (i == TRUNC_AFTER)
					{
						CLEAR_IOERR ();
						i = open (sptr, O_CREAT | O_TRUNC | O_BINARY | O_WRONLY, S_IREAD | S_IWRITE);
						status_line (MSG_TXT (M_TRUNC_MSG), sptr);
						(void) close (i);
					}
					else if (i == SHOW_DELETE_AFTER)
					{
						CLEAR_IOERR ();
						(void) unlink (sptr);
						status_line (MSG_TXT (M_UNLINKING_MSG), sptr);
					}
					else if (i == DELETE_AFTER)
					{
						CLEAR_IOERR ();
						(void) unlink (sptr);
					}
				}
			}					/* while */

			(void) fclose (fp);
			(void) unlink (fname);
		}						/* !stat */
	}							/* for */

	return TRUE;
}
