{$debug-}
{$line-}

{$include: 'types.int'}
{$include: 'globals.int'}
{$include: 'ident.int'}
{$include: 'load.int'}
{$include: 'utils.int'}
{$include: 'xmodem.int'}
{$include: 'script5.int'}
{$include: 'database.int'}
{$include: 'dlxutil.int'}
{$include: 'dlxinit.int'}

program DLX (input, output);

{DLX Bulletin Board System V7.0

 FREEWARE NOTICE

 DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
 Anyone who wishes to may run the program, copy it, or modify it for
 any purpose, including commercial gain.}

USES types,globals,ident,load,utils,xmodem,script5,database,dlxutil,dlxinit;

const
  bs = chr(8);
  lf = chr(10);
  cr = chr(13);
  ctlc_dos  = 16#23;
  wsize = (number_of_lines+7) div 8;

var
  screen_ptr [PUBLIC] : screen_ads_typ;
  row0 [PUBLIC], col0 [PUBLIC], lmc0 [PUBLIC] : integer;
  stifled [PUBLIC] : boolean;
  cancelled [PUBLIC] : boolean;
  to_warn [PUBLIC] : integer;
  to_kill [PUBLIC] : integer;
  bs_local [PUBLIC] : byte;
  wrap0 [PUBLIC] : byte;
  cesxqq [EXTERN]: word;
  doseqq [EXTERN]: word;
  tm_warn : para;

{***INTERFACE TO THE COM_PAX2 ASYNCHRONOUS COMMUNICATIONS PACKAGE***}
{$include: 'com_pax2.int'}

{***Interface to the PASASM assembler utilities package***}
{$include: 'pasasm.int'}
{$include: 'newasm.int'}

{***Interface to KBD library***}
{$include: 'kbd.int'}

{***Interface to MS Pascal library***}
function dosxqq(command, parameter: word): byte; EXTERN;
function tics : word; EXTERN;
procedure time(var s : string); EXTERN;
procedure vectin(v : word; procedure i [INTERRUPT]); EXTERN;

{***Interface to Brackenridge's More Handles function***}
{$include: 'extndh.int'}

{***Special for calling file initialize module***}
procedure globals; EXTERN;


procedure endoqq [PUBLIC]; {supercedes stub in Pascal library}
begin
  if w.s<>0 and then w^[0].active then restoreh;
  if not alls_well then
    [writeln('*** LINE:',wx:1,', STATE:',q[wx].state:1);
     writeln('*** DEPTH:',macro_depth:1,', INPUT: ',w^[wx].strx)];
end {endoqq};

procedure ctl_break [INTERRUPT];
begin
  clean_up;
  ret2dos(3);
end {ctl_break};

var
  i,j,k,l,m,n,t : integer;
  wi,wj : word;
  i4 : integer4;
  ch : char;
  str : lstring(long_line);
  p,p2 : para;
  oldtop : integer;
  ix : 0..long_line;
  echo_to_printer : boolean;
  local : integer;
  cmdline: ads of lstring(255);
  doomstime: lstring(5); {planned shutdown time}

label
  more_out;

begin

{Initialize}
cmdline.s := cesxqq;
cmdline.r := 16#80;
globals;{pascal file system}
alls_well:=true;
nill.s:=0; nill.r:=0;
w.s:=0;
bavail:=RETYPE(bpara,nill);
init;{setup stuff for pasasm}

{initialize screen pointer}
screen_ptr.s := vidbuf;
screen_ptr.r := 0;
herald;
chkmem;
crit_on;
seed:=tics or 1;
disbpara(newbpara); {force one onto the avail list}
doomstime.len:=0;
w := far_alloc(sizeof(w^));
for i:=1 to ord(cmdline^.len) do
  if cmdline^[i]<=':' and then cmdline^[i]>='0' then
    [doomstime.len:=doomstime.len+1;
     doomstime[doomstime.len]:=cmdline^[i];
     if doomstime.len>=UPPER(doomstime) then break];

{Ask sysop which lines to activate}
n:=0;
if number_of_lines>0 then
  [writeln('Select serial line(s) to activate:');
   writeln];
for i:=number_of_lines downto 1 do begin
  write('Activate line ',i:1,'? '); readln(str);
  if str<>null and then uc(str[1])='Y' then
    [w^[i].onscreen:=true; n:=n+1;
     w^[i].baud:=300; w^[i].max_baud:=300;
     w^[i].echo:=true]
  else if decode(str,wj) then
    [w^[i].onscreen:=true; n:=n+1;
     w^[i].baud:=wj; w^[i].max_baud:=wj;
     w^[i].echo:=false]
  else
    w^[i].onscreen:=false;
end {for};
w^[0].onscreen:=true; n:=n+1;
w^[0].baud:=9600; w^[0].max_baud:=9600;
w^[0].echo:=true;
if n>10 and then extndh=-1 then
  writeln('FILES=?');

config1;

load_em(ch_warn,tm_warn);

config2;
to_warn:=18*timeout-540;
to_kill:=18*timeout;

config_comm;

{main loop}
stifled:=false; cancelled:=false; bs_local:=1;
alls_well:=false;
echo_to_printer:=false;
shutdown_mode:=false;
if n>=(srm1 div 2) then n:=(srm1 div 2)-1; {can only display so many lines}
t:=0;
oldtop:=0;
running:=true;
wx:=0; gstat_line;
vectin(ctlc_dos,ctl_break); {intercept ctrl-break}
{let 'em rip!}
swap_ovl;
for i:=number_of_lines downto 0 do
  [w^[i].echo:=true;
   if i>0 then
     [w^[i].onscreen:=false;
      if w^[i].active then
        [select_port(i); dtr_on]]];
while running do begin

  {time processing -- status lines}
  if t<300 then {150 in 5.5}
    t:=t+1
  else begin
    t:=0; allow_break;
    mytime[0]:=chr(8); time(mytime);
    jt:=      (ord(mytime[1])-ord('0'))*10+(ord(mytime[2])-ord('0'));
    jt:=jt*60+(ord(mytime[4])-ord('0'))*10+(ord(mytime[5])-ord('0'));
    jt:=jt*60+(ord(mytime[7])-ord('0'))*10+(ord(mytime[8])-ord('0'));
    if jt<180 then intl_date;
    for wx:=number_of_lines downto 0 do
      if w^[wx].active and then w^[wx].state=going and then
         q[wx].logged_in and then (not q[wx].xover)
        then status_line(wx);
    wx:=0; gstat_line;
    if shutdown_mode then
      [if shutdown_time <= (jt div 60) then
         [running:=false;
          for i:=0 to number_of_lines do
            [if w^[i].active and then w^[i].state=going and then
	        q[i].state<snip then
               [w^[i].chat:=-1; q[i].cleanup:='I';
                w^[i].node_type:=nt_compute; q[i].state:=cleanup1]
             else if i>0 and then q[i].logged_in then
               running:=true]]]
    else if doomstime.len>=4 and then eq2(mytime,doomstime) then
      [doseqq:=0; shut_down(20)];
  end {time processing};

  {do function keys}
  if f_count>0 then
    [k:=f_recv;
     case k of
     59..66 : {F1 thru F8 = show lines in small groups}
       [k:=k-58;
        if wsize*(k-1)+1<=number_of_lines then
          [for i:=number_of_lines downto 1 do w^[i].onscreen:=false;
           l:=0; {next available row}
           for i:=wsize*k downto wsize*(k-1)+1 do begin
             if i>number_of_lines then cycle;
             if w^[i].active then w^[i].onscreen:=true;
             w^[i].top:=l; w^[i].bot:=w^[i].top+(srm1 div (wsize+1))-2;
             w^[i].stat:=w^[i].bot+1; l:=w^[i].stat+1;
             scrollup(w^[i].top*256+0,w^[i].bot*256+scm1,nattr,0);
             w^[i].row:=w^[i].top;
             if w^[i].active and then w^[i].state=going and then
                q[i].logged_in and then (not q[i].xover)
               then status_line(i);
	     movesl2(ads w^[i].stat_char^.msg[1],
	     	     ads screen_ptr^[w^[i].stat,0].character,screen_cols);
	     movesl2(ads w^[i].stat_attr^.msg[1],
	     	     ads screen_ptr^[w^[i].stat,0].atrb,screen_cols);
           end {for};
           if w^[0].top>l then
	     scrollup(l*256+0,(w^[0].top-1)*256+scm1,nattr,0);
           if row0=oldtop and then col0=0 then
             [w^[0].row:=l; row0:=l; setcp(l,0)];
           oldtop:=l; w^[0].top:=l;
           w^[0].bot:=screen_rows-3; w^[0].stat:=screen_rows-2;
           if row0<w^[0].top then
             [row0:=w^[0].top; w^[0].row:=row0;
              col0:=0; w^[0].col:=0;
              lmc0:=0; w^[0].lmc:=0;
              setcp(row0,0)];
           scrollup(w^[0].stat*256+0,w^[0].stat*256+scm1,iattr,0);
           if w^[0].state=going and then
              q[0].logged_in and then (not q[0].xover)
             then status_line(0);
	   movesl2(ads w^[0].stat_char^.msg[1],
	    	   ads screen_ptr^[w^[0].stat,0].character,screen_cols);
	   movesl2(ads w^[0].stat_attr^.msg[1],
	     	   ads screen_ptr^[w^[0].stat,0].atrb,screen_cols);
           wx:=0; gstat_line]];
     67 : {F9 = show all lines}
       [m:=0; {number of windows displayed so far}
        l:=0; {next available row}
	for i:=1 to number_of_lines do
	  if w^[i].active and then m<n
	    then [w^[i].onscreen:=true; m:=m+1]
	    else w^[i].onscreen:=false;
        for i:=number_of_lines downto 1 do
          if w^[i].active and then w^[i].onscreen then
            [w^[i].top:=l; w^[i].bot:=w^[i].top+(srm1 div n)-2;
             w^[i].stat:=w^[i].bot+1; l:=w^[i].stat+1;
             w^[i].row:=w^[i].top;
             scrollup(w^[i].top*256+0,w^[i].bot*256+scm1,nattr,0);
             if w^[i].state=going and then
                q[i].logged_in and then (not q[i].xover)
               then status_line(i);
	     movesl2(ads w^[i].stat_char^.msg[1],
	   	     ads screen_ptr^[w^[i].stat,0].character,screen_cols);
	     movesl2(ads w^[i].stat_attr^.msg[1],
	    	     ads screen_ptr^[w^[i].stat,0].atrb,screen_cols)];
        if w^[0].top>l then scrollup(l*256+0,(w^[0].top-1)*256+scm1,nattr,0);
        if row0=oldtop and then col0=0 then
          [w^[0].row:=l; row0:=l; setcp(l,0)];
        oldtop:=l; w^[0].top:=l;
        w^[0].bot:=screen_rows-3; w^[0].stat:=screen_rows-2;
        if row0<w^[0].top then
          [row0:=w^[0].top; w^[0].row:=row0;
           col0:=0; w^[0].col:=0;
           lmc0:=0; w^[0].lmc:=0;
           setcp(row0,0)];
        scrollup(w^[0].stat*256+0,w^[0].stat*256+scm1,iattr,0);
        if w^[0].state=going and then
           q[0].logged_in and then (not q[0].xover)
          then status_line(0);
	movesl2(ads w^[0].stat_char^.msg[1],
	    	ads screen_ptr^[w^[0].stat,0].character,screen_cols);
	movesl2(ads w^[0].stat_attr^.msg[1],
	     	ads screen_ptr^[w^[0].stat,0].atrb,screen_cols);
        wx:=0; gstat_line];
     68 : {F10 = display line 0 (kbd) only}
       [for i:=number_of_lines downto 1 do w^[i].onscreen:=false;
        if w^[0].top>0 then scrollup(0,(w^[0].top-1)*256+scm1,nattr,0);
        if row0=oldtop and then col0=0 then
           [w^[0].row:=0; row0:=0; setcp(0,0)];
        oldtop:=0; w^[0].top:=0;
        scrollup(w^[0].stat*256+0,w^[0].stat*256+scm1,iattr,0);
        if w^[0].state=going and then
           q[0].logged_in and then (not q[0].xover)
          then status_line(0);
	movesl2(ads w^[0].stat_char^.msg[1],
	    	ads screen_ptr^[w^[0].stat,0].character,screen_cols);
	movesl2(ads w^[0].stat_attr^.msg[1],
	     	ads screen_ptr^[w^[0].stat,0].atrb,screen_cols);
        wx:=0; gstat_line];
     114: {Ctrl-PrtSc = Toggle echo to printer}
       echo_to_printer := not echo_to_printer;
     otherwise {ignore other function keys};
     end {case}];

  {do keyboard}
  wx:=0;
  if w^[0].active then
    if w^[0].state=stopped then
      [w^[0].state:=starting;
       scrollup(w^[0].top*256+0,w^[0].bot*256+scm1,nattr,0);
       newstat(0,ord(ss[36].len)+1,iattr,null); bs_local:=1;
       w^[0].row:=w^[0].top; w^[0].col:=0; w^[0].lmc:=0;
       w^[0].wrapat:=wrap_column; wrap0:=wrd(w^[0].wrapat);
       row0:=w^[0].row; col0:=w^[0].col; lmc0:=w^[0].lmc; setcp(row0,col0);
       w^[0].output:=nill; w^[0].strx:=null; w^[0].connect_sec0:=jt;
       w^[0].chat:=-1; w^[0].chatintro:=nill;
       w^[0].bulletin:=nill; w^[0].chat_warned:=false; w^[0].echo:=true;
       w^[0].more:=0; w^[0].more_crlfs:=0; w^[0].pagesize:=defpage-2;
       if w^[0].pagesize<=0 then w^[0].pagesize:=MAXINT;
       newstat(0,ord(ss[36].len)+1,iattr,ss[3])] {Waiting}
    else if cancelled or else chat_timed_out then {control C}
      [cancelled:=false; purgekbd;
       w^[0].more:=0; w^[0].more_crlfs:=0;
       if w^[0].chat>=0 then
         [i:=w^[0].chat; w^[0].chat:=-1; w^[i].chat:=-1;
          bs_local:=1;
          w^[i].more:=0; w^[i].more_crlfs:=0;
	  disparas(w^[0].chatintro);
	  disparas(w^[i].chatintro);
          if q[0].level=9 then
            [i4:=jt-w^[i].ch0; if i4<0 then i4:=i4+one_day; 
             w^[i].connect_sec0:=w^[i].connect_sec0+i4];
          if q[i].level=9 then
            [i4:=jt-w^[i].ch0; if i4<0 then i4:=i4+one_day; 
             w^[0].connect_sec0:=w^[0].connect_sec0+i4]]
       else
         [if w^[0].crud
	    then disparas(w^[0].output)
	    else w^[0].output:=nill;
          w^[0].row:=row0+1; w^[0].col:=0; w^[0].lmc:=0;
          if w^[0].row>w^[0].bot then
            [scrollup(w^[0].top*256+0,w^[0].bot*256+scm1,nattr,1);
             w^[0].row:=w^[0].bot];
          row0:=w^[0].row; col0:=0; lmc0:=0;
          str[0]:=chr(1); str[1]:=chr(3); {control c}
          bbs(str)]]
    else if w^[0].chatintro<>nill then
      [for i:=1 to ord(w^[0].chatintro^.crlfs) do begin
         if row0>w^[0].bot then
           [scrollup(w^[0].top*256+0,w^[0].bot*256+scm1,nattr,1);
            row0:=w^[0].bot; col0:=0];
          row0:=row0+1; setcp(row0,col0); lmc0:=0;
       end {for};
       w^[0].more_crlfs:=0; w^[0].more:=0;
       w^[0].row:=row0; w^[0].col:=col0;
       if w^[0].row>w^[0].bot then
         [scrollup(w^[0].top*256+0,w^[0].bot*256+scm1,nattr,1);
          w^[0].row:=w^[0].bot; w^[0].col:=0];
       strout(w^[0].row,w^[0].col,w^[0].chatintro^.msg);
       w^[0].row:=w^[0].row+1; w^[0].col:=0;
       p:=w^[0].chatintro; w^[0].chatintro:=p^.link; dispara(p);
       if w^[0].chatintro=nill then
         [if w^[0].row>w^[0].bot then
            [scrollup(w^[0].top*256+0,w^[0].bot*256+scm1,nattr,1);
             w^[0].row:=w^[0].bot]];
       row0:=w^[0].row; col0:=0; setcp(row0,0);
       if w^[0].chatintro=nill then [bs_local:=0; echo_kbd]]
    else if w^[0].bulletin<>nill and then col0=0 and then
    	    w^[0].more<=w^[0].pagesize and then
	    ((q[0].xstr=nill) or (not gc(0))) then
      [for i:=1 to ord(w^[0].bulletin^.crlfs) do begin
         if row0>w^[0].bot then
           [scrollup(w^[0].top*256+0,w^[0].bot*256+scm1,nattr,1);
            row0:=w^[0].bot; col0:=0];
          row0:=row0+1; setcp(row0,col0); lmc0:=0;
	  if w^[0].chat=-1 then
            w^[0].more:=w^[0].more+1;
          if w^[0].more>w^[0].pagesize then
            [w^[0].bulletin^.crlfs:=w^[0].bulletin^.crlfs-wrd(i);
             domore(0); goto more_out];
       end {for};
       w^[0].row:=row0; w^[0].col:=0;
       if kr_count>0 then w^[0].row:=w^[0].row+1;
       if w^[0].row>w^[0].bot then
         [scrollup(w^[0].top*256+0,w^[0].bot*256+scm1,nattr,1);
          w^[0].row:=w^[0].bot];
       strout(w^[0].row,0,w^[0].bulletin^.msg);
       if w^[0].chat=-1 then
         w^[0].more:=w^[0].more+1;
       if kr_count=0 then w^[0].row:=w^[0].row+1;
       if w^[0].row>w^[0].bot and then
          ((w^[0].chat>=0) or (w^[0].node_type=nt_prompt)) then
         [scrollup(w^[0].top*256+0,w^[0].bot*256+scm1,nattr,1);
          w^[0].row:=w^[0].bot];
       p:=w^[0].bulletin; w^[0].bulletin:=p^.link; dispara(p);
       row0:=w^[0].row; col0:=0; lmc0:=0; setcp(row0,0);
       if w^[0].more>w^[0].pagesize then domore(0)]
    else if w^[0].node_type=nt_compute and then w^[0].chat=-1 and then
            w^[0].more<=w^[0].pagesize then
      bbs(null)
    else if w^[0].output<>nill and then w^[0].chat=-1 and then
            w^[0].more<=w^[0].pagesize then
      [if not stifled then
         [for i:=w^[0].more_crlfs+1 to ord(w^[0].output^.crlfs) do begin
            if row0>w^[0].bot then
              [scrollup(w^[0].top*256+0,w^[0].bot*256+scm1,nattr,1);
               row0:=w^[0].bot; col0:=0];
             row0:=row0+1; setcp(row0,col0); lmc0:=0;
             if w^[0].more>0 then w^[0].more:=w^[0].more+1;
             if w^[0].more>w^[0].pagesize then
               [w^[0].more_crlfs:=i;
                domore(0); goto more_out];
          end {for};
          w^[0].more_crlfs:=0;
          if row0>w^[0].bot then
            [scrollup(w^[0].top*256+0,w^[0].bot*256+scm1,nattr,1);
             row0:=w^[0].bot; col0:=0];
          strout(row0,0,w^[0].output^.msg);
          if w^[0].output^.link=nill and then w^[0].node_type=nt_prompt then
            [col0:=ord(w^[0].output^.msg[0]);
             setcp(row0,col0); lmc0:=col0; w^[0].more:=0;
             if w^[0].echo then echo_kbd]
          else
            [row0:=row0+1; setcp(row0,col0); lmc0:=0;
             if w^[0].more>0 or else w^[0].output^.msg<>null
               then w^[0].more:=w^[0].more+1];
          p:=w^[0].output;
          w^[0].output:=p^.link;
          if w^[0].crud then dispara(p);
          if w^[0].output=nill and then w^[0].node_type=nt_display then
            w^[0].node_type:=nt_compute;
          if w^[0].node_type=nt_prompt then {avoid pause 1 line before prompt}
            [if w^[0].output=nill or else w^[0].output^.link=nill then
               w^[0].more:=0];
          if w^[0].more>w^[0].pagesize then domore(0)]]
    else {get input}
      [if w^[0].chat>=0 then {chat mode}
        [if w^[w^[0].chat].chatintro=nill then
         [ch:=k_recv;
          if echo_to_printer then
            [if ch=cr then
               [eval(dosxqq(5,wrd(cr))); eval(dosxqq(5,wrd(lf)))]
             else if ch<>chr(0) then
               eval(dosxqq(5,wrd(ch)))];
          case ch of {chat mode}
            chr(0),lf : ;
            bs : if col0>0 then
                   [send2(w^[0].chat,bs); send2(w^[0].chat,' ');
                    send2(w^[0].chat,bs); col0:=col0-1;
                    screen_ptr^[row0,col0].character:=' ';
                    w^[0].row:=row0; w^[0].col:=col0; setcp(row0,col0)];
            cr : [send2(w^[0].chat,cr); send2(w^[0].chat,lf);
                  w^[0].row:=w^[0].row+1; w^[0].col:=0;
                  if w^[0].row>w^[0].bot then
                    [scrollup(w^[0].top*256+0,w^[0].bot*256+scm1,nattr,1);
                     w^[0].row:=w^[0].bot];
                  row0:=w^[0].row; col0:=0; setcp(row0,0); echo_kbd];
            otherwise send2(w^[0].chat,ch);
          end {case}]]
       else {not chat mode -- normal input}
         [if kr_count>0 then {have chars including cr}
            [row0:=row0+1; col0:=0;
             j:=0; w^[0].strx[0]:=chr(long_line);
             while true do
               [ch:=k_recv;
                if ch=cr or else ch=chr(0) then break;
                j:=j+1;
                if j<=UPPER(w^[0].strx) then w^[0].strx[j]:=ch];
             if j<=UPPER(w^[0].strx)
               then w^[0].strx[0]:=chr(j)
               else w^[0].strx[0]:=chr(UPPER(w^[0].strx));
             if w^[0].more>w^[0].pagesize then
               [eval(pre_scr(w^[0].strx,str));
	        if str=null then ch:=mn[13][1] else ch:=str[1];
                if ch=mn[13][2] {N} or else ch=mn[13][4] {Q} then
                  cancelled:=true
                else
                  [if ch=mn[13][3] {C}
                     then w^[0].more:=-MAXINT
                     else w^[0].more:=0;
                   row0:=row0+1; col0:=0; lmc0:=0;
                   if row0>w^[0].bot then
                     [scrollup(w^[0].top*256+0,w^[0].bot*256+scm1,nattr,1);
                      row0:=w^[0].bot; col0:=0];
                    w^[0].row:=row0; w^[0].col:=0; w^[0].lmc:=0;
		    setcp(row0,col0)]]
	     else
               [w^[0].more:=0; bbs(w^[0].strx)]]]];
more_out:

  {actual phone/modem lines}
  for local:=1 to number_of_lines do begin
    wx:=local;
    if w^[wx].active then begin
      if w^[wx].dismiss then
        [if clock_raw<w^[wx].clock_target
           then cycle
           else w^[wx].dismiss:=false];
      select_port(wx);
      case w^[wx].talking_to of

      modem : begin
        w^[wx].reset_count:=0;
        if mytime = '16:17:00' then
          w^[wx].talking_to:=disconnect
        else if r_count>0 and then (not shutdown_mode) then begin
          ch:=receive;
          if ch=cr and then w^[wx].proto=plain then
            w^[wx].talking_to:=connecting
          else if ch=lf then
            [w^[wx].row:=w^[wx].row+1; w^[wx].col:=0;
             if w^[wx].row>w^[wx].bot then
               [scrollu(w^[wx].top,w^[wx].bot,nattr,1);
                w^[wx].row:=w^[wx].bot];
             while w^[wx].strx<>null and then w^[wx].strx[1]<>ss[53][1] do {C}
               delete(w^[wx].strx,1,1);
             if w^[wx].strx<>null and then w^[wx].strx[1]=ss[53][1] then {C}
               [w^[wx].dismiss:=true;
                w^[wx].clock_target:=clock_raw+4;
                w^[wx].talking_to:=setting_baud_rate]
             else
               w^[wx].strx:=null]
          else
            if ch<>cr and then ch<>chr(0) then
              [if w^[wx].onscreen then
                 screen_ptr^[w^[wx].row,w^[wx].col].character:=ch;
               if w^[wx].col<screen_cols then w^[wx].col:=w^[wx].col+1;
               i:=ord(w^[wx].strx.len)+1;
               if i<=UPPER(w^[wx].strx)
                 then [w^[wx].strx.len:=wrd(i); w^[wx].strx[i]:=ch]
                 else [w^[wx].reset_count:=0; w^[wx].talking_to:=disconnect]];
        end {if r_count>0};
      end {modem};

      setting_baud_rate : begin
        wi:=w^[wx].baud;
        if eq(w^[wx].strx,ss[53]) then {CONNECT}
          w^[wx].baud:=300
        else if w^[wx].strx.len>ss[53].len then {CONNECT xxxx}
          [delete(w^[wx].strx,1,ord(ss[53].len)+1);
	   for j:=2 to ord(w^[wx].strx.len) do
	     if w^[wx].strx[j]<'0' or else w^[wx].strx[j]>'9' then  {/ARQ?}
	       [w^[wx].strx.len:=wrd(j-1);
		break];
           if decode(w^[wx].strx,wj) then w^[wx].baud:=wj];
        w^[wx].dismiss:=true; w^[wx].clock_target:=clock_raw+modem_delay[6];
	if w^[wx].baud<>wi then
          [open_com(w^[wx].baud,'N','1');
	   w^[wx].clock_target:=w^[wx].clock_target+modem_delay[6]];
	if not rlsd then
	  w^[wx].clock_target:=w^[wx].clock_target+modem_delay[6];
        w^[wx].talking_to:=connecting;
      end {setting_baud_rate};

      connecting : begin
        w^[wx].output:=nill; w^[wx].strx:=null; w^[wx].connect_sec0:=jt;
        w^[wx].chat:=-1; w^[wx].chatintro:=nill;
        w^[wx].bulletin:=nill; w^[wx].state:=starting;
	w^[wx].chat_warned:=false;
        w^[wx].more:=0; w^[wx].more_crlfs:=0; w^[wx].pagesize:=defpage-2;
        if w^[wx].pagesize<=0 then w^[wx].pagesize:=MAXINT;
        w^[wx].wrapat:=wrap_column; wrap(w^[wx].wrapat-5);
        w^[wx].echo:=true; bbs(null);
        w^[wx].dismiss:=true; w^[wx].clock_target:=clock_raw+4;
        w^[wx].talking_to:=human;
      end {connecting};

      human : begin
        if w^[wx].state=starting then
          [purge_com; w^[wx].strx:=null]
	else if w^[wx].state=stopped then
          [send(cr); send(lf);
           w^[wx].talking_to:=wait_for_output; cycle];
        if not rlsd and then jt>60 and then jt<(one_day-60) then
          [if w^[wx].chat=0 then bs_local:=1;
           w^[wx].state:=stopping; bbs(null); cycle];
        if warning then {long time since key press or data sent}
          [if jt<=60 or else jt>=(one_day-60) then
             unwarn
           else
             [if w^[wx].col<>0 then
                [send(cr); send(lf);
                 w^[wx].row:=w^[wx].row+1; w^[wx].col:=0; w^[wx].lmc:=0;
                 if w^[wx].row>w^[wx].bot then
                   [scrollu(w^[wx].top,w^[wx].bot,nattr,1);
                    w^[wx].row:=w^[wx].bot]];
              notify(wx,tm_warn)]]
        else if cancelled_com or else chat_timed_out then {control C}
          [purge_com;
           w^[wx].more:=0; w^[wx].more_crlfs:=0;
           if w^[wx].chat>=0 then
             [i:=w^[wx].chat; w^[wx].chat:=-1; w^[i].chat:=-1;
              if i=0 then bs_local:=1;
	      w^[i].more:=0; w^[i].more_crlfs:=0;
	      disparas(w^[wx].chatintro);
	      disparas(w^[i].chatintro);
              if q[wx].level=9 then
                [i4:=jt-w^[i].ch0; if i4<0 then i4:=i4+one_day; 
                 w^[i].connect_sec0:=w^[i].connect_sec0+i4];
              if q[i].level=9 then
                [i4:=jt-w^[wx].ch0; if i4<0 then i4:=i4+one_day; 
                 w^[wx].connect_sec0:=w^[wx].connect_sec0+i4];
              if time_check(false) then
                bbs(null)]
           else
             [if w^[wx].crud
	        then disparas(w^[wx].output)
		else w^[wx].output:=nill;
              send(cr); send(lf); w^[wx].row:=w^[wx].row+1; w^[wx].col:=0;
              if w^[wx].row>w^[wx].bot then
                [scrollu(w^[wx].top,w^[wx].bot,nattr,1);
                 w^[wx].row:=w^[wx].bot];
              str[0]:=chr(1); str[1]:=chr(3); {control c}
              bbs(str)]]
        else if w^[wx].chatintro<>nill then
          [if s_free > ord(w^[wx].chatintro^.msg[0])+
                       2*ord(w^[wx].chatintro^.crlfs)+2 then
	     [w^[wx].more_crlfs:=0; w^[wx].more:=-MAXINT;
              eval(send_para(w^[wx].chatintro));
              send(cr); send(lf);
              if w^[wx].row>w^[wx].bot then
                [scrollu(w^[wx].top,w^[wx].bot,nattr,1);
                 w^[wx].row:=w^[wx].bot; w^[wx].col:=0];
              if w^[wx].onscreen then
	        strout(w^[wx].row,0,w^[wx].chatintro^.msg);
              w^[wx].row:=w^[wx].row+1; w^[wx].lmc:=0;
              p:=w^[wx].chatintro; w^[wx].chatintro:=p^.link; dispara(p);
              if (w^[wx].chatintro=nill) and then (w^[wx].row>w^[wx].bot) then
                [scrollu(w^[wx].top,w^[wx].bot,nattr,1);
                 w^[wx].row:=w^[wx].bot; w^[wx].col:=0]; w^[wx].more:=0;
              echo_com]]
        else if w^[wx].more>w^[wx].pagesize and then w^[wx].more<>32000 then
          [if s_free > ord(more_txt^.msg[0])+2 then
             [domore(wx); w^[wx].more:=32000]]
        else if w^[wx].bulletin<>nill and then w^[wx].col=0 and then
		w^[wx].more<=w^[wx].pagesize and then
		((q[wx].xstr=nill) or (not gc(wx))) then
	  [if (jt mod (32*5+1))=(5*wx) and then {every 5 sec check a line}
	      gc(wx) and then time_check(false) then
             force_cancel
           else if s_free > ord(w^[wx].bulletin^.msg[0])+
                            2*ord(w^[wx].bulletin^.crlfs)+2 then
             [if not send_para(w^[wx].bulletin) then cycle;
              send(cr); send(lf);
              if w^[wx].row>w^[wx].bot then
                [scrollu(w^[wx].top,w^[wx].bot,nattr,1);
                 w^[wx].row:=w^[wx].bot; w^[wx].col:=0;
                 if w^[wx].onscreen then
                   strout(w^[wx].row,0,w^[wx].bulletin^.msg);
                 w^[wx].row:=w^[wx].row+1]
              else
                [if w^[wx].onscreen then
                   strout(w^[wx].row,0,w^[wx].bulletin^.msg);
                 w^[wx].row:=w^[wx].row+1;
                 if w^[wx].row>w^[wx].bot then
                   [scrollu(w^[wx].top,w^[wx].bot,nattr,1);
                    w^[wx].row:=w^[wx].bot; w^[wx].col:=0]];
	      if w^[wx].chat=-1 then
	        w^[wx].more:=w^[wx].more+1;
              p:=w^[wx].bulletin; w^[wx].bulletin:=p^.link; dispara(p);
              w^[wx].lmc:=0]]
        else if w^[wx].node_type=nt_compute and then w^[wx].chat=-1 and then
		w^[wx].more<=w^[wx].pagesize then
          bbs(null)
        else if w^[wx].output<>nill and then w^[wx].chat=-1 and then
		w^[wx].more<=w^[wx].pagesize then
          [if s_free > ord(w^[wx].output^.msg[0])+
                       2*(ord(w^[wx].output^.crlfs)-w^[wx].more_crlfs)+2 then
             [if not send_para(w^[wx].output) then cycle;
	      w^[wx].more_crlfs:=0;
              if w^[wx].row>w^[wx].bot then
                [scrollu(w^[wx].top,w^[wx].bot,nattr,1);
                 w^[wx].row:=w^[wx].bot; w^[wx].col:=0];
              if w^[wx].onscreen then strout(w^[wx].row,0,w^[wx].output^.msg);
              if w^[wx].output^.link=nill and then
                 w^[wx].node_type=nt_prompt then
                [w^[wx].col:=ord(w^[wx].output^.msg[0]);
                 w^[wx].lmc:=w^[wx].col; w^[wx].more:=0;
                 if w^[wx].echo then echo_com]
              else
                [send(cr); send(lf);
                 w^[wx].row:=w^[wx].row+1; w^[wx].lmc:=0;
                 if w^[wx].more>0 or else w^[wx].output^.msg<>null
                   then w^[wx].more:=w^[wx].more+1];
              p:=w^[wx].output;
              w^[wx].output:=p^.link;
              if w^[wx].crud then dispara(p);
	      if w^[wx].output=nill and then w^[wx].node_type=nt_display then
	        w^[wx].node_type:=nt_compute;
	      if w^[wx].node_type=nt_prompt then
	        [if w^[wx].output=nill or else w^[wx].output^.link=nill then
		   w^[wx].more:=0]]]
        else {no output -- get input}
          [if w^[wx].chat>=0 then {chat mode}
            [if w^[w^[wx].chat].chatintro=nill then
             [ch:=receive;
              if echo_to_printer and then w^[wx].chat=0 then
                [if ch=cr then
                   [eval(dosxqq(5,wrd(cr))); eval(dosxqq(5,wrd(lf)))]
                 else if ch<>chr(0) then
                   eval(dosxqq(5,wrd(ch)))];
              case ch of {chat mode}
                chr(0),lf : ;
                bs : if w^[wx].col>w^[wx].lmc then
                       [send2(w^[wx].chat,bs); send2(w^[wx].chat,' ');
                        send2(w^[wx].chat,bs); w^[wx].col:=w^[wx].col-1;
                        if w^[wx].onscreen then
                          screen_ptr^[w^[wx].row,w^[wx].col].character:=' '];
                cr : [send2(w^[wx].chat,cr); send2(w^[wx].chat,lf); send(lf);
                      if w^[wx].onscreen then
                        screen_ptr^[w^[wx].row,scm1].character:='|';
                      w^[wx].row:=w^[wx].row+1; w^[wx].col:=0;
                      if w^[wx].row>w^[wx].bot then
                        [scrollu(w^[wx].top,w^[wx].bot,nattr,1);
                         w^[wx].row:=w^[wx].bot];
                      echo_com];
                otherwise
                     [send2(w^[wx].chat,ch);
                      if w^[wx].col<screen_cols then
                        [if w^[wx].onscreen then
                           screen_ptr^[w^[wx].row,w^[wx].col].character:=ch;
                         w^[wx].col:=w^[wx].col+1]];
              end {case}]]
           else {not chat mode -- normal input}
             [if r_count>0 then begin {means we've got one or more characters}
                ch:=receive;
                if ch=cr then
                   [if w^[wx].strx.len>scm1 then [send(cr); w^[wx].col:=0];
                    send(lf); w^[wx].row:=w^[wx].row+1;
                    if w^[wx].row>w^[wx].bot then
                      [scrollu(w^[wx].top,w^[wx].bot,nattr,1);
                       w^[wx].row:=w^[wx].bot; w^[wx].col:=0];
                    if w^[wx].more>w^[wx].pagesize then {page pause input}
		      [eval(pre_scr(w^[wx].strx,str));
		       if str=null then ch:=mn[13][1] else ch:=str[1];
		       if ch=mn[13][2] {N} or else ch=mn[13][4] {Q} then
		         force_cancel
		       else if ch=mn[13][3] {C} then
			 w^[wx].more:=-MAXINT
		       else
			 w^[wx].more:=0]
		    else
		      bbs(w^[wx].strx);
		    w^[wx].strx:=null]
                 else if ch=bs then
                   [i:=ord(w^[wx].strx[0])-1;
                    if i<0 or else w^[wx].col<=w^[wx].lmc then
                      [w^[wx].strx:=null; w^[wx].col:=w^[wx].lmc]
                    else
                      [w^[wx].strx[0]:=chr(i); w^[wx].col:=w^[wx].col-1;
                       if w^[wx].echo and then w^[wx].onscreen then
                         screen_ptr^[w^[wx].row,w^[wx].col].character:=' ']]
                 else if ch<>lf and then ch<>chr(0) and then
                         w^[wx].col<screen_cols then
                   [ix:=ord(w^[wx].strx.len+1);
                    if ix<=UPPER(w^[wx].strx) then
                      [w^[wx].strx.len:=wrd(ix); w^[wx].strx[ix]:=ch];
                    if w^[wx].echo then
                      [if w^[wx].onscreen then
                         screen_ptr^[w^[wx].row,w^[wx].col].character:=ch;
                       w^[wx].col:=w^[wx].col+1]];
              end {if r_count>0}]];
      end {human};

      wait_for_output : begin
        while rlsd and then w^[wx].output<>nill and then
           s_free>ord(w^[wx].output^.msg[0])+2 do
          [send_ls(w^[wx].output^.msg);
           if w^[wx].row>w^[wx].bot then
             [scrollu(w^[wx].top,w^[wx].bot,nattr,1);
              w^[wx].row:=w^[wx].bot; w^[wx].col:=0];
           if w^[wx].onscreen then strout(w^[wx].row,0,w^[wx].output^.msg);
           send(cr); send(lf);
           w^[wx].row:=w^[wx].row+1; w^[wx].col:=0; w^[wx].lmc:=0;
           p:=w^[wx].output; w^[wx].output:=p^.link;
           if w^[wx].crud then dispara(p)];
        if not rlsd or else s_working=0 then
          [while w^[wx].output<>nill do
             [p:=w^[wx].output; w^[wx].output:=p^.link;
              if w^[wx].crud then dispara(p)];
           if w^[wx].col>0 then [w^[wx].row:=w^[wx].row+1; w^[wx].col:=0];
           if w^[wx].row>w^[wx].bot then
             [scrollu(w^[wx].top,w^[wx].bot,nattr,1);
              w^[wx].row:=w^[wx].bot; w^[wx].col:=0];
           w^[wx].dismiss:=true; w^[wx].clock_target:=clock_raw+12;
           w^[wx].reset_count:=0; w^[wx].talking_to:=disconnect];
      end {wait_for_output};

      disconnect : begin
        if w^[wx].reset_count>=max_retries then
          w^[wx].talking_to:=cls
        else
          [w^[wx].reset_count:=w^[wx].reset_count+1;
           close_com;
           w^[wx].baud:=w^[wx].max_baud;
           open_com(w^[wx].baud,'N','1');
           dtr_off;
           newstat(wx,ord(ss[36].len)+1,iattr,null);
           w^[wx].dismiss:=true;
           w^[wx].clock_target := clock_raw + modem_delay[1] +
                                 5*(w^[wx].reset_count-1);
           w^[wx].talking_to:=reset_modem1];
      end {disconnect};

      reset_modem1 : begin
        dtr_on;
        if w^[wx].proto=plain then
          w^[wx].talking_to:=cls
        else
          [w^[wx].dismiss:=true; w^[wx].clock_target:=clock_raw+modem_delay[2];
           w^[wx].talking_to:=reset_modem2];
      end {reset_modem1};

      reset_modem2 : begin
         purge_com;
	 send_ls(ss[1]); {ATZ} send(cr); w^[wx].crud:=false;
         w^[wx].dismiss:=true; w^[wx].clock_target:=clock_raw+modem_delay[3];
         w^[wx].talking_to:=reset_modem3;
      end {reset_modem2};

      reset_modem3 : begin
        if r_count=0 then
          [if shutdown_mode
             then w^[wx].talking_to:=cls
             else w^[wx].talking_to:=reset_modem4]
        else
          [ch:=receive;
           if ch=lf then
             [w^[wx].row:=w^[wx].row+1; w^[wx].col:=0;
              if w^[wx].row>w^[wx].bot then
                [scrollu(w^[wx].top,w^[wx].bot,nattr,1);
                 w^[wx].row:=w^[wx].bot];
	      if shutdown_mode
                then w^[wx].talking_to:=cls]
           else if ch<>cr and then ch<>chr(0) then
             [if w^[wx].onscreen then
                screen_ptr^[w^[wx].row,w^[wx].col].character:=ch;
              w^[wx].col:=w^[wx].col+1;
              if ch=ss[52][1] then {OK}
                w^[wx].crud:=true
              else if w^[wx].crud and then ch=ss[52][2] then {OK}
                [if shutdown_mode
                   then w^[wx].talking_to:=cls
                   else w^[wx].talking_to:=reset_modem4]
              else
                w^[wx].crud:=false]];
      end {reset_modem3};

      reset_modem4 : begin
        send_ls(set_modem_cmd); send(cr); w^[wx].crud:=false;
        w^[wx].dismiss:=true; w^[wx].clock_target:=clock_raw+modem_delay[4];
        w^[wx].talking_to:=reset_modem5;
      end {reset_modem4};

      reset_modem5 : begin
        if r_count=0 then
          w^[wx].talking_to:=disconnect
        else
          [ch:=receive;
           if ch=lf then
             [w^[wx].row:=w^[wx].row+1; w^[wx].col:=0;
              if w^[wx].row>w^[wx].bot then
                [scrollu(w^[wx].top,w^[wx].bot,nattr,1);
                 w^[wx].row:=w^[wx].bot]]
           else if ch<>cr and then ch<>chr(0) then
             [if w^[wx].onscreen then
                screen_ptr^[w^[wx].row,w^[wx].col].character:=ch;
              w^[wx].col:=w^[wx].col+1;
              if ch=ss[52][1] then {OK}
                w^[wx].crud:=true
              else if w^[wx].crud and then ch=ss[52][2] then {OK}
                [w^[wx].dismiss:=true;
                 w^[wx].clock_target:=clock_raw+modem_delay[5];
                 w^[wx].talking_to:=cls]
              else
                w^[wx].crud:=false]];
      end {reset_modem5};

      cls : begin
        while r_count>0 and then receive<>lf do ;
        scrollu(w^[wx].top,w^[wx].bot,nattr,0);
        w^[wx].row:=w^[wx].top; w^[wx].col:=0; w^[wx].lmc:=0;
        w^[wx].strx:=null; w^[wx].state:=starting;
        if shutdown_mode
          then newstat(wx,ord(ss[36].len)+1,iattr,ss[4])  {Shutdown}
          else newstat(wx,ord(ss[36].len)+1,iattr,ss[3]); {Waiting}
        w^[wx].talking_to:=modem;
      end {cls};        

      end {case talking_to};
    end {if com port active};
  end {for each com port};

end {while};

clean_up;

end.
