{$debug-}
{$line-}

{$include: 'types.int'}
{$include: 'globals.int'}
{$include: 'funs.int'}
{$include: 'database.int'}
{$include: 'load.int'}
{$include: 'loadinit.int'}
{$include: 'utils.int'}

IMPLEMENTATION OF utils;

{DLX Bulletin Board System V7.0

 FREEWARE NOTICE

 DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
 Anyone who wishes to may run the program, copy it, or modify it for
 any purpose, including commercial gain.}

USES types,globals,funs,database,load,loadinit;

const
  tab = chr(9);

var
  screen_ptr [EXTERN] : screen_ads_typ;
  wrap0 [EXTERN] : byte;

{***INTERFACE TO THE COM_PAX2 ASYNCHRONOUS COMMUNICATIONS PACKAGE***}
{$include: 'com_pax2.int'}

{***Interface to the PASASM assembler utilities package***}
{$include: 'pasasm.int'}
{$include: 'newasm.int'}

{***Interface to KBD library***}
{$include: 'kbd.int'}

{***Interface to MS Pascal library***}
function getmqq(wants : word) : adsmem; EXTERN;
procedure dismqq(block : adsmem); EXTERN;
function umulok(a,b : word; var c : word) : boolean; EXTERN;
procedure endxqq; EXTERN;

var
  doseqq [EXTERN]: word;

procedure konkat{vars d : lstring; consts s : string};
var
  i,j : integer;
begin
  if ord(d.len)+UPPER(s) > UPPER(d) then
    [j:=ord(d.len); d.len:=wrd(UPPER(d));
     for i:=j+1 to UPPER(d) do d[i]:=s[i-j]]
  else
    concat(d,s);
end {konkat};

procedure kopylst{consts s : string; vars d : lstring};
begin
  if UPPER(s) > UPPER(d) then
    [d.len:=wrd(UPPER(d));
     for var i:=1 to UPPER(d) do d[i]:=s[i]]
  else
    copylst(s,d);
end {kopylst};

procedure kopystr{consts s : string; vars d : string};
begin
 if UPPER(s) > UPPER(d) then
   for var i:=1 to UPPER(d) do d[i]:=s[i]
 else
   copystr(s,d);
end {kopystr};

procedure load_em{vars w1,w2 : para};
begin
  write('1'); load_ss; load_mn;
  fSmall:=true;
  write('2'); load_macros;
  write('3'); load_script;
  fSmall:=false;
  w1:=cwn_txt; w2:=wrn_txt;
end {load_em};

function far_alloc{wants : word} {adsmem};
begin
  far_alloc:=getmqq(wants);
  lhc:=lhc+wants+2;
  if lhc>lhc_max then lhc_max:=lhc;
end {far_alloc};

function newpara{consts s : string} {para};
var
  w : word;
  p : para;
begin
  w:=para_size;
  if fSmall then
    [w:=w-wrd(screen_cols-UPPER(s));
     if odd(w) then w:=w+1];
  p:=far_alloc(w);
  p^.amper:=false; p^.link:=nill; p^.crlfs:=0;
  kopylst(s,p^.msg);
  newpara:=p;
end {newpara};

procedure dispara{p : adsmem};
var
  q : ads of word;
begin
  if p.s=0 then return;
  q:=p; q.r:=q.r-2;
  lhc:=lhc-q^-2;
  dismqq(p);
end {dispara};

procedure disparas{vars p : para};
var
  q : para;
begin
  while p<>nill do
    [q:=p; p:=q^.link; dispara(q)];
end {disparas};

procedure newhead{var h : mailhead};
begin
  new(h);
  h^.head_link:=nil;
  h^.text_first:=nill; h^.text_last:=nill;
  h^.index:=0; h^.deleted:=false;
end {newhead};

procedure dishead{h : mailhead};
begin
  if h<>nil then
    [h^.text_first:=nill; h^.text_last:=nill;
     h^.index:=0; h^.deleted:=false;
     dispose(h)];
end {dishead};

function date2jd{consts dd : string}  {integer4};
var
  c,ya : integer4;
  month,day,year,temp : integer;
  w : word;
begin
{get raw date}
  month:=(ord(dd[1])-ord('0'))*10 + (ord(dd[2])-ord('0'));
  day  :=(ord(dd[4])-ord('0'))*10 + (ord(dd[5])-ord('0'));
  year :=(ord(dd[7])-ord('0'))*10 + (ord(dd[8])-ord('0'));
{deal with non-American dates}
  w := date_format;
  if LOBYTE(w)>0 then [temp:=month; month:=day; day:=temp];
  if LOBYTE(w)>1 then [temp:=year; year:=day; day:=temp];
{process}
  if year>=80
    then year:=year+1900
    else year:=year+2000;
  if month > 2 then
    month := month - 3
  else begin
    month := month + 9;  year := year - 1;
  end {else};
  c := year div 100;
  ya := year mod 100;
  date2jd := ((146097*c) div 4) + ((1461*ya) div 4) +
             ((153*month + 2) div 5) + day + 1721119;
end {date2jd};

function time2secs{const tt : string}  {integer4};
var
  secs : integer4;
begin
  if tt[1]>='0' and then tt[1]<='9' then
    [secs:=(ord(tt[1])-ord('0'))*10 + (ord(tt[2])-ord('0'));
     secs:=secs*60+((ord(tt[4])-ord('0'))*10 + (ord(tt[5])-ord('0')));
     secs:=secs*60+((ord(tt[7])-ord('0'))*10 + (ord(tt[8])-ord('0')))]
  else
    secs:=0;
  time2secs:=secs;
end {time2secs};

function copy_of(p : para) : para;
var
  p1,p2 : para;
begin
  copy_of := nill;
  p1:=nill;
  while p<>nill do begin
    p2:=newpara(p^.msg);
    p2^.amper:=p^.amper; p2^.crlfs:=p^.crlfs;
    if p1=nill
      then copy_of:=p2
      else p1^.link:=p2;
    p1:=p2;
    p:=p^.link;
  end {while};
end {copy_of};

procedure replace{vars big_s:lstring; consts little_s:lstring;
                  pos,xlen : integer};
{big_s is the string to be modified.  little_s is the new string
 to be inserted into big_s at character position pos, replacing the
 next xlen characters to be found there.}
var
  little_len,delta,freight,new_len : integer;
begin
  if pos<1 or else pos>ord(big_s.len) or else xlen<0 then return;
  if xlen+pos-1 > ord(big_s.len) then xlen := ord(big_s.len)-pos+1;
  little_len:=ord(little_s.len);
  delta:=little_len-xlen;
  if delta<>0 then begin
    freight:=ord(big_s.len)-pos-xlen+1;
    new_len:=ord(big_s.len)+delta;
    if new_len>UPPER(big_s) then
      [freight:=freight-(new_len-UPPER(big_s));
       new_len:=UPPER(big_s)];
    if delta>0 then big_s.len:=wrd(new_len);
    if freight>0 then
      [if delta>0 then {shift right}
         movesr(ads big_s[pos+xlen],ads big_s[pos+little_len],wrd(freight))
       else {shift left}
         movesl(ads big_s[pos+xlen],ads big_s[pos+little_len],wrd(freight))];
    if delta<0 then big_s.len:=wrd(new_len);
  end {if};
  if pos+little_len>UPPER(big_s) then
    little_len:=UPPER(big_s)-pos+1;
  if little_len>0 then
    [if pos+little_len-1>ord(big_s.len) then big_s.len:=wrd(pos+little_len-1);
     movesl(ads little_s[1],ads big_s[pos],wrd(little_len))];
end {replace};

{evaluate if condition}
{truth value of s[i1..i2-1] op s[i2..i3]}
function tvalue(consts s : lstring; i1,i2,i3 : integer; op : char) : boolean;
var
  s0,s1,s2 : lstring(screen_cols div 2);
  j,k : integer;
  j4,k4 : integer4;
begin
  if i1=0 or else i3=0 then [tvalue:=false; return];
  if i2=0 then {no operator}
    [tvalue := (scanne(i3-i1+1,' ',s,i1) < i3-i1+1);
     return];
  s0.len := wrd(i2-i1+1);
  if s0.len > UPPER(s0) then s0.len:=UPPER(s0);
  if s0.len > 0 then movesl(ads s[i1],ads s0[1],s0.len);
  stripx(s0,s1);
  s0.len := wrd(i3-i2+1);
  if s0.len > UPPER(s0) then s0.len:=UPPER(s0);
  if s0.len > 0 then movesl(ads s[i2],ads s0[1],s0.len);
  stripx(s0,s2);
  if op=':' then
    [for j:=1 to ord(s1.len) do s1[j]:=uc(s1[j]);
     for j:=1 to ord(s2.len) do s2[j]:=uc(s2[j]);
     tvalue := (positn(s2,s1,1) > 0)]
  else if decode(s1,j4) and then decode(s2,k4) then
    case op of
      '<' : tvalue := (j4 < k4);
      '=' : tvalue := (j4 = k4);
      '#' : tvalue := (j4 <> k4);
      '>' : tvalue := (j4 > k4);
      otherwise tvalue:=false;
    end {case}
  else begin
    if s1.len < s2.len then k:=ord(s1.len) else k:=ord(s2.len);
    for j:=1 to k do
      if uc(s1[j]) < uc(s2[j]) then
        [tvalue := (op = '<'); return]
      else if uc(s1[j]) > uc(s2[j]) then
        [tvalue := (op = '>'); return];
    case op of
      '<' : tvalue := (s1.len < s2.len);
      '=' : tvalue := (s1.len = s2.len);
      '>' : tvalue := (s1.len > s2.len);
    end {case};
  end {else};
end {tvalue};

{expand ampersand codes}
function substitute{vars s : lstring} {boolean};
var
  i,j : integer;
  str : lstring(screen_cols);
  delta : integer;
  c1,c2 : char;
  if1,if2 : integer;
  ifop : char;
  skipmode : boolean;
begin
  substitute:=true;
  if1:=0; if2:=0; ifop:=' '; skipmode:=false;
  i:=1;
  while i<=ord(s.len)-2 do begin
    i:=i+scaneq(ord(s.len),'&',s,i);
    if i>ord(s.len)-2 then break;
    c1:=s[i+1]; c2:=uc(s[i+2]);
    if c1='-' and then c2='-' then {comment}
      [s.len:=wrd(i-1); break];
{if statement}
    if c1='?' then begin
      if c2='(' then
        [if1:=i; replace(s,null,i,3); cycle]
      else if c2='<' or else c2='=' or else c2='>' or else
              c2='#' or else c2=':' then
        [ifop:=c2; if2:=i; replace(s,null,i,3); cycle]
      else if c2='T' and then if1>0 then
        [skipmode:=not tvalue(s,if1,if2,i-1,ifop);
         replace(s,null,if1,i-if1+3); i:=if1; if2:=i;
	 cycle]
      else if c2='E' then
        [if skipmode and then if1>0
           then [replace(s,null,if1,i-if1+3); i:=if1]
	   else replace(s,null,i,3);
         skipmode:=not skipmode; if2:=i; cycle]
      else if c2=')' then
        [if skipmode and then if2>0
           then [replace(s,null,if2,i-if2+3); i:=if2]
           else replace(s,null,i,3);
         if1:=0; if2:=0; ifop:=' ';
         skipmode:=false; cycle]
    end {if};
{normal ampersand code}
    if not skipmode and then funx(i,c1,s[i+2],str) then
      [if UPPER(s)=screen_cols then
         [if i+ord(str.len)-1>UPPER(s) or else
             s.len+str.len-3>wrd(UPPER(s)) then
            [substitute:=false; return]]
       else
         [if i+ord(str.len)-1>UPPER(s) then
            [substitute:=false; str.len:=wrd(UPPER(s)-i+1)];
          if s.len+str.len-3>wrd(UPPER(s)) then
            [substitute:=false; s.len:=wrd(UPPER(s))-str.len+1]];
       if c2='&' then delta:=1 else delta:=0;
       replace(s,str,i,3); i:=i+ord(str.len)-delta]
    else i:=i+1;
  end {while};
end {substitute};

procedure expand_tabs{vars s : lstring};
const
  tsiz = 8;
var
  i,j : integer;
  str : lstring(tsiz);
begin
  i:=1;
  while i<=ord(s.len) do begin
    i:=i+scaneq(ord(s.len),tab,s,i);
    if i>ord(s.len) then break;
    j:=tsiz-((i-1) mod tsiz);
    str.len:=wrd(j); fillc(adr str[1],wrd(j),' ');
    if i+ord(str.len)-1>UPPER(s) then str.len:=wrd(UPPER(s)-i+1);
    if s.len+str.len-1>wrd(UPPER(s)) then s.len:=wrd(UPPER(s))-str.len+1;
    replace(s,str,i,1);
    i:=i+ord(str.len);
  end {while};
end {expand_tabs};

{expand ampersand functions, making a copy of p as we go}
function zip{p : para} {para};
var
  p1,p2 : para;
  long_s : lstring(long_line);
begin
  macro_depth:=0;
  zip:=nill;
  p1:=nill;
  while p<>nill do begin
    init_fx;
    if p^.msg.len<3 or else
       scaneq(ord(p^.msg.len),'&',p^.msg,1)=ord(p^.msg.len) then
      p2:=newpara(p^.msg)
    else if p^.msg.len>screen_cols-10 then
      [copylst(p^.msg,long_s); eval(substitute(long_s));
       p2:=newpara(long_s)]
    else
      [p2:=newpara(p^.msg);
       if not substitute(p2^.msg) then
         [copylst(p^.msg,long_s); eval(substitute(long_s));
          if long_s.len>screen_cols then long_s.len:=screen_cols;
          copylst(long_s,p2^.msg)]];
    p2^.amper:=p^.amper; p2^.crlfs:=p^.crlfs;
    if p1=nill
      then zip:=p2
      else p1^.link:=p2;
    p1:=p2;
    p:=p^.link;
  end {while};
end {zip};

procedure make_number{consts s1 : string; var s2 : lstring};
var
  i,j : integer;
begin
 j:=0;
 for i:=1 to UPPER(s1) do
   if s1[i]>='0' and then s1[i]<='9' and then j<UPPER(s2) then
     [j:=j+1; s2[0]:=chr(j); s2[j]:=s1[i]];
end {make_number};

procedure crc_16{c : char; var crc_value : word};
{Computes a 16-bit circular redundancy check.  Initialize the global
 crc_value to 0, then call this routine for each byte.}
begin
  crc_value := crc_value xor (wrd(c)*256);
  for var i := 1 to 8 do
    if not umulok(crc_value,2,crc_value) then {hi bit was a 1}
      crc_value := crc_value xor 16#1021; {X^15+X^12+X^5+1}
end {crc_16};
  
function crc_ls{consts s : string} {word};
var
  w : word;
  i : integer;
begin
  w:=0;
  for i:=1 to UPPER(s) do
    crc_16(s[i],w);
  crc_ls:=w;
end {crc_ls};

procedure encrypt{var s : lstring};
var
  i : integer;
  crc1,crc2 : word;
begin
  while s.len>0 and then s[ord(s.len)]=' ' do s.len:=s.len-1;
  crc1:=1; crc2:=0;
  for i:=1 to ord(s.len) do
    if odd(i)
      then crc_16(s[i],crc1)
      else crc_16(s[i],crc2);
  s.len:=4;
  s[1]:=chr(32+(crc1 mod 95)); crc1:=crc1 div 95;
  s[2]:=chr(32+(crc1 mod 95));
  s[3]:=chr(32+(crc2 mod 95)); crc2:=crc2 div 95;
  s[4]:=chr(32+(crc2 mod 95));
end {encrypt};

function eq{consts s1,s2 : string} {boolean};
{extra trailing blanks on either string are ignored; case ignored}
var
  i,limit : integer;
begin
  eq:=false;
  limit:=UPPER(s1); if UPPER(s2)>limit then limit:=UPPER(s2);
  for i:=1 to limit do
    if i<=UPPER(s1) then
      [if i<=UPPER(s2) then
         [if uc(s1[i])<>uc(s2[i]) then return]
       else
         [if s1[i]<>' ' then return]]
    else
      [if s2[i]<>' ' then return];
  eq:=true;
end {eq};
  
function eq2{consts s1,s2 : string} {boolean};
{compare stops at end of s2; case ignored}
var
  i : integer;
begin
  eq2:=false;
  for i:=1 to UPPER(s2) do
    if i<=UPPER(s1) then
      [if uc(s1[i])<>uc(s2[i]) then return]
    else
      [if s2[i]<>' ' then return];
  eq2:=true;
end {eq2};
  
function eq3{consts s1,s2 : string} {boolean};
{strings must be exactly equal, including case}
var
  i : integer;
begin
  eq3:=false;
  if UPPER(s1)<>UPPER(s2) then return;
  for i:=1 to UPPER(s2) do
    if s1[i]<>s2[i] then return;
  eq3:=true;
end {eq3};

procedure prompt_with{pa : para};
begin
  if pa=nill or else w^[wx].output<>nill then
    return;
  w^[wx].node_type:=nt_prompt;
  if pa^.amper
    then w^[wx].output:=zip(pa)
    else w^[wx].output:=pa;
  w^[wx].crud:=pa^.amper;
end {prompt_with};

procedure display{pa : para};
begin
  if pa=nill or else w^[wx].output<>nill then
    return;
  w^[wx].node_type:=nt_display;
  if pa^.amper
    then w^[wx].output:=zip(pa)
    else w^[wx].output:=pa;
  w^[wx].crud:=pa^.amper;
end {display};

function string_question{consts s : string; var target : string} {boolean};
var
  pruning : boolean;
  i,j : integer;
begin
  pruning:=true; j:=1;
  for i:=1 to UPPER(s) do
    [if pruning then
       [if s[i]<=' ' then cycle else pruning:=false];
     if s[i]<' ' then cycle;
     if j>UPPER(target) then break;
     target[j]:=s[i]; j:=j+1];
  for i:=j to UPPER(target) do target[i]:=' ';
  string_question:=(target[1]<>' ');
end {string_question};

{agree yes/no.  default = yes}
function agree{consts s : string} {boolean};
begin
  if UPPER(s)=0
    then agree:=true
    else agree:=(uc(s[1])<>mn[1][2]); {N}
end {agree};

{agree yes/no.  default = no}
function nagree{consts s : string} {boolean};
begin
  if UPPER(s)=0
    then nagree:=false
    else nagree:=(uc(s[1])=mn[1][1]); {Y}
end {nagree};

function number_question{consts s : lstring;
                         lo,hi : integer; var target : string;
                         var i : integer} {boolean};
var
  str : lstring(long_line);
begin
  i:=0;
  if decode(s,i) and then
     (i>=lo) and then
     (i<=hi) and then
     encode(str,i:UPPER(target)) then
    [kopystr(str,target); number_question:=true]
  else
    number_question:=false;
end {number_question};

function number_query{consts s : lstring;
                      lo,hi : integer; var i : integer} {boolean};
begin
  i:=-1;
  if decode(s,i) and then
     (i>=lo) and then
     (i<=hi) then
    number_query:=true
  else
    number_query:=false;
end {number_query};

{s can be either a line number or a file number.  return true
 if it's ok (minimally) to bother that line, and set line variable.
 prefer file number over a line number}
function ok2bother{consts s : lstring; var line : integer} {boolean};
var
  i : integer;
begin
  line:=-1; ok2bother:=false;
  if decode(s,line) then
    [i:=on_line(line);
     if i>=0 then
       [line:=i;
        ok2bother:=true]
     else if q[wx].level=9    and then
    	line>=0               and then
    	line<=number_of_lines and then
        w^[line].active       and then
	w^[line].state=going  and then
        q[line].state<snip    then
       ok2bother:=true];
end {ok2bother};

function ivalue{const s : string} {integer};
var
  ls : lstring(30);
  i : integer;
begin
  kopylst(s,ls);
  if decode(ls,i)
    then ivalue:=i
    else ivalue:=-1;
end {ivalue};

function hvalue{consts s : string} {integer};
{convert height to inches}
var
  ls : lstring(10);
  last : char;
  i,ftx,inx,feet,inches : integer;
begin
  hvalue:=-1;
  if UPPER(s)<2 or else UPPER(s)>5 then return;
  copylst(s,ls);
  if metric then
    [if decode(ls,i) and then i>100 and then i<260 {centimeters}
       then hvalue:=(50*i) div 127; {convert to inches}
     return];
  ftx:=0; inx:=0; last:=' ';
  for i:=1 to UPPER(s) do
    case s[i] of
      '''' : [ftx:=i; last:=''''];
      '"'  : [inx:=i; last:='"'];
      '0'..'9' : last:=s[i];
      ' ' : ;
      otherwise return;
    end {case};
  if ftx=0 then return;
  kopylst(s,ls); ls.len:=wrd(ftx-1);
  if not decode(ls,feet) then return;
  if inx=0 and then ((last>='0') and (last<='9')) then
    inx:=UPPER(s)+1;
  if inx=0 and then (last='''') then
    inches:=0
  else if inx-ftx-1>=1 then
    [kopylst(s,ls); ls.len:=wrd(inx-1); delete(ls,1,ftx);
     if not decode(ls,inches) then return]
  else
    return;
  if (feet in [2..7]) and then (inches in [0..11]) then
    hvalue:=12*feet+inches;
end {hvalue};

{concatenate separated by one blank}
procedure cat{vars ls : lstring; consts s : string};
var
  i,j : integer;
begin
  while true do begin
    i:=ord(ls.len);
    if i=0 then break;
    if ls[i]<>' ' then break;
    ls.len:=wrd(i-1);
  end {while};
  i:=i+1; ls.len:=wrd(i); ls[i]:=' ';
  for j:=1 to UPPER(s) do begin
    i:=i+1; ls.len:=wrd(i); ls[i]:=s[j];
    if i=UPPER(ls) then break;
  end {for};
  while true do begin
    i:=ord(ls.len);
    if i=0 then break;
    if ls[i]<>' ' then break;
    ls.len:=wrd(i-1);
  end {while};
end {cat};

{copy to/from/subject/date to q fields}
function crakhdr{p : para} {boolean};
begin
  crakhdr:=true;
  if p^.msg.len>ss[20].len+2 and then
     p^.msg[ss[20].len+1]=':' and then
     eq2(p^.msg,ss[20]) then {To}
    [kopylst(p^.msg,q[wx].msg_to^.msg);
     delete(q[wx].msg_to^.msg,1,ord(ss[20].len+2))]
  else if p^.msg.len>ss[21].len+2 and then
	  p^.msg[ss[21].len+1]=':' and then
	  eq2(p^.msg,ss[21]) then {From}
    [kopylst(p^.msg,q[wx].msg_from^.msg);
     delete(q[wx].msg_from^.msg,1,ord(ss[21].len+2))]
  else if p^.msg.len>ss[22].len+2 and then
	  p^.msg[ss[22].len+1]=':' and then
	  eq2(p^.msg,ss[22]) then {Subject}
    [kopylst(p^.msg,q[wx].msg_subject^.msg);
     delete(q[wx].msg_subject^.msg,1,ord(ss[22].len+2))]
  else if p^.msg.len>ss[23].len+2 and then
	  p^.msg[ss[23].len+1]=':' and then
	  eq2(p^.msg,ss[23]) then {Date}
    [kopylst(p^.msg,q[wx].msg_date^.msg);
     delete(q[wx].msg_date^.msg,1,ord(ss[23].len+2))]
  else
    crakhdr:=false;
end {crakhdr};

procedure parse_header{p : para};
var
  i,j : integer;
  str : lstring(long_line);
begin
  if q[wx].msg_from=nill
    then q[wx].msg_from:=newpara(null)
    else q[wx].msg_from^.msg:=null;
  if q[wx].msg_to=nill
    then q[wx].msg_to:=newpara(null)
    else q[wx].msg_to^.msg:=null;
  if q[wx].msg_date=nill
    then q[wx].msg_date:=newpara(null)
    else q[wx].msg_date^.msg:=null;
  if q[wx].msg_subject=nill
    then q[wx].msg_subject:=newpara(null)
    else q[wx].msg_subject^.msg:=null;
  if p<>nill then
    while p^.msg<>null and then crakhdr(p) do
      p:=p^.link;
  fillc(adr q[wx].your,member_length,' ');
  if q[wx].msg_from=nill or else q[wx].msg_from^.msg=null then
    q[wx].correspondent:=0
  else
    [kopylst(q[wx].msg_from^.msg,str);
     for i:=ord(str.len) downto 1 do
       if str[i]=' ' then [delete(str,1,i); break];
     if not decode(str,q[wx].correspondent) then q[wx].correspondent:=0];
end {parse_header};

procedure prepare_header;
var
  p : para;
  str : lstring(screen_cols);
begin
  p:=newpara(ss[21]); concat(p^.msg,': '); {From: }
  konkat(p^.msg,q[wx].my.name); cat(p^.msg,q[wx].my.userid);
  q[wx].msg_first:=p; q[wx].msg_last:=p;
  p:=newpara(ss[20]); concat(p^.msg,': ');
  konkat(p^.msg,q[wx].your.name); cat(p^.msg,q[wx].your.userid);
  q[wx].msg_last^.link:=p; q[wx].msg_last:=p;
  p:=newpara(ss[23]); concat(p^.msg,': '); {Date: }
  konkat(p^.msg,mydate); cat(p^.msg,mytime);
  q[wx].msg_last^.link:=p; q[wx].msg_last:=p;
end {prepare_header};

function get_answer{c : char; p : para} {para};
var
  p2 : para;
begin
  get_answer:=nill;
  if not (c in ['A'..'Y']) then return;
  while true do begin
    if p=nill then return;
    if p^.msg.len>=7 and then p^.msg[1]=' ' and then
       p^.msg[4]=c and then p^.msg[5]='.' then break;
    p:=p^.link;
  end {while};
  p2:=newpara(p^.msg);
  delete(p2^.msg,1,6);
  get_answer:=p2;
end {get_answer};

procedure mbx{const path,id : string; var str : lstring};
var
  i : integer;
  str2 : lstring(10);
begin
  kopylst(path,str);
  kopylst(id,str2); eval(decode(str2,i)); eval(encode(str2,i:5));
  for i:=1 to 5 do if str2[i]=' ' then str2[i]:='0';
  konkat(str,str2);
end {mbx};

function on_line{uid : integer} {integer};
var
  i : integer;
begin
  on_line:=-1;
  for i:=0 to number_of_lines do
    if w^[i].active and then
       w^[i].state=going and then
       q[i].logged_in and then
       q[i].userid=uid then
      [on_line:=i; break];
end {on_line};

procedure notify{i : integer; p : para};
var
  p2 : para;
  k : integer;
begin
  if p=nill or else w^[i].state<>going or else
     q[i].state in [libr_transfer..libr_post_up,snip..dummy] then return;
  if w^[i].bulletin=nill then
    w^[i].bulletin:=zip(p)
  else
    [p2:=w^[i].bulletin; k:=1;
     while p2^.link<>nill do [p2:=p2^.link; k:=k+1];
     if k<=notify_max then p2^.link:=zip(p)];
end {notify};

{'setct' is true if a true time check will result in immediate bumpage}
function time_check{setct : boolean} {boolean};
var
  i4 : integer4;
  i,j,time2day : integer;
  fl : boolean;
begin
  time_check:=false;
  if wx=0 then return;
  i4:=jt-w^[wx].connect_sec0;
  if i4<0 then i4:=i4+one_day;
  q[wx].minutes_on:=ord(i4 div 60);
  time2day := q[wx].minutes_on + q[wx].minutes_2day;
  time_check := (time2day > time_limit[q[wx].level]);
  if nBump>0 then begin
    if q[wx].level<privnbm and then time2day>bumpmax then
      [time_check:=true; if setct then bumpct1:=bumpct1+1]
    else
      [j:=0;
       for i:=1 to number_of_lines do
         if w^[i].active and then
            ((w^[i].state<>going) or (q[i].state>=snip)) then
	   [j:=j+1; if j>=nBump then [time_check:=false; break]];
       if result(time_check) and then setct then bumpct2:=bumpct2+1];
  end {if nBump};
end {time_check};

function filename_ok{consts s : string} {boolean};
var
  dot,i : integer;
  front : lstring(8);
begin
  filename_ok:=false;
{enforce 8.3 filenames}
  if UPPER(s)=0 or else UPPER(s)>12 then return;
  if not (s[1] in fileset) then return;
  dot:=0;
  for i:=1 to UPPER(s) do
    if s[i]='.' then
      [if dot>0 then return;
       dot:=i]
    else if not (s[i] in fileset) then
      return;
  if dot>9 then return;
  if dot>0 and then UPPER(s)-dot>3 then return;
  if dot=0 and then UPPER(s)>8 then return;
{check for reserved filenames}
  if dot=0 then front.len:=wrd(UPPER(s)) else front.len:=wrd(dot-1);
  for i:=1 to ord(front.len) do front[i] := uc(s[i]);
  if eq(front,'CON')  or else eq(front,'AUX')  or else
     eq(front,'COM1') or else eq(front,'COM2') or else
     eq(front,'LPT1') or else eq(front,'PRN')  or else
     eq(front,'LPT2') or else eq(front,'LPT3') or else
     eq(front,'NUL')  or else eq(front,'USER') or else
     eq(front,'LIST') or else eq(front,'ERR') or else
     eq(front,'CLOCK$') then return;
  filename_ok:=true;
end {filename_ok};

function mult_open{vars filename : lstring; zfix : integer} {integer};
{opens a file for writing
 returns file handle number or negated dos error code
  zfix=0 => use mail_zopen (zaps control-z's)
  zfix=1 => use mail_open (straight append) }
var
  i : integer;
begin
  if filename=null then
    [mult_open:=2; q[wx].dos_err:=2; {file not found} return];
  for i:=0 to number_of_lines do
    if i<>wx and then w^[i].file_locked<>nill and then
       eq(filename,w^[i].file_locked^.msg) then
      [mult_open:=-1; q[wx].dos_err:=-1; {lock error} return];
  case zfix of
    0 : i:=mail_zopen(filename);
    1 : i:=mail_open(filename);
  end {case};
  if i>0 then
    [if w^[wx].file_locked=nill
       then w^[wx].file_locked:=newpara(filename)
       else kopylst(filename,w^[wx].file_locked^.msg);
     w^[wx].rw:=writing]
  else
    q[wx].dos_err:=-i;
  mult_open:=i;
end {mult_open};

procedure init_q;
begin
  fillc(adr q[wx].my,member_length,' ');
  fillc(adr q[wx].your,member_length,' ');
  q[wx].low_age:=0; q[wx].high_age:=maxint;
  q[wx].last_called:=maxint;
  q[wx].least_times:=1;
  q[wx].match_gender[1]:=mn[2][3] {B}; q[wx].match_pref[1]:=mn[3][4] {A};
  q[wx].bflag:=false; q[wx].bindex:=0; q[wx].flag:=false; q[wx].index:=0;
  q[wx].count:=0;
  q[wx].msg_first:=nill; q[wx].msg_last:=nill; q[wx].msg_ptr:=nill;
  q[wx].verify_data:=nill; q[wx].send_line_count:=0;
  q[wx].mbx_first:=nil; q[wx].mbx_last:=nil; q[wx].mbx_ptr:=nil;
  q[wx].correspondent:=0; q[wx].handle:=0; q[wx].current_msg:=0;
  q[wx].msg_to:=nill; q[wx].msg_from:=nill; q[wx].hold_target:=0;
  q[wx].msg_date:=nill; q[wx].msg_subject:=nill;
  q[wx].holding:=false; q[wx].pm:=nil; q[wx].direction:=1;
  q[wx].qs:=nil; q[wx].qa:=nill; q[wx].qr:=0; q[wx].es:=nil;
  q[wx].pub_msg:=nill; q[wx].bio_msg:=nill; q[wx].bio_msg_last:=nill;
  q[wx].mail_io_error:=false; q[wx].paging_beeps:=0;
  q[wx].pathname:=null; q[wx].filename:=null; q[wx].count4:=0;
  q[wx].state2:=0; q[wx].dos_err:=0; q[wx].xstr:=nill; q[wx].mail_mod:=false;
  q[wx].group_chat:=false; q[wx].squelch:=0; q[wx].callno:=number_of_calls+1;
  q[wx].xover:=false; q[wx].xfermode:=fAscii;
  q[wx].buffer:=RETYPE(bpara,nill); q[wx].channel:=0;
end {init_q};

function disk2u{i : integer} {boolean};
var
  j : integer;
begin
  j:=on_line(i);
  if j>=0 then
    [movel(adr q[j].my,adr q[wx].your,member_length);
     disk2u:=true]
  else
    [if dbg_member(i,q[wx].your)
       then disk2u:=(q[wx].your.active='T')
       else disk2u:=false];
end {disk2u};

procedure strout{row,col:integer;consts msg:lstring};
var
 limit : integer;
begin
  limit:=ord(msg.len);
  if limit>screen_cols-col then limit:=screen_cols-col;
  movesl2(ads msg[1],ads screen_ptr^[row,col].character,wrd(limit));
end {strout};

procedure scrollu{top,bot,attr,lines : integer};
begin
  if w^[wx].onscreen then
    scrollup(top*256,bot*256+scm1,attr,lines);
end {scrollu};

{is someone in group chat?}
function gc{line : integer} {boolean};
begin
  if w^[line].active and then
     w^[line].state=going and then
     q[line].logged_in and then
     q[line].group_chat and then
     w^[line].chat=-1
  then gc:=true else gc:=false;
end {gc};

{leave group chat}
procedure sayanora;
var
  i : integer;
  p : para;
begin
  disparas(q[wx].xstr);
  if q[wx].group_chat and then q[wx].userid>=log_lowest then
    for i:=0 to number_of_lines do
      if i<>wx and then gc(i) and then q[wx].channel=q[i].channel
        then notify(i,old_txt);
  setwrap(w^[wx].wrapat);
  q[wx].group_chat:=false;
  q[wx].channel:=0;
end {sayanora};

procedure setwrap{col : integer};
begin
  if wx=0
    then wrap0:=wrd(col)
    else wrap(col-5);
end {setwrap};

procedure newstat{line,col,att:integer;const msg:string};
{COL IS ZERO ORIGIN}
var
  i,limit : integer;
begin
  if UPPER(msg)=0 then
    [for i:=col+1 to screen_cols do
       [w^[line].stat_char^.msg[i]:=' ';
        w^[line].stat_attr^.msg[i]:=chr(att)];
     w^[line].stat_char^.msg.len:=wrd(col)]
  else begin
    limit:=UPPER(msg);
    if col+limit > screen_cols then
      limit:=screen_cols-col;
    if w^[line].stat_char^.msg.len<wrd(col+limit) then
      w^[line].stat_char^.msg.len:=wrd(col+limit);
    for i:=1 to limit do
      [w^[line].stat_char^.msg[col+i]:=msg[i];
       w^[line].stat_attr^.msg[col+i]:=chr(att)];
  end {if};
  if w^[line].onscreen then
    [if UPPER(msg)=0 then
       scrollup(w^[line].stat*256+col,w^[line].stat*256+scm1,att,0)
     else
       for i:=col+1 to col+limit do
         [screen_ptr^[w^[line].stat,i-1].character:=w^[line].stat_char^.msg[i];
          screen_ptr^[w^[line].stat,i-1].atrb:=w^[line].stat_attr^.msg[i]]];
end {newstat};

procedure status_line{line : integer};
var
  i,temp : integer;
  p,p2 : para;
begin
{from point of view of line}
  temp:=wx; wx:=line;
  p:=zip(sta_txt);
  wx:=temp;
{do status line}
  temp:=ord(w^[line].stat_char^.msg.len);
  if p<>nill and then (not eq3(p^.msg,w^[line].stat_char^.msg)) then
    [kopylst(p^.msg,w^[line].stat_char^.msg);
     if q[line].paging_beeps>0 then
       w^[line].stat_char^.msg.len:=wrd(temp);
     if w^[line].onscreen then
       strout(w^[line].stat,0,w^[line].stat_char^.msg)];
  disparas(p);
end {status_line};

var gsline : lstring(screen_cols);
value gsline := null;

procedure gstat_line;
var
  p,p2 : para;
  i : integer;
begin
  p:=zip(gst_txt);
  if p<>nill and then (not eq3(p^.msg,gsline)) then
    [kopylst(p^.msg,gsline);
     if screen_ptr^[gstat,0].atrb<>chr(gattr) then
       for i:=0 to scm1 do screen_ptr^[gstat,i].atrb:=chr(gattr);
     strout(gstat,0,gsline)];
  disparas(p);
end {gstat_line};

procedure stripx{consts s1 : string; vars s2 : lstring};
var
  first_nb,last_nb,i,limit : integer;
begin
  first_nb:=0;
  last_nb:=0;
  limit:=UPPER(s1);
  if limit>ord(UPPER(s2)) then
    limit:=UPPER(s2);
  s2[0]:=chr(limit);
  for i:=1 to limit do begin
    s2[i]:=s1[i];
    if s1[i]<>' ' then begin
      last_nb:=i;
      if first_nb=0 then first_nb:=i;
    end {if};
  end {for};
  s2[0]:=chr(last_nb);
  if first_nb>1 then delete(s2,1,first_nb-1);
end {stripx};

procedure myid;
var
  p,p2 : para;
begin
  p:=w^[wx].output;
  if p=nill then return;
  while p^.link<>nill do p:=p^.link;
  p2:=newpara(null); p^.link:=p2; p:=p2;
  p2:=newpara(es1);  p^.link:=p2; p:=p2;
  p2:=newpara(es2);  p^.link:=p2;
end {myid};

function dir{const s : string; attr : byte} {para};
var
  j : byte;
  str : lstring(24);

  procedure copyit; {fill str with filename}
  var
    i4 : integer4;
    str2 : lstring(12);
  begin
    str.len:=20; fillc(adr str[1],20,' ');
    for var i:=31 to 42 do
      if w^[wx].strx[i]=chr(0)
        then break
        else str[i-30]:=w^[wx].strx[i];
    if (wrd(w^[wx].strx[22]) and 16#10)=0 then
      [movesl(ads w^[wx].strx[27],ads i4,4);
       if encode(str2,i4:8) then
         movel(adr str2[1],adr str[13],8)]
    else
      [movel(adr ss[14][1],adr str[14],ss[14].len); {<DIR>}
       str.len:=13+ss[14].len];
  end;

begin
  dir:=nill;
  set_dta(ads w^[wx].strx[1]);
  while true do begin
    if attr>0
      then j:=find_first(adr s[1],attr)
      else j:=find_next;
    if j=0 then
      [copyit;
       if str[1]='.'
         then [attr:=0; cycle]
         else dir:=newpara(str)];
    return;
  end {while};
end {dir};

function see_pub {boolean};
begin
  see_pub := false;
  if q[wx].level=9 then [see_pub:=true; return];
  if q[wx].level<ord(q[wx].pm^.minlevr) then return;
  if q[wx].level>ord(q[wx].pm^.maxlev) then return;
  if business then [see_pub:=true; return];
{not business}
  if ivalue(q[wx].my.age) < ord(q[wx].pm^.minage) or else
     ivalue(q[wx].my.age) > ord(q[wx].pm^.maxage) then return;
  if q[wx].pm^.gender<>mn[2][3] {B} and then
     q[wx].pm^.gender<>q[wx].my.gender[1] then return;
  if q[wx].pm^.pref<>mn[3][4] {A} and then
     q[wx].my.pref[1]<>mn[3][2] {B} and then
     q[wx].pm^.pref<>q[wx].my.pref[1] then return;
  see_pub := true;
end {see_pub};

procedure ret2dos{errlev : integer};
begin
  doseqq := wrd(errlev);
  endxqq;
end;

{shutting down for so many minutes}
procedure shut_down{minutes : integer};
begin
  q[wx].count:=minutes;
  shutdown_mode:=true;
  shutdown_time:=ord(jt div 60)+10;
  if shutdown_time>=(24*60) then shutdown_time:=shutdown_time-(24*60);
  nBump:=0;
  for var i:=0 to number_of_lines do
    if w^[i].active then
      [if w^[i].state=going and then q[i].state<snip then
         notify(i,shutdown_txt)
       else if i>0 then
         [w^[i].reset_count:=0; w^[i].talking_to:=disconnect]]
end {shut_down};

function hard_cr {boolean};
begin
  if wx=0
    then hard_cr:=not kbd_soft
    else hard_cr:=not was_soft;
end {hard_cr};

procedure nth_path{const s : lstring; n : integer; var str : lstring};
var
  i,j : integer;
begin
  str.len:=0;
  i:=0;
  for j:=1 to n-1 do begin
    i:=i+1;
    while i<=ord(s.len) and then s[i]<>';' do i:=i+1;
  end {for};
  if i>=ord(s.len) then return;
  j:=i+1;
  while j<=ord(s.len) and then s[j]<>';' do j:=j+1;
  kopylst(s,str);
  if j<=ord(str.len) then delete(str,j,ord(str.len)-j+1);
  if i>1 then delete(str,1,i);
end {nth_path};

{$debug-}
{$line-}
function rand {word};
begin
  seed:=3125*seed+1;
  rand:=seed and MAXINT;
end {rand};

END.
