/* entry.c */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <alloc.h>
#include <mem.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "twindow.h"
#include "keys.h"

#define FIELDCHAR '_'
int insert_mode=FALSE;
extern int helpkey;
extern unsigned char usemouse;

/* Local prototypes */
extern void pascal print_clock(void);
void pascal addfield(WINDOW *wnd,FIELD *fld);
void pascal data_value(WINDOW *wnd,FIELD *fld);
void pascal insert_status(void);
int pascal read_field(WINDOW *wnd,FIELD *fld);
void pascal right_justify(char *s);
void pascal right_justify_zero_fill(char *s);
int pascal validate_date(char *s);
int pascal endstroke(int c);
int pascal spaces(char *c);

/* Initialize a template */
void pascal init_template(WINDOW *wnd) {

	FIELD *fld,*fl;

	fld=FHEAD;
	while (fld) {
		fl=fld->fnxt;
		free(fld);
		fld=fl;
	}
	FHEAD=NULL;
}

/* Establish a field in a template */
FIELD * pascal establish_field(wnd,cl,rw,msk,bf,ty)
WINDOW *wnd;
int rw;
int cl;
char *msk;
char *bf;
int ty;
{
	FIELD *fld;

	if ((fld=malloc(sizeof(FIELD)))==NULL)
		return NULL;
	fld->fmask=msk;
	fld->frow=rw;
	fld->fcol=cl;
    fld->fbuff=bf;
	fld->ftype=ty;
	fld->fprot=0;
	fld->fnxt=fld->fprv=NULL;
	fld->fvalid=NULL;
	fld->fhelp=NULL;
	fld->fhwin=NULL;
	fld->flx=fld->fly=0;
	addfield(wnd,fld);
	return fld;
}

/* Add a field to the end of the list */
static void pascal addfield(WINDOW *wnd,FIELD *fld) {

	if (FTAIL) {
		fld->fprv=FTAIL;
		FTAIL->fnxt=fld;
	}
	FTAIL=fld;
	if(!FHEAD)
		FHEAD=fld;
}

/* Display a data field */
static void pascal disp_field(WINDOW *wnd,char *bf,char *msk) {

	while (*msk) {
		wputcharaw (wnd,*msk !=FIELDCHAR ? *msk : *bf++);
		msk++;
	}
}

/* Display the data value in a field */
static void pascal data_value(WINDOW *wnd,FIELD *fld) {

	wcursor(wnd,fld->fcol,fld->frow);
	disp_field(wnd,fld->fbuff,fld->fmask);
}

/* Display all the fields in a window */
void pascal field_tally(WINDOW *wnd)
{
	FIELD *fld;

	fld=FHEAD;
	while(fld != NULL) {
		data_value(wnd,fld);
		fld=fld->fnxt;
	}
}

/* Set a field's help window */
void pascal field_window(FIELD *fld,char *hwin,int x,int y) {

    fld->fhwin=hwin;
	fld->flx=x;
	fld->fly=y;
}

/* Clear a template to all blanks */
void pascal clear_template (WINDOW *wnd) {

	FIELD *fld;
	char *bf,*msk;

	fld=FHEAD;
	while (fld != NULL) {
		bf=fld->fbuff;
		msk=fld->fmask;
		while (*msk) {
			if(*msk==FIELDCHAR)
				*bf++=' ';
			msk++;
		}
		fld=fld->fnxt;
	}
	field_tally(wnd);
}

/* Prepare a template to end in blanks */
void pascal prep_template (WINDOW *wnd) {

	FIELD *fld;
	char *bf,*msk;

	fld=FHEAD;
	while (fld != NULL) {
		bf=fld->fbuff;
		msk=fld->fmask;
        while((*bf!=0) && (*msk!=0)) {
			if (*msk!=FIELDCHAR) {
				msk++;
				continue;
			}
            if (*msk==0) {
				break;
			}
			bf++;
			msk++;
		}
		while (*msk) {
			if(*msk==FIELDCHAR)
				*bf++=' ';
			msk++;
		}
        *bf=0;
        fld=fld->fnxt;
	}
	field_tally(wnd);
}

/* Set insert/exchange cursor shape */
static void pascal insert_status() {
	set_cursor_type(insert_mode ? 0x0106 : 0x0607);
}

/* Read a field from the keyboard */
static int pascal read_field (WINDOW *wnd,FIELD *fld) {

	char *mask=fld->fmask,*buff=fld->fbuff;
	int done=FALSE,c,column;

	column=fld->fcol;
	while(*mask!=FIELDCHAR) {
		column++;
		mask++;
	}
	while (TRUE) {
		wcursor(wnd,column,fld->frow);
		c=0;
		SHOWMOUSE;
		CONFINEMOUSE(wnd);
		while(!kbhit()) {
		  if(usemouse) {

                union REGS rg;

				rg.x.ax=3;
				int86(0x33,&rg,&rg);
				move_mouse(rg.x.cx/8,rg.x.dx/8);
				rg.x.ax=5;
                rg.x.bx=0;          /* Check left button */
                int86(0x33,&rg,&rg);
				if(rg.x.bx) {       /* Button pressed */
                    rg.x.cx/=8;     /* Mouse x */
                    rg.x.dx/=8;     /* Mouse y */
					if(rg.x.cx==COL && rg.x.dx==ROW) {
						c=ESC;
						break;
					}
					if(rg.x.dx==ROW && rg.x.cx==COL+WIDTH-1) {
						c=PGUP;
						break;
					}
					if(rg.x.cx==COL && rg.x.dx==ROW+HEIGHT-1) {
						c=PGDN;
						break;
					}
					if(rg.x.cx==COL+WIDTH-1 & rg.x.dx==ROW+HEIGHT-1) {
						c=F10;
						break;
					}
					if(!c) {
						c=get_screen_char(rg.x.cx,rg.x.dx);
						if((c=='-' || c=='X') && toupper(fld->ftype)=='O') {
							if(c=='-') c='X';
							else c='-';
						}
					}
					if(!isdigit(c) && (toupper(fld->ftype)!='O' && toupper(fld->ftype)!='A')) c=0;
					if(c) break;
				}
				rg.x.ax=3;
				int86(0x33,&rg,&rg);
				move_mouse(rg.x.cx/8,rg.x.dx/8);
				rg.x.ax=5;
				rg.x.bx=1;
				int86(0x33,&rg,&rg);
				if(rg.x.bx) {
					c=ESC;
					break;
				}
				rg.x.ax=3;
				int86(0x33,&rg,&rg);
				move_mouse(rg.x.cx/8,rg.x.dx/8);
				rg.x.ax=5;
				rg.x.bx=2;
				int86(0x33,&rg,&rg);
				if(rg.x.bx) {
					c=DN;
					break;
				}
          }
#ifdef USECLOCK
          print_clock();
#endif
		}
		HIDEMOUSE;
		if(!c)c=get_char();
        if(fld->ftype=='A' || fld->ftype=='O') c=toupper(c);
		clear_message();
		switch(c) {
			case '\b':
			case BS:
				if(buff==fld->fbuff) {
					done=c==BS;
					break;
				}
				--buff;
				do {
					--mask;
					--column;
				} while (*mask !=FIELDCHAR);
                if (c==BS) break;
			case DEL:
				if(fld->ftype!='O') {
					movmem(buff+1,buff,strlen(buff));
					*(buff+strlen(buff))=' ';
					wcursor(wnd,column,fld->frow);
					disp_field(wnd,buff,mask);
				}
				break;
			case CTRL_Y:
				strset(buff,' ');
				disp_field(wnd,buff,mask);
				break;
			case CTRL_RIGHT:
                do {
					column++;
					mask++;
					if(*mask==FIELDCHAR)buff++;
				} while(*buff==' ' && *mask);
				if(*mask) {
					do {
						column++;
						mask++;
						if(*mask==FIELDCHAR)buff++;
					}	while(*buff!=' ' && *mask);
				}
				break;
			case CTRL_LEFT:
				if(mask>fld->fmask) {
					do {
						--column;
						--mask;
						if(*mask==FIELDCHAR)--buff;
					} while(*buff==' ' && mask>fld->fmask);
				}
				if(mask>fld->fmask) {
					do {
						--column;
						--mask;
						if(*mask==FIELDCHAR)--buff;
					} while(*buff!=' ' && mask>fld->fmask);
				}
				break;
			case END:
				column=fld->fcol;
				mask=fld->fmask;
				buff=fld->fbuff;
				do {
					column++;
					mask++;
					if(*mask==FIELDCHAR)buff++;
				} while(*mask);
				while(*buff==' ' && mask>fld->fmask) {
					--column;
					--mask;
					if(*mask==FIELDCHAR)--buff;
				}
				if(*buff!=' ') buff++;
				break;
			case HOME:
				column=fld->fcol;
				mask=fld->fmask;
				buff=fld->fbuff;
                while(*mask!=FIELDCHAR) {
                    column++;
                    mask++;
                }
                break;
			case FWD:
				do {
					column++;
					mask++;
				} while(*mask && *mask!=FIELDCHAR);
				buff++;
				break;
			case INS:
				insert_mode ^= TRUE;
				insert_status();
				break;
			case '.':
				if (fld->ftype=='C') {
					if (*mask++ && *buff==' ') {
						*buff++='0';
						if (*mask++ && *buff==' ')
							*buff++='0';
					}
					right_justify(fld->fbuff);
					wcursor(wnd,fld->fcol,fld->frow);
					disp_field(wnd,fld->fbuff,fld->fmask);
					column=fld->fcol+strlen(fld->fmask)-2;
					mask=fld->fmask+strlen(fld->fmask)-2;
					buff=fld->fbuff+strlen(fld->fbuff)-2;
					break;
				}
			default:
				if (endstroke(c)) {
					done=TRUE;
					break;
				}
				if (toupper(fld->ftype)!='A'&&toupper(fld->ftype)!='O'&&!isdigit(c)) {
					error_message("Numbers only");
					break;
				}
				if (toupper(fld->ftype)=='O'&& c!='X') c='-';
                if (insert_mode && fld->ftype!='O') {
					movmem(buff,buff+1,strlen(buff)-1);
					disp_field(wnd,buff,mask);
					wcursor(wnd,column,fld->frow);
				}
				*buff++=c;
				wputcharaw(wnd,c);
				do {
					column++;
					mask++;
				} while(*mask && *mask!=FIELDCHAR);
				if(!*mask)
					c=FWD;
				break;
			}
            if (!*mask) done=TRUE;
			if(done) {
				if(fld->ftype=='D' && c!=ESC && validate_date(fld->fbuff)!=OK) {
				  return ERROR;
				}
				break;
			}
		}
		if(c!=ESC && toupper(fld->ftype)!='A') {
			if(fld->ftype=='C') {
				if(*mask++ && *buff==' ') {
					*buff++='0';
					if(*mask++ && *buff==' ')
						*buff++='0';
				}
			}
            if (fld->ftype=='Z' || fld->ftype=='D') right_justify_zero_fill(fld->fbuff);
            else right_justify(fld->fbuff);
			wcursor(wnd,fld->fcol,fld->frow);
			disp_field(wnd,fld->fbuff,fld->fmask);
		}
		return c;
}

/* Test C for an ending keystroke */
static int pascal endstroke(int c) {

	switch(c) {
		case '\r':
		case '\n':
		case '\t':
		case ESC:
        case ALT_F1:
        case ALT_F2:
        case ALT_F3:
        case ALT_F4:
        case ALT_F5:
        case ALT_F6:
        case ALT_F7:
        case ALT_F8:
        case ALT_F9:
		case ALT_F10:
		case F1:
		case F2:
		case F3:
		case F4:
		case F5:
		case F6:
		case F7:
		case F8:
		case F9:
	    case F10:
		case CTRL_PGUP:
		case CTRL_PGDN:
		case CTRL_END:
		case CTRL_HOME:
		case PGUP:
		case PGDN:
		case HOME:
		case END:
		case UP:
		case DN:
			return TRUE;
		default:
			return FALSE;
	}
}

/* Right justify, space fill */
static void pascal right_justify(char *s)
{
	int len;

	len=strlen(s);

/*	while(*s==' ' || *s=='0' && len) {
*/

	while(*s==' '&& len) {
		len--;
		*s++=' ';
	}

/*
	if(len)
		while(*(s+(len-1)) == ' ') {
			movmem(s,s+1,len-1);
			*s=' ';
		}
*/

}

/* Right justify,zero fill */
static void pascal right_justify_zero_fill(char *s)
{
	int len;

	if(spaces(s))
		return;
	len=strlen(s);
	while(*(s+len-1)==' ') {
		movmem(s,s+1,len-1);
		*s='0';
	}
}

/* Test for spaces */
int pascal spaces(char *c)
{
	while(*c==' ')
		c++;
	return !*c;
}

/* Validate a date */
static int pascal validate_date(char *s)
{
    static char days[]=
		{31,28,31,30,31,30,31,31,30,31,30,31};
    char date[15];
	int mo;

	strcpy(date,s);
	if(spaces(date))
		return OK;
	days[1]=(char)atoi(date+4%4) ? 28:29;
	*(date+4)='\0';
	mo=atoi(date+3);
	*(date+2)='\0';
	if(mo && mo<13 && atoi(date) && (char)atoi(date)<=days[mo-1])
		return OK;
	error_message("Invalid date");
	return ERROR;
}

/* Process data entry for a screen template */
int pascal data_entry (WINDOW *wnd)
{
	FIELD *fld;
	int exitcode,isvalid,done=FALSE,oldhelpkey=helpkey;

	field_tally(wnd);
	fld=FHEAD;
	/* Collect data from keyboard into screen */
	while(fld!=NULL && done==FALSE) {
		set_help(fld->fhwin,fld->flx,fld->fly);
		helpkey=(fld->fhelp) ? 0 : oldhelpkey;
		wcursor(wnd,fld->fcol,fld->frow);
		if(fld->fprot==FALSE) {
			reverse_video(wnd);
			data_value(wnd,fld);
			wcursor(wnd,fld->fcol,fld->frow);
			exitcode=read_field(wnd,fld);
			isvalid=(exitcode != ESC && fld->fvalid) ? (*(fld->fvalid))(fld->fbuff) : OK;
		}
		else {
			exitcode=FWD;
			isvalid=OK;
		}
		if(isvalid == OK) {
			normal_video(wnd);
			data_value(wnd,fld);
			switch(exitcode) {     /* Passed edit */
				case F1:	if (fld->fhelp) {
								(*(fld->fhelp))(fld->fbuff);
								data_value(wnd,fld);
							}
							break;
				case DN:
				case '\r':
				case FWD:	fld=fld->fnxt;
							if(fld==NULL) {
								if (exitcode=='\r') {
									exitcode=F10;
									done=TRUE;
								}
								else fld=FHEAD;
							}
							break;
				case UP:
				case BS:	fld=fld->fprv;
							if(fld==NULL)
								fld=FTAIL;
							break;
				default:	done=endstroke(exitcode);
							break;
			}
		}
    }
	helpkey=oldhelpkey;
	return(exitcode);
}

/* Display a window prompt */
void pascal wprompt(WINDOW *wnd,int x,int y,char *s) {

	wcursor(wnd,x,y);
	wprintfraw(wnd,s);
}

