(*

Psych0's commonly used routines,
 written by various peoples (SWAG is great)


*)

{$ifdef __DOS__}
function shareinstalled : boolean; assembler; asm
  mov ax, 1000h;
  int 02fh;
  xor ah, ah;
  and al, 0ffh;
  end;
{$else}
 {$ifdef __os2__}
 const
 shareinstalled = true;
 {$endif} { __os2__ }
{$endif} { __dos__ }


{$ifdef __dos__}
FUNCTION Empty( s: STRING ): BOOLEAN; ASSEMBLER;
ASM
       CLD
       XOR   CH, CH
       LES   DI, s
       MOV   CL, BYTE PTR ES:[DI]
       JCXZ  @@1
       INC   DI
       MOV   AL, ' '
       REPE  SCASB
       JZ    @@1          { empty }
       MOV   AL, False
       JMP   @@2
@@1:   MOV   AL, True
@@2:
END;

{$else}

 {$ifdef __OS2__}

FUNCTION Empty( s: STRING ): BOOLEAN;
begin;

END;
 {$endif} {__os2__}
{$endif} {__dos__}

procedure replace(var pre:string; changefrom, changeto:string);
var
 at : byte;

begin;
while pos(changefrom,pre) > 0 do
 begin
 at := pos(changefrom,pre);
 delete(pre, at, length(changefrom));
 insert(changeto, pre, at);
 end;
end;


function fDelSlash(st: PathStr): PathStr; { from JSDOOR's STRMISC }
{ Removes trailing backslashes. Will not remove one from say C:\ }
var colonslash: boolean;
Begin
  colonslash := pos(':\',st)<>0;
  While (St[length(st)] = '\') do Delete(St,length(st),1);
  If colonslash and (pos(':\',st)=0) then st := fDelSlash(st);
  fDelSlash := st;
End;



function fAddSlash(inpath:string):string;
begin;
If (Length(InPath) > 0) and (InPath[Length(InPath)] <> '\') Then
 Begin
 {   If InPath[Length(InPath)] <> '\' Then
     Begin}
 InPath[0] := Chr(Length(InPath) + 1);
 InPath[Length(InPath)] := '\';
 End;
    {End;}
faddslash:=inpath;
end;

Procedure pAddSlash(Var InPath: String);
Begin
If (Length(InPath) > 0) and (InPath[Length(InPath)] <> '\') Then
 Begin
 InPath[0] := Chr(Length(InPath) + 1);
 InPath[Length(InPath)] := '\';
 End;
end;

{$ifdef __dos__}
FUNCTION PADL( s: STRING; n: BYTE; c: CHAR ): STRING; ASSEMBLER;
ASM
      PUSH   DS
      CLD

      LES    DI, @Result
      INC    DI
      LDS    SI, s
      XOR    AX, AX
      LODSB
      PUSH   AX

      XOR    CX, CX
      MOV    CL, n
      SUB    CL, AL

      CMP    CX, 0
      JNB    @@1
      XOR    CX, CX

@@1:  MOV    AL, c
      REP    STOSB

      POP    CX
      REP    MOVSB

      MOV    DI, WORD PTR @Result
      MOV    AL, n
      MOV    BYTE PTR ES:[DI], AL
      POP    DS
END;

FUNCTION LTrim( s: STRING; c: CHAR ): STRING; Assembler;
ASM
      PUSH   DS
      LDS    SI, s
      XOR    AX, AX
      LODSB
      XCHG   AX, CX
      LES    DI, @Result
      INC    DI
      JCXZ   @@2

      MOV    BL, c
      CLD
@@1:  LODSB
      CMP    AL, BL
      LOOPE  @@1
      DEC    SI
      INC    CX
      REP    MOVSB

@@2:  XCHG   AX, DI
      MOV    DI, WORD PTR @Result
      SUB    AX, DI
      DEC    AX
      STOSB
      POP    DS
END;


{$else} { __dos__ }
{Function PadL(St:String;Ch:Char;L:Integer): String;}

FUNCTION PADL( s: STRING; n: BYTE; c: CHAR ): STRING;
Var
 TempStr : String;
 i       : Word;

Begin
If Length(S) >= n Then
 PadL := Copy(S,1,n)
 Else
 Begin
 For i := 1 to (N - Length(S)) Do
  TempStr[i] := C;
 TempStr[0] := Chr(N - Length(S));
 PadL := TempStr + S;
 End;
End;
{$endif} {__dos__}

{
  function RTrim(Str: String): String;
  var len: Byte absolute Str;
  begin
    while (Str[len] = Space) do Dec(len);
    RTrim := Str
  end {RTrim}{;}



FUNCTION RTrim( Rtrims: STRING; Rtrimc: CHAR ): STRING;
BEGIN
WHILE (LENGTH(rtrims) > 0) AND (rtrims[LENGTH(rtrims)] = rtrimc)
 DO DEC(rtrims[0]);
RTrim := rtrims;
END;

{$ifdef __dos__}
FUNCTION PADR( s: STRING; n: BYTE; c: CHAR ): STRING;
ASSEMBLER;
ASM
      PUSH   DS
      CLD
      LDS    SI, s
      XOR    AX, AX
      LODSB
      MOV    CX, AX

      LES    DI, @Result
      INC    DI
      REP    MOVSB

      MOV    CL, n
      SUB    CL, AL

      CMP    CX, 0
      JNB    @@1
      XOR    CX, CX

@@1:  MOV    AL, c
      REP    STOSB

      MOV    DI, WORD PTR @Result
      MOV    AL, n
      MOV    BYTE PTR ES:[DI], AL

      POP    DS
END;

{$else}
{Function padright(st:string;ch:char;l:integer):string;}
FUNCTION PADR( s: STRING; n: BYTE; c: CHAR ): STRING;
  var
    i:          integer;
    tempstr:    string;

  begin
  tempstr := s;
  if length(tempstr) > n then
    tempstr[0] := chr(n);
  if length(tempstr) < n then
    begin
    for i := length(tempstr)+1 to n do
      tempstr[i] := c;
    tempstr[0] := chr(n);
    end;
  padr := tempstr;
  end;
{$endif} {__dos__}

Function PosLastChar(Ch: Char; St: String): Word;
  Var
    i: Word;

  Begin
  i := Length(St);
  While ((i > 0) and (st[i] <> ch)) Do
    Dec(i);
  PosLastChar := i;
  End;

{$ifdef __dos__}

Procedure CursorOn;assembler;
asm
 mov        ax,0100h
 mov        cx,0607h
 int        10h
 end;

Procedure CursorOff; assembler;
asm
 mov        ax,0100h
 mov        cx,2020h
 int        10h
 end;

{$else} { __dos__ }

procedure cursoron;  begin; end;
procedure cursoroff; begin; end;

{$endif} {__dos__}


Function IntToStr(Num: longint): String; {JSDOOR}
{ This function takes an integer value, and creates a string }

{ changed st string[11] instead of 255 length, saves memory }
Var st: string[11];
Begin
  Str(Num,St);
  IntToStr := st;
End;

Function StrToInt(St: String): longint; {JSDOOR}
{ String to integer value }
Var num: longint; code: os_int;
Begin
  Val(St,num,code);
  StrToInt := num;
End;


{
Procedure SetFlag(Var Attr : Byte ; Flag : Byte) ;
Begin
     Attr:=Attr Or Flag ;
{
Procedure ClearFlag(Var Attr : Byte ; Flag : Byte) ;
Begin
     Attr:=Attr And (Not Flag) ;
End ;
}
Procedure  ToggleFlag(Var Attr : Byte ; Flag : Byte) ;
Begin
     Attr:=Attr XOr Flag ;
End ;

{

Function IsFlagSet(Attr : Byte ; Flag : Byte) : Boolean ;
Begin
     IsFlagSet:=(Attr And Flag)<>0 ;
End ;

     }


Procedure SetLFlag(Var L: LongInt; Bit: Byte; Setting: Boolean);
  Var
    Mask: LongInt;

  Begin
  Mask := 1;
  Mask := Mask Shl (Bit - 1);
  If Setting Then
    L := L or Mask
  Else
    L := (L and (Not Mask));
  End;


Function GetLFlag(L: LongInt; Bit: Byte): Boolean;
  Var
    Mask: LongInt;

  Begin
  Mask := 1;
  Mask := Mask Shl (Bit - 1);
  If (L and Mask) = 0 Then
    GetLFlag := False
  Else
    GetLFlag := True;
  End;


Procedure SetBFlag(Var L: Byte; Bit: Byte; Setting: Boolean);
  Var
    Mask: Byte;

  Begin
  Mask := 1;
  Mask := Mask Shl (Bit - 1);
  If Setting Then
    L := L or Mask
  Else
    L := (L and (Not Mask));
  End;


Function GetBFlag(L: Byte; Bit: Byte): Boolean;
  Var
    Mask: Byte;

  Begin
  Mask := 1;
  Mask := Mask Shl (Bit - 1);
  If (L and Mask) = 0 Then
    GetBFlag := False
  Else
    GetBFlag := True;
  End;

procedure SwapBit(var b:byte;bit:byte);
begin;
if getbflag(b,bit)=false then
 setbflag(b,bit,true) else
  setbflag(b,bit,false);
end;

function LeadingZero(w : Word) : String;
var
  s : String;
begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  LeadingZero := s;
end;


FUNCTION HexB( b: BYTE ): String2;
CONST
     HexChar : ARRAY[0..15] OF Char = '0123456789ABCDEF';
BEGIN
     Hexb := HexChar[b SHR 4] + HexChar[b AND $F];
END;

FUNCTION HexW( w: WORD ): String4;
BEGIN
     HexW := HexB(HI(w)) + HexB(LO(w));
END;

FUNCTION HexL( l: LONGINT ): String8;
BEGIN
     HexL := HexW(HI(l)) + HexW(LO(l));
END;


function calcchange(lint, lint2: longint) : string;
begin;
if lint = lint2 then
 calcchange:='0';
if lint > lint2 then
 calcchange:='-'+IntToStr(lint  - lint2);
if lint < lint2 then
 calcchange:='+'+IntToStr(lint2 - lint);
end; { calcchange }

function exist(filename: filestr): boolean;
{$ifdef existdirinfo}
var
 dirinfo: searchrec; {$endif}
begin
findfirst(filename, $20, dirinfo);
exist:=(doserror=0) and (filename<>#0) ;
end;

FUNCTION Comma( i: LONGINT ): STRING12;
{ FUNCTION to place commas in a number for printing }
VAR
   s: STRING;
   x: INTEGER;
BEGIN
     STR( i:0, s );
     x := LENGTH( s ) - 2;
     WHILE x > 1 DO BEGIN
           INSERT( ',', s, x );
           DEC( x, 3 );
     {W}END;
     Comma := s;
END;

Function GregorianToJulian(DT: DateTime): LongInt;
Var
  Century: LongInt;
  XYear: LongInt;
  Temp: LongInt;
  Month: LongInt;

  Begin
  Month := DT.Month;
  If Month <= 2 Then
    Begin
    Dec(DT.Year);
    Inc(Month,12);
    End;
  Dec(Month,3);
  Century := DT.Year Div 100;
  XYear := DT.Year Mod 100;
  Century := (Century * D1) shr 2;
  XYear := (XYear * D0) shr 2;
  GregorianToJulian :=  ((((Month * 153) + 2) div 5) + DT.Day) + D2
    + XYear + Century;
  End;


Function DTToUnixDate(DT: DateTime): LongInt;
   Var
     SecsPast, DaysPast: LongInt;

  Begin
  DaysPast := GregorianToJulian(DT) - c1970;
  SecsPast := DaysPast * 86400;
  SecsPast := SecsPast + (LongInt(DT.Hour) * 3600) + (DT.Min * 60) + (DT.Sec);
  DTToUnixDate := SecsPast;
  End;
{
  Procedure JulianToGregorian(JulianDN : LongInt; Var Year, Month,
  Day : Integer);

  Var
    Temp,
    XYear: LongInt;
    YYear,
    YMonth,
    YDay: Integer;

  Begin
  Temp := (((JulianDN - D2) shl 2) - 1);
  XYear := (Temp Mod D1) or 3;
  JulianDN := Temp Div D1;
  YYear := (XYear Div D0);
  Temp := ((((XYear mod D0) + 4) shr 2) * 5) - 3;
  YMonth := Temp Div 153;
  If YMonth >= 10 Then
    Begin
    YYear := YYear + 1;
    YMonth := YMonth - 12;
    End;
  YMonth := YMonth + 3;
  YDay := Temp Mod 153;
  YDay := (YDay + 5) Div 5;
  Year := YYear + (JulianDN * 100);
  Month := YMonth;
  Day := YDay;
  End;


Procedure UnixToDt(SecsPast: LongInt; Var Dt: DateTime);
  Var
    DateNum: LongInt;

  Begin
  Datenum := (SecsPast Div 86400) + c1970;
  JulianToGregorian(DateNum, Integer(DT.Year), Integer(DT.Month),
    Integer(DT.day));
  SecsPast := SecsPast Mod 86400;
  DT.Hour := SecsPast Div 3600;
  SecsPast := SecsPast Mod 3600;
  DT.Min := SecsPast Div 60;
  DT.Sec := SecsPast Mod 60;
  End;
}
function getparam(gpS: string; gpN: integer): string; { org. from DDPLUS }

var
 gpA: integer;
 gpS2: string;
begin;
while (length(gpS)>0)  and (gpS[1]=' ')  do delete(gpS,1,1);
if gpN<>1 then
 begin;
 while (length(gpS)>0) and (gpS[1]<>' ') do delete(gpS,1,1);
 while (length(gpS)>0) and (gpS[1]=' ')  do delete(gpS,1,1);
 end;
if gpN=3 then
 begin;
 while (length(gpS)>0) and (gpS[1]<>' ') do delete(gpS,1,1);
 while (length(gpS)>0) and (gpS[1]=' ')  do delete(gpS,1,1);
 end;
while (pos(' ',gpS)<>0) do
 begin;
 gpA:=1;
 gpS2:='';
 while gpS[gpA]<>' ' do
  begin;
  gpS2:=gpS2+upcase(gpS[gpA]);
  gpA:=gpA+1;
  end;
 gpS:=gpS2;
 end;
while (length(gpS)>0) and (gpS[length(gpS)]=' ') do delete(gpS,length(gpS),1);
for gpA:=1 to length(gpS) do gpS[gpA]:=upcase(gpS[gpA]);
getparam:=gpS;
end;


function numparams(nmS: string): integer;  { originally from DDPLUS, rewritten
                                             by Psych0}

var
 nmI: integer;

begin;
nmi:=0;
numparams:=0;
nmS:=rtrim(nmS,' ');
if length(nmS)=0 then exit;
if nmS[1]=';'    then exit;
if getparam(nmS,1)<>'' then inc(nmI);
if getparam(nmS,2)<>'' then inc(nmI);
if getparam(nmS,3)<>'' then inc(nmI);
numparams:=nmI;
end;


{asm
MUL BH = BH/AL

}


{$IFDEF FASTWRITE}
{$IFDEF __DOS__}
PROCEDURE FastWrite(Col, Row, Attr : Byte; Str : String); {NEAR;} ASSEMBLER;
{.$DEFINE FASTW_FINDADDR}
{ This procedure is the only one which is not mine }
  ASM
    PUSH   DS           {Save DS}
    MOV    DL,CheckSnow {Save CheckSnow Setting}
{$IFDEF FASTW_FINDADDR}
    MOV    ES,SegB800   {ES = Colour Screen Segment}
    MOV    SI,SegB000   {SI = Mono Screen Segment}
    MOV    DS,Seg0040   {DS = ROM Bios Segment}
{$ELSE} { FASTW_FINDADDR }
    MOV    ES,ScreenSeg
{$ENDIF} { FASTW_FINDADDR }
    MOV    BX,[49h]     {BL = CRT Mode, BH = ScreenWidth}
    MOV    AL,Row       {AL = Row No}
    MUL    BH           {AX = Row * ScreenWidth}
    XOR    CH,CH        {CH = 0}
    MOV    CL,Col       {CX = Column No}
    ADD    AX,CX        {(Row*ScreenWidth)+Column}
    ADD    AX,AX        {Multiply by 2 (2 Byte per Position)}
    MOV    DI,AX        {DI = Screen Offset}
{$IFDEF FASTW_FINDADDR}
    CMP    BL,7         {CRT Mode = Mono?}
    JNE    @@DestSet    {No  - Use Colour Screen Segment}
    MOV    ES,SI        {Yes - ES = Mono Screen Segment}
    XOR    DX,DX        {Force jump to FWrite}
  @@DestSet:            {ES:DI = Screen Destination Address}
{$ELSE} {FASTW_FINDADDR}

{$ENDIF} {FASTW_FINDADDR}
    LDS    SI,Str       {DS:SI = Source String}
    CLD                 {Move Forward through String}
    LODSB               {Get Length Byte of String}
    MOV    CL,AL        {CX = Input String Length}
    JCXZ   @@Done       {Exit if Null String}
    MOV    AH,Attr      {AH = Attribute}
    OR     DL,DL        {Test Mono/CheckSnow Flag}
    JZ     @@FWrite     {Snow Checking Disabled or Mono - Use FWrite}
{Output during Screen Retrace's}
    MOV    DX,003DAh    {6845 Status Port}
  @@WaitLoop:           {Output during Retrace's}
    MOV    BL,[SI]      {Load Next Character into BL}
    INC    SI           {Update Source Pointer}
    CLI                 {Interrupts off}
  @@Wait1:              {Wait for End of Retrace}
    IN      AL,DX       {Get 6845 status}
    TEST    AL,8        {Vertical Retrace in Progress?}
    JNZ     @@Write     {Yes - Output Next Char}
    SHR     AL,1        {Horizontal Retrace in Progress?}
    JC      @@Wait1     {Yes - Wait until End of Retrace}
  @@Wait2:              {Wait for Start of Next Retrace}
    IN      AL,DX       {Get 6845 status}
    SHR     AL,1        {Horizontal Retrace in Progress?}
    JNC     @@Wait2     {No - Wait until Retrace Starts}
  @@Write:              {Output Char and Attribute}
    MOV     AL,BL       {Put Char to Write into AL}
    STOSW               {Store Character and Attribute}
    STI                 {Interrupts On}
    LOOP   @@WaitLoop   {Repeat for Each Character}
    JMP    @@Done       {Exit}
{Ignore Screen Retrace's}
  @@FWrite:             {Output Ignoring Retrace's}
    TEST   SI,1         {DS:SI an Even Offset?}
    JZ     @@Words      {Yes - Skip (On Even Boundary)}
    LODSB               {Get 1st Char}
    STOSW               {Write 1st Char and Attrib}
    DEC    CX           {Decrement Count}
    JCXZ   @@Done       {Finished if only 1 Char in Str}
  @@Words:              {DS:SI Now on Word Boundary}
    SHR    CX,1         {CX = Char Pairs, Set CF if Odd Byte Left}
    JZ     @@ChkOdd     {Skip if No Pairs to Store}
  @@Loop:               {Loop Outputing 2 Chars per Loop}
    MOV    BH,AH        {BH = Attrib}
    LODSW               {Load 2 Chars}
    XCHG   AH,BH        {AL = 1st Char, AH = Attrib, BH = 2nd Char}
    STOSW               {Store 1st Char and Attrib}
    MOV    AL,BH        {AL = 2nd Char}
    STOSW               {Store 2nd Char and Attrib}
    LOOP   @@Loop       {Repeat for Each Pair of Chars}
  @@ChkOdd:             {Check for Final Char}
    JNC    @@Done       {Skip if No Odd Char to Display}
    LODSB               {Get Last Char}
    STOSW               {Store Last Char and Attribute}
  @@Done:               {Finished}
    POP    DS           {Restore DS}
END;
{$endif} {__DOS__}
{$endif} {fastwrite}

{$ifdef __OS2__}
Function upCase(C : Char) : Char; assembler;  { from LxLite STROP.PAS }
asm             mov     al,&C
                cmp     al,'a'
                jb      @@ok
                cmp     al,'z'
                jbe     @@lo
                cmp     al,''
                jb      @@ok
                cmp     al,''
                jbe     @@lo
                cmp     al,''
                jb      @@ok
                cmp     al,''
                ja      @@ok
                sub     al,80-32
@@lo:           sub     al,20h
@@ok:
end;

Function lowCase(C : Char) : Char; assembler; { from LxLite STROP.PAS }
asm             mov     al,&C
                cmp     al,'A'
                jb      @@ok
                cmp     al,'Z'
                jbe     @@up
                cmp     al,''
                jb      @@ok
                cmp     al,''
                jbe     @@up
                cmp     al,''
                jb      @@ok
                cmp     al,''
                ja      @@ok
                add     al,80-32
@@up:           add     al,20h
@@ok:
end;
{$endif} { __OS2__ }


{$ifdef __DOS__}
function fLoStr(const s:string):string; assembler;
asm
 push ds
 lds  si,s
 les  di,@result
 lodsb            { load and store length of string }
 stosb
 xor  ch,ch
 mov  cl,al
 jcxz @empty      { FIX for null string }
 @LowerLoop:
  lodsb
  cmp  al,'A'
  jb   @cont
  cmp  al,'Z'
  ja   @cont
  add  al,' '
 @cont:
   stosb
   loop @LowerLoop
 @empty:
   pop  ds
 end;  { LoStr }

function fUpStr(const s:string):string; assembler;
  asm
    push ds
    lds  si,s
    les  di,@result
    lodsb            { load and store length of string }
    stosb
    xor  ch,ch
    mov  cl,al
    jcxz @empty      { FIX for null length string }
  @upperLoop:
    lodsb
    cmp  al,'a'
    jb   @cont
    cmp  al,'z'
    ja   @cont
    sub  al,' '
  @cont:
    stosb
    loop @UpperLoop
  @empty:
    pop  ds
  end;  { UpStr }

{$endif} {normal_asm}

{$IFDEF __OS__}
Procedure LoStr(var S : String); { from LxLite }
var i : byte;
begin
 for i:=1 to length(s) do s[i]:=LowCase(s[i]);
end;

Function  fLoStr(S : String) : String;
begin
 LoStr(s); fLoStr := s;
end;


Procedure UpStr(var S : String);
var i : byte;
begin
 for i:=1 to length(s) do s[i]:=UpCase(s[i]);
end;

{Function  fUpStr(S : String) : String;
begin
 UpStrP(s); fUpStr := s;
end;}

{$ENDIF} {__OS2__}

{$IFDEF NORMAL_ASM}
function BlockPos(var Buffer;Size: word;S: string): integer;
{function Pos(Substr: String; S: String): Byte;}

  { Search in Buffer of Size bytes for the string S }
  begin
  { Load "buffer" address into ES:DI, "buffer" offset into BX, Length(s) -
    1 into DX, contents of "s[1]" into AL, offset of "s[2]" into SI, and
    "size" - Length(s) + 1 into CX.  If "size" < Length(s), or if
    Length(s) = 0, return zero. }

  Inline($1E/               {        PUSH    DS           }
         $16/               {        PUSH    SS           }
         $1F/               {        POP     DS           }
         $C4/$BE/>buffer/   {        LES     DI,buffer[BP]}
         $89/$FB/           {        MOV     BX,DI        }
         $8B/$8E/>size/     {        MOV     CX,size[bp]  }
         $8D/$B6/>s+2/      {        LEA     SI,s+2[bp]   }
         $8A/$86/>s+1/      {        MOV     AL,s+1[bp]   }
         $8A/$96/>s/        {        MOV     DL,s[bp]     }
         $84/$D2/           {        TEST    DL,DL        }
         $74/$23/           {        JZ      ERROR        }
         $FE/$CA/           {        DEC     DL           }
         $30/$F6/           {        XOR     DH,DH        }
         $29/$D1/           {        SUB     CX,DX        }
         $76/$1B/           {        JBE     ERROR        }

  { Scan the ES:DI buffer, looking for the first occurrence of "s[1]."  If
    not found prior to reaching Length(s) characters before the end of the
    buffer, return zero.  If Length(s) = 1, the entire string has been
    found, so report success. }

       $FC/               {        CLD                  }
       $F2/               {NEXT:   REPNE                }
       $AE/               {        SCASB                }
       $75/$16/           {        JNE     ERROR        }
       $85/$D2/           {        TEST    DX,DX        }
       $74/$0C/           {        JZ      FOUND        }

  { Compare "s" (which is at SS:SI) with the ES:DI buffer, in both cases
    starting with the first byte just past the length byte of the string.
    If "s" does not match what is at the DI position of the buffer, reset
    the registers to the values they had just prior to the comparison, and
    look again for the next occurrence of the length byte. }

         $51/               {        PUSH    CX           }
         $57/               {        PUSH    DI           }
         $56/               {        PUSH    SI           }
         $89/$D1/           {        MOV     CX,DX        }
         $F3/               {        REPE                 }
         $A6/               {        CMPSB                }
         $5E/               {        POP     SI           }
         $5F/               {        POP     DI           }
         $59/               {        POP     CX           }
         $75/$EC/           {        JNE     NEXT         }

  { String found in buffer.  Set AX to the offset, within buffer, of the
    first byte of the string (the length byte), assuming that the first
    byte of the buffer is at offset 1. }

         $89/$F8/           {FOUND:  MOV     AX,DI        }
         $29/$D8/           {        SUB     AX,BX        }
         $EB/$02/           {        JMP     SHORT RETURN }

  { An "error" condition.  Return zero. }

         $31/$C0/           {ERROR:  XOR     AX,AX        }
         $89/$46/$FE/       {RETURN: MOV     [BP-2],AX    }
         $1F)               {        POP     DS           }
  end;

{$ENDIF}




{$ifdef notusedNormal_asm}
procedure GoToXY(x,y : word);assembler;
  asm
    mov    ax,y
    mov    dh,al
    dec    dh
    mov    ax,x
    mov    dl,al
    dec    dl
    mov    ah,2
    xor    bh,bh
    int    10h
  end;
{$endif}


{$IFDEF NORMAL_ASM}
Procedure GetFileMode; Assembler;

Asm
           CLC
           CMP    ES:[DI].TextRec.Mode, fmInput
           JE     @1
           MOV    [InOutRes], 104         { 'File not opened For reading' }
           xor    AX, AX                  { Zero out Function result }
           xor    DX, DX
           STC
@1:
end;  { GetFileMode }

Procedure TextSeek(Var f : Text; n : LongInt); Assembler;

Asm
    LES    DI, f
          CALL   GetFileMode
    JC     @2

    MOV    CX, Word Ptr n+2        { Move File Pointer }
    MOV    DX, Word Ptr n
    MOV    BX, ES:[DI].TextRec.Handle
          MOV    AX, 4200h
          inT    21h
          JNC    @1                      { Carry flag = reading past Eof }
          MOV    [InOutRes], AX
          JMP    @2

                           { Force read next time }
@1:  MOV    AX, ES:[DI].TextRec.Bufend
                       MOV    ES:[DI].TextRec.BufPos, AX
@2:
end;  { TextSeek }
    {end TextUtil }


Function TextFilePos(Var f : Text) : LongInt; Assembler;

Asm
        LES    DI, f
        CALL   GetFileMode
        JC     @1

        xor    CX, CX                  { Get position of File Pointer }
        xor    DX, DX
        MOV    BX, ES:[DI].TextRec.handle
        MOV    AX, 4201h
        inT    21h                     { offset := offset-Bufend+BufPos }
                                xor    BX, BX
        SUB    AX, ES:[DI].TextRec.Bufend
        SBB    DX, BX
        ADD    AX, ES:[DI].TextRec.BufPos
        ADC    DX, BX
@1:
end;  { TextFilePos }
{$endif}


{Procedure NormalCursor; Assembler;
asm
 mov ah,1
 mov ch,6
 mov cl,7
 int $10
end;

{Procedure BlockCursor; Assembler;
asm
 mov ah,1
 mov ch,0
 mov cl,7
 int $10
end;}

