;------------------------------------------------------------------------
;               Silver Xpress 5.00 Protocol Definition file
;            (c) copyright 1988-1994 by Santronics Software
;------------------------------------------------------------------------

; This is the new protocol control file for Silver Xpress version 5.0
; only.  The 4.0x protocol control file is still compatible, but
; starting with version 5.0x, XMT.EXE was merged into Xpress which
; means we have internal protocols.  You will notice the better control,
; reliability and improved efficiency in file transfers.

; PROTOCOL:  This statement begins a PROTOCOL definition.  Each PROTOCOL
; must have a description.  The description is shown to the user at
; the file transfer selection menu.  You should describe the protocol
; as it is on the HOST.

Protocol Z-Modem (Batch) Recommended!

;  The HotKey keyword is the menu option letter the user hits to select
;  this protocol.

  HotKey   Z

; The BasicName is the short name or protocol name which is used to
; tell the user WHAT protocol to start on his end.  This is necessary
; because you may have as a long description "ZMODEM (moby/Fossil)" but
; the user simply has ZMODEM in his terminal.  Some users have called our
; support center with download problems and asked side questions, "Could
; it be that I don't have Moby Turbo ZMODEM with the fossil"?
; You can understand now why I did this! <grin>

  BasicName  Zmodem

; If the word "Internal" appears here, then the protocol is a internal
; protocol for Silver Xpress.  The external calls Download and Upload
; keywords are ignored.  When using the internal protocols, the following
; switches define the protocol and options:
;
;   Protocols:
;
;   /Z    Zmodem
;   /X    Xmodem/CRC
;   /Y    Ymodem
;
;   Protocols options
;
;   /K    Use 1K block                      (Xmodem and Ymodem only)
;   /G    Use "streaming"                   (Xmodem and Ymodem only)
;   /8    Try 8K blocks first, then 1K      (Zmodem only)
;   /A    Use recovery feature              (Zmodem only)
;   /O    overwrite file is already there   (Zmodem only)
;   /N    Only send file if newer or longer (Zmodem only)

  Internal /Z /8 /O

;  The Batch keyword tells Xpress that this protocol is capable of
;  sending multiple files at the same time.

  Batch Yes

;  The TwoWay statement tells Xpress to LOOK in the UPLOAD directory
;  for a REP file AFTER a download takes place.  It was meant to be used
;  for a dual transfer protocol system such as BI-MODEM or HSLINK.  Only
;  answer YES to his question if a dual transfer protocol is DEFINED and
;  implemented.

  TwoWay No

; External Protocols (when INTERNAL is not defined).
; The DownLoad and Upload statements are used to define EXTERNAL
; protocols only.  DOWNLOAD is used to send files to the user.  UPLOAD
; is used to receive files from the user.  The default XMT.EXE is the
; new Silver Xpress X, Y, Zmodem protocols.  NO need to use DSZ.  It is
; free of charge to registered sysops of Silver Xpress.  To see the
; switch parameters for XMT, type XMT at the DOS command prompt.  The
; substitution parameters are defined as follows:
;
;   %p  - comm port      %lb - Lock Baud Rate    %b  - user connect rate
;   %f  - name of file
;
; If you want the external protocols, comment the Internal keyword.
  Download $XMT  /HWBOTH /F /C %p /B %b /T /Z  %f
  Upload   $XMT  /HWBOTH /F /C %p /B %b /R /Z /O %f

End Protocol

Protocol Y-Modem (Batch)
  BasicName  Ymodem
  HotKey   Y
  Internal /Y
  Batch    Yes
  TwoWay   No
; If you want the external protocols, comment the Internal keyword.
  Download !XMT.EXE /H HWBOTH /C %p /B %b /T /Y %f
  Upload   !XMT.EXE /H HWBOTH /C %p /B %b /R /Y %f
End Protocol

Protocol Y-Modem G (Batch)
  BasicName  YmodemG
  HotKey   G
  Internal /Y /G /K
  Batch    Yes
  TwoWay   No
; If you want the external protocols, comment the Internal keyword.
  Download !XMT.EXE  /H HWBOTH /C %p /B %b /T /G %f
  Upload   !XMT.EXE  /H HWBOTH /C %p /B %b /R /G %f
End Protocol

Protocol X-Modem/CheckSum
  BasicName  Xmodem/CRC
  HotKey     X
  Internal   /X
  Batch      No
  TwoWay     No
; If you want the external protocols, comment the Internal keyword.
  Download   !XMT.EXE  /HWBOTH /C %p /B %b /T /X %f
  Upload     !XMT.EXE  /HWBOTH /C %p /B %b /R /X %f
End Protocol

Protocol X-Modem 1K
  BasicName  Xmodem-1K
  HotKey     K
  Internal   /X /K
  Batch      Yes
  TwoWay     No
; If you want the external protocols, comment the Internal keyword.
  Download   !XMT.EXE /HWBOTH /C %p /B %b /T /K %f
  Upload     !XMT.EXE /HWBOTH /C %p /B %b /R /K %f
End Protocol


Protocol XModem-1K-G
  BasicName  Xmodem-1K-G
  HotKey     1
  Internal   /X /K /G
  Batch      No
  TwoWay     No
; If you want the external protocols, comment the Internal keyword.
  Download   !XMT.EXE  /HWBOTH /C %p /B %b /T /L %f
  Upload     !XMT.EXE  /HWBOTH /C %p /B %b /R /L %f
End Protocol

; If you have MPT (formerly PUMA) then uncomment the lines below.
; Protocol MPT 1.10/PUMA 1.0
;  BasicName MPT
;  Hotkey    P
;  Download  $MPT.EXE  P%p E%b S%lb S %f
;  Upload    $MPT.EXE  P%p E%b S%lb R %f
;  Batch     Yes
;  TwoWay    No
; End Protocol

; This is an External Protocol.  Uncomment if not be used.
; Protocol HS-LINK Two Way Transfer
;  BasicName HS-LINK
;  HotKey    H
;  Batch     Yes
;  TwoWay    Yes
;  Download  !HS-LINK.EXE  %f -u%ud
;  UpLoad    !HS-LINK.EXE  -u%f
; End Protocol
