REM Filename Menu Box for Hexed v2.7a PD 2002.

' get include file.
REM $INCLUDE: 'hexedit.inc'

' structure directory structure function.
FUNCTION Directories$ (Var1%)
 ON LOCAL ERROR RESUME NEXT
 IF Windows.Detected THEN
    GET 3, Var1%, WinFileStruc
    Directories$ = WinFileStruc.Name
 ELSE
    GET 3, Var1%, DosFileStruc
    Directories$ = DosFileStruc.Name
 END IF
END FUNCTION

' structure filename structure function.
FUNCTION Filenames$ (Var1%)
 ON LOCAL ERROR RESUME NEXT
 IF Windows.Detected THEN
    GET 2, Var1%, WinFileStruc
    Filenames$ = WinFileStruc.Name
 ELSE
    GET 2, Var1%, DosFileStruc
    Filenames$ = DosFileStruc.Name
 END IF
END FUNCTION

' File input menu box.
SUB Menu (C$, D$, X$, E$)

' returns:
'   C$  -  Drive letter.
'       Normally C without : or \
'   D$  -  Directory.
'       Without leading or trailing \ (can be null)
'   X$  -  Filespec.
'       Normally *.*
'   E$  -  Filename.
'       Can be long filename.

' concatenate:
'   IF D$="" THEN
'      Filename=C$+":\"+E$
'   ELSE
'      Filename=C$+":\"+D$+"\"+E$
'   END IF

' define simple error routine
ON LOCAL ERROR GOTO Error.Routine

' test windows
GOSUB TestWindows

' open structure files
GOSUB OpenDataFiles

' display menu screen
GOSUB MainMenu

' get current drive/directory
GOSUB InitDrive
GOSUB InitDir

' read all subdirectories
Current.Dir = 1
Dir.Box.Line = 1
GOSUB ClearDirBox
GOSUB LoadDirSpec
GOSUB DisplayDirSpec
GOSUB DisplayCurrentDir

' display first ten files
IF D$ = "" THEN
   F$ = C$ + ":\*.*"
ELSE
   F$ = C$ + ":\" + D$ + "\" + "*.*"
END IF
GOSUB ClearFileBox
GOSUB LoadFileSpec
GOSUB DisplayFileSpec
GOSUB DisplayCurrentPath

' main input loop
X$ = "*.*"
LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
PRINT SPACE$(12);
LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
PRINT X$;
DO
   LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
   PRINT SPACE$(12);
   LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
   PRINT X$;
   DO
      I$ = ""
      DO
         I$ = INKEY$
         IF LEN(I$) THEN
            EXIT DO
         END IF
      LOOP
      IF I$ = ":" OR I$ = "\" OR I$ = "/" THEN
         I$ = ""
      END IF
      IF LEN(I$) = 2 THEN
         I$ = ""
      END IF
      ' Tab moves to file loop, or
      '   directory loop if there are no files.
      IF I$ = CHR$(9) THEN
         IF Num.Files > 0 THEN
            GOSUB FileInputLoop
         ELSE
            GOSUB DirInputLoop
            IF I$ = CHR$(13) THEN
               I$ = ""
               Current.Dir = 1
               Dir.Box.Line = 1
               GOSUB ClearDirBox
               GOSUB LoadDirSpec
               GOSUB DisplayDirSpec
               GOSUB DisplayCurrentDir
            END IF
            GOSUB DisplayCurrentPath
         END IF
         EXIT DO
      END IF
      IF I$ = CHR$(13) THEN
         I$ = ""
         EXIT DO
      END IF
      IF I$ = CHR$(27) THEN
         EXIT DO
      END IF
      IF I$ = CHR$(8) THEN
         IF LEN(X$) > 0 THEN
            X$ = LEFT$(X$, LEN(X$) - 1)
            LOCATE CSRLIN, POS(0) - 1, 1
            PRINT " ";
            LOCATE CSRLIN, POS(0) - 1, 1
         END IF
      ELSE
         I$ = LTRIM$(I$)
         I$ = RTRIM$(I$)
         I$ = UCASE$(I$)
         IF LEN(X$) < 12 THEN
            PRINT I$;
            X$ = X$ + I$
         END IF
      END IF
   LOOP
   IF I$ = CHR$(27) THEN
      E$ = ""
      EXIT DO
   END IF
   IF I$ = CHR$(13) THEN
      EXIT DO
   END IF
   IF D$ = "" THEN
      F$ = C$ + ":\" + X$
   ELSE
      F$ = C$ + ":\" + D$ + "\" + X$
   END IF
   GOSUB ClearFileBox
   GOSUB LoadFileSpec
   GOSUB DisplayFileSpec
LOOP
COLOR Plain, Black
CLS
EXIT SUB

FileInputLoop:
 E$ = Filenames(1)
 E$ = RTRIM$(E$)
 COLOR Plain, Black
 LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
 PRINT SPACE$(12);
 LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
 PRINT LEFT$(E$, 12);
 COLOR Black, Plain
 LOCATE 6 + Xcoor - 1, 4 + Ycoor - 1, 1
 PRINT LEFT$(E$, 12);
 COLOR Plain, Black
 GOSUB DisplayLongName2
 Current.File = 1
 File.Box.Line = 1
 E$ = RTRIM$(Filenames(1))
 I$ = ""
 DO
    DO
       I$ = INKEY$
       IF LEN(I$) THEN
          EXIT DO
       END IF
    LOOP
    ' shift-tab returns to top
    IF LEN(I$) = 2 THEN
       IF ASC(RIGHT$(I$, 1)) = 15 THEN
          I$ = ""
          RETURN
       END IF
    END IF
    ' Tab moves to directory loop
    IF I$ = CHR$(9) THEN
       GOSUB DirInputLoop
       IF I$ = CHR$(9) THEN
          GOSUB DisplayCurrentPath
          RETURN
       END IF
       IF I$ = CHR$(13) THEN
          I$ = ""
          Current.Dir = 1
          Dir.Box.Line = 1
          GOSUB ClearDirBox
          GOSUB LoadDirSpec
          GOSUB DisplayDirSpec
          GOSUB DisplayCurrentDir
          GOSUB DisplayCurrentPath
          RETURN
       END IF
    END IF
    IF I$ = CHR$(13) THEN
       RETURN
    END IF
    IF I$ = CHR$(27) THEN
       RETURN
    END IF
    IF LEN(I$) = 1 THEN
       SELECT CASE I$
       CASE "A" TO "Z", "a" TO "z", "0" TO "9"
       DO
          IF Current.File + 1 <= Num.Files THEN
             IF File.Box.Line < 10 THEN
                LOCATE File.Box.Line + 5 + Xcoor - 1, 4 + Ycoor - 1, 1
                COLOR Plain, Black
                PRINT LEFT$(RTRIM$(Filenames(Current.File)), 12);
                File.Box.Line = File.Box.Line + 1
                Current.File = Current.File + 1
                E$ = RTRIM$(Filenames(Current.File))
                COLOR Plain, Black
                LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                PRINT SPACE$(12);
                LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                PRINT LEFT$(E$, 12);
                LOCATE File.Box.Line + 5 + Xcoor - 1, 4 + Ycoor - 1, 1
                COLOR Black, Plain
                PRINT LEFT$(E$, 12);
                COLOR Plain, Black
                GOSUB DisplayLongName2
             ELSE
                Current.File = Current.File + 1
                E$ = RTRIM$(Filenames(Current.File))
                COLOR Plain, Black
                LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                PRINT SPACE$(12);
                LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                PRINT LEFT$(E$, 12);
                GOSUB ClearFileBox
                COLOR Plain, Black
                FOR V = 1 TO 9
                   LOCATE 15 - V + Xcoor - 1, 4 + Ycoor - 1, 1
                   PRINT LEFT$(RTRIM$(Filenames(Current.File - V)), 12);
                NEXT
                COLOR Black, Plain
                LOCATE 15 + Xcoor - 1, 4 + Ycoor - 1, 1
                PRINT LEFT$(RTRIM$(Filenames(Current.File)), 12);
                GOSUB DisplayLongName2
             END IF
             IF LEFT$(E$, 1) = I$ THEN
                EXIT DO
             END IF
          ELSE
             EXIT DO
          END IF
       LOOP
       END SELECT
       I$ = ""
    END IF
    IF LEN(I$) = 2 THEN
       V = ASC(RIGHT$(I$, 1))
       SELECT CASE V
       CASE 72 ' up
          IF Current.File - 1 > 0 THEN
             IF File.Box.Line > 1 THEN
                LOCATE File.Box.Line + 5 + Xcoor - 1, 4 + Ycoor - 1, 1
                COLOR Plain, Black
                PRINT LEFT$(RTRIM$(Filenames(Current.File)), 12);
                File.Box.Line = File.Box.Line - 1
                Current.File = Current.File - 1
                E$ = RTRIM$(Filenames(Current.File))
                COLOR Plain, Black
                LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                PRINT SPACE$(12);
                LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                PRINT LEFT$(E$, 12);
                LOCATE File.Box.Line + 5 + Xcoor - 1, 4 + Ycoor - 1, 1
                COLOR Black, Plain
                PRINT LEFT$(E$, 12);
                COLOR Plain, Black
                GOSUB DisplayLongName2
             ELSE
                Current.File = Current.File - 1
                E$ = RTRIM$(Filenames(Current.File))
                COLOR Plain, Black
                LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                PRINT SPACE$(12);
                LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                PRINT LEFT$(E$, 12);
                GOSUB ClearFileBox
                COLOR Plain, Black
                FOR V = 1 TO 9
                   IF Current.File + V <= Num.Files THEN
                      LOCATE 6 + V + Xcoor - 1, 4 + Ycoor - 1, 1
                      PRINT LEFT$(RTRIM$(Filenames(Current.File + V)), 12);
                   END IF
                NEXT
                COLOR Black, Plain
                LOCATE 6 + Xcoor - 1, 4 + Ycoor - 1, 1
                PRINT LEFT$(RTRIM$(Filenames(Current.File)), 12);
                GOSUB DisplayLongName2
             END IF
          END IF
       CASE 80 ' down
          IF Current.File + 1 <= Num.Files THEN
             IF File.Box.Line < 10 THEN
                LOCATE File.Box.Line + 5 + Xcoor - 1, 4 + Ycoor - 1, 1
                COLOR Plain, Black
                PRINT LEFT$(RTRIM$(Filenames(Current.File)), 12);
                File.Box.Line = File.Box.Line + 1
                Current.File = Current.File + 1
                E$ = RTRIM$(Filenames(Current.File))
                COLOR Plain, Black
                LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                PRINT SPACE$(12);
                LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                PRINT LEFT$(E$, 12);
                LOCATE File.Box.Line + 5 + Xcoor - 1, 4 + Ycoor - 1, 1
                COLOR Black, Plain
                PRINT LEFT$(E$, 12);
                COLOR Plain, Black
                GOSUB DisplayLongName2
             ELSE
                Current.File = Current.File + 1
                E$ = RTRIM$(Filenames(Current.File))
                COLOR Plain, Black
                LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                PRINT SPACE$(12);
                LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                PRINT LEFT$(E$, 12);
                GOSUB ClearFileBox
                COLOR Plain, Black
                FOR V = 1 TO 9
                   LOCATE 15 - V + Xcoor - 1, 4 + Ycoor - 1, 1
                   PRINT LEFT$(RTRIM$(Filenames(Current.File - V)), 12);
                NEXT
                COLOR Black, Plain
                LOCATE 15 + Xcoor - 1, 4 + Ycoor - 1, 1
                PRINT LEFT$(RTRIM$(Filenames(Current.File)), 12);
                GOSUB DisplayLongName2
             END IF
          END IF
       CASE 73 ' pgup
          IF Current.File - 10 > 0 THEN
             File.Box.Line = 1
             Current.File = Current.File - 10
          ELSE
             File.Box.Line = 1
             Current.File = 1
          END IF
          E$ = RTRIM$(Filenames(Current.File))
          COLOR Plain, Black
          LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
          PRINT SPACE$(12);
          LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
          PRINT LEFT$(E$, 12);
          GOSUB ClearFileBox
          COLOR Plain, Black
          FOR V = 1 TO 9
             IF Current.File + V <= Num.Files THEN
                LOCATE 6 + V + Xcoor - 1, 4 + Ycoor - 1, 1
                PRINT LEFT$(RTRIM$(Filenames(Current.File + V)), 12);
             END IF
          NEXT
          COLOR Black, Plain
          LOCATE 6 + Xcoor - 1, 4 + Ycoor - 1, 1
          PRINT LEFT$(RTRIM$(Filenames(Current.File)), 12);
          GOSUB DisplayLongName2
       CASE 81 ' pgdn
          IF Current.File + 10 <= Num.Files THEN
             File.Box.Line = 10
             Current.File = Current.File + 10
             E$ = RTRIM$(Filenames(Current.File))
             COLOR Plain, Black
             LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
             PRINT SPACE$(12);
             LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
             PRINT LEFT$(E$, 12);
             GOSUB ClearFileBox
             COLOR Plain, Black
             FOR V = 1 TO 9
                LOCATE 15 - V + Xcoor - 1, 4 + Ycoor - 1, 1
                PRINT LEFT$(RTRIM$(Filenames(Current.File - V)), 12);
             NEXT
             COLOR Black, Plain
             LOCATE 15 + Xcoor - 1, 4 + Ycoor - 1, 1
             PRINT LEFT$(RTRIM$(Filenames(Current.File)), 12);
             GOSUB DisplayLongName2
          ELSE
             IF Current.File + 1 <= Num.Files THEN
                DO UNTIL Current.File = Num.Files
                   IF File.Box.Line < 10 THEN
                      LOCATE File.Box.Line + 5 + Xcoor - 1, 4 + Ycoor - 1, 1
                      COLOR Plain, Black
                      PRINT LEFT$(RTRIM$(Filenames(Current.File)), 12);
                      File.Box.Line = File.Box.Line + 1
                      Current.File = Current.File + 1
                      E$ = RTRIM$(Filenames(Current.File))
                      COLOR Plain, Black
                      LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                      PRINT SPACE$(12);
                      LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                      PRINT LEFT$(E$, 12);
                      LOCATE File.Box.Line + 5 + Xcoor - 1, 4 + Ycoor - 1, 1
                      COLOR Black, Plain
                      PRINT LEFT$(E$, 12);
                      COLOR Plain, Black
                      GOSUB DisplayLongName2
                   ELSE
                      Current.File = Current.File + 1
                      E$ = RTRIM$(Filenames(Current.File))
                      COLOR Plain, Black
                      LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                      PRINT SPACE$(12);
                      LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                      PRINT LEFT$(E$, 12);
                      GOSUB ClearFileBox
                      COLOR Plain, Black
                      FOR V = 1 TO 9
                         LOCATE 15 - V + Xcoor - 1, 4 + Ycoor - 1, 1
                         PRINT LEFT$(RTRIM$(Filenames(Current.File - V)), 12);
                      NEXT
                      COLOR Black, Plain
                      LOCATE 15 + Xcoor - 1, 4 + Ycoor - 1, 1
                      PRINT LEFT$(RTRIM$(Filenames(Current.File)), 12);
                      GOSUB DisplayLongName2
                   END IF
                LOOP
             END IF
          END IF
       CASE 71 ' home
          IF Current.File > 1 THEN
             File.Box.Line = 1
             Current.File = 1
          END IF
          E$ = RTRIM$(Filenames(Current.File))
          COLOR Plain, Black
          LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
          PRINT SPACE$(12);
          LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
          PRINT LEFT$(E$, 12);
          GOSUB ClearFileBox
          COLOR Plain, Black
          FOR V = 1 TO 9
             IF Current.File + V <= Num.Files THEN
                LOCATE 6 + V + Xcoor - 1, 4 + Ycoor - 1, 1
                PRINT LEFT$(RTRIM$(Filenames(Current.File + V)), 12);
             END IF
          NEXT
          COLOR Black, Plain
          LOCATE 6 + Xcoor - 1, 4 + Ycoor - 1, 1
          PRINT LEFT$(RTRIM$(Filenames(Current.File)), 12);
          GOSUB DisplayLongName2
       CASE 79 ' end
          IF Current.File + 1 <= Num.Files THEN
             DO UNTIL Current.File = Num.Files
                IF File.Box.Line < 10 THEN
                   LOCATE File.Box.Line + 5 + Xcoor - 1, 4 + Ycoor - 1, 1
                   COLOR Plain, Black
                   PRINT LEFT$(RTRIM$(Filenames(Current.File)), 12);
                   File.Box.Line = File.Box.Line + 1
                   Current.File = Current.File + 1
                   E$ = RTRIM$(Filenames(Current.File))
                   COLOR Plain, Black
                   LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                   PRINT SPACE$(12);
                   LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                   PRINT LEFT$(E$, 12);
                   LOCATE File.Box.Line + 5 + Xcoor - 1, 4 + Ycoor - 1, 1
                   COLOR Black, Plain
                   PRINT LEFT$(E$, 12);
                   COLOR Plain, Black
                   GOSUB DisplayLongName2
                ELSE
                   Current.File = Current.File + 1
                   E$ = RTRIM$(Filenames(Current.File))
                   COLOR Plain, Black
                   LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                   PRINT SPACE$(12);
                   LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
                   PRINT LEFT$(E$, 12);
                   GOSUB ClearFileBox
                   COLOR Plain, Black
                   FOR V = 1 TO 9
                      LOCATE 15 - V + Xcoor - 1, 4 + Ycoor - 1, 1
                      PRINT LEFT$(RTRIM$(Filenames(Current.File - V)), 12);
                   NEXT
                   COLOR Black, Plain
                   LOCATE 15 + Xcoor - 1, 4 + Ycoor - 1, 1
                   PRINT LEFT$(RTRIM$(Filenames(Current.File)), 12);
                   GOSUB DisplayLongName2
                END IF
             LOOP
          END IF
       END SELECT
    END IF
 LOOP
 RETURN

DirInputLoop:
 GOSUB ClearLongName2
 Q$ = RTRIM$(Directories(Current.Dir))
 LOCATE Dir.Box.Line + 5 + Xcoor - 1, 21 + Ycoor - 1, 1
 COLOR Black, Plain
 PRINT LEFT$(Q$, 12);
 COLOR Plain, Black
 GOSUB DisplayLongName1
 I$ = ""
 DO
    DO
       I$ = INKEY$
       IF LEN(I$) THEN
          EXIT DO
       END IF
    LOOP
    ' shift-tab returns to file loop
    IF LEN(I$) = 2 THEN
       IF ASC(RIGHT$(I$, 1)) = 15 THEN
          I$ = ""
          LOCATE Dir.Box.Line + 5 + Xcoor - 1, 21 + Ycoor - 1, 1
          COLOR Plain, Black
          PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
          ' returns if no files.
          IF Num.Files = 0 THEN
             GOSUB ClearLongName2
             RETURN
          END IF
          ' display current filename.
          GOSUB DisplayLongName2
          E$ = Filenames(Current.File)
          E$ = RTRIM$(E$)
          COLOR Plain, Black
          LOCATE File.Box.Line + 5 + Xcoor - 1, 4 + Ycoor - 1, 1
          PRINT SPACE$(12);
          COLOR Black, Plain
          LOCATE File.Box.Line + 5 + Xcoor - 1, 4 + Ycoor - 1, 1
          PRINT LEFT$(E$, 12);
          COLOR Plain, Black
          RETURN
       END IF
    END IF
    ' Tab returns to top loop
    IF I$ = CHR$(9) THEN
       LOCATE Dir.Box.Line + 5 + Xcoor - 1, 21 + Ycoor - 1, 1
       COLOR Plain, Black
       PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
       RETURN
    END IF
    IF I$ = CHR$(13) THEN
       ' check the path type
       SELECT CASE Q$
       CASE "." ' self
          ' nul
       CASE ".." ' parent
          IF INSTR(D$, "\") = 0 THEN
             D$ = ""
          ELSE
             FOR V = LEN(D$) TO 1 STEP -1
                IF MID$(D$, V, 1) = "\" THEN
                   D$ = LEFT$(D$, V - 1)
                   EXIT FOR
                END IF
             NEXT
          END IF
       CASE ELSE ' imbedded path
          IF D$ = "" THEN
             D$ = Q$
          ELSE
             D$ = D$ + "\" + Q$
          END IF
       END SELECT
       RETURN
    END IF
    IF I$ = CHR$(27) THEN
       RETURN
    END IF
    IF LEN(I$) = 1 THEN
       SELECT CASE I$
       CASE "A" TO "Z", "a" TO "z", "0" TO "9"
       DO
          IF Current.Dir + 1 <= Num.Dirs THEN
             IF Dir.Box.Line < 10 THEN
                LOCATE Dir.Box.Line + 5 + Xcoor - 1, 21 + Ycoor - 1, 1
                COLOR Plain, Black
                PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
                Dir.Box.Line = Dir.Box.Line + 1
                Current.Dir = Current.Dir + 1
                LOCATE Dir.Box.Line + 5 + Xcoor - 1, 21 + Ycoor - 1, 1
                COLOR Black, Plain
                PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
                COLOR Plain, Black
             ELSE
                GOSUB ClearDirBox
                Current.Dir = Current.Dir + 1
                COLOR Plain, Black
                FOR V = 1 TO 9
                   LOCATE 15 - V + Xcoor - 1, 21 + Ycoor - 1, 1
                   PRINT LEFT$(RTRIM$(Directories(Current.Dir - V)), 12);
                NEXT
                COLOR Black, Plain
                LOCATE 15 + Xcoor - 1, 21 + Ycoor - 1, 1
                PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
                COLOR Plain, Black
             END IF
             Q$ = RTRIM$(Directories(Current.Dir))
             GOSUB DisplayLongName1
             IF LEFT$(Q$, 1) = I$ THEN
                EXIT DO
             END IF
          ELSE
             EXIT DO
          END IF
       LOOP
       END SELECT
       I$ = ""
    END IF
    IF LEN(I$) = 2 THEN
       V = ASC(RIGHT$(I$, 1))
       SELECT CASE V
       CASE 72 ' up
          IF Current.Dir - 1 > 0 THEN
             IF Dir.Box.Line > 1 THEN
                LOCATE Dir.Box.Line + 5 + Xcoor - 1, 21 + Ycoor - 1, 1
                COLOR Plain, Black
                PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
                Dir.Box.Line = Dir.Box.Line - 1
                Current.Dir = Current.Dir - 1
                LOCATE Dir.Box.Line + 5 + Xcoor - 1, 21 + Ycoor - 1, 1
                COLOR Black, Plain
                PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
                COLOR Plain, Black
             ELSE
                GOSUB ClearDirBox
                Current.Dir = Current.Dir - 1
                COLOR Plain, Black
                FOR V = 1 TO 9
                   IF Current.Dir + V <= Num.Dirs THEN
                      LOCATE 6 + V + Xcoor - 1, 21 + Ycoor - 1, 1
                      PRINT LEFT$(RTRIM$(Directories(Current.Dir + V)), 12);
                   END IF
                NEXT
                COLOR Black, Plain
                LOCATE 6 + Xcoor - 1, 21 + Ycoor - 1, 1
                PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
                COLOR Plain, Black
             END IF
             Q$ = RTRIM$(Directories(Current.Dir))
             GOSUB DisplayLongName1
          END IF
       CASE 80 ' down
          IF Current.Dir + 1 <= Num.Dirs THEN
             IF Dir.Box.Line < 10 THEN
                LOCATE Dir.Box.Line + 5 + Xcoor - 1, 21 + Ycoor - 1, 1
                COLOR Plain, Black
                PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
                Dir.Box.Line = Dir.Box.Line + 1
                Current.Dir = Current.Dir + 1
                LOCATE Dir.Box.Line + 5 + Xcoor - 1, 21 + Ycoor - 1, 1
                COLOR Black, Plain
                PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
                COLOR Plain, Black
             ELSE
                GOSUB ClearDirBox
                Current.Dir = Current.Dir + 1
                COLOR Plain, Black
                FOR V = 1 TO 9
                   LOCATE 15 - V + Xcoor - 1, 21 + Ycoor - 1, 1
                   PRINT LEFT$(RTRIM$(Directories(Current.Dir - V)), 12);
                NEXT
                COLOR Black, Plain
                LOCATE 15 + Xcoor - 1, 21 + Ycoor - 1, 1
                PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
                COLOR Plain, Black
             END IF
             Q$ = RTRIM$(Directories(Current.Dir))
             GOSUB DisplayLongName1
          END IF
       CASE 73 ' pgup
          IF Current.Dir - 10 > 0 THEN
             Dir.Box.Line = 1
             Current.Dir = Current.Dir - 10
          ELSE
             Dir.Box.Line = 1
             Current.Dir = 1
          END IF
          GOSUB ClearDirBox
          COLOR Plain, Black
          FOR V = 1 TO 9
             IF Current.Dir + V <= Num.Dirs THEN
                LOCATE 6 + V + Xcoor - 1, 21 + Ycoor - 1, 1
                PRINT LEFT$(RTRIM$(Directories(Current.Dir + V)), 12);
             END IF
          NEXT
          COLOR Black, Plain
          LOCATE 6 + Xcoor - 1, 21 + Ycoor - 1, 1
          PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
          COLOR Plain, Black
          Q$ = RTRIM$(Directories(Current.Dir))
          GOSUB DisplayLongName1
       CASE 81 ' pgdn
          IF Current.Dir + 10 <= Num.Dirs THEN
             GOSUB ClearDirBox
             Dir.Box.Line = 10
             Current.Dir = Current.Dir + 10
             COLOR Plain, Black
             FOR V = 1 TO 9
                LOCATE 15 - V + Xcoor - 1, 21 + Ycoor - 1, 1
                PRINT LEFT$(RTRIM$(Directories(Current.Dir - V)), 12);
             NEXT
             COLOR Black, Plain
             LOCATE 15 + Xcoor - 1, 21 + Ycoor - 1, 1
             PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
             COLOR Plain, Black
             Q$ = RTRIM$(Directories(Current.Dir))
             GOSUB DisplayLongName1
          ELSE
             IF Current.Dir + 1 <= Num.Dirs THEN
                DO UNTIL Current.Dir = Num.Dirs
                   IF Dir.Box.Line < 10 THEN
                      LOCATE Dir.Box.Line + 5 + Xcoor - 1, 21 + Ycoor - 1, 1
                      COLOR Plain, Black
                      PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
                      Dir.Box.Line = Dir.Box.Line + 1
                      Current.Dir = Current.Dir + 1
                      LOCATE Dir.Box.Line + 5 + Xcoor - 1, 21 + Ycoor - 1, 1
                      COLOR Black, Plain
                      PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
                      COLOR Plain, Black
                   ELSE
                      GOSUB ClearDirBox
                      Current.Dir = Current.Dir + 1
                      COLOR Plain, Black
                      FOR V = 1 TO 9
                         LOCATE 15 - V + Xcoor - 1, 21 + Ycoor - 1, 1
                         PRINT LEFT$(RTRIM$(Directories(Current.Dir - V)), 12);
                      NEXT
                      COLOR Black, Plain
                      LOCATE 15 + Xcoor - 1, 21 + Ycoor - 1, 1
                      PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
                      COLOR Plain, Black
                   END IF
                LOOP
                Q$ = RTRIM$(Directories(Current.Dir))
                GOSUB DisplayLongName1
             END IF
          END IF
       CASE 71 ' home
          IF Current.Dir > 1 THEN
             Dir.Box.Line = 1
             Current.Dir = 1
          END IF
          GOSUB ClearDirBox
          COLOR Plain, Black
          FOR V = 1 TO 9
             IF Current.Dir + V <= Num.Dirs THEN
                LOCATE 6 + V + Xcoor - 1, 21 + Ycoor - 1, 1
                PRINT LEFT$(RTRIM$(Directories(Current.Dir + V)), 12);
             END IF
          NEXT
          COLOR Black, Plain
          LOCATE 6 + Xcoor - 1, 21 + Ycoor - 1, 1
          PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
          COLOR Plain, Black
          Q$ = RTRIM$(Directories(Current.Dir))
          GOSUB DisplayLongName1
       CASE 79 ' end
          IF Current.Dir + 1 <= Num.Dirs THEN
             DO UNTIL Current.Dir = Num.Dirs
                IF Dir.Box.Line < 10 THEN
                   LOCATE Dir.Box.Line + 5 + Xcoor - 1, 21 + Ycoor - 1, 1
                   COLOR Plain, Black
                   PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
                   Dir.Box.Line = Dir.Box.Line + 1
                   Current.Dir = Current.Dir + 1
                   LOCATE Dir.Box.Line + 5 + Xcoor - 1, 21 + Ycoor - 1, 1
                   COLOR Black, Plain
                   PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
                   COLOR Plain, Black
                ELSE
                   GOSUB ClearDirBox
                   Current.Dir = Current.Dir + 1
                   COLOR Plain, Black
                   FOR V = 1 TO 9
                      LOCATE 15 - V + Xcoor - 1, 21 + Ycoor - 1, 1
                      PRINT LEFT$(RTRIM$(Directories(Current.Dir - V)), 12);
                   NEXT
                   COLOR Black, Plain
                   LOCATE 15 + Xcoor - 1, 21 + Ycoor - 1, 1
                   PRINT LEFT$(RTRIM$(Directories(Current.Dir)), 12);
                   COLOR Plain, Black
                END IF
             LOOP
             Q$ = RTRIM$(Directories(Current.Dir))
             GOSUB DisplayLongName1
          END IF
       END SELECT
    END IF
 LOOP
 RETURN

MainMenu:
' define screen offsets,
' allows menu centering.
Xcoor = 5
Ycoor = 20
' draw menu
COLOR , 1
CLS
LOCATE Xcoor, Ycoor
COLOR , 0
COLOR Yellow
PRINT CHR$(ULcorner) + STRING$(33, Hline) + CHR$(URcorner)
LOCATE Xcoor + 1, Ycoor
PRINT CHR$(Vline) + " ";
COLOR White
PRINT "Filename:";
COLOR Yellow
PRINT "                       " + CHR$(Vline)
LOCATE Xcoor + 2, Ycoor
PRINT CHR$(Vline) + "                                 " + CHR$(Vline)
LOCATE Xcoor + 3, Ycoor
PRINT CHR$(Vline) + " ";
COLOR White
PRINT "Files:           Directories:   ";
COLOR Yellow
PRINT CHR$(Vline)
LOCATE Xcoor + 4, Ycoor
PRINT CHR$(Vline);
COLOR Magenta
PRINT " " + CHR$(ULcorner) + STRING$(12, Hline) + CHR$(URcorner) + "   ";
PRINT CHR$(ULcorner) + STRING$(12, Hline) + CHR$(URcorner) + " ";
COLOR Yellow
PRINT CHR$(Vline)
COLOR Yellow
LOCATE Xcoor + 5, Ycoor
PRINT CHR$(Vline);
COLOR Magenta
PRINT " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "   " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + " ";
COLOR Yellow
PRINT CHR$(Vline)
COLOR Yellow
LOCATE Xcoor + 6, Ycoor
PRINT CHR$(Vline);
COLOR Magenta
PRINT " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "   " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + " ";
COLOR Yellow
PRINT CHR$(Vline)
COLOR Yellow
LOCATE Xcoor + 7, Ycoor
PRINT CHR$(Vline);
COLOR Magenta
PRINT " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "   " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + " ";
COLOR Yellow
PRINT CHR$(Vline)
COLOR Yellow
LOCATE Xcoor + 8, Ycoor
PRINT CHR$(Vline);
COLOR Magenta
PRINT " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "   " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + " ";
COLOR Yellow
PRINT CHR$(Vline)
COLOR Yellow
LOCATE Xcoor + 9, Ycoor
PRINT CHR$(Vline);
COLOR Magenta
PRINT " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "   " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + " ";
COLOR Yellow
PRINT CHR$(Vline)
COLOR Yellow
LOCATE Xcoor + 10, Ycoor
PRINT CHR$(Vline);
COLOR Magenta
PRINT " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "   " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + " ";
COLOR Yellow
PRINT CHR$(Vline)
COLOR Yellow
LOCATE Xcoor + 11, Ycoor
PRINT CHR$(Vline);
COLOR Magenta
PRINT " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "   " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + " ";
COLOR Yellow
PRINT CHR$(Vline)
COLOR Yellow
LOCATE Xcoor + 12, Ycoor
PRINT CHR$(Vline);
COLOR Magenta
PRINT " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "   " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + " ";
COLOR Yellow
PRINT CHR$(Vline)
COLOR Yellow
LOCATE Xcoor + 13, Ycoor
PRINT CHR$(Vline);
COLOR Magenta
PRINT " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "   " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + " ";
COLOR Yellow
PRINT CHR$(Vline)
COLOR Yellow
LOCATE Xcoor + 14, Ycoor
PRINT CHR$(Vline);
COLOR Magenta
PRINT " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "   " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + " ";
COLOR Yellow
PRINT CHR$(Vline)
COLOR Yellow
LOCATE Xcoor + 15, Ycoor
PRINT CHR$(Vline);
COLOR Magenta
PRINT " " + CHR$(LLcorner) + STRING$(12, Hline) + CHR$(LRcorner) + "   ";
PRINT CHR$(LLcorner) + STRING$(12, Hline) + CHR$(LRcorner) + " ";
COLOR Yellow
PRINT CHR$(Vline)
LOCATE Xcoor + 16, Ycoor
PRINT CHR$(LLcorner) + STRING$(33, Hline) + CHR$(LRcorner)
IF Xcoor - 1 > 0 THEN
   COLOR Green, Blue
   LOCATE Xcoor - 1, Ycoor
   PRINT "Hexedit v2.7a for Windows/DOS 2002.";
END IF
IF Xcoor + 17 <= 24 THEN
   COLOR Green, Blue
   LOCATE Xcoor + 17, Ycoor
   PRINT "Path:";
END IF
IF Xcoor + 18 <= 24 THEN
   COLOR Green, Blue
   LOCATE Xcoor + 18, Ycoor
   PRINT "File:";
END IF
COLOR Plain, Black
RETURN

' display path
DisplayCurrentPath:
 Q$ = D$
 FOR Var = LEN(Q$) TO 1 STEP -1
    IF MID$(Q$, Var, 1) = "\" THEN
       Q$ = MID$(Q$, Var + 1)
       EXIT FOR
    END IF
 NEXT
 IF Q$ = "" THEN
    Q$ = "\"
 END IF
 GOSUB DisplayLongName1
 RETURN

' display long directory
DisplayLongName1:
 IF Q$ = "." THEN
    RETURN
 END IF
' IF Q$ = ".." THEN
'    GOSUB ClearLongName1
'    RETURN
' END IF
 COLOR Green, Blue
 IF Xcoor + 17 <= 24 THEN
    Length = 80 - Ycoor - 1
    LOCATE Xcoor + 17, Ycoor
    PRINT SPACE$(Length);
    LOCATE Xcoor + 17, Ycoor
    P$ = "Path: " + Q$
    IF LEN(P$) > Length THEN
       P$ = LEFT$(P$, Length - 3) + "..."
    END IF
    PRINT P$;
 END IF
 COLOR Plain, Black
 RETURN

' display long filename
DisplayLongName2:
 COLOR Green, Blue
 IF Xcoor + 18 <= 24 THEN
    Length = 80 - Ycoor - 1
    LOCATE Xcoor + 18, Ycoor
    PRINT SPACE$(Length);
    LOCATE Xcoor + 18, Ycoor
    P$ = "File: " + E$
    IF LEN(P$) > Length THEN
       P$ = LEFT$(P$, Length - 3) + "..."
    END IF
    PRINT P$;
 END IF
 COLOR Plain, Black
 RETURN

' clear long directory area
ClearLongName1:
 COLOR Green, Blue
 IF Xcoor + 17 <= 24 THEN
    Length = 80 - Ycoor - 1
    LOCATE Xcoor + 17, Ycoor
    PRINT SPACE$(Length);
    LOCATE Xcoor + 17, Ycoor
    PRINT "Path: ";
 END IF
 COLOR Plain, Black
 RETURN

' clear long filename area
ClearLongName2:
 COLOR Green, Blue
 IF Xcoor + 18 <= 24 THEN
    Length = 80 - Ycoor - 1
    LOCATE Xcoor + 18, Ycoor
    PRINT SPACE$(Length);
    LOCATE Xcoor + 18, Ycoor
    PRINT "File: ";
 END IF
 COLOR Plain, Black
 RETURN

' check windows dos
TestWindows:
 InregsX.AX = &H160A
 CALL InterruptX(&H2F, InregsX, OutregsX)
 IF OutregsX.AX = False THEN
    Temp = (OutregsX.BX AND &HFF00) / 256
    IF Temp >= 4 THEN
       Windows.Detected = True
    END IF
 END IF
 RETURN

' return current drive.
InitDrive:
 InregsX.AX = &H1900
 CALL InterruptX(&H21, InregsX, OutregsX)
 Drive.Number = OutregsX.AX AND &HFF
 C$ = CHR$(Drive.Number + 65)
 RETURN

' return current directory.
InitDir:
 ' check windows dos
 IF Windows.Detected THEN
    ' get current directory
    InregsX.AX = &H7147
    InregsX.DX = Drive.Number + 1
    InregsX.DS = VARSEG(ASCIIZ3)
    InregsX.SI = VARPTR(ASCIIZ3)
    CALL InterruptX(&H21, InregsX, OutregsX)
 ELSE
    ' get current directory
    InregsX.AX = &H4700
    InregsX.DX = Drive.Number + 1
    InregsX.DS = VARSEG(ASCIIZ3)
    InregsX.SI = VARPTR(ASCIIZ3)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 D$ = LEFT$(ASCIIZ3, INSTR(ASCIIZ3, CHR$(0)) - 1)
 RETURN

' initialize directory/filename record.
OpenDataFiles:
 CLOSE #2, #3
 V$ = ENVIRON$("TMP")
 IF V$ = "" THEN
    V$ = ENVIRON$("TEMP")
 END IF
 IF LEN(V$) THEN
    IF RIGHT$(V$, 1) = "\" THEN
       F1$ = V$ + "HEXEDIT1.DAT"
    ELSE
       F1$ = V$ + "\HEXEDIT1.DAT"
    END IF
    IF RIGHT$(V$, 1) = "\" THEN
       F2$ = V$ + "HEXEDIT2.DAT"
    ELSE
       F2$ = V$ + "\HEXEDIT2.DAT"
    END IF
    GOSUB TestFile
 END IF
 IF Var = False THEN
    F1$ = "C:\TEMP\HEXEDIT1.DAT"
    F2$ = "C:\TEMP\HEXEDIT2.DAT"
    GOSUB TestFile
    IF Var = False THEN
       F1$ = "HEXEDIT1.DAT"
       F2$ = "HEXEDIT2.DAT"
       GOSUB TestFile
       IF Var = False THEN
          ERROR 76
          END
       END IF
    END IF
 END IF
 IF Windows.Detected THEN
    OPEN F1$ FOR RANDOM AS #2 LEN = LEN(WinFileStruc)
    OPEN F2$ FOR RANDOM AS #3 LEN = LEN(WinFileStruc)
 ELSE
    OPEN F1$ FOR RANDOM AS #2 LEN = LEN(DosFileStruc)
    OPEN F2$ FOR RANDOM AS #3 LEN = LEN(DosFileStruc)
 END IF
 RETURN

' test data file exists.
' returns: Var=-1 if file exists,
'   or non-existent & can be created.
TestFile:
 Var = False
 ASCIIZ = F1$ + CHR$(0)
 InregsX.AX = &H4300
 InregsX.DS = VARSEG(ASCIIZ)
 InregsX.DX = VARPTR(ASCIIZ)
 CALL InterruptX(&H21, InregsX, OutregsX)
 IF (OutregsX.Flags AND &H1) = &H0 THEN
    Var = True
 END IF
 ' check file nonexistent.
 IF (OutregsX.AX) = 2 THEN
    Var = True
 END IF
 RETURN

' load current subdirectories.
LoadDirSpec:
 Num.Dirs = 0
 GOSUB SetDTA
 ' find first directory
 IF D$ = "" THEN
    ASCIIZ3 = C$ + ":\*.*" + CHR$(0)
 ELSE
    IF D$ = "\" THEN
       ASCIIZ3 = C$ + ":\*.*" + CHR$(0)
    ELSE
       ASCIIZ3 = C$ + ":\" + D$ + "\*.*" + CHR$(0)
    END IF
 END IF
 IF Windows.Detected THEN
    InregsX.AX = &H714E
    InregsX.CX = &H37
    InregsX.SI = &H1
    InregsX.DS = VARSEG(ASCIIZ3)
    InregsX.DX = VARPTR(ASCIIZ3)
    InregsX.ES = VARSEG(WDTAfile)
    InregsX.DI = VARPTR(WDTAfile)
    CALL InterruptX(&H21, InregsX, OutregsX)
    Wfile.Handle = OutregsX.AX
 ELSE
    InregsX.AX = &H4E00
    InregsX.CX = &H37
    InregsX.DS = VARSEG(ASCIIZ3)
    InregsX.DX = VARPTR(ASCIIZ3)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 ' store directories
 DO
    ' check for directory
    IF Windows.Detected THEN
       Attribute = ASC(WDTAfile.FileBits)
    ELSE
       Attribute = ASC(DTAfile.FileBits)
    END IF
    IF (Attribute AND &H10) = &H10 THEN
       ' store directory name
       IF Windows.Detected THEN
          E$ = WDTAfile.ASCIIZfull
       ELSE
          E$ = DTAfile.ASCIIZfilename
       END IF
       IF INSTR(E$, CHR$(0)) THEN
          E$ = LEFT$(E$, INSTR(E$, CHR$(0)) - 1)
       END IF
       IF Num.Dirs < 32767 THEN
          Num.Dirs = Num.Dirs + 1
          IF Windows.Detected THEN
             WinFileStruc.Name = E$
             PUT 3, Num.Dirs, WinFileStruc
          ELSE
             DosFileStruc.Name = E$
             PUT 3, Num.Dirs, DosFileStruc
          END IF
       END IF
    END IF
    ' find next directory
    IF Windows.Detected THEN
       ' find next long filename
       InregsX.AX = &H714F
       InregsX.BX = Wfile.Handle
       InregsX.SI = &H1
       InregsX.ES = VARSEG(WDTAfile)
       InregsX.DI = VARPTR(WDTAfile)
       CALL InterruptX(&H21, InregsX, OutregsX)
    ELSE
       ' find next directory
       InregsX.AX = &H4F00
       CALL InterruptX(&H21, InregsX, OutregsX)
    END IF
    ' check findnext error
    IF (OutregsX.Flags AND &H1) = &H1 THEN
       EXIT DO
    END IF
 LOOP
 ' check windows dos
 IF Windows.Detected THEN
    ' close long filename search
    InregsX.AX = &H71A1
    InregsX.BX = Wfile.Handle
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 IF Num.Dirs = 0 THEN
    IF Windows.Detected THEN
       WinFileStruc.Name = "."
       PUT 3, 1, WinFileStruc
    ELSE
       DosFileStruc.Name = "."
       PUT 3, 1, DosFileStruc
    END IF
    Num.Dirs = 1
 END IF
 GOSUB ResetDTA
 IF HeapSortOff THEN
    RETURN
 END IF
 IF Windows.Detected THEN
    GOSUB Win.Heap.Sort2
 ELSE
    GOSUB Dos.Heap.Sort2
 END IF
 RETURN

DisplayDirSpec:
 VarX = 0
 DO
    VarX = VarX + 1
    IF VarX > 10 THEN
       EXIT DO
    END IF
    IF VarX > Num.Dirs THEN
       EXIT DO
    END IF
    LOCATE VarX + 5 + Xcoor - 1, 21 + Ycoor - 1, 1
    E$ = Directories(VarX)
    E$ = RTRIM$(E$)
    PRINT LEFT$(E$, 12);
 LOOP
 RETURN

ClearDirBox:
 FOR VarX = 1 TO 10
    LOCATE VarX + 5 + Xcoor - 1, 21 + Ycoor - 1, 1
    PRINT SPACE$(12);
 NEXT
 RETURN

DisplayCurrentDir:
 ' deconcatenate long path with \..\ characters
 Z$ = C$ + ":\" + D$
 DO
    IF LEN(Z$) > 32 THEN
       V1 = INSTR(Z$, "\")
       IF V1 > 0 THEN
          DO
             IF MID$(Z$, V1, 4) = "\..\" THEN
                V1 = INSTR(V1 + 1, Z$, "\")
             ELSE
                EXIT DO
             END IF
          LOOP
          V2 = INSTR(V1 + 1, Z$, "\")
          IF V2 > 0 THEN
             Z$ = LEFT$(Z$, V1) + ".." + MID$(Z$, V2)
          ELSE
             EXIT DO
          END IF
       END IF
    ELSE
       EXIT DO
    END IF
 LOOP
 DO
    V = INSTR(Z$, "\..\..\")
    IF V > 0 THEN
       Z$ = LEFT$(Z$, V - 1) + "\..\" + MID$(Z$, V + 7)
    ELSE
       EXIT DO
    END IF
 LOOP
 IF LEN(Z$) > 32 THEN
    Z$ = LEFT$(Z$, 32)
 END IF
 LOCATE 3 + Xcoor - 1, 3 + Ycoor - 1, 1
 PRINT SPACE$(32);
 LOCATE 3 + Xcoor - 1, 3 + Ycoor - 1, 1
 PRINT Z$;
 RETURN

' load specified files.
LoadFileSpec:
 Num.Files = 0
 GOSUB SetDTA
 ' find first file
 ASCIIZ3 = F$ + CHR$(0)
 IF Windows.Detected THEN
    InregsX.AX = &H714E
    InregsX.CX = &H27
    InregsX.SI = &H1
    InregsX.DS = VARSEG(ASCIIZ3)
    InregsX.DX = VARPTR(ASCIIZ3)
    InregsX.ES = VARSEG(WDTAfile)
    InregsX.DI = VARPTR(WDTAfile)
    CALL InterruptX(&H21, InregsX, OutregsX)
    Wfile.Handle = OutregsX.AX
 ELSE
    InregsX.AX = &H4E00
    InregsX.CX = &H27
    InregsX.DS = VARSEG(ASCIIZ3)
    InregsX.DX = VARPTR(ASCIIZ3)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 ' store files
 DO
    ' check findnext error
    IF (OutregsX.Flags AND &H1) = &H1 THEN
       EXIT DO
    END IF
    ' check for file
    IF Windows.Detected THEN
       Attribute = ASC(WDTAfile.FileBits)
    ELSE
       Attribute = ASC(DTAfile.FileBits)
    END IF
    IF (Attribute AND &H10) <> &H10 THEN
       ' store directory name
       IF Windows.Detected THEN
          E$ = WDTAfile.ASCIIZfull
       ELSE
          E$ = DTAfile.ASCIIZfilename
       END IF
       IF INSTR(E$, CHR$(0)) THEN
          E$ = LEFT$(E$, INSTR(E$, CHR$(0)) - 1)
       END IF
       IF Num.Files < 32767 THEN
          Num.Files = Num.Files + 1
          IF Windows.Detected THEN
             WinFileStruc.Name = E$
             PUT 2, Num.Files, WinFileStruc
          ELSE
             DosFileStruc.Name = E$
             PUT 2, Num.Files, DosFileStruc
          END IF
       END IF
    END IF
    ' find next file
    IF Windows.Detected THEN
       ' find next long filename
       InregsX.AX = &H714F
       InregsX.BX = Wfile.Handle
       InregsX.SI = &H1
       InregsX.ES = VARSEG(WDTAfile)
       InregsX.DI = VARPTR(WDTAfile)
       CALL InterruptX(&H21, InregsX, OutregsX)
    ELSE
       ' find next directory
       InregsX.AX = &H4F00
       CALL InterruptX(&H21, InregsX, OutregsX)
    END IF
 LOOP
 ' check windows dos
 IF Windows.Detected THEN
    ' close long filename search
    InregsX.AX = &H71A1
    InregsX.BX = Wfile.Handle
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 GOSUB ResetDTA
 LOCATE Xcoor + 3, Ycoor + 9
 PRINT SPACE$(10);
 LOCATE Xcoor + 3, Ycoor + 9
 COLOR White
 PRINT "(" + MID$(STR$(Num.Files), 2) + ")";
 COLOR 7
 IF HeapSortOff THEN
    RETURN
 END IF
 COLOR White
 LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
 PRINT SPACE$(12);
 LOCATE 2 + Xcoor - 1, 13 + Ycoor - 1, 1
 PRINT "Sorting..";
 COLOR 7
 IF Windows.Detected THEN
    GOSUB Win.Heap.Sort1
 ELSE
    GOSUB Dos.Heap.Sort1
 END IF
 RETURN

DisplayFileSpec:
 VarX = 0
 DO
    VarX = VarX + 1
    IF VarX > 10 THEN
       EXIT DO
    END IF
    IF VarX > Num.Files THEN
       EXIT DO
    END IF
    LOCATE VarX + 5 + Xcoor - 1, 4 + Ycoor - 1, 1
    E$ = Filenames(VarX)
    E$ = RTRIM$(E$)
    PRINT LEFT$(E$, 12);
 LOOP
 RETURN

ClearFileBox:
 FOR VarX = 1 TO 10
    LOCATE VarX + 5 + Xcoor - 1, 4 + Ycoor - 1, 1
    PRINT SPACE$(12);
 NEXT
 RETURN

' assign program dta.
SetDTA:
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(DTAfile)
 InregsX.DX = VARPTR(DTAfile)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN

' restore basic dta.
ResetDTA:
 InregsX.AX = &H1A00
 InregsX.DS = BASIC.DTA.SEG
 InregsX.DX = BASIC.DTA.OFF
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN

' sorts windows hexedit1.dat file.
Win.Heap.Sort1:
 IF Num.Files < 2 THEN
    RETURN
 END IF
 Num = Num.Files
 FOR I = 2 TO Num
    J = I
    DO UNTIL J = 1
       P = J \ 2
       I1$ = Filenames(J)
       I2$ = Filenames(P)
       IF I1$ > I2$ THEN
          WinFileStruc.Name = I2$
          PUT 2, J, WinFileStruc
          WinFileStruc.Name = I1$
          PUT 2, P, WinFileStruc
          J = P
       ELSE
          EXIT DO
       END IF
    LOOP
 NEXT
 FOR I = Num TO 2 STEP -1
    I1$ = Filenames(1)
    I2$ = Filenames(I)
    WinFileStruc.Name = I2$
    PUT 2, 1, WinFileStruc
    WinFileStruc.Name = I1$
    PUT 2, I, WinFileStruc
    J = 1
    DO
       IF 2! * CSNG(J) > CSNG(I) - 1! THEN
          EXIT DO
       END IF
       C = 2 * J
       IF C + 1 <= I - 1 THEN
          IF Filenames(C + 1) > Filenames(C) THEN
             C = C + 1
          END IF
       END IF
       I1$ = Filenames(J)
       I2$ = Filenames(C)
       IF I1$ < I2$ THEN
          WinFileStruc.Name = I2$
          PUT 2, J, WinFileStruc
          WinFileStruc.Name = I1$
          PUT 2, C, WinFileStruc
          J = C
       ELSE
          EXIT DO
       END IF
    LOOP
 NEXT
 RETURN

' sorts dos hexedit1.dat file.
Dos.Heap.Sort1:
 IF Num.Files < 2 THEN
    RETURN
 END IF
 Num = Num.Files
 FOR I = 2 TO Num
    J = I
    DO UNTIL J = 1
       P = J \ 2
       I1$ = Filenames(J)
       I2$ = Filenames(P)
       IF I1$ > I2$ THEN
          DosFileStruc.Name = I2$
          PUT 2, J, DosFileStruc
          DosFileStruc.Name = I1$
          PUT 2, P, DosFileStruc
          J = P
       ELSE
          EXIT DO
       END IF
    LOOP
 NEXT
 FOR I = Num TO 2 STEP -1
    I1$ = Filenames(1)
    I2$ = Filenames(I)
    DosFileStruc.Name = I2$
    PUT 2, 1, DosFileStruc
    DosFileStruc.Name = I1$
    PUT 2, I, DosFileStruc
    J = 1
    DO
       IF 2! * CSNG(J) > CSNG(I) - 1! THEN
          EXIT DO
       END IF
       C = 2 * J
       IF C + 1 <= I - 1 THEN
          IF Filenames(C + 1) > Filenames(C) THEN
             C = C + 1
          END IF
       END IF
       I1$ = Filenames(J)
       I2$ = Filenames(C)
       IF I1$ < I2$ THEN
          DosFileStruc.Name = I2$
          PUT 2, J, DosFileStruc
          DosFileStruc.Name = I1$
          PUT 2, C, DosFileStruc
          J = C
       ELSE
          EXIT DO
       END IF
    LOOP
 NEXT
 RETURN

' sorts windows hexedit2.dat file.
Win.Heap.Sort2:
 IF Num.Dirs < 2 THEN
    RETURN
 END IF
 Num = Num.Dirs
 FOR I = 2 TO Num
    J = I
    DO UNTIL J = 1
       P = J \ 2
       I1$ = Directories(J)
       I2$ = Directories(P)
       IF I1$ > I2$ THEN
          WinFileStruc.Name = I2$
          PUT 3, J, WinFileStruc
          WinFileStruc.Name = I1$
          PUT 3, P, WinFileStruc
          J = P
       ELSE
          EXIT DO
       END IF
    LOOP
 NEXT
 FOR I = Num TO 2 STEP -1
    I1$ = Directories(1)
    I2$ = Directories(I)
    WinFileStruc.Name = I2$
    PUT 3, 1, WinFileStruc
    WinFileStruc.Name = I1$
    PUT 3, I, WinFileStruc
    J = 1
    DO
       IF 2! * CSNG(J) > CSNG(I) - 1! THEN
          EXIT DO
       END IF
       C = 2 * J
       IF C + 1 <= I - 1 THEN
          IF Directories(C + 1) > Directories(C) THEN
             C = C + 1
          END IF
       END IF
       I1$ = Directories(J)
       I2$ = Directories(C)
       IF I1$ < I2$ THEN
          WinFileStruc.Name = I2$
          PUT 3, J, WinFileStruc
          WinFileStruc.Name = I1$
          PUT 3, C, WinFileStruc
          J = C
       ELSE
          EXIT DO
       END IF
    LOOP
 NEXT
 RETURN

' sorts dos hexedit2.dat file.
Dos.Heap.Sort2:
 IF Num.Dirs < 2 THEN
    RETURN
 END IF
 Num = Num.Dirs
 FOR I = 2 TO Num
    J = I
    DO UNTIL J = 1
       P = J \ 2
       I1$ = Directories(J)
       I2$ = Directories(P)
       IF I1$ > I2$ THEN
          DosFileStruc.Name = I2$
          PUT 3, J, DosFileStruc
          DosFileStruc.Name = I1$
          PUT 3, P, DosFileStruc
          J = P
       ELSE
          EXIT DO
       END IF
    LOOP
 NEXT
 FOR I = Num TO 2 STEP -1
    I1$ = Directories(1)
    I2$ = Directories(I)
    DosFileStruc.Name = I2$
    PUT 3, 1, DosFileStruc
    DosFileStruc.Name = I1$
    PUT 3, I, DosFileStruc
    J = 1
    DO
       IF 2! * CSNG(J) > CSNG(I) - 1! THEN
          EXIT DO
       END IF
       C = 2 * J
       IF C + 1 <= I - 1 THEN
          IF Directories(C + 1) > Directories(C) THEN
             C = C + 1
          END IF
       END IF
       I1$ = Directories(J)
       I2$ = Directories(C)
       IF I1$ < I2$ THEN
          DosFileStruc.Name = I2$
          PUT 3, J, DosFileStruc
          DosFileStruc.Name = I1$
          PUT 3, C, DosFileStruc
          J = C
       ELSE
          EXIT DO
       END IF
    LOOP
 NEXT
 RETURN

' simple error routine
Error.Routine:
 CLS
 COLOR White
 PRINT "Hex Editor Menu " + Version + " " + Release + " critical error trap:"
 COLOR Yellow
 ErrorTrap = ERR
 SELECT CASE ERR
 CASE 5
    PRINT "Syntax error." ' should not happen.
 CASE 9
    PRINT "Subscript out of range."
 CASE 14
    PRINT "Out of string space."
 CASE 24
    PRINT "Device timeout."
 CASE 25
    PRINT "Device fault."
 CASE 27
    PRINT "Out of paper."
 CASE 52
    PRINT "Bad file name or number."
 CASE 53
    PRINT "File not found."
 CASE 54
    PRINT "Bad file mode."
 CASE 55
    PRINT "File already open."
 CASE 57
    PRINT "Device I/O error."
 CASE 58
    PRINT "File already exists."
 CASE 59
    PRINT "Bad record length."
 CASE 61
    PRINT "Disk full."
 CASE 62
    PRINT "Input past eof."
 CASE 63
    PRINT "Bad record length."
 CASE 64
    PRINT "Bad filename."
 CASE 67
    PRINT "Not enough file handles."
 CASE 68
    PRINT "Device unavailable."
 CASE 70
    PRINT "Permission denied."
 CASE 71
    PRINT "Disk not ready."
 CASE 72
    PRINT "Disk-media error."
 CASE 75
    PRINT "Path/File access error."
 CASE 76
    PRINT "Pathname not found."
 CASE 81
    PRINT "Invalid name."
 CASE ELSE
    PRINT "Untrapped error" + STR$(ERR) + "."
 END SELECT
 ' display error prompt.
 COLOR Green
 PRINT "Check temp variables, or DOS file handles, then restart."
 COLOR Plain
 END
END SUB
