                          Table of Contents
        
        Preface . . . . . . . . . . . . . . . . . . . . . . . . . . .   i

        address . . . . . . . . . . . . . . . . . . . . . . . . . . .   i

        GETTING STARTED . . . . . . . . . . . . . . . . . . . . . . .   1

        BASIC CONSIDERATIONS  . . . . . . . . . . . . . . . . . . . .   3

        CURSOR MOVEMENT / NAVIGATION  . . . . . . . . . . . . . . . .   7

        REFERENCE SECTION . . . . . . . . . . . . . . . . . . . . . .   9
             CHANGE TYPE  . . . . . . . . . . . . . . . . . . . . . .   9
             CHANGE NAME  . . . . . . . . . . . . . . . . . . . . . .  10
             COMPARE  . . . . . . . . . . . . . . . . . . . . . . . .  10
             COMPLEMENT . . . . . . . . . . . . . . . . . . . . . . .  11
             COPY . . . . . . . . . . . . . . . . . . . . . . . . . .  11
             CREATE . . . . . . . . . . . . . . . . . . . . . . . . .  12
             DELETE SEQUENCE  . . . . . . . . . . . . . . . . . . . .  12
             DELETE to end of line  . . . . . . . . . . . . . . . . .  12
             DELETE to end of sequence  . . . . . . . . . . . . . . .  12
             ERROR MESSAGES . . . . . . . . . . . . . . . . . . . . .  12
             FILES  . . . . . . . . . . . . . . . . . . . . . . . . .  13
             FIND . . . . . . . . . . . . . . . . . . . . . . . . . .  14
             GENETIC CODE . . . . . . . . . . . . . . . . . . . . . .  15
             GET  . . . . . . . . . . . . . . . . . . . . . . . . . .  16
             GOTO . . . . . . . . . . . . . . . . . . . . . . . . . .  16
             HELP . . . . . . . . . . . . . . . . . . . . . . . . . .  17
             HORIZONTAL SCROLL  . . . . . . . . . . . . . . . . . . .  17
             INPUT  . . . . . . . . . . . . . . . . . . . . . . . . .  18
             INPUT/OUTPUT commands  . . . . . . . . . . . . . . . . .  18
             INSERT/TYPEOVER  . . . . . . . . . . . . . . . . . . . .  19
             JOIN . . . . . . . . . . . . . . . . . . . . . . . . . .  19
             LOWER CASE . . . . . . . . . . . . . . . . . . . . . . .  19
             MATCH  . . . . . . . . . . . . . . . . . . . . . . . . .  19
             MOVE . . . . . . . . . . . . . . . . . . . . . . . . . .  20
             OUTPUT . . . . . . . . . . . . . . . . . . . . . . . . .  20
             PRINT-OUT  . . . . . . . . . . . . . . . . . . . . . . .  21
             PUT  . . . . . . . . . . . . . . . . . . . . . . . . . .  24
             PUT ALL  . . . . . . . . . . . . . . . . . . . . . . . .  24
             QUIT . . . . . . . . . . . . . . . . . . . . . . . . . .  24
             RE-DEFINE ORIENTATION  . . . . . . . . . . . . . . . . .  25
             REMOVE NUMBERS AND SPACES  . . . . . . . . . . . . . . .  25
             REMOVE SPACES  . . . . . . . . . . . . . . . . . . . . .  25
             REPLACE  . . . . . . . . . . . . . . . . . . . . . . . .  25
             REPLICATE  . . . . . . . . . . . . . . . . . . . . . . .  26
             RESTORE  . . . . . . . . . . . . . . . . . . . . . . . .  26
             REVERSE  . . . . . . . . . . . . . . . . . . . . . . . .  26
             SLIDE LEFT . . . . . . . . . . . . . . . . . . . . . . .  26
             SLIDE RIGHT  . . . . . . . . . . . . . . . . . . . . . .  27
             SAVE . . . . . . . . . . . . . . . . . . . . . . . . . .  27
             SCROLL . . . . . . . . . . . . . . . . . . . . . . . . .  27
             SPACE IN 3 . . . . . . . . . . . . . . . . . . . . . . .  28               SPACE IN n . . . . . . . . . . . . . . . . . . . . . . .  28
             TAB  . . . . . . . . . . . . . . . . . . . . . . . . . .  28
             TYPEOVER . . . . . . . . . . . . . . . . . . . . . . . .  28
             TRANSLATE  . . . . . . . . . . . . . . . . . . . . . . .  29
             UNDO . . . . . . . . . . . . . . . . . . . . . . . . . .  29
             UPPER CASE . . . . . . . . . . . . . . . . . . . . . . .  30
             VERTICAL SCROLL  . . . . . . . . . . . . . . . . . . . .  30
             WALLS  . . . . . . . . . . . . . . . . . . . . . . . . .  30
             WIPE . . . . . . . . . . . . . . . . . . . . . . . . . .  30
                                       ESEE




                            The EyeBall Sequence Editor 


                                   Version 1.04

                   Copyright (c) Eric Cabot 1987,1988,1989,1990
                               All Rights Reserved.





        The author, Eric Cabot, makes no  warranty, express or implied to
        you or any other person or entity. The author will not be liable
        for incidental, consequential or other similar damages arising
        through the use of this manual or the software described herein.


                                        Preface 

   My original intent in creating a multiple sequence editor was to provide
   scientists with a basic word-processor for rather routine and naturally
   obvious editing and presentation tasks because none was available.  As you
   use ESEE please forgive me for providing any but the bare basic tools
   necessary for actual sequence analysis. There are so many ways to analyze
   data that I have had to, perforce, leave all decisions about what to
   actually do with the data in the hands of individual users.  This, of
   course, has  permitted me to primarily concentrate on editing problems, per
   se, and in addition has certainly hastened the release of ESEE to a needy
   world.  Hopefully, these trade-offs will seem worth it. 

   I would like to thank all of the early ESEE users for their patience,
   criticisms and suggestions.  Without the contributions of those many
   individuals, the program's quality most assuredly would have suffered. 
   Special thanks are due to:  A.T. Beckenbach, D. L. Baillie, M.J. Smith, W.
   Kelley Thomas and J. Boom.   Delaney Software Ltd. is also to be thanked,
   not only for providing the sequence database routines used by the program
   SEQNCE, but also for permitting any modifications that were deemed
   necessary.


   If you are reading this and are not a registered user of ESEE then you are
   fortunate to have gotten something for nothing; you're welcome.    Please
   address all correspondance to


                  Eric. Cabot
                  Department of Biology
                  University of Rochester
                  Rochester, NY, 14627
                        

   I would be pleased to hear from any users, registered or not, who may have
   uncovered a bug in the program. 


   So why bother registering?  The most significant reason is that update and
   other useful information is sent directly to any registered users. Since
   little bugs do pop-up now and then, ESEE is gets revised on a frequent basis.
   For the time being, updates are being provided, free of charge, to registered
   users, by request.








                                    i                    ESEE Owner's Manual

                                                        GETTING STARTED  1


  GETTING STARTED

     The EyeBall Sequence Editor (ESEE) is a multi-sequence editing program
  specifically developed for the entry, manipulation and presentation of nucleic
  acid and amino acid sequences.  The program always treats  sequences as
  independent entities and refers to each only by number and cursor position. 
  When you first enter the editor there is one empty sequence of type N.  In
  order to use additional sequences they must be created or input.  There are
  three ways to input data: INPUT, RESTORE or GET.  If you input when there is
  only one sequence, and that is empty, then that sequence is replaced by the
  new material.  There are six ways to create new sequences: CREATE, REPLICATE,
  COMPLEMENT, COMPARE, and MATCH.  

    ESEE is entirely memory resident and therefore need not be in the current
  directory at start-up time.  (The current directory can be changed from within
  the filer window.)  The very first screen that you will see has a key piece of
  information: the maximum number of sequences that you will be allowed to use
  based upon the amount of memory that is available after loading the program,
  which requires 140 kilobytes of memory to run with a single sequence.  Each
  additional sequence requires approximately 18.5 kilobytes.  Users with only
  256K are limited to 7 sequences.

     While you are in the editor you can get online information by depressing
  F3.  If, at any time, the file ESEEHELP.FIL is not located in the current
  directory then you will be prompted for a path name for the directory in which
  the help file is located. Once you have specified the correct path the program
  will not re-prompt you for a path to the help file unless you inadvertently
  "loose track" of the help  file by changing the current directory. You can
  change the current directory at will through the FILER window.  You can also
  get help from within the PRINT-OUT window.
   
    The sequence on which the cursor resides at any time is considered the
  current sequence.  Most of the editing commands, including most of the cursor
  movement commands, work only with the current sequence.  You can navigate to
  other sequences with the up- and down-arrow keys.  These keys also cause the
  screen to scroll at the borders of the editing area.  The current sequence
  does change when you scroll.  Certain commands (DELETE, INPUT, GET, REPLICATE,
  WIPE, and COMPLEMENT) may change the current sequence.

    The pages displayed in the editor refer to screen pages not to pages of
  print-out which are handled separately.  The last page is dynamically
  calculated as the number of sequences in use changes.  This page always
  includes the position 18,000.  






                                    1                    ESEE Owner's Manual

                                                          GETTING STARTED  2


     As the number of sequences in use increases, the number of lines of
  sequence that can be  displayed on a screen page decreases.  With 10 or more
  sequences, only one line (60 positions) of each is displayed.

      Quit the program by typing <ESC>, <RET> (i.e. the "ENTER" key), or F10. 
  You can exit most of the windows with <ESC> or F10.  In the case of the
  Genetic Code Window you must exit by typing <RET>.  The <RET> key is used to
  abort most of the editing commands but there are a few exceptions, notably
  GET, PUT, and FIND.  Read the prompts carefully until you become familiar with
  the various commands and features of ESEE.

      A final note, if anything "weird" happens to the display while you are
  editing try using UNDO to correct any problem then try updating the screen
  display by changing pages or going into one of the four available windows.  If
  you do discover a bug the author would like to hear about it AS SOON AS
  POSSIBLE since every effort is made to maintain a stable piece of software. 
  It does not matter if you are a registered user or not, REPORT ALL BUGS,
  please.






























                                    2                    ESEE Owner's Manual
                                                       GETTING STARTED    3


  BASIC CONSIDERATIONS

  Sequences:        The editor treats each sequence as a long numbered list of
                    characters.  The number assigned to a sequence reflects its
                    position as displayed by the editor, with the highest
                    numbered sequence on the bottom and the lowest (i.e #1) on
                    top. Every single character shown on the screen, including
                    spaces, walls, punctuation and other chemically nonsensical
                    characters, is considered a member of the sequence and is
                    duly assigned a sequence position.
              
  Current Sequence:  The sequence on which the cursor resides at any given 
  time.  

  Sequence Position:  Any possible numbered location for a character in a
                    sequence.  The positions are numbered starting at position 1
                    at the top left of page one and proceeding to rightward and
                    downward.  Please note that insertions/deletions invariably
                    cause changes in the numerical positions of all sequence
                    elements downstream of the point of the insertion/deletion. 
                    It is possible to assign a meaningful number to the start of
                    a sequence, to be used by the print-out process. 

   Current Position: The cursor position relative to the start of the current 
                    sequence.  It is quite possible for the current position to
                    be beyond the end of the current sequence.

   End of Sequence:  One position beyond the last actual character in a
                    sequence.  The editor displays the end of sequence as a
                    "happy face".  Many operations, including all of those that
                    change sequences, will be inhibited if the current position
                    is beyond the end of sequence.  It is possible to insert,
                    delete or backspace while the cursor is at the end of
                    sequence itself.

   Up Stream:       Towards the left and/or up. By default the upstream end is 
                    5-prime for nucleic acids and amino for proteins. 

   Down Stream:     Towards the right and/or down. By default the downstream end
                    is 3-prime for nucleic acids and carboxyl for proteins. 









                                    3                    ESEE Owner's Manual
                                                       GETTING STARTED    4


  Orientation:      Forward orientation (the default) means that the a sequence
                    is displayed in a 5-prime to 3-prime orientation (amino to
                    carboxyl for polypeptides).   The editor indicates forward
                    orientation with the symbol "  "  displayed  to the
                    immediate left of sequence.  The symbol for reverse is " ". 
                    You can either REVERSE a sequence or REDECLARE its
                    orientation, but ESEE almost always works from left to right
                    with no regard for the chemical orientation.  So remember:
                    downstream is to the right and not to the 3' end.  

  Processive Commands:  Several of the ESEE commands work in a manner that is 
                    termed "processive", meaning that the action of the parti-
                    cular command begins at the current cursor position. Pro-
                    cessive commands always work in  a downstream direction, no
                    matter what the orientation of the current sequence.        

                       
                    The following is a list of all the processive commands:

                                FIND                 REPLACE
                                SPACE in n      Space in triplets
                                REMOVE SPACES   REMOVE SPACES and Numbers
                                    TRANSLATE        DELETE to End Of Sequence
                                TAB             DELETE to End of Line
                                Shift-TAB       JOIN

                Most of the processive commands terminate at the end of sequence
                but in the case of TRANSLATE, the spacing commands, and the
                REMOVE SPACES command, the point of termination may be
                influenced by walls.  (Note: The action REMOVE SPACES AND
                NUMBERS is unaffected by walls.)

  Walls:        Walls cause the premature termination of translation or of the
                spacing commands.  In order to stop translation the wall must be
                on the product sequence (i.e. the polypeptide), not the
                template. Downstream from the first wall encountered during
                translation, the sequence remains unmoved and unchanged. If a
                wall is encountered at some position in the template, a blank is
                inserted at that position in the product.

                The REMOVE SPACES command also terminates if walls are found.
                Downstream of the wall the sequence remains fixed and any blanks
                that were removed by the command are re-inserted immediately
                upstream of the wall.




                                   4                    ESEE Owner's Manual
                                                        GETTING STARTED    5


  Sequence Types:  There are four valid types of sequence:  N, P, T, A which
                respectively stand for nucleic acid, polypeptide, triple-letter
                coded polypeptide, and anything else.  The most important
                differences between the way that the different type sequences
                are treated are summarized below.

                Print-out numbering:  At the time of print-out every single
                    character of a sequence is numbered except for sequences of
                    type T, in which case the number of characters on a  print-
                    out line is counted and divided by three.  This procedure
                    does not guarantee to produce the correct numbering. For
                    this reason the numbering on T-type sequences is suppressed,
                    by default and it is strongly recommended that you not
                   number type-T sequences.

                Translation:  The template for a sequence must be type N.  The
                    translation product must go on a sequence of either type P
                    or type T.

                COMPARE and MATCH:  You can only COMPARE/MATCH sequences of the
                    same type. You cannot use COMPARE/MATCH with type-A
                    sequences.

                Spacing: Triplet spacing works differently for type-P
                    sequences in order for them to be properly aligned with
                    nucleic acid sequences that are triplet spaced. 

                   
  Upper and Lower Case:  For the most part, upper and lowercase are freely
                    interchangeable in sequences. 


  Names:            A sequence name can be up to 64 characters, only the first
                    ten characters of which are displayed by the editor.  At
                    print-out time you can control the width of the name field. 
                    It is highly recommended that you use names to identify your
                    sequences as soon as they are brought into use but naming is
                    strictly optional.  It should be noted that, even if you
                    don't use any names at all, space will be reserved for the
                    name field on every line of the printout unless the width of
                    the name field is zero.  This feature is explained in more
                    detail in the section describing  printing in this manual. 







                                  5                    ESEE Owner's Manual
                                                        GETTING STARTED    6



  CURSOR MOVEMENT / NAVIGATION

   HOME         moves the cursor to the first position on the current line of
                the current sequence

   END          moves the cursor to the last position on the current line of the
                current sequence

   Page Down    goes down a page, unless you are already on the last possible
                page...the position of the cursor on the screen does not change
                but the current position increases by the number of positions
                that can be displayed on a page

   Page Up      works just like Page Down except in reverse
   
   Right Arr    shifts the current position downstream by 1

   Left Arr     shifts the current position upstream by 1

   Up Arr       moves the cursor up one sequence,  if the top of the screen is
                reached the screen scrolls down by one group of sequences if
                possible

   Down Arr     moves the cursor down one sequence, if the bottom of the screen
                is reached the screen scrolls up by one group of sequences if
                possible

   cnt-HOME     takes the cursor to the top-left corner of the screen on the
                current sequence

   cnt-END      takes the cursor to the bottom-right corner of the screen on the
                current sequence

   cnt-PgDn     takes the cursor to the last possible page...the screen position
                of the cursor does not change although the current position does

   cnt-PgUp     works like cnt-PgDn but the cursor moves to page 1...if the
                cursor is already on page 1 then the cursor moves to position 1
                of the current sequence

   cnt-right    shifts the current position downstream 10 positions

   cnt-left     shifts the current position upstream 10 positions





                                    6                    ESEE Owner's Manual
                                            CURSOR MOVEMENT / NAVIGATION   7


   alt =        shifts the current position to a specified position

   cnt-<RET>    shifts the current position to a the end of the current sequence

     ]          SLIDEs the current sequence downstream by one position without
                changing the cursor's position on the screen,  sliding has the
                effect of horizontally scrolling the current sequence relative
                to any other sequences

     [          SLIDEs the current sequence upstream







































                                    7                    ESEE Owner's Manual
                                                     REFERENCE SECTION  8


  REFERENCE SECTION

  CHANGE TYPE                                         alt-F4  or alt-T
   
   This command allows you to re-designate the type of the current sequence. 
   Any sequence may be designated as any of the four valid types.  

   When CHANGE TYPE is evoked, the cursor is positioned in the type field on
   the current line.  You are prompted to enter either a letter corresponding
   to a valid type, or to cycle through the list of types using the cursor-pad
   arrow keys.  The down and left keys take you one way through the list and
   the up and right keys take you the other way.  Selection is made by typing
   <RET>.

   If you accidentally call up CHANGE TYPE then typing <RET> will return you to
   edit mode with no change.

   The valid types are:
            N: nucleic acid      
            P: protein in single letter abbreviation
            T: protein in triple letter abbreviation
            A: anything else 

     The type of a sequence may affect certain commands as detailed below (also
     see the discussion of sequence types in the Basic Considerations section
     above).  TRANSLATE will only work if the current sequence is of type T or P
     and there has to be a sequence of type N somewhere above (i.e. a lower
     sequence number) the T or P sequence to act as a translational template.  
     COMPARE and MATCH can only be used of two sequences of the same type, and
     the type cannot be type A.  At print-out time, the type of a sequence can
     influence the default setting of the option "suppress numbering".


















                                    8                    ESEE Owner's Manual
                                                        REFERENCE SECTION  9


  CHANGE NAME                                          cnt-f4 or alt-n

   This command allows you to assign, change or display the fullname of a
   sequence. The maximum name length is 64 characters, only ten of which are
   displayed in edit mode. You are encouraged to name your sequences as soon as
   they are created or input to avoid any possible confusion between sequences.

   If you inadvertently summon up CHANGE NAME simply typing <RET> will return
   you to edit mode leaving the previous name intact.

   The print-out window allows you the option of setting the width of the name
   field at print-out time.


   When entering names do not type beyond the end of the name field window
   because the name that you have just typed will become invisible until you
   finish entering the new name by typing <RET>.

   You can cause a name to be blank by typing <SPACE> one or more times followed
   by <RET>.   If you change your mind while entering a new name then type <ESC>
   <RET>. This will restore the original name.

  COMPARE                                                       shf-F6

   This command creates a new sequence that is the result of the comparison of
   between the current sequence and the first sequence of the same type that can
   be found above.  If, for example, the current sequence is sequence #6 and it
   is type N, sequence #5 is type P, and sequences #1, #2 and #3 are type N,
   COMPARE will compare sequence #3 to the current sequence.

   The result of COMPARE is displayed as a newly created sequence of type A and
   it is put immediately below the current sequence. The COMPARE result is a dot
   when the two compared sequences are the same at a position and when they
   differ, the character at that position in the current sequence is produced.
   If you don't like dots then you should navigate to the beginning of the
   resulting sequence and use REPLACE to change the dots to some other
   character.

   COMPARE is most useful for showing differences between very closely related
   sequences.  If the sequences are very different you might consider using
   MATCH instead.

   COMPARE and MATCH are not case sensitive, meaning that upper- and lowercase
   versions of the same letter (eg. G and g) will be reported as the same
   letter.  This can give some spurious results when comparing triple-letter
   coded proteins -- be warned. 



                                    9                    ESEE Owner's Manual
                                                       REFERENCE SECTION  10


   COMPLEMENT                                                       F5

   If there is enough room and memory a new sequence is created that is the
   complement of the current sequence.  The new sequence becomes the current
   sequence and is displayed in the forward orientation.  Only sequences of type
   N may be complemented.  Only the following characters produce complements: G,
   A, C, T, N, R, Y.  All other characters are simply copied to the new sequence
   as is.  Case is not significant in complementation but the it is preserved in
   the characters of the complement sequence.


  COPY                                                             F7 

   This command is designed to let you mark off a contiguous section of
   sequence, a copy of which can be inserted at any location in any sequence,
   provided that there is room to hold the insertion. Once you finish marking,
   the copy is stored in memory and you are free to change the area that was
   marked.  Note:  highlighting is turned off when you finish the marking.  
   After marking you are free to use any other ESEE commands before you retrieve
   the copy.  The copy process can be interrupted at any time simply by typing
   <ESC>.

   To mark text use any of the following keys and finish marking by typing
   either <RET> or F7.  Next navigate to the insertion point and type either
   <RET> or F7.

     Right Arrow  ....  marks and highlights a single downstream character

     Down Arrow   ....  marks the next 60 positions (i.e. down one line)

     END          ....  marks all positions between the current position and the
                        end of the line

     PageDown     ....  marks all positions between the current position and the
                        bottom of the page.

     Left Arrow   ....  unmarks the rightmost marked character and backs the
                        cursor up by one position.


   You cannot mark a new block without either completing the copy process or
   aborting it with the <ESC> key.







                                10                    ESEE Owner's Manual
                                                      REFERENCE SECTION  11


  CREATE                                              alt-C or alt-F8 

   This command creates a new sequence of type N at the cursor location and
   designates it as the current sequence, providing (A) that there is enough
   memory and (B) there fewer than the maximum number of sequences (=21)
   currently in use.  If the cursor was on the highest numbered sequence than
   you are prompted to choose between inserting the new sequence above the
   bottom sequence or appending below.  In all other cases the current sequence
   and all those below it are "pushed" down by one to make a hole in which to
   insert the new sequence.


  DELETE SEQUENCE                                      alt-D or shf-f2

   This command deletes the current sequence. You are always prompted to confirm
   if you really wish to perform such a destructive task since your data is
   sacrosanct.  If you delete every single sequence a new empty sequence of type
   N is created as sequence #1.

  DELETE to end of line    cnt-Y
     (Processive COMMAND)

   The current sequence is deleted from the position of the cursor to the end of
   the current line.

  DELETE to end of sequencecnt-Z
     (Processive COMMAND)

   This  command is similar to DELETE sequence except in two regards: (A) you
   are not prompted for confirmation, and (B) the deletion begins at the current
   cursor position and moves downstream until the end of the sequence is
   encountered. The cursor position becomes the new end of sequence.


  ERROR MESSAGES

   Errors are usually reported on the bottom line of the display. These messages
   are displayed for 2 seconds. If you depress any key when an error message is
   displayed, it will disappear immediately. If the key pressed generates the
   same error then you get the error message again. Messages that say
   "INHIBITED" are only displayed for 1.5 seconds. 

   In some cases the error messages are displayed at the top of the screen. 
   This is usually when there is a very long or important message.  





                                  11                    ESEE Owner's Manual
                                                      REFERENCE SECTION  12


  FILES                                                alt-F or shf-F3

   The filer window allows you to perform file management tasks without leaving
   the program.  It always displays the current drive and directory on the
   bottom line of the window.  This information is updated if the current
   directory is changed with the Change Directory sub-command.

   Exit the filer window by typing  Q or <ESC>.

    The filer sub-commands are listed below.


     DIRECTORY         d
            ERASE             e
            CHANGE DIRECTORY  c
            RENAME            r
            LOOK              l

     These sub-commands all work pretty much like their DOS equivalents. If you
     change the current directory you may have to specify a new path to the
     helpfile ESEEHELP.FIL.  The directory sub-command shows filenames
     highlighted and sub-directory names dimlighted.
   
     The LOOK command will display a disk file using a window that is 60 columns
     wide and 11 rows high.  It is not possible to look beyond column 60 of any
     file.   This  command can be useful to check that and output or save
     operation was successful. You can also look at the ".sin"   file of a
     sequence database to see the names, types and lengths of the database
     entries.




















                                    12                    ESEE Owner's Manual
                                                       REFERENCE SECTION  13


  FIND                                                              f8
            (Processive COMMAND)

   This command will move the cursor to the start of the first occurrence of
   string of up to 25 characters in length. If the string cannot be found in the
   current sequence then the cursor does not move, and a message to that effect
   is briefly displayed at the bottom of the screen.  

   The first time you use FIND there is no previous search string so you are
   prompted to supply one.  At this point you can type <RET> to abort the FIND
   or you can enter a new string. During entry you are permitted to use the
   backspace key to delete mistakes. You can start over by typing <ESC>.

   Subsequent FINDs will attempt allow you to reuse the previous search string,
   should one exist, if you so desire. If one does exist, then there are three
   choices: <RET> to reuse the previous string, <ESC> to abort, or anything else
   to enter a new search string. In the latter case you will be presented with
   the same prompt as when there is no search string, as described above.

   You can put walls into search strings by holding down the alt key while
   typing the number 222 with the keyboard's number pad.  A second way to find
   walls is to actually use the ctrl-backspace keystroke for walls as you enter
   the search string.  If the second approach is used then walls will be
   represented by a   character as you are typing.  Subsequent finds will
   correctly show a wall character in the search string.
























                                 13                    ESEE Owner's Manual                                                        REFERENCE SECTION  14


  GENETIC CODE                                         alt-G or alt-f3

   The GENETIC CODE window displays and allows changes to the genetic code that
   is used for translation.  There are really only two non-exclusive options in
   this window, entry of new codon usages either from the key-board and/or from
   one or more disk files.

   To change the genetic code from the keyboard simply type in a valid nucleic
   acid codon in either upper or lower case.  Non valid codons will be ignored
   at this point.  Next you will be prompted for a three letter then a single
   letter code for that codon.  If you enter a different number of characters
   for the prompts you will be re-prompted.  For the single and triple letter
   codes they are taken literally in terms of case and also what letters you
   choose to use, no matter how "non-standard".

   The codon files are very simple ASCII files.  Each line in a codon file
   should be of the format:

                     CCCxTTTxS

   where CCC stands for a valid codon, TTT is for the triple letter code, S is
   for the single letter code and the x stands for any character at all,  but
   usually a blank or an equals sign is used.  If the CCC field specifies a
   codon that is not valid then the line is ignored, just as it is when entering
   codes from the keyboard. The files NEWCODE.1 and NEWCODE.2 that are
   distributed with ESEE are sample codon files that demonstrate the valid use
   of rather unusual triple and single letter codes.

   Exit the GENETIC CODE window by typing <RET> when being prompted for a codon
   to change.



















                                   14                    ESEE Owner's Manual

                                                      REFERENCE SECTION  15


  GET                                                           cnt-F9

   This command retrieves a sequence from a database that is designed to work
   with the SEQNCE program of Delaney Software, Ltd.  The PUT and PUT-ALL
   commands also generate SEQNCE-databases.  This feature allows you access to
   all of the major nucleic acid and protein databases that Delaney Software
   distributes.  In the case of the nucleic acid databases (such as EMBL and
   GENBANK) the databases are compacted reducing their sizes by a factor of four
   compared to the original ASCII format.  

   The first time that you use GET you are prompted to specify a database.  If
   the one specified does not exist then the GET command aborts.  Subsequent
   GETs give you the option of using the same database or specifying a new one.

   Next you are prompted to specify the name of the sequence that you want to
   GET. The name can be up to 64 characters.  A blank name will cause the GET
   command to abort.  Unfortunately, there is no way to list the directory of a
   SEQNCE-database from within ESEE.  You can, however, see what names are in a
   database at the DOS level by TYPE-ing the ".sin" file of the database.  It is
   not recommended that you use an text-editor on the ".sin" files -- if you
   inadvertently change the ".sin" file then the database may be adversely
   affected.

        See  PUT and PUT-ALL for more information on SEQNCE databases.


  GOTO                                                           alt =

   This command is a special navigation command that causes the cursor to move
   to a new current position that you select.  You are prompted to give the
   number of the new position.  If you try to go to a position beyond the last
   possible page, then the GOTO will be ignored.  The current sequence is not
   changed by GOTO.
















                                 15                    ESEE Owner's Manual
                                                      REFERENCE SECTION  16


  HELP                                                              F3

   Help is available from either the main Edit window or from the Print-out
   window.  (Later releases will probably also have help available from the
   other windows.)  There are currently three pages of edit help and two pages
   of print-out help.  You might like to print out the first part of the help
   file since it has a useful keyboard template. If you have somehow lost your
   help file then you can either write one or contact your distributor for a
   replacement.  Make sure that the version number of your copy of the program
   (shown on the logo panel at start-up time) and the version number on the
   first page of the edit-help screen are the same.

   If the file ESEEHELP.fil cannot be located in the current directory then you
   will be prompted to designate a path to the help file.  It is recommended,
   but not mandatory, that you use as complete and explicit a path designation
   as possible so as to avoid confusion if you change the current drive and or
   directory.  For example, suppose the current directory is C:\SQLIB and
   ESEEHELP.fil is in C:\ when you run ESEE. The very first time you summon help
   you will be prompted for the path.  Suppose you answer ".."  or "\" and then
   change the directory to D:\adir.  In this case, you will again be re-prompted
   for the help path if you summon help.  The proper response should have been
   "C:\".

   Within the help window you can type F3, alt-H or Pagedown to see the next
   screen.  Any other keys will return you to the editor at the current sequence
   position.

   If you give a copy of ESEE to someone else the author would be grateful if
   you would make a point of distributing the help file as well.  

   The help file should not be renamed (although ESEE.EXE certainly could).


  HORIZONTAL SCROLL LEFT                                             [
       Please see SLIDE LEFT.


  HORIZONTAL SCROLL RIGHT                                            ]
       Please see SLIDE RIGHT.










                                  16                    ESEE Owner's Manual

                                                       REFERENCE SECTION  17


  INPUT                                                alt-I or alt-F9

   Read an ASCII file in as a new sequence, if there is enough memory and
   sequence space.  If the current sequence is the highest numbered sequence
   then you are prompted to append or insert.  Otherwise the new sequence
   becomes the current sequence (without moving the cursor) and all sequences
   below that point get pushed down.  If there is only one sequence and that is
   empty then the new sequence will replace the original sequence.  



  INPUT/OUTPUT commands

   INPUT COMMANDS:

  alt-I, alt-F9     INPUT:      Read a sequence from an ASCII file.


  alt-R, sh-F9      RESTORE:    Read in one or more sequences from a   file that
                                was saved with the SAVE command.


  cnt-F9            GET:        Get a sequence from a database designed to be
                                used by the program SEQNCE.


   OUTPUT COMMANDS:

  alt-O, alt-F10    OUTPUT:     Write a sequence to an ASCII file.


  alt-S, sh-F10     SAVE:       Save all sequences, with their names, numbering,
                                and type specifications, to a special "save"
                                file.


  shf-F1            PUT:        Send a sequence to a database formatted for use
                                by the SEQNCE program.  


  cnt-F2            PUT ALL:    Send all sequences to a SEQNCE database.







                                   17                    ESEE Owner's Manual
                                                       REFERENCE SECTION  18


  INSERT/TYPEOVER

   This is a toggle. It is recommended that you use insert mode most of the time
   as there is no undo command available and typeovers can be both destructive
   and confusing.  It is particularly important that you check to see that you
   are not in TYPEOVER mode when you put in walls.  

   TAB and Shf-TAB are destructive in TYPEOVER mode, meaning that blanks will 
   overwrite the current sequence beginning at the current position. This
   feature can be useful for quick deletions.


  JOIN                                                          shf-F7
     (Processive COMMAND)
   Joins the current sequence to any sequence that you choose, starting at and
   including the current position.  You can JOIN a sequence to itself, doubling
   its length and creating a direct repeat.  To join an entire sequence, move
   the cursor to position 1 before using JOIN.


  LOWER CASE                                                    cnt-F6
     (Processive COMMAND)

   Converts any letters to lowercase, beginning at the current position on the
   current sequence and terminating at the end of sequence.
            
       Please consult the entry for UPPER CASE for more information.


  MATCH                                                             F6

   Works just like COMPARE except that (A) the resulting sequence is put
   immediately above the current sequence, (B) if there already is a sequence of
   type A above the current sequence, it will be replaced by the result of the
   MATCH, and (C) the results are displayed as vertical bars in positions that
   are the same (irrespective of case), and as a blank where they differ.  As
   with COMPARE, you cannot use MATCH when the cursor is beyond the end of the
   current sequence or if there is insufficient room to create another sequence.

   Please consult the entry for COMPARE for more information.









                                  18                    ESEE Owner's Manual

                                                       REFERENCE SECTION  19


  MOVE                                                 alt-M or shf-F8

   The current sequence is moved, becoming the sequence specified, by number, in
   response to a prompt. The current sequence is essentially plucked out of its
   current position, relative to any other sequences, and re-inserted at the new
   location.  One of two things will happen to the sequences below the insertion
   point, depending on the number of the target sequence relative to the current
   sequence. If the target number is greater than that of the current sequence,
   then all the sequences displayed below the current sequence, up to and
   including the one bearing the target number, will have their numbers
   decreased by one. If the target number is less than that of the current
   sequence, all of the sequences below the current sequences have their numbers
   increased by one.


  OUTPUT                                              alt-O or alt-F10

   Send a copy of the current sequence to an ASCII file (or device).  At the end
   of each line of output, the ASCII code CR/LF is sent to the file.  The width
   of each line is determined by the setting of Line Length in the Print-Out
   Window.  The default width value is 60.

   If the specified output file already exists you are prompted to select one of
   three choices:  overwrite the existing file, append the current sequence to
   the existing file, or abort the command.  Appended sequences always begin on
   a new line in the file.

   If a DOS input/output error occurs during the output process, nothing will be
   output if the destination is a file, if it is a device, some of the output
   may get through.

















                                  19                    ESEE Owner's Manual
                                                      REFERENCE SECTION  20


  PRINT-OUT     alt-P or  alt-F7

   The PRINT-OUT window is used to create formatted print-outs. Each of the 
  sub-commands of PRINT-OUT is detailed below

   DESTINATION:     Specify a file or a device. Don't use colons in device
                    names, i.e. use names like PRN, LPT2 and CON not names like
                    PRN:, etc. Unlike OUTPUT and SAVE, PRINT-OUT will overwrite
                    an existing file with no query.
                    
                Set the destination to CON to preview the print-out.  If you
                type <CNT-BREAK> when printing to CON you will cause termination
                of execution of the editor, taking any unsaved sequences with it
                so BEWARE!

  TITLE:            Enter a string of up to 80 characters to be printed on the
                    top of each page.  Note: The title takes up 4 lines of the
                    print out even if it is blank (the default).

  Line length:  Specify the number of sequence characters to include on a line. 
                This setting also affects the format of files written with the
                OUTPUT command.

                When calculating the length of line to use keep in mind that
                some of the other print-out settings will also affect the
                horizontal format.  You have to allow spaces for the left
                margin,  for the name-field + 1 space and also for the numbers +
                1 space (if not suppressed).

  Page length:  Specify the maximum number of lines to print on a page. Remember
                to allow 4 lines for the title and whatever is required by the
                top margin.  Groups of sequences are not split over pages. 
                After each page a form feed is sent.  The number of lines that
                will fit on a page can be influenced by the vertical spacing
                used by your printer.

  Print Blank Lines: By default any lines that contain only blanks are not
                printed.  If this option is set to 'Y' then blank lines will
                appear in the output.  Sequence numbers never appear on blank
                lines.

  Read Printer File: It is possible to read a file containing settings
                for the print-out window.  See Save Printer File below for more
                information on saving printer files. 





                                   20                    ESEE Owner's Manual
                                                       REFERENCE SECTION  21


  Save Printer File: This command creates a special file containing all 
                of the settings of the print out window, including the settings
                of the printer-command sub-window.  The only exception is the 
                list of sequences with numbering suppressed since this is really
                an attribute of the actual sequences in use at any given time,
                rather than a printer setting, per se.

  Suppress Form Feeds:  This is useful for getting two or more outputs on a     
                single page.

  Suppress Numbering:   Enter the number of a sequence that shouldn't be
                numbered. By default numbering is suppressed on T and A type
                sequences.

                    Unsuppress by "suppressing" a given sequence a second  
                    time. You may add as  many valid sequence numbers to  this
                    list as you desire.

  Vertical spacing between groups of lines: 
                Enter a value from 0 through 25.

  Printer Command: Selected presets are highlighted. Selecting a printer preset
  a second time  unselects the option. 

                In addition you may enter an ASCII string of up to  255
                characters containing control codes for your own printer. These
                codes are sent before your sequences. Enter nonprintable
                characters as decimals in square brackets. This string can be
                added to as you go along.  <RET>  alone will clear any existing
                string.

  Name Width:       Sets the width of the name field for purposes of print-out.
                    Valid values are in the range of 0 to 64.   A blank space is
                    always left between the name field and the beginning of the
                    sequences unless the field width is 0.

  Go:               Starts printout.  Printing is complete when the word "GO"
                    disappears.  You can interrupt the print-out by typing any
                    key when the GO window is displayed.









                                   21                    ESEE Owner's Manual
                                                       REFERENCE SECTION  22


  Additional Print-OUT information:

     By default only sequences of type N and P are numbered on print-out. If the
     sequence is type T and numbering is unsuppressed then the numbering is the
     same as for type N except that the count is divided by 3 with the remainder
     ignored. Sequences of type P will be numbered correctly.

     Beware of destroying any previous data by printing-out on top of an
     existing file.  No attempt is made to stop you from doing this so be
     careful. If you print-out to a file without a sufficiently large setting of
     page length then you risk having form-feed characters put into your file.
     This may be unacceptable when you try to read the printed file into some
     word processors. 

     Remember, WALLs are not printed. You have to replace them with specific
     characters if they are required as place-holdlers.

     If you need to have special formatting features such as underlining,
     bold,font changes, etc.  then use print-out to a file and read the file
     into your favorite word processor as if it were any normal ASCII file
     (which it will be except for embedded form-feeds and any printer commands
     that you have defined or selected).

     Don't forget to set-up the format of your word processor program so that it
     will accommodate the length and width of your print-out, and then read-in
     the file printed-out from ESEE. For example failure to extend the left
     margin to suit a wide print-out could potentially scramble your text with
     wrap-arounds.





















                                 22                    ESEE Owner's Manual
                                                     REFERENCE SECTION  23


  PUT                                                          cnt-F10

   The PUT command sends the current sequence to a database that can be used by
   the GET command as well as by the program SEQNCE (produced and distributed by
   Delaney Software, LTD.)  This section of ESEE was provided by Delaney
   Software.

   The first time that you use PUT you are prompted to specify a database. If
   the database doesn't exist it is created (even if the PUT later aborts for
   some other reason).  Subsequent PUTs will allow you to use the previous
   database or specify a new one.  The databases consist of two files: one with
   a suffix of ".sin" and one with the same prefix but with a ".sqn" suffix.  

   During PUT, sequences of type A and T are converted to type o.  If you later
   use GET the sequence will become type A. Therefore you should change the type
   of a T sequence back to type T from type A after a subsequent GET.  (NOTE:
   the SEQNCE program does not normally store protein sequences in triple-letter
   codes).  If the sequence is nucleic acid and is all in uppercase then PUT
   will compact it  resulting in a four-fold reduction in disk-space.  

   If the current sequence does not have a name then you are prompted for one. 
   If you type <RET> in response to this prompt then the PUT aborts.

   If the sequence is in the file already then there are two choices, delete the
   one already there or abort the PUT.

   (Please see GET for more information.)


  PUT ALL                                                       shf-F1

   This command works just like PUT except that every single sequence is sent to
   the specified database.  The prompts are all the same.

  QUIT                                           alt-Q or F10 or <ESC>

   You are prompted for confirmation before exiting the editor.  You must answer
   with a "Y" or "y" in order terminate the editing session.  Be aware that all
   sequences in memory will be unaccessible once you leave the program.  It is,
   therefore, highly recommended that you back-up your work with SAVE, OUTPUT or
   PUT before exiting.








                                   23                    ESEE Owner's Manual
                                                      REFERENCE SECTION  24

  RE-DEFINE ORIENTATION   shf-F5

   This command simply changes the sequence orientation arrow that is displayed
   to the immediate left of each line of sequence. A right facing arrow
   indicates that a sequence is displayed in a forward manner (i.e. 5-prime to
   3-prime for nucleic acids and NH-COOH for polypeptides). The intent of this
   command is to allow you to enter sequences in a 3-prime to 5-prime
   orientation, reverse them, and have the editor understand that they are
   really displayed in a forward rather than reverse orientation.

   Please see "REVERSE" for more information how orientation affects the
   behavior of the editor.


  REMOVE NUMBERS AND SPACES                            alt-F2
     (Processive COMMAND)

   All spaces and digits in the current sequence are removed processively,
   starting from the cursor position and ending at the end of the sequence. 
   Walls are ignored.

   Please see the "SPACE" for more information on the spacing.


  REMOVE SPACES               F2
     (Processive COMMAND, AFFECTED BY WALLS)

   All spaces are removed from the current sequence processive, starting from
   the cursor position and ending either at the end of sequence or at the first
   wall encountered.   In the case of a wall, any upstream spaces that are
   removed are  re-inserted  immediately upstream of the wall, leaving the
   wall's position unchanged.

   Another way to remove spaces is to use the REPLACE command and replace all
   spaces with nulls.


  REPLACE                                                           F9
     (Processive COMMAND)

   This command allows you to change or delete all copies of any given character
   in the current sequence, starting from the cursor position and moving
   processively to the end of the sequence.

   The replace command first prompts you for the character to change and then
   for the character to use as the substitute.  You may use the key sequence
   <cnt-backspace> for the WALL character as a response to the prompts.If you
   enter <F9> in response to the prompt for the substitute then the all
   downstream copies of the target character are deleted.

                                   24                    ESEE Owner's Manual
                                                       REFERENCE SECTION  25


  REPLICATE               shf-F4

   A new sequence that is a copy of the current sequence is created and inserted
   immediately below the current sequence. The command aborts if there is not
   enough computer memory to hold another sequence or if there are already 21
   sequences in the editor.


  RESTORE                                                       shf-F9

   One or more sequences are read in from a file. The specified file MUST have
   been created by the SAVE command.  Do not attempt to RESTORE a simple ASCII
   sequence file, use INPUT instead.  Any name, numbering, type, and orientation
   characteristics associated with the sequences at the time of saving will also
   be restored.

   If the editor contains only one sequence and that is empty, (eg. the initial
   status of the editor) the first sequence restored will become sequence #1,
   otherwise the restored sequences will be appended below the highest numbered
   sequence that already exists.  

   The restore process will abort if there will not be enough memory to hold the
   restored sequences, if the restoration requires more than 21 sequences, or if
   there are any input/output errors.

   Please see SAVE for more information.


  REVERSE                                                       alt-F5

   The current sequence is reversed, no matter what its type.  This means that
   the last character of the sequence becomes the first, and vice versa.  The
   reverse command reverse the direction of the orientation arrow that is
   displayed to the immediate left of each line of sequence.

   Please see RE-DEFINE ORIENTATION for more information.


  SLIDE LEFT                                                         [

   The current sequence is pushed upstream (to the left) leaving the current
   position unchanged. This means that the cursor does not move relative to the
   screen but scrolls relative to the sequence.  The sliding can only be done if
   there is a blank in position 1.  If you need to use the character "[" then
   use some other rare character and then use REPLACE to change it to "[".




                                   25                    ESEE Owner's Manual
                                                       REFERENCE SECTION  26


  SLIDE RIGHT                                                        ]

   The current sequence is pushed downstream (to the right) leaving the current
   position unchanged. This means that the cursor does not move relative to the
   screen but scrolls relative to the sequence. The sliding is accomplished by
   inserting a blank in position 1.  SLIDE RIGHT becomes inhibited when the
   sequence length reaches the maximum (which currently is 16,000 characters). 
   If you need to use the character "]" then use some other rare character and
   then use REPLACE to change it to "]".


  SAVE                                                alt-S or shf-F10

   All of the sequences displayed in the editor are saved to a specially
   formatted file that is designed to be read with the RESTORE command.  Any
   attributes, such as names, types, and orientations, associated with the
   sequences are saved as well.  

   If the specified destination file already exists you are prompted to either
   overwrite it or abort the save procedure.

   It is strongly recommended that you  use SAVE frequently so that you are
   protected from data loss caused by some mishap or malfunction.

   Input/output errors will abort the save process.

   Please see RESTORE for more information.


  SCROLL                                              UP or DOWN ARROW

   When you use up (down) arrow when the cursor is on the top (bottom) line of
   the edit-space then the display scrolls down (up) by one group of sequences. 
   Scrolling is not possible beyond the first (last) page.















                                   26                    ESEE Owner's Manual
                                                      REFERENCE SECTION  27


  SPACE IN 3                                                        F1
     (Processive COMMAND, AFFECTED BY WALLS)

   A space is inserted at every fourth position.  This makes the sequence
   longer.  If the sequence length reaches the maximum (16,000) then the
   insertion of blanks terminates with the sequence only partially spaced in
   triplets.  All spaces are removed before the triplet spacing begins so this
   command could also be called "respace in 3".

   If a wall is encountered before the end of sequence then respacing stops at
   the position of the wall and everything downstream stays as it was.

   Triplet spacing can have a strange affect on sequences of type P.  When 
   translation is performed with P-type sequences they are spaced to be centered
   over the codons and thus triplet spacing is designed to keep the single-
   letter coded protein sequences centered over triplets of nucleic acid
   sequence.

   Use the REMOVE spaces command to get rid of spaces.

  SPACE IN n                                                    alt-F1
     (Processive COMMAND, AFFECTED BY WALLS)

   This command works just like SPACE in 3 except that you are prompted to give
   a number for spacing.  This number can be anything as long as it is less than
   the maximum allowable sequence length (i.e. 16,000).

  TAB
     (Processive COMMAND)

   The tab key inserts 10 spaces starting at the position of the cursor.  If the
   end of sequence within 10 spaces of the cursor then action terminates at the
   end of sequence.  You cannot use tab  when the cursor is beyond the end of
   sequence.  

   The TAB key is "destructive" in TYPEOVER mode, meaning that the blanks are
   written over any characters in the next 10 positions.  This feature can be
   used for quick deletions because you can use REMOVE spaces to get rid of the
   new blanks.

   See SHIFT-TAB for more information.

  TYPEOVER

   Typeover mode is destructive, meaning that a typed character replaces the
   character at the current position rather than inserting. You cannot use
   TYPEOVER when the cursor is at or beyond the end of sequence.


                                   27                    ESEE Owner's Manual
                                                     REFERENCE SECTION  28


  TRANSLATE                                                           F4
     (Processive COMMAND, AFFECTED BY WALLS)

  RULES for TRANSLATION:

    a.     The current must be a sequence of type P or T.  (Type T give
            3-letter amino    acids).

    b.     There must be a sequence of type N somewhere above the current
            sequence.  The first one found, moving upwards from the current
            sequence is considered    the template sequence.

    c.      Translation will proceed to the right (downstream) from the cursor
            position.

    d.      Translation will stop when it encounters a "WALL" in  the current
            sequence or when the end of the template sequence is reached.

    e.      Spaces (up to the first wall) are removed from the template strand
            before translation. If there are any walls in the template, the
            translation will "jump" them, leaving a space at that position, and
            the translation will stay in frame.  If walls are used in the
            template sequence then avoid having two or more walls in a row.

     f.     If you use walls with translations, it may be a good idea to insert
            them  (i.e, not with TYPEOVER mode) in both the template and peptide
            sequences.
 
    g.      You may translate from with the cursor on a sequence of type N, in 
            which case the a new sequence is created below the current sequence
            to hold the product.  Translation this way always produces a single
            letter product.


     - Use Alt-G to see or change the current genetic code.

     - the product sequence will always be the same length as the       template
  after translation


  UNDO                                                           cnt-U

   The result of any insertion, deletion, copy, join, or translation can be
   undone using this command provided no other key has been depressed. This
   includes going into windows.




                                  28                    ESEE Owner's Manual
                                                      REFERENCE SECTION  29


  UPPER CASE                                                    cnt-F5
     (Processive COMMAND)

   All alphabetic characters from the cursor position to the end of sequence are
   converted to uppercase.  The opposite action is performed by the LOWER CASE
   command.  

   The editor treats upper and lower case characters as the same thing when
   translating, comparing or matching.  The commands FIND and REPLACE, however,
   do make a distinction between the two cases.


  VERTICAL SCROLL
     Please see SCROLL for information.


  WALLS                                                  cnt-backspace
     (AFFECTS SPACE IN 3, SPACE IN n, TRANSLATE, AND REMOVE SPACES)

   Walls have three functions: Stopping the action of spacing and space removal
   commands, stopping translations, and acting as simple landmarks.

   It is a good idea to check that you are NOT IN TYPEOVER mode when putting in
   walls as they, as any other character, replace the character at the cursor
   position in that mode.

   AT PRINT-OUT TIME WALLS ARE NOT NUMBERED OR PRINTED.  This, unfortunately may
   put your sequences out of alignment. Two remedies to this situation are to
   place a walls at the same positions in all of the sequences or to use REPLACE
   to remove all walls before printing (after saving your work, if you don't
   want to loose the wall positions). In future releases of ESEE you will be
   able to specify how walls are printed.

      
  WIPE                                                 alt-W or cnt-F2

   Wipes all sequences from the editor. You are prompted for confirmation.  The
   result is one empty sequence. The print-out  settings are unaffected by WIPE.











