#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*          GWTOP - Topology         */
/*        MS-WINDOWS front end       */
/*                                   */
/*          Title dialog box         */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <stdio.h>
#include <string.h>
#include "defines.h"					/* symbols also used in .DLG files		*/
#include "globals.h"					/* gepasi's own symbols					*/
#include "gwtop.h"						/* macros, function prototypes, etc.	*/
#include "gep1.h"						/* gepasi's variables					*/
#include "topgvar.h"					/* global variables						*/

#pragma alloc_text( CODE6, EdName )

BOOL FAR PASCAL EdName( HWND hDlg, WORD message, WORD wParam, LONG lParam )
{
 static	HWND	hEdit;
 char buff[256];

 switch( message )
 {
  case WM_INITDIALOG:
   /* show the image on the mirror.									*/
   _fmemcpy( (void __far *) buff,
   	         (void __far *) topname,
             (size_t) sizeof( topname ) );

   /* get the handle to the edit control							*/
   hEdit = GetDlgItem( hDlg, IDE_M0 );

   /* Limit the length of the tile to 255 characters				*/
   SendMessage( hEdit, EM_LIMITTEXT, (WORD) 255, 0 );

   /* if the title is not empty put it in the edit box and select it*/
   if( buff[0] )
   {
    SendMessage( hEdit, WM_SETTEXT, 0, (DWORD) (LPSTR) buff );
    SendMessage( hEdit, EM_SETSEL, 0, MAKELONG( 0, 32767 ) );
   }

   /* set the focus on the edit control								*/
   SetFocus( hEdit );

   return TRUE;

  case WM_COMMAND:
   switch( wParam )
   {
    case IDC_HELP:                        /* Help for this Dialog Box			 */
   	 WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "Title editor" );
     SetFocus( hEdit );
     return TRUE;

    case IDOK:
     SendMessage( hEdit, WM_GETTEXT, (WORD) 256, (DWORD) (LPSTR) buff );

     /* copy the altered image to the original	*/
     _fmemcpy( (void __far *) topname,
   	           (void __far *) buff,
               (size_t) sizeof( topname ) );
     notsaved = 1;
     /* close the dialog box and return			*/
     EndDialog( hDlg, IDOK );
     return TRUE;

    case IDCANCEL:
     /* close the dialog box and return			*/
     EndDialog( hDlg, IDCANCEL );
     return TRUE;
   }

  default: return FALSE;
 }
}