# makefile for GEPASI - Zortech C

CFLAGS= -DMSDOS -mx -2

.c.obj:
	ztc -c $(CFLAGS) $*

OBJECTS = gepmain.obj getall.obj globvar.obj metconan.obj metcvars.obj \
newton.obj pmu.obj r250.obj datab.obj daxpy.obj ddot.obj dgefa.obj \
dgesl.obj dscal.obj idamax.obj lsoda.obj kinetics.obj matrix.obj rates.obj \
dynamic.obj gepout.obj gauss.obj gaussvar.obj

gepasi: $(OBJECTS)
	$(CC) $(OBJECTS) $(CFLAGS_)

clean:
	rm *.obj

gepmain.obj:      gepmain.c pmu.h globals.h globvar.h except.c r250.h \
matrix.h kinetics.h rates.h gauss.h newton.h metconan.h lsoda.h dynamic.h \
datab.h getall.h gepout.h
getall.obj:       getall.c globals.h globvar.h datab.h newton.h strtbl.h \
gauss.h kinetics.h pmu.h
gepout.obj:       gepout.c globals.h globvar.h datab.h newton.h metconan.h \
lsoda.h pmu.h
datab.obj:        datab.c globals.h globvar.h lsoda.h strtbl.h
globvar.obj:      globvar.c globals.h
metcvars.obj:     metcvars.c globals.h
gaussvar.obj:     gaussvar.c globals.h
matrix.obj:       matrix.c globals.h globvar.h
pmu.obj:          pmu.c
r250.obj:         r250.c r250.h
daxpy.obj:        daxpy.c
ddot.obj:         ddot.c
dgefa.obj:        dgefa.c
dgesl.obj:        dgesl.c
dscal.obj:        dscal.c
idamax.obj:       idamax.c
lsoda.obj:        lsoda.c
metconan.obj:     metconan.c globals.h globvar.h matrix.h datab.h
kinetics.obj:     kinetics.c globals.h globvar.h datab.h
rates.obj:        rates.c globals.h globvar.h datab.h
dynamic.obj:      dynamic.c globals.h lsoda.h globvar.h rates.h datab.h pmu.h
gauss.obj:        gauss.c globals.h globvar.h
newton.obj:       newton.c globals.h globvar.h matrix.h rates.h datab.h


#$(FILE) : file.h file.c
#        ztc -c $(CFLAGS) -DA$* file -o$*.obj
