/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992, 1993 Pedro Mendes
*/

/*************************************/
/*                                   */
/*          global variables         */
/*                                   */
/*          MICROSOFT C 6.00         */
/*           QuickC/WIN 1.0          */
/*             ULTRIX cc             */
/*              GNU gcc              */
/*                                   */
/*   (include here compilers that    */
/*   compiled GEPASI successfully)   */
/*                                   */
/*************************************/


#include <setjmp.h>

 extern double xss[MAX_MET];                     /* concentrations at the s.s.     */
 extern double x[MAX_MET];                       /* concentrations at time t       */
 extern double x0[MAX_MET];                      /* concentrations at time 0       */
 extern double moiety[MAX_MET];                  /* total conserved moiety conc.   */
 extern double rate[MAX_MET];                    /* rates at time t                */
 extern double flux[MAX_STEP];                   /* fluxes at time t               */
 extern double cum[MAX_MET];					  /* cumulative lyapunov exponents  */
 extern double tt[MAX_MET];                      /* lifetimes                      */
 extern double ttt;                              /* pathway lifetime               */
 extern int totmet;                              /* number of total metabolites    */
 extern int nmetab;                              /* number of internal metabolites */
 extern int nextmet;                             /* number of external metabolites */
 extern int indmet;                              /* number of int. indp. metabs.   */
 extern int depmet;                              /* number of int. dep. metabs.    */
 extern int nsteps;                              /* number of steps                */
 extern double endtime;                          /* time value for last iteration  */
 extern double actime;                           /* current time                   */
 extern char metname[MAX_MET][NAME_L];           /* metabolite names               */
 extern char stepname[MAX_STEP][NAME_L];         /* metabolite names               */
 extern int intmet[MAX_MET];                     /* 1 if internal metabolite       */
 extern int ur[MAX_MET];                         /* permut. on metabolites  u -> g */
 extern int uc[MAX_MET];                         /* permutations on steps   u -> g */
 extern float ml[MAX_MET][MAX_MET];              /* multipliers of gauss reduction */
 extern float lm[MAX_MET][MAX_MET];              /* inverse of ml                  */
 extern float ld[MAX_MET][MAX_MET];              /* metabolite linear dependencies */
 extern int stoiu[MAX_MET][MAX_STEP];            /* user stoicheiometric matrix    */
 extern int stoi[MAX_MET][MAX_STEP];             /* stoicheiometric matrix         */
 extern float rstoi[MAX_MET][MAX_STEP];          /* reduced stoicheiometric matrix */
 extern int kinetu[MAX_STEP];                    /* type of kinetics (user numb.)  */
 extern int kinetype[MAX_STEP];                  /* type of kinetics of each step  */
 extern unsigned char (*loop)[MAX_STEP][MAX_MET];/* def. of modification loops	   */
 extern int (*rstr)[MAX_STEP][MAX_MOL];			 /* reaction structure			   */
 extern double jacob[MAX_MET][MAX_MET];          /* jacobian of rates at time t    */
 extern double (*rateq[MAX_STEP])();             /* pointers to rate equations     */
 extern double (*partder[MAX_STEP][MAX_MET])();  /* pointers to partial derivatives*/
 extern double Dxv[MAX_STEP][MAX_MET];    /*  ---+                          */
 extern double Duv[MAX_STEP][MAX_MET];    /*     |    defined in            */
 extern double DuJ[MAX_STEP][MAX_MET];    /*     |    metcvars.c            */
 extern double Gamma[MAX_MET][MAX_STEP];  /*     |    compiled              */
 extern double C[MAX_STEP][MAX_STEP];     /*     |    separatly             */
 extern double ttcc[MAX_MET];             /*     |                          */
 extern double aux1[MAX_MET][MAX_MET];    /*     |                          */
 extern double aux2[MAX_MET][MAX_MET];    /*  ---+                          */

 extern double intst, nfeval, njeval;            /* double vers. of nst, nfe & nje */

 extern float ver_no;							 /* .sim file version              */
 extern unsigned long iter;						 /* number of current iteration	   */
 extern int delete;			 				     /* 1 to delete list file at end   */
 extern int newtlim;                             /* limit of interations in Newton */
 extern int debugval;                            /* debug verbose mode             */
 extern int cx, cy;                              /* ptrs for cursor position       */
 extern char filename[MAX_FIL][PWIDTH];          /* run filenames                  */
 extern char repfile[PWIDTH];					 /* filename for report file	   */
 extern char TopFile[PWIDTH];                    /* topology filename              */
 extern char listfile[PWIDTH];					 /* file with list of simulations  */
 extern char dyname[PWIDTH];                     /* filename for dyn file		    */
 extern char inputf[PWIDTH];                     /* list file name                 */
 extern int nrunfiles;                           /* number of files to run         */
 extern jmp_buf mark;						 	 /* mark for longjmp (fp exceptions*/
 extern	int	jmpret;								 /* return value of setjmp			*/
 extern int	fperr;		    				     /* floting point error number	   */
 extern char fpstr[128];
 extern char topname[256];						 /* pathway title				   */
 extern char *errormsg[];
 extern char *gepasi;
 extern char *version_no;
