#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992, 1993  Pedro Mendes
*/

/*************************************/
/*                                   */
/*             heap check            */
/*                                   */
/*            specific for           */
/*          Visual C/C++ 1.0         */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GEPASI successfully)   */
/*                                   */
/*************************************/

#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>

/*
 USE THE FOLLOWING ON THE CODE TO CHECK THE HEAP

 o  heapstat( _heapchk() );
    Check heap status. Should be OK at start of heap.

 o  heapstat( _heapset( 254 ) );
    Fill all free blocks with the test character.

 o  heapvalidate( 254 );
    Do heapvalidate to make sure none of the operations
    wrote to free blocks.

*/


/* Tests each block in the heap. If a modified free block is found,
 * returns it's address. Otherwise returns NULL.
 */

#ifdef _MSC_VER

long int heap_check_counter = 0;

int __far *heapvalidate( char fill )
{
    struct _heapinfo hi;
    unsigned heapstatus, i;
    char __far *p;

    /* Walk through entries, checking free blocks. */
    hi._pentry = NULL;
    while( (heapstatus = _heapwalk( &hi )) == _HEAPOK )
    {
        /* For free entries, check each byte to see that it still has
         * only the fill character. Return address if changed.
         */
        if( hi._useflag != _USEDENTRY )
        {
            for( p = (char __far *)hi._pentry, i = 0; i < hi._size; p++,i++ )
                if( (char)*p != fill )
                {
                    printf( "%4ld Free entry at %Fp modified.\n", heap_check_counter++, hi._pentry );
                    return hi._pentry;
                }
        }
    }
    printf( "%4ld Free entries are unchanged.\n", heap_check_counter++ );
    return NULL;
}

/* Reports on the status returned by _heapwalk, _heapset, or _heapchk */
void heapstat( int status )
{
    printf( "\n%4ld Heap status: ", heap_check_counter++ );
    switch( status )
    {
        case _HEAPOK:
            printf( "OK - heap is fine" );
            break;
        case _HEAPEMPTY:
            printf( "OK - empty heap" );
            break;
        case _HEAPEND:
            printf( "OK - end of heap" );
            break;
        case _HEAPBADPTR:
            printf( "ERROR - bad pointer to heap" );
            break;
        case _HEAPBADBEGIN:
            printf( "ERROR - bad start of heap" );
            break;
        case _HEAPBADNODE:
            printf( "ERROR - bad node in heap" );
            break;
    }
    printf( "\n" );

}

void heap_check( void )
{
 heapstat( _heapchk() );
}

void heap_free_set( void )
{
 heapstat( _heapset( 254 ) );
}

void heap_free_check( void )
{
 heapvalidate( (char) 254 );
}

#endif


#ifndef _MSC_VER

void heap_check( void )
{
 return;
}

void heap_free_set( void )
{
 return;
}

void heap_free_check( void )
{
 return;
}

#endif
