;
;        MWRLOAD -  A utility program written by Marty W. Rhodes
;
;  This is a hard drive bootstrap loader program that will allow the
;  user to select which partition/OS to boot and run.  It installs in
;  the Master Boot Record (1st sector) of the first hard drive and resides
;  there with the partition table for that drive.  It needs to be installed
;  using a the separate installation program (INSTALL.EXE) that came with 
;  it.  You will also need the program EXE2COM.EXE to strip off the EXE 
;  header after linking.  (Full source for both EXE2COM and INSTALL should
;  also have been included in this archive.)  
;
;
;  If, for some reason, this loader does not work properly with your 
;  system you can uninstall it by booting from a bootable DOS diskette 
;  that has the FDISK program on it and typing:
;        
;                     FDISK /MBR <enter>
;    
;
;  This program works like the default DOS FDISK boot loader unless the user 
;  holds down the ctrl key when booting.  If the ctrl key is down when this 
;  program is invoked, it prompts the user to enter a partition number to
;  boot from.  If the user types in a number between 1 and 4 then the 
;  operating system in that partition will become the default boot O/S
;  from then on.  If the user types anything else (other than 1, 2, 3, or 4), 
;  then nothing is changed.  
;
;
; ***** WARNING:  This program does almost no sanity checking.  It assumes 
;  you know what you are doing.  If you tell it to boot a partition that 
;  is not really bootable or that does not even exist, it will obligingly 
;  attempt to do so for you.  (This sort of mistake can, of course, be 
;  easliy fixed by rebooting, holding down the ctrl key, and changing the
;  default boot partition again - this time to one that is valid.)    
;
;
;  This file contains the full source code for the loader program.  It 
;  was written on an MS/DOS system using Borland TASM v4.0.  It should 
;  work with most older versions of TASM and it should be easy to port 
;  to MASM, if you don't have TASM.  It should work, as is, on just 
;  about any Intel 80x86 system but the source is included if you need 
;  to make changes or if you just want to play.  The BUILD.BAT file will 
;  compile, link, and install it for you if you have TASM and TLINK in 
;  your path.  The source should also be easy to port to other I86-based 
;  operating systems (UNIX, OS/2, NT, etc.), since it (by necessity) makes 
;  no DOS-specific calls.  It uses only hardware/BIOS calls.  After all, 
;  it's hard to make any DOS calls when DOS has not even been loaded yet!
; 
;
;  I wrote this program because I needed it on my system after I 
;  installed LINUX and Windows NT in addition to MS/DOS.  I found their 
;  boot loaders to be inadequate, in the case of LINUX, and non-existent, 
;  in the case of Windows NT and MS/DOS.  I also did it as an exercise to 
;  teach myself I86 assembler language.
;
;
;  NOTE:  If you make changes to this program, your final linked 
;  executable file (MWRLOAD.COM and MWRLOAD.BIN, in my case) must not 
;  exceed 446 bytes!!!!   In fact, it would be best if they were 
;  exactly 446 bytes long (you can pad out to that with binary zeros.).  
;  If your code exceeds 446 bytes, you will get unpredictable results.  
;  But then I am probably wasting my time telling you this because 
;  NOBODY, who didn't already know that, would be foolish enough to 
;  try writing their own bootstrap loader, would they? <g>
;
;
;  I can be reached via e-mail at:     mwrhodes@home.com
;
;   
;
IDEAL
NOSMART
NOJUMPS
BBOOT   EQU 07C00h                            ; offset of BIOS boot sector image
HOLD    EQU 0500h                             ; offset of hold area for boot sector
ORGOFF  EQU 0100h                             ; offset of loader entry point
SIGOFF  EQU 01FEh                             ; offset of boot rec signature
SIG     EQU 0AA55h                            ; boot record signature
BRLEN   EQU 0100h                             ; boot record length in words
CSBASE  EQU 0000h                             ; code segment base for far jumps
P1OFF   EQU 01BEh                             ; offset of 1st partition record
BOOTYES EQU 080h                              ; partition is bootable flag
BOOTNO  EQU 00h                               ; partition not bootable flag
MAXPART EQU 04h                               ; maximum partition count
PRLEN   EQU 010h                              ; partition record length
ZEROB   EQU 00h                               ; constant value = 0 (byte)
ASSUME CS:SEG1,DS:SEG1
SEGMENT SEG1 PUBLIC
ORG 0100h

start:    
            CLI                               ; Disable Interrupts
            XOR    AX,AX                      ; clear AX to zero
            MOV    SS,AX                      ; same with SS
            MOV    SP,BBOOT                   ; set SP to boot sector offset
            MOV    SI,SP                      ; same with SI
            PUSH   AX                         ; save AX
            POP    ES                         ; ES = AX = zero
            PUSH   AX                         ; save it again
            POP    DS                         ; DS = AX = zero
            STI                               ; Enable Interrupts
            CLD                               ; clear direction flag, string instructions will increment SI & DI
            MOV    DI,HOLD + ORGOFF           ; DI = hold area offset
            MOV    CX,BRLEN                   ; CX = length of boot record
            REPNZ                             ; repeat next string operation CX times
            MOVSW                             ; move word in SI to DI and increment both
            JMP    FAR PTR CSBASE:OFFSET jumpin + HOLD   ; jump into the stuff we just copied
    jumpin:                                   ; ok, now we continue at a new spot in memory
            TEST   [BYTE PTR OFFSET tflag + HOLD],080h  ; have we already been thru this?
            JNZ    resume                     ; yes, so skip all the setup stuff
            MOV    AX,08300h                  ; INT 15h, function 83h (set timer event)
            MOV    CX,0020h                   ; wait 200000h microseconds
            XOR    DX,DX                      ; lotsa zeros in 200000h microseconds
            MOV    BX,OFFSET tflag + HOLD     ; point to flag byte to test if the timer has popped
            INT    15h                        ; set that timer
            JNB    wt                         ; ok, it's set so goto wt label
            MOV    [BYTE PTR OFFSET tflag + HOLD],0FFh  ; bummer, set timer failed so set the timer-already-popped flag
    wt:     
            MOV    AH,02h                     ; we're gonna see if the ctrl key is down
            INT    16h                        ; go look (INT 16h, function 02h)
            TEST   AL,04h                     ; was it down? 
            JNZ    cont1                      ; yup, so goto cont1 label
            TEST   [BYTE PTR OFFSET tflag + HOLD],080h  ; ok, no ctrl key yet but has the timer popped yet?
            JZ     wt                         ; no, so let's give him some more time to press it
            JMP    resume                     ; ok, either he doesn't want to change anything or he's unconscious
    cont1:  
            MOV    SI,OFFSET ques + HOLD      ; point to ques message
            CALL   PRTSTR                     ; print it
    readky:
            MOV    AH,02h                     ; gonna look at the keyboard buffer
            INT    16h                        ; looking at it
            JZ     readit                     ; it's empty so goto readit label
            MOV    AH,ZEROB                   ; oops, there's junk in it so let's clear it
            INT    16h                        ; clearing one char
            JMP    readky                     ; ok, let's go see if there's anymore junk in it
    readit:
            MOV    AH,ZEROB                   ; let's get a keystroke
            INT    16h                        ; getting it
            MOV    [BYTE PTR OFFSET partn + HOLD],AL   ; save it in partn field
            CMP    AL,031h                    ; was it < '1'
            JB     abort                      ; yes, so abort change
            CMP    AL,035h                    ; was it > '4'
            JNB    abort                      ; yes, so abort change
            MOV    SI,BBOOT + P1OFF           ; point at 1st partition record
            MOV    AH,[BYTE PTR OFFSET partn + HOLD]    ; load in partition to boot
            SUB    AH,030h                    ; convert from ascii to binary number
            MOV    BL,ZEROB                   ; we're gonna count partitions in BL 
    patch:                                    ; ok, now we're gonna patch the partition table
            MOV    [BYTE PTR SI],BOOTNO       ; set partition bootable flag to false
            INC    BL                         ; one more down
            CMP    BL,AH                      ; is this one the one to boot?
            JNZ    skip1                      ; no, so goto skip1 label
            MOV    [BYTE PTR SI],BOOTYES      ; ok, flag it as bootable
    skip1: 
            ADD    SI,PRLEN                   ; point to next partition
            CMP    BL,MAXPART                 ; is this the last partition?
            JNZ    patch                      ; no, so do it again
            MOV    AX,0301h                   ; setting up to write new MBR 
            MOV    CX,0001h                   ; still setting up...
            MOV    DX,0080h                   ; still...
            CALL   DISKIO                     ; write it
            INT    19h                        ; reload system from 0000h:07C00h
    resume:
            MOV    SI,HOLD + ORGOFF + P1OFF   ; SI = offset of partition #1
            MOV    BL,MAXPART                 ; BL = max. # of partitions
    part:  
            CMP    [BYTE PTR SI],BOOTYES      ; is partition bootable ?
            JZ     bootable                   ; yes, so goto bootable
            CMP    [BYTE PTR SI],BOOTNO       ; ok, is it empty ?
            JNZ    notmt                      ; no, it has something in it so goto notmt
            ADD    SI,PRLEN                   ; ok, let's check the next partition
            DEC    BL                         ; one down, BL to go
            JNZ    part                       ; not done yet so goto part
            INT    18h                        ; bummer, no bootable partition so invoke ROM BASIC (LOL)
    bootable:  
            MOV    DX,[SI]                    ; load 1st 2 bytes of partition record into DX
            MOV    CX,[SI+02h]                ; load bytes 3 & 4 of partition record into CX
            MOV    BP,SI                      ; load address of partition record into BP
    nxt:  
            ADD    SI,PRLEN                   ; point SI at next partition record
            DEC    BL                         ; one more down
            JZ     cont2                      ; it was the last bootable one so goto cont2
            CMP    [BYTE PTR SI],BOOTNO       ; still one left so see if it is empty
            JZ     nxt                        ; it's empty so goto nxt
    notmt:  
            MOV    SI,OFFSET err1 + HOLD      ; bummer, invalid partition table so point SI at error message #1
            CALL   PRTSTR
    halt:   JMP    halt                       ; we'll just stay here for awhile
    cont2:  
            MOV    AX,0201h                   ; AH = 2, AL = 1
            CALL   DISKIO            
            MOV    SI,OFFSET err3 + HOLD      ; point to error message #3
            MOV    DI,BBOOT + SIGOFF          ; point to sector we just read
            CMP    [WORD PTR DI],SIG          ; does it have a valid signature
            JNZ    nosig                      ; no, so display error message #3 and halt
            MOV    SI,BP                      ; SI = BP = address of bootable partition record (?)
            JMP    FAR PTR CSBASE:BBOOT       ; jump into 1st sector of the bootable partition 
    abort:  
            MOV    [BYTE PTR OFFSET tflag + HOLD],0FFh  ; aborting the change so skip the timer junk  
            JMP    jumpin                     ; go back and start over
    nosig:
            CALL   PRTSTR
            JMP    halt

PROC        CLSCR                             ; clear the screen & home the cursor
            MOV    AX,0600h                   ; clear the screen (INT 10h, function 06h)
            MOV    BX,0700h                   ; text attributes
            XOR    CX,CX                      ; start at line/col zero
            MOV    DX,03285h                  ; end at line/col 50/133
            INT    10h                        ; clear it
            MOV    AX,0200h                   ; set cursor position (INT 10h, function 02h) 
            XOR    DX,DX                      ; going to top-left
            XOR    BX,BX                      ; yup, top-left 
            INT    10h                        ; move it
            RET                               ; all done  
ENDP        CLSCR

PROC        PRTSTR                            ; print a null-terminated string on the console (teletype mode)
  nxtchar: 
            LODSB                             ; load error message into AL one byte at a time
            CMP    AL,ZEROB                   ; is AL = zero ?
            JZ     done2                      ; yes, so all done
            PUSH   SI                         ; save SI
            MOV    BX,0007h                   ; BX = 7
            MOV    AH,0Eh                     ; AH = 14
            INT    10h                        ; write char in AL to screen
            POP    SI                         ; restore SI
            JMP    nxtchar                    ; go get another char
    done2:
            RET  
ENDP        PRTSTR

PROC        DISKIO
            MOV    DI,0005h                   ; gonna try the I/O 5 times
    retry:
            MOV    BX,BBOOT                   ; memory buffer @ 07C00h for disk I/O
            PUSH   DI                         ; save DI
            INT    13h                        ; call BIOS disk I/O
            POP    DI                         ; restore DI
            JNB    done1                       ; I/O went ok so all done
            XOR    AX,AX                      ; oops, reset disk...
            INT    13h                        ; resetting
            DEC    DI                         ; one try down
            JNZ    retry                      ; go try again
            MOV    SI,OFFSET err2 + HOLD      ; bummer, all 5 I/O attempts failed
            CALL   PRTSTR                     ; display error message
            JMP    halt                       ; stay here awhile
    done1:  
            RET
ENDP        DISKIO     

    partn   DB     00h                        ; holds partition number if boot partition is changed
    tflag   DB     00h                        ; timer has popped flag (bit 7)
    err1    DB     "Bad partition table"      ; error message #1
            DB     00h
    err2    DB     "Disk I/O Error"           ; error message #2
            DB     00h
    err3    DB     "Missing O/S"              ; error message #3
            DB     00h
    ques    DB     "Enter partition # (1..4) "  ; prompt to enter a new partition to boot from
            DB     63 DUP (00h)               ; pad out to 446 to fill code part of boot record
ENDS        SEG1
END         start

