/***************************************************************************
*
*      Author:			Giuseppe Aquilani
*      File:			int09vct.h
*      Date:			02/02/96
*		 description:  file header for interrupt's vector for keyboard
*                    for DPMI32 of Borland
*      parameters:
*            Ist_H09()   -> install a new handler for keyboard
*            oldseg_call -> segment of old handler
*				 oldoff_call -> offset of old handler
*				 raw_key     -> keyboard's scan code
*            Free_Int()  -> restore old handler with oldseg_call:oldoff_call
*
*      My address:
*            telesis@pelagus.it
*            ik0jre@pelagus.it
*				 ik0jre@i0xnh.ilaz.ita
***************************************************************************/


#pragma inline
#define INDEX_UP        0
#define INDEX_DOWN      1
#define INDEX_RIGHT     2
#define INDEX_LEFT      3
#define INDEX_ROTL      4
#define INDEX_ROTR      5
#define INDEX_MINUS     6
#define INDEX_PLUS      7

int raw_key;                        //scan code of keyboard
short int oldseg_call,oldoff_call;  //seg:offset of oldhandler

extern "C" {void Ist_H09(void);     //install new handler
				void Free_Int(void);    //restore handler
			  }

struct real_reg
{
  int edi;
  int esi;
  int ebp;
  int und;
  int ebx;
  int edx;
  int ecx;
  int eax;
  short int cpuflag;
  short int es;
  short int ds;
  short int fs;
  short int gs;
  short int ip;
  short int cs;
  short int sp;
  short int ss;
};
struct real_reg realreg;
short int key_table[8] = {0,0,0,0,0,0,0,0};
