*******************************************************
* program to build a upload file of payroll information
*    Copyright Tim Schroeder 1996
*    All Rights Reserved
*    timsch@midusa.net
* Note: This left in as source code for modification by
*       end users. Please share or sell your mods to this
*       file.
*******************************************************

IF VAL(ACCESS) < 4
  ?? CHR(7)
  WAIT WINDOW NOWAIT 'Must be a level 4 or above.'
  RETURN
ENDIF

IF NOT isdir(mguplddr)  && PDL FUNCTION
  saystr = 'Invalid drive for upload drive. Aborting Process'
  =popalert('Notice',saystr)
  RETURN
ENDIF

saystr = 'Have you ran and checked Summary, Spread and Changed reports ?  '
saystr = saystr+'This Builds the File that will later be sent to the office.'
IF NOT popwarn(saystr) && PDL FUNCTION
  WAIT WINDOW NOWAIT 'Process Aborted'
  RETURN
ENDIF
IF mgstore = 'Unregistered Version'
  ?? CHR(7)
  saystr = 'This option disabled for unregistered software. '
  saystr = saystr + 'Please Contact Tim Schroeder at 316-341-0303! '
  saystr = saystr + 'or at timsch@midusa.net'
  =popalert('Notice!',saystr)
  return
ENDIF
=noteit('/Created external posting file/')
moldsafety = SET('safety')
SET SAFETY OFF
* STRUCTURE employee changed/new
*BUILD A STRING TO USE AS A upload FILENAME
* CHAR 1 'E'= Employee
* CHAR 2 = COMANY NUMBER EG '5'
* CHAR 3 AND 4 = DEPARTMENT NUMBER EG. '01'
* CHAR 5 AND 6 = DAY OF MONTH
* CHAR 7 AND 8 = MONTH OF YEAR
muploadf = 'E'+RIGHT(mgcompno,1);
  +ALLTRIM(STUFF(mgdeptno,1,1,' '))+;
  SUBSTR(DTOC(mgperend),4,2)+SUBSTR(DTOC(mgperend),1,2)+'.DBF'

IF cknewemp()
  WAIT WINDOW  'New Employees Found' TIMEOUT 2
ENDIF
IF ckchgemp()
  WAIT WINDOW  'Changed Employees Found' TIMEOUT 2
ENDIF
x=cktrans()
IF x
  ?? CHR(7)
  saystr = 'Since you have a transferd employee. Auto postings'+;
    'are not possible at this time. '
  =popalert('Notice',saystr)
  CLOSE DATA
  RETURN
ENDIF
WAIT WINDOW NOWAIT 'Creating file of new/changed employees'
* use the employee file and copy proper records to muploadf
SELECT employee

COPY TO (mguplddr)+(muploadf) FOR changed > 0 OR new $ 'TRY';
  AND NOT DELETED()

*BUILD A STRING TO USE AS A upload FILENAME
* STRUCTURE
* CHAR 1 'P'= Payroll
* CHAR 2 = COMANY NUMBER EG '5'
* CHAR 3 AND 4 = DEPARTMENT NUMBER EG. '01'
* CHAR 5 AND 6 = DAY OF MONTH
* CHAR 7 AND 8 = MONTH OF YEAR
muploadf = 'P'+RIGHT(mgcompno,1);
  +ALLTRIM(STUFF(mgdeptno,1,1,' '))+;
  SUBSTR(DTOC(mgperend),4,2)+SUBSTR(DTOC(mgperend),1,2)+'.DBF'
* use the SBT prxpst file and copy structure to muploadf
SELECT 0
USE prxpst.dbf
COPY STRUCTURE TO (mguplddr)+(muploadf)
USE
USE (mguplddr)+(muploadf) ALIAS xpst

** Process hours file to get totals
**********************************************************
*NOTE: even thou amount is included in this SQL
*      SBT recalculates it
*
**********************************************************
SELECT hours.emplno, employee.first, employee.last,;
  employee.ssnum,;
  hours.jobnum, hours.jobdesc, hours.rate,hours.otherdesc,;
  SUM(hours.hours) AS qty, SUM(hours.amount) AS amt;
  FROM HOURS,employee;
  WHERE hours.emplno = employee.emplno AND;
  hours.date >= mgperbeg AND hours.date<=mgperend ;
  GROUP BY employee.last,employee.first,hours.jobnum;
  INTO TABLE tothrs

*******************************************
** WHAT IF NEW EMPLOYEE BUT NO HOURS POSTED
** OR WAS TERMINATED WITHOUT HOURS
*******************************************
SELECT employee
SET FILTER TO
LOCATE FOR new $ 'TRY' AND NOT DELETED()
DO WHILE FOUND()
  SCATTER MEMVAR
  SELECT tothrs
  LOCATE FOR emplno = employee.emplno
  IF NOT FOUND()
    APPEND BLANK
    GATHER MEMVAR
    ** need some fields filled out with dummy info
    REPLACE jobnum WITH 1
    REPLACE jobdesc WITH 'COOKING'
  ENDIF
  SELECT employee
  CONTINUE
ENDDO



********* take care of overtime ***

** must use select because of possible double records
SELECT emplno,SUM(HOURS) AS HOURS,rate,wkend,maxdesc,maxjobnum;
  FROM ot WHERE wkend >= mgperbeg AND wkend <= mgperend;
  GROUP BY emplno, maxdesc INTO TABLE tot_ot

INDEX ON emplno + STR(maxjobnum) TO tot_ot.ndx

SELECT tothrs
SET RELATION TO emplno+STR(jobnum) INTO tot_ot
GO TOP
SCAN
  ** add ot record if 1 exists to tothrs
  SELECT tot_ot
  othours = tot_ot.hours
  otrate = tot_ot.rate
  SELECT tothrs
  SCATTER MEMVAR  && tothrs
  IF EMPTY(othours)
    LOOP
  ENDIF

  IF othours > 0
    * minus out overtime from regular hours
    REPLACE tothrs.qty WITH tothrs.qty - othours
    REPLACE tothrs.amt WITH tothrs.rate * tothrs.qty

    * add the overtime record to tothrs
    STORE RECNO() TO mrecord
    APPEND BLANK
    GATHER MEMVAR
    REPLACE qty WITH othours
    REPLACE tothrs.rate WITH otrate
    REPLACE amt WITH qty * tothrs.rate
    REPLACE jobnum WITH 6 && modify to use systable
    REPLACE jobdesc WITH 'OVERTIME'
    GO mrecord
  ENDIF
ENDSCAN
INDEX ON ALLTRIM(LAST)+ALLTRIM(first);
  +STR(jobnum) TO tothrs.ndx

** add records to alias xpst  unique file for each store
SELECT tothrs
GO TOP
nseqno = 1
m.emplno = emplno
SCAN
  IF emplno <> m.emplno
    nseqno = nseqno + 1
    m.emplno = emplno
  ENDIF
  SELECT xpst
  APPEND BLANK
  REPLACE prxseq WITH PADL(ALLTRIM(STR(nseqno,5,0)),5,'0')
  REPLACE prsource WITH 'XP1'
  REPLACE prempl WITH tothrs.emplno
  REPLACE prbeg WITH DTOC(mgperbeg)
  REPLACE prend WITH DTOC(mgperend)
  REPLACE prdate WITH ' ' && mgperend
  REPLACE prcycle WITH 'S'
  REPLACE prdays WITH '15'
  *************************************************
  * adjust this structure as required
  *************************************************
  DO CASE
    CASE tothrs.jobdesc = 'COOKING'
      REPLACE prstr1 WITH tothrs.jobdesc
      REPLACE prqty WITH tothrs.qty
      REPLACE print1 WITH tothrs.jobnum
      REPLACE prtype WITH 'HR'
      REPLACE prrate WITH tothrs.rate
    CASE tothrs.jobdesc = 'WAITING'
      REPLACE prqty WITH tothrs.qty
      REPLACE prstr1 WITH tothrs.jobdesc
      REPLACE print1 WITH tothrs.jobnum
      REPLACE prtype WITH 'HR'
      REPLACE prrate WITH tothrs.rate
    CASE tothrs.jobdesc = 'HOSTING'
      REPLACE prqty WITH tothrs.qty
      REPLACE prstr1 WITH tothrs.jobdesc
      REPLACE print1 WITH tothrs.jobnum
      REPLACE prtype WITH 'HR'
      REPLACE prrate WITH tothrs.rate
    CASE tothrs.jobdesc = 'DELIVERY'
      REPLACE prqty WITH tothrs.qty
      REPLACE prstr1 WITH tothrs.jobdesc
      REPLACE print1 WITH tothrs.jobnum
      REPLACE prtype WITH 'HR'
      REPLACE prrate WITH tothrs.rate
    CASE tothrs.jobdesc = 'TIPS'
      REPLACE prqty WITH tothrs.amt
      REPLACE prstr1 WITH tothrs.jobdesc
      REPLACE print1 WITH tothrs.jobnum
      REPLACE prtype WITH 'T'
      REPLACE prrate WITH 1
    CASE tothrs.jobdesc = 'VACATION'
      REPLACE prqty WITH tothrs.qty
      REPLACE prstr1 WITH tothrs.jobdesc
      REPLACE print1 WITH tothrs.jobnum
      REPLACE prtype WITH 'HV'
      REPLACE prrate WITH tothrs.rate
    CASE tothrs.jobdesc = 'HOLIDAY'
      REPLACE prqty WITH tothrs.qty
      REPLACE prstr1 WITH tothrs.jobdesc
      REPLACE print1 WITH tothrs.jobnum
      REPLACE prtype WITH 'HH'
      REPLACE prrate WITH tothrs.rate
    CASE tothrs.jobdesc = 'SALARY'
      REPLACE prqty WITH tothrs.qty
      REPLACE prstr1 WITH tothrs.jobdesc
      REPLACE print1 WITH tothrs.jobnum
      REPLACE prtype WITH 'S '
      REPLACE prrate WITH tothrs.rate
    CASE tothrs.jobdesc = 'COMISSION'
      REPLACE prqty WITH tothrs.qty
      REPLACE prstr1 WITH tothrs.jobdesc
      REPLACE print1 WITH tothrs.jobnum
      REPLACE prtype WITH 'CM'
      REPLACE prrate WITH tothrs.rate
    CASE tothrs.jobdesc = 'OTHER TAXABLE'
      REPLACE prqty WITH tothrs.qty
      REPLACE prstr1 WITH tothrs.jobdesc
      REPLACE print1 WITH tothrs.jobnum
      REPLACE prtype WITH 'OT'
      REPLACE prrate WITH tothrs.rate
      IF EMPTY('tothrs.otherdesc')
        REPLACE prdesc WITH 'OTHER TAXABLE'
      ELSE
        REPLACE prdesc WITH tothrs.otherdesc
      ENDIF
    CASE tothrs.jobdesc = 'OVERTIME'
      REPLACE prqty WITH tothrs.qty
      REPLACE prstr1 WITH tothrs.jobdesc
      REPLACE print1 WITH tothrs.jobnum
      REPLACE prtype WITH 'HO'
      REPLACE prrate WITH tothrs.rate
    OTHERWISE
      * add error case
      saystr = 'There is an invalid jobcode. In your Hours file. '
      saystr = saystr+'Do not send Data to the Office'
      =popalert('Warning',saystr)

  ENDCASE
ENDSCAN
CLOSE DATA
WAIT WINDOW NOWAIT 'done'
DELETE FILE tothrs.dbf
DELETE FILE tothrs.ndx

SET SAFETY &moldsafety
