/*
** Demo for The Window Boss
**
** Copyright (c) 1985-1990 - Philip A. Mongelluzzo
** All rights reserved.
**
*/

#include "windows.h"                    /* windows header file */

#if DLC
int _stack = 8192;                      /* Datalight C */
#endif

#if BORLAND
unsigned _stklen = 8192;
#endif

#if __TSC__                             
#define MAXWIN 70                       /* TopSpeed C */
#else
#define MAXWIN 100                      /* for 100 windows */
#endif

WINDOWPTR wins[MAXWIN];                 /* DONT INCREASE IN SMALL MODEL */

unsigned blue = BLUE;                   /* remap for mono */

/*
** Prototypes to keep the new ANSI Compilers Happy
*/

#if BORLAND | WATCOM | MSC
int main(int argc, char **argv);
int dedemo(void);
int pddemo(void);
int dotelecom(int ch);
int dosetup(int ch);
int dofileman(int ch);
int dooutput(int ch);
int dorun(int ch);
int doedit(int ch);
int nap(int ticks);
int hiber(int seconds);
int chkesc(void);
int paktc(void);
#endif

main(argc,argv)
int argc;
char *argv[];
{
WINDOWPTR     w2, w3;                   /* a few windows */
WINDOWPTR tw1, tw2, tw3;                /* and a few more */

WINDOWPTR wn_qpopup();                  /* function returns WP */
int i,j;                                /* scratch integers */
int t50rib;                             /* top 50 atrib */
int watrib,batrib;                      /* scratch atributes */
int rv;                                 /* for popup */
int row,col;                            /* for 100 windows */

MOUSEPTR mm;                            /* my mouse ptr */
int mstat, mclik, mrow, mcol;           /* mouse stuff */

  static struct pmenu m1 = {
    00, FALSE, 00,
    00, 00, {
    01, 02, "Presenting", 0,
    99, 99, "",99 }
  };

  static struct pmenu m2 = {
    00, FALSE, 00,
    00, 00, {
    01, 02, "The", 0,
    03, 02, "W i n d o w   B O S S", 0,
    05, 02, "Fast - Easy - Windows", 0,
    07, 02, "for the C Language", 0,
    99, 99, "",99 }
  };

  static struct pmenu intelc = {
    00, FALSE, 00,
    02, 06, {
    01, 02, "         Intellicom", 0,
    02, 02, "        Quick - Help", 0,
    04, 05, "1 General Information  ", 1,
    05, 05, "2 Terminal Mode Options", 2,
    06, 05, "3 XMODEM File Send     ", 3,
    07, 05, "4 XMODEM File Receive  ", 4,
#if MSC | DLC | CI86 | LC3
     8, 05, "5 CompuServe Exec Mode ", 5,
#else         
    08, 05, "5 CompuServe Exec Mode ", 5,
#endif
    10, 02, "Press: ESC to quit or Cursor", 0,
    11, 02, " Keys to Position Cursor then", 0,
    12, 02, " press RETURN for MORE info.", 0,
    99, 99, "",99 }
  };

if(argc > 2) wn_dmaflg=FALSE;         /* for testing bios access */
  if(wns_mtflg == 7) blue = BLACK;      /* remap if mono */
  if(argc > 1) wn_dmode(PAINT);         /* pretend CGA */

  wn_init();                            /* save entry screen */

  batrib = v_setatr(WHITE,BLACK,0,BOLD);/* set border atrib */
  watrib = v_setatr(WHITE,RED,0,0);     /* make it american */
  w2 = wn_qpopup(0,0,0,16,3,watrib,batrib,&m1);
  for(i=1; i<11; i++)                   /* move it into place */
    w2 = wn_move(w2, i, i*2); 

  hiber(1);                             /* wait 1 second (aprx) */

  batrib = v_setatr(RED,WHITE,0,BOLD);  /* set border atrib */
  watrib = v_setatr(blue,WHITE,0,BOLD); /* make this american too */
  w3 = wn_qpopup(0,0,0,30,9,watrib|BOLD,batrib,&m2);
  for(i=1; i<8; i++)                    /* move into place */
    w3 = wn_move(w3,i,6*i);             /* move into place */

  hiber(5);                             /* reading time.. */

  wn_clr(w3);
  wn_title(w3," PLEASE NOTE ");
  wn_printf(w3,"\n");
  wn_printf(w3,"This demo contains reading\n");
  wn_printf(w3,"time delays that you can\n");
  wn_printf(w3,"shorten by pressing the ESC\n");
  wn_printf(w3,"key.\n\n");
  wn_printf(w3,"Press any key to continue...");
  paktc();

  wn_close(w3);                         /* close a couple */
  hiber(1);
  wn_close(w2);
  hiber(1);

  watrib = v_setatr(WHITE,BLACK,0,BOLD);
  for(i=0; i<25; i++) {                 /* build the back drop */
    v_locate(0,i,0);                    /* position cursor */
    v_wca(0, 0xb0, watrib, 80);         /* the fast way */
  }
  v_hidec();                            /* hide the cursor */

  watrib = v_setatr(WHITE,BLACK,0,0);   /* window attribute */
  batrib = v_setatr(blue,WHITE,0,0);    /* border attribute */
  w3 = wn_open(800,1,9,60,21,watrib,batrib);
  w3->bstyle |= BOLD;                   /* toggle bold on then off */
  wn_title(w3," The Window BOSS for C ");
  w3->bstyle ^= BOLD;
  wn_puts(w3,1,1,"The Window BOSS puts YOU in control of the most important");
  wn_puts(w3,2,1,"sophisticated state-of-the-art screen handling techniques");
  wn_puts(w3,3,1,"available today.  Pop-up windows, pull-down menus, status ");
  wn_puts(w3,4,1,"lines and context sensitive help functions are a breeze ");
  wn_puts(w3,5,1,"to implement!  Your program automatically senses the ");
  wn_puts(w3,6,1,"video card installed and ALL your video output takes ");
  wn_puts(w3,7,1,"place with no snow, no flicker, and no delay. But best of");
  wn_puts(w3,8,1,"all, The Window BOSS is available as SHAREWARE software!");
  wn_puts(w3,9,1," ");
  wn_puts(w3,10,1,"The Window BOSS is available for the Lattice, Microsoft,  ");
  wn_puts(w3,11,1,"Datalight, Borland, Mix Power C, Aztec, WATCOM, Zortech,");
  wn_puts(w3,12,1,"and Computer Innovation CI86 C Compilers.  Registered");
  wn_puts(w3,13,1,"users receive complete documentation, all source code,");
  wn_puts(w3,14,1,"and libaries for the small and large memory models for");
  wn_puts(w3,15,1,"all supported compilers (others can be locally created)!");
  wn_puts(w3,16,1," ");
  wn_puts(w3,17,1,"I challenge you to compare: The Window BOSS is faster");
  wn_puts(w3,18,1,"and easier to use than most commercial products on the");
  wn_puts(w3,19,1,"market today!");
  hiber(30);

  wn_clr(w3);
  wn_puts(w3, 1,1,"Tim Parker's column in the February 87 issue of Computer ");
  wn_puts(w3, 2,1,"Language stated \"the ease of use will cause some ");
  wn_puts(w3, 3,1,"programmers to go overboard with windows\", and \"if you ");
  wn_puts(w3, 4,1,"are a die-hard C programmer looking for a useful, ");
  wn_puts(w3, 5,1,"license-free product, this is it\".");
  wn_puts(w3, 6,1," ");
  wn_puts(w3, 7,1,"Hardin Bothers' column in the June 88 issue of PC ");
  wn_puts(w3, 8,1,"Resource stated \"Within its domain, The Window BOSS is ");
  wn_puts(w3, 9,1,"as useful and as powerful as any C library I've used\". ");
  wn_puts(w3,10,1,"\"The Window BOSS owes much of its power to its ");
  wn_puts(w3,11,1,"uncluttered organization. Although the product supports ");
  wn_puts(w3,12,1,"five C Compilers - Microsoft C, Lattice C, Borland's ");
  wn_puts(w3,13,1,"Turbo C, Computer Innovations CI86, and Datalight C - it ");
  wn_puts(w3,14,1,"does it with a minmum of fuss\".");
  wn_puts(w3,15,1," ");
  wn_puts(w3,16,1,"The BOSS is currently being used by dozens of Fortune ");
  wn_puts(w3,17,1,"500 Companies, numerous universities, and discriminating ");
  wn_puts(w3,18,1,"\"C\" programmers around the world!  Haven't you waited ");
  wn_puts(w3,19,1,"long enough?");
  hiber(30);


  wn_clr(w3);
  wn_puts(w3, 1,1,"  Psst...");
  wn_puts(w3, 2,1,"  ");
  wn_puts(w3, 3,1,"    The Window BOSS is one of ");
  wn_puts(w3, 4,1,"               PC-SIG's TOP 50 Best Selling Programs");
  wn_puts(w3, 5,1,"  ");
  wn_puts(w3, 6,1,"                          ");
  wn_puts(w3, 7,1,"                                   ");
  wn_puts(w3, 8,1,"                                ");
  wn_puts(w3, 9,1,"                                ");
  wn_puts(w3,10,1,"                             ");
  wn_puts(w3,11,1,"  ");
  wn_puts(w3,12,1,"                         ");
  wn_puts(w3,13,1,"                                ");
  wn_puts(w3,14,1,"                            ");
  wn_puts(w3,15,1,"                                ");
  wn_puts(w3,16,1,"                         ");
  wn_puts(w3,17,1,"  ");
  wn_puts(w3,18,1,"            Shareware Magazine Jan-Feb 1990");
  wn_puts(w3,19,1,"  ");
  for(j=0; j<=WHITE; j++) {
    t50rib = v_setatr(WHITE,j,0,BOLD);
    wn_natrib(w3,t50rib);
  }
  wn_dmode(PAINT);
  wn_natrib(w3,watrib);
  wn_dmode(FLASH);
  hiber(5);
  
  watrib = v_setatr(WHITE,blue,0,0);    /* window attribute */
  batrib = v_setatr(RED,WHITE,0,BOLD);  /* border attribute */
  w2 = wn_open(0,5,5,50,10,watrib,batrib);
  if(!w2) exit(1);                      /* yes.. it should be better */
  wn_puts(w2,0,0," Simple text output is very fast");
  wn_puts(w2,1,0," and snow free.");
  wn_puts(w2,3,0," Watch this....");
  hiber(3);
  wn_clr(w2);                           /* clear it then fill it */
  for(i=0; i<10; i++)
    wn_puts(w2,i,0," Very fast screen output - no snow!");
  hiber(5);
  wn_clr(w2);                           /* do it again */
  for(i=0; i<10; i++)
    wn_puts(w2,i,0," Another window full of fast text.");
  hiber(5);

  wn_clr(w2);
  wn_printf(w2," The BOSS also supports a printf function!\n");
  wn_printf(w2," Its as simple as:\n\n");
  wn_printf(w2," \twn_printf(wn,\"%%d\\n\",i);\n\n");
  wn_printf(w2," to print a value in a window.\n\n");
  wn_printf(w2," Scrolling works too\n");
  wn_printf(w2," Lets count (slowly) to 10...\n");
  wn_sync(w2, TRUE);
  hiber(10);
  for(i=1;i<11;i++) {
    wn_printf(w2," The count is: %d\n", i);
    nap(5);
  }
  wn_printf(w2," Ok, lets see what it looks like at\n");
  wn_printf(w2," full speed.. (counting to 25)\n");
  hiber(5);
  for(i=1;i<26;i++)
    wn_printf(w2," The count is: %d\n", i);
  hiber(5);                             /* reading time */
  wn_sync(w2, FALSE);
  v_hidec();

  wn_clr(w2);
  wn_putsa(w2,0,0," Full color support is provided.",WHITE<<4);
  for(i=1; i<6; i++)
    wn_putsa(w2,i,0, " Add a little color to your life.",WHITE<<4|i);
  wn_putsa(w2,6,0," As is window movement....watch...",WHITE<<4|BLACK);
  hiber(5);

  for(i=0; i<13; i++)                   /* move the window around */
    w2 = wn_move(w2, i, i*2); 
  hiber(5);
  wn_printf(w2,"\n Lets put it back where we started...\n");
  hiber(3);
  w2 = wn_move(w2,5,5); 
  wn_printf(w2," Now, lets add a title to our window!\n");
  hiber(3);
  w2->bstyle |= BOLD;
  wn_title(w2," Pretty Powerful Stuff ");
  w2->bstyle ^= BOLD;
  hiber(5);

/* ============================= Tiled Window Stuff ===================== */

  wn_printf(w2," Tiled windows are supported\n");
  wn_printf(w2," Lets add three.\n");
  hiber(5);

  wn_sbit=FAST;
  tw1 = wn_open(500,3,5,40,10, RED<<4|YELLOW|BOLD, RED<<4|WHITE|BOLD);
  wn_sync(tw1,TRUE);
  wn_printf(tw1,"ONE\n");
  tw2 = wn_open(500,6,8,40,10, blue<<4|WHITE|BOLD, blue<<4|GREEN|BOLD);
  wn_sync(tw2,TRUE);
  wn_printf(tw2,"TWO\n");
  tw3 = wn_open(500,9,11,40,10,GREEN<<4|WHITE|BOLD, GREEN<<4|WHITE|BOLD);
  wn_sync(tw3,TRUE);
  wn_printf(tw3,"THREE\n");
  wn_printf(tw3," Press a key and watch TWO move\n");
  wn_printf(tw3," To the top!!\n");
  v_getch();

  wn_activate(tw2);
  wn_printf(tw2," Press a key and watch THREE move\n");
  wn_printf(tw2," To the top!!\n");
  v_getch();
  wn_activate(tw3);
  wn_printf(tw3," Press a key and watch ONE move\n");
  wn_printf(tw3," To the top!!\n");
  v_getch();
  wn_activate(tw1);

  wn_printf(tw1, " Ok..Press a key\n");
  wn_printf(tw1, " and we will continue with the show!");
  v_getch();

  wn_close(tw1);
  wn_close(tw3);
  wn_close(tw2);

  wn_clr(w2);
  wn_printf(w2," 100 are as easy as 3!!\n");
  wn_printf(w2," Press any key please..\n");
  v_getch();

  for (i = 0; i < MAXWIN; i++) {
     row = (rand() % 12) +3;
     col = (rand() % 62) +2;
     batrib = rand() % 16;
     watrib = rand() % 128;
     if(wns_mtflg == 7) {
       batrib = v_setatr(BLACK,WHITE,0,BOLD);
       watrib = v_setatr(BLACK,WHITE,0,BOLD);
     }
     wins[i] = wn_open(0,row,col,11,7,watrib, batrib);
     if(!wins[i]) {
       v_locate(0,0,0);
       v_cls(NORMAL);
       printf("wn_open failed...reduce MAXWIN!!\n");
       exit(1);
     }  
     wn_printf(wins[i],"%d",i);
  }
  hiber(5);
  
  wn_clr(w2);
  wn_printf(w2," Lets activate the bottom 10 one at a time.\n");
  wn_printf(w2," When you hear the beep press a key...\n");
  hiber(5);

  paktc();
  for(i=0;i<10;i++) {
    wn_printf(wins[i]," Activated!\n");
    paktc();
  }

  wn_clr(w2);
  wn_printf(w2, " Truly Powerful Stuff!!\n");
  wn_printf(w2, " Ok..Press a key\n");
  wn_printf(w2, " and we will SLOWLY close all 100 windows by\n");
  wn_printf(w2, " floating each window to the top of the stack\n");
  wn_printf(w2, " and restoring the image that existed prior to\n");
  wn_printf(w2, " the window being opened. Concurrently, all \n");
  wn_printf(w2, " other hidden images will be adjusted to reflect\n"); 
  wn_printf(w2, " the fact that a window has vanished!!\n");
  v_getch();

  for(i=MAXWIN-1; i>=0; i--) {
    wn_printf(wins[i]," Closing\n");
    nap(2);
    if(!wn_close(wins[i])) {
      v_cls(7);
      v_locate(0,0,0);
      printf("wn_close failed!\n");
      exit(1);
    }
  }

  wn_sbit=SLOW;

/* ========================= Popup & Help Stuff ========================= */

  wn_clr(w2);
  wn_printf(w2," Popup Menus are a breeze.\n\n");
  wn_printf(w2," Watch....");
  hiber(2);
  if(!wn_hlinit(0,0,78,23,BLUE<<4 | WHITE, BLUE<<4 | WHITE,"intelc")) {
    v_locate(0,0,0);
    printf("wn_hlinit failed!\n");
    exit(0);
  }
  do {
    rv = wn_popup(0,0,0,33,14, WHITE<<4|BLACK, blue<<4|WHITE, &intelc,FALSE);

    switch (rv) {                       /* dispatch */
      case 1:
        wn_help("%general information%");
        break;
      case 2:
        wn_help("%terminal%");
        break;
      case 3:
        wn_help("%checksum xmit1%");
        break;
      case 4:
        wn_help("%checksum recv1%");
        break;
      case 5:
        wn_help("%cistty1%");
        break;
      case 99:
      default:
        break;
    }
  } while(rv !=99);

/***************************** Pulldown Stuff *****************************/

  wn_clr(w2);                           /* setup for pulldown */
  wn_printf(w2," Pulldown Menus are easy too!!\n\n");
  wn_printf(w2," Watch....");
  hiber(2);
  pddemo();                             /* pulldown sample */

/***************************** Data Entry Stuff **************************/

                                        /* set up for data entry */
  wn_clr(w2);
  wn_printf(w2," Naturally, The Window BOSS fully supports\n");
  wn_printf(w2," data entry in windows!!\n\n");
  wn_printf(w2," Lets try a small sample ....");
  hiber(5);
  dedemo();                             /* do the data entry demo */

/**************************** Summary Stuff *******************************/

  wn_clr(w2);                           /* clear the window */
  w2->bstyle |= BOLD;                   /* toggle bold on then off */
  wn_title(w2," The Window BOSS for C ");
  w2->bstyle ^= BOLD;
  wn_printf(w2,"\n\n  The following is a quick summary\n");
  wn_printf(w2,"  of SOME of the functions available...");
  hiber(4);

  wn_help("%bossinfo%");                /* provide some details */

  wn_clr(w2);                           /* and now the credits */
  wn_printf(w2,"\n\n\n");
  wn_printf(w2,"                  The Window BOSS\n");
  wn_printf(w2,"             Copyright (c) 1985 - 1990\n");
  wn_printf(w2,"              Philip  A. Mongelluzzo\n");
  wn_printf(w2,"                 273 Windy Drive\n");
  wn_printf(w2,"              Waterbury, Conn  06705\n");

  wn_printf(w2,"\n\t\t\t\tThats all folks...\n\n");

  hiber(10);                            /* all done ! */
  wn_close(w2);
  wn_close(w3);
  wn_exit();                            /* restore entry screen */

/**************************** Mouse Stuff *********************************/


  mm = mo_reset();                      /* init mouse */

  if(mm) {                              /* mouse exists */
    printf("Simple Mouse Demo - press any key to continue...");
    v_getch();
    v_cls(NORMAL);                      /* clear the screen */
    v_locate(0,0,0);                    /* locate the cursor */
    printf("Mouse exists with %d buttons.\n", mo_nbutt(mm));
    printf("Move mouse, randomly click right button, click left to end.\n");
    mo_motion(mm);                      /* set motion counters */
    mo_setptr(mm, 0x1E, NORMAL);        /* set mouse pointer style */
    mo_reigon(mm, 0, 0, 80, 25);        /* set mouse "window" */
    mo_show(mm);                        /* show the critter */

    do {                                /* click tests */
      mo_press(mm, MO_RIGHT, &mstat, &mclik, &mrow, &mcol);
      if(mclik > 0) {                   /* right button PRESSED ? */                           
        v_locate(0,3,0);                /* display info if so */
        printf("Right button @ %03d,%03d\n", mrow, mcol);
      }
      mo_release(mm, MO_LEFT, &mstat, &mclik, &mrow, &mcol); 
      if(mclik > 0) {                   /* left RELEASED ? */
        v_locate(0,4,0);
        printf("Left  button @ %03d,%03d\n", mrow, mcol);
      }
    } while (mclik != 1);

    v_locate(0,5,0);
    printf("Roll test... move mouse, click left or right for next test.\n");
    do {                                /* rolling test */
      mo_rcpos(mm, &mstat, &mrow, &mcol);
      v_locate(0,6,0);
      printf("Mouse @ %03d,%03d\n", mrow, mcol);
    } while (!mstat);

    mo_wait(mm);                        /* wait for mouse to settle */
    v_cls(NORMAL);                      /* clear screen */
    v_locate(0,0,0);                    /* locate cursor */
    printf("Mouse fence test\n");
    printf("Just try n' get out!! (click)\n");
    mo_locate(mm, 5, 0);                /* home mouse .. almost */
    mo_reigon(mm, 5, 0, 10, 10);        /* set mouse window size */

    do {                                /* exit on button release */
      mo_release(mm, MO_LEFT,  &mstat, &mclik, &mrow, &mcol); 
      if(mclik)
        break;
      mo_release(mm, MO_RIGHT, &mstat, &mclik, &mrow, &mcol); 
      if(mclik)
        break;
    } while (TRUE);

    v_cls(NORMAL);                      /* clear screen */
    v_locate(0,0,0);                    /* home cursor */
    mo_hide(mm);                        /* hide mouse */
    mm = mo_reset();                    /* reset mouse */
    exit(0);                            /* finito */
  }
  exit(0);
}

/************************* Data Entry Demo Code ***************************/

dedemo()                                /* data entry demo */
{
WINDOWPTR wn;                           /* window pointer */
WIFORM frm;                             /* form pointer */
static struct db {                      /* record layout */
  char  date[10];                       /* date string */
  int   month,day,year;                 /* date numerics */
  char  time[10];                       /* time string */
  int   thrs,tmin,tsec;                 /* time numerics */
  char  name[32];                       /* name */
  char  adr[32];                        /* street address */
  char  city[17];                       /* city */
  char  st[4];                          /* state */
  char  zip[8];                         /* zip */
  char  phone[18];                      /* phone string */
  int   ac, nnx, num;                   /* phone numerics */
  char  age[4];                         /* age */
  int   old;                            /* age numeric */
} rec;
unsigned atrib;                         /* data entry field atribute */
char *emsg1,*emsg2,*emsg3;              /* error msg ptr */
char fchar;                             /* fill character */

                                        /* open window */
  wn = wn_open(0,10,10,42,9,(BLUE<<4|YELLOW|BOLD),(BLUE<<4|WHITE|BOLD));
  if(!(wn)) {                           /* errors ?? */
    printf("wn_open failed!!\n");       /* tell of woe... */
    exit(1);                            /* and die */
  }  
  wn_title(wn," Sample Data Entry Form ");

  frm = wn_frmopn(11);                  /* form open for 10 fields */
  if(!frm) {                            /* errors ?? */
    printf("wn_frmopn failed!!\n");     /* tell of woe... */
    exit(1);                            /* and die */
  }

  atrib = (BLUE<<4) | WHITE | BOLD;     /* field attribute */
  *rec.date = NUL;                      /* set edit buffer to zip */
  *rec.time = NUL;                      /* set edit buffer to zip */
  *rec.adr = NUL;                       /* set edit buffer to zip */
  *rec.city = NUL;                      /* set edit buffer to zip */
  *rec.st = NUL;                        /* set edit buffer to zip */
  *rec.zip = NUL;                       /* set edit buffer to zip */
  *rec.phone = NUL;                     /* set edit buffer to zip */
  *rec.age = NUL;                       /* set edit buffer to zip */

  emsg1 = "Invalid date, press any key to continue...";
  emsg2 = "Invalid time, press any key to continue...";
  emsg3 = "Age must be between 1 and 99, press any key to continue...";

  fchar = '_';

  wn_gdate (SET,frm,0, wn,1,1, "Date: ",atrib,fchar,&rec.month,&rec.day,&rec.year,rec.date,NSTR,emsg1);
  wn_gtime (SET,frm,1, wn,1,23,"Time: ",atrib,fchar,&rec.thrs,&rec.tsec,&rec.tmin, rec.time,NSTR,emsg2);
  wn_gtext (SET,frm,2, wn,3,1, "Name: ",atrib,fchar,30,rec.name,NSTR,NSTR);
  wn_gtext (SET,frm,3, wn,4,1, "Addr: ",atrib,fchar,30,rec.adr,NSTR,NSTR);
  wn_gtext (SET,frm,4, wn,5,1, "City: ",atrib,fchar,15,rec.city,NSTR,NSTR);
  wn_gutext(SET,frm,5, wn,5,23,  "ST: ",atrib,fchar,2,rec.st,NSTR,NSTR);
  wn_gtext (SET,frm,6, wn,5,31, "Zip: ",atrib,fchar,5,rec.zip,NSTR,NSTR);
  wn_gphone(SET,frm,7, wn,7,1, "Tele: ",atrib,fchar,&rec.ac,&rec.nnx,&rec.num,rec.phone,NSTR,NSTR);
  wn_gint  (SET,frm,8, wn,7,23,"Age : ",atrib,fchar,&rec.old,2,1,99,rec.age,NSTR,emsg3);

  if(!wn_frmget(frm)) {                 /* get (read) form */
    v_cls(7);                           /* die if errors !! */
    v_locate(0,0,0);
    printf("Memory Corruption Error!\n");
    exit(1);
  }

  wn_clr(wn);                           /* clear window & display data */
  wn_printf(wn,"Data entered was:\n");
  wn_printf(wn,"Date: %02d/%02d/%02d  ", rec.month, rec.day, rec.year);
  wn_printf(wn,"Time: %02d:%02d:%02d\n", rec.thrs, rec.tmin, rec.tsec);
  wn_printf(wn,"Name: %s\n",rec.name);
  wn_printf(wn,"Adr:  %s\n",rec.adr);
  wn_printf(wn,"City: %s ST: %s Zip: %s\n",rec.city, rec.st, rec.zip);
  wn_printf(wn,"Tele: (%03d) %03d-%04d\n", rec.ac, rec.nnx, rec.num);
  wn_printf(wn,"Age:  %2d\n",rec.old);
  wn_printf(wn,"\nPress any key to continue..");
  v_getch();

  wn_frmcls(frm);                       /* close for */
  wn_close(wn);                         /* close window */
  return(NULL);                         /* keep the compilers happy */
}

/*********************** Pulldown Menu Code *******************************/

pddemo()
{
WINDOWPTR w0;                           /* back drop */
int fini;                               /* finished flag */
int watrib,batrib;                      /* scratch atributes */
int rv;                                 /* for popup */
int currch;                             /* current choice */

static struct pmenu mainbar = {         /* menu bar */
  00, FALSE, 00,
  00, 06, {
  00, 05, "EDIT", 1,
  00, 15, "RUN", 2,
  00, 25, "OUTPUT", 3,
  00, 35, "FILE MANAGER", 4,
  00, 50, "SETUP", 5,
  00, 60, "TELECOM", 6,
  00, 70, "QUIT", 7,
  99, 99, "",99 }
};

static struct pmenu pdedit = {          /* Edit Pulldown */
  00, FALSE, 00,
  00, 05, {
  00, 00, "Edit existing data file      ", 1,
  01, 00, "Edit new data file           ", 2,
  02, 00, "Pull up data file template   ", 3,
  03, 00, "Select data file group       ", 4,
  04, 00, "Print all data files         ", 5,
   5, 00, "Save                         ", 6,
  99, 99, "",99 }
};

static struct pmenu pdrun = {           /* Run Pulldown */
  00, FALSE, 00,
  00, 01, {
  00, 00, "Single  ", 1,
  01, 00, "Batch   ", 2,
  99, 99, "",99 }
};

static struct pmenu pdoutput = {        /* Output Pulldown */
  00, FALSE, 00,
  00, 02, {
  00, 00, "View    ", 1,
  01, 00, "Print   ", 2,
  02, 00, "Graphics", 3,
  99, 99, "",99 }
};

static struct pmenu pdfileman = {       /* File Manager Pulldown */
  00, FALSE, 00,
  00, 06, {
  00, 00, "Rename  ", 1,
  01, 00, "Copy    ", 2,
  02, 00, "Delete  ", 3,
  03, 00, "Chdir   ", 4,
  04, 00, "Editor  ", 5,
  05, 00, "Print   ", 6,
  06, 00, "DOS     ", 7,
  99, 99, "",99 }
};

static struct pmenu pdsetup = {         /* Setup Pulldown */        
  00, FALSE, 00,
  00, 02, {
  00, 00, "Colors  ", 1,
  01, 00, "Printers", 2,
  02, 00, "Plotters", 3,
  99, 99, "",99 }
};

static struct pmenu pdtelecom = {       /* Telcomm Pulldown */
  00, FALSE, 00,
  00, 01, {
  00, 00, "No      ", 1,
  01, 00, "Yes     ", 2,
  99, 99, "",99 }
};

static struct pmenu pdquit = {          /* Quit Pulldown */
  00, FALSE, 00,
  00, 01, {
  00, 00, "No      ", 1,
  01, 00, "Yes     ", 2,
  99, 99, "",99 }
};

  fini = FALSE;                         /* say we are not done */
  w0 = wn_open(1000,0,0,80,25,NVIDEO,NVIDEO);   /* save entry screen */
  if(!w0) return(NULL);                 /* less than graceful exit */

  wn_puts(w0,22,0, "Use cursor keys to highlight, Enter key to select");
  wn_puts(w0,23,0, "Press ESC to return to Menu Bar");
  wn_puts(w0,24,0, "To continue the demo ... Select Quit from menu bar, then YES from pulldown");

  batrib = v_setatr(BLACK,WHITE,0,0);   /* set border atrib */
  watrib = v_setatr(BLACK,WHITE,0,0);   /* keep it simple too */

  do {                                  /* Pull down Loop */
    rv = wn_popup(0,0,0,78,01, watrib, batrib, &mainbar, FALSE);
    switch (rv) {                       /* dispatch based on mainbar */
      case 1:                           /* Edit */
        do {
          currch = wn_popup(00,03, 5, 29, 6, watrib, batrib, &pdedit, FALSE);
          doedit(currch);
        } while (currch != 99);
        break;
      case 2:                           /* Run */
        do {
          currch = wn_popup(00,03, 15, 8, 2, watrib, batrib, &pdrun, FALSE);
          dorun(currch);
        } while (currch != 99);
        break;
      case 3:                           /* Output */
        do {
          currch = wn_popup(00,03, 25, 8, 3, watrib, batrib, &pdoutput, FALSE);
          dooutput(currch);
        } while (currch != 99);
        break;
      case 4:                           /* Filemanager */
        do {
          currch = wn_popup(00,03, 35, 8, 7, watrib, batrib, &pdfileman, FALSE);
          dofileman(currch);
        } while (currch != 99);
        break;
      case 5:                           /* Setup */
        do {
          currch = wn_popup(00,03, 50, 8, 3, watrib, batrib, &pdsetup, FALSE);
          dosetup(currch);
        } while (currch !=99);
        break;
      case 6:
        do {
          currch = wn_popup(00,03, 60, 8, 2, watrib, batrib, &pdtelecom, FALSE);
          dotelecom(currch);
        } while (currch != 99);
        break;
      case 7:                           /* quit */
        currch = wn_popup(00,03, 70, 8, 2, watrib, batrib, &pdquit, TRUE);
        if(currch == 2) {
          fini = TRUE;
          mainbar.winopn = FALSE;
          wn_close(mainbar.wpsave);
        }
        break;
      case 99:
      default:
        break;
    }
  } while(!fini);                       /* do till fini == TRUE */
  wn_close(w0);
}

dotelecom(ch)                           /* telcomm */
int ch;
{
WINDOWPTR wn;
static char *msg = "Telcom";

  if(ch == 99) return(NULL);
  wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
  wn_printf(wn,"  %s choice: %d,  Press any key to continue...............",msg,ch);
  v_getch();
  wn_close(wn);
}

dosetup(ch)                             /* setup */
int ch;
{
WINDOWPTR wn;
static char *msg = "Setup";

  if(ch == 99) return(NULL);
  wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
  wn_printf(wn,"  %s choice: %d,  Press any key to continue...............",msg,ch);
  v_getch();
  wn_close(wn);
}

dofileman(ch)                           /* file manager */
int ch;
{
WINDOWPTR wn;
static char *msg = "File";

  if(ch == 99) return(NULL);
  wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
  wn_printf(wn,"  %s choice: %d,  Press any key to continue...............",msg,ch);
  v_getch();
  wn_close(wn);
}

dooutput(ch)                            /* output manager */
int ch;
{
WINDOWPTR wn;
static char *msg = "Output";

  if(ch == 99) return(NULL);
  wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
  wn_printf(wn,"  %s choice: %d,  Press any key to continue...............",msg,ch);
  v_getch();
  wn_close(wn);
}

dorun(ch)                               /* single/batch mngr */
int ch;
{
WINDOWPTR wn;
static char *msg = "Run Manager";

  if(ch == 99) return(NULL);
  wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
  wn_printf(wn,"  %s choice: %d,  Press any key to continue...............",msg,ch);
  v_getch();
  wn_close(wn);
}

doedit(ch)                              /* edit mngr */
int ch;
{
WINDOWPTR wn;
static char *msg = "Edit";

  if(ch == 99) return(NULL);
  wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
  wn_printf(wn,"  %s choice: %d,  Press any key to continue...............",msg,ch);
  v_getch();
  wn_close(wn);
}

/************************* Miscellaneous Code *****************************/


nap(ticks)                              /* sleep a few clock ticks */
int ticks;
{
unsigned long tc;
unsigned long ts, te;

  ts = wns_gticks();                    /* get current tick count */
  do {
    if(chkesc()) return(NULL);
    te = wns_gticks();
    tc = te-ts;
  } while (tc < (unsigned long)ticks);
}

hiber(seconds)
int seconds;
{
  nap(seconds * 18);
  return(NULL);
}

chkesc()                                /* check for ESC while napping */
{
int c;

  if(v_kstat()) {
    c=v_getch() & 0x7f;
    switch(c) {
      case ESC:
        return(TRUE);
      case ETX:
        v_cls(7);
        v_locate(0,0,0);
        exit(0);
      default:
        return(FALSE);
    }
  }
  return(FALSE);
}

paktc()                                 /* press any key to continue */
{
  v_wtty(0x07);                         /* beep */
  v_getch();
  return(NULL);
}

/* End */
