/*****************************************************************************
*
* Header file for :
*
* Base to base conversion library. Version 1.0 Beta
* Copyright (C) 1995 Sammy Yousef
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
* This library provides routines for conversion of numbers between bases.
* Storing the number as a double floating point does cause inaccuracies in
* the translations. It has been tested under DOS, Linux and Unix System V
*
* This library was written for readability and ease of use NOT efficiency
*
* *##################*Use this library at your own risk.*###################*
*
* If you use this program and have any comments feel free to email me. 
* I would be most grateful for any feedback about either the quality of the
* code or the reliability of these routines.
*
* Author : Sammy Yousef
*              syousef@socs.uts.edu.au
*              syousef@ghostgum.itd.edu.au
*              sammy@ftoomsh.socs.uts.edu.au
*
*          Also known as Whiteheart on the talkers.
*
* Date   : 2 August 1995
*
*****************************************************************************/

/*************************** Definitions of Constants *************************/

#define MAXSTRINGIN 81          /* set maximum length of an input number */
#define MAXBASE 36              /* the maximum base supported by the program */
#define MAXSTRINGOUT 302        /* set maximum length of an output number to 
                                   a reasonable number - we couldn't allocate
                                   enough mem for the full range of conversion
                                   because worst case is as follows :
                                   based on converting from base 35 to base 2
                                   with 80 digits ie sqrt(35 to power 81) */ 
#define MAXDECIMAL 70           /* maximum number of decimal places in output */


/**************** Prototypes for input checking routines **********************/

int check_digit(int,char);
int check_numstring(int,char [MAXSTRINGIN]);
int check_bases(int,int);
int check_radix(char [MAXSTRINGIN]);


/******** Conversion between base 10 digit (integer) and base N digit *********/

int decimal_integer(char);
char character_integer(int);


/************ Whole and fraction conversion from base N to base 10 double *****/

double whole_to_ten(int,char [MAXSTRINGIN]);
double fraction_to_ten(int,char [MAXSTRINGIN]);


/***** Whole and fraction conversion from base 10 double to base N string *****/

void baseten_to_basex_whole(char[MAXSTRINGOUT],int,double);
void baseten_to_basex_fraction(char[MAXSTRINGOUT],int,double);


/***** Prototypes for splitting/recombining the whole and fractional parts *****
****** of a number *******/

int split_at_radix(char [MAXSTRINGIN],char [MAXSTRINGIN],char [MAXSTRINGIN]);
void recombine(char [MAXSTRINGOUT],char [MAXSTRINGOUT],char [MAXSTRINGOUT]);


/****************************** conversion between bases **********************/

int btb(int,int,char [MAXSTRINGIN],char [MAXSTRINGOUT]);

