/* 02 - Create data example for Bullet/REXX */
/* 3-Aug-96
   Calls made in this example:
   - blt_Init()
   - blt_DeleteFileDos()   [to delete test-generated files]
   - blt_CreateData()
   - blt_OpenData()        [file-level locks used]
   - blt_FlushDataHeader()
   - blt_ReadDataHeader()
   - blt_CopyDataHeader()
   - blt_ZapDataHeader()
   - blt_StatHandle()
   - blt_BackupFile()
   - blt_StatData()
   - blt_CloseData()
   - blt_Exit()
*/

/* Typically, each test routine's arg pack (blt_IP., etc.) is set to NOVALUE */
/* so that any unset variables can easily be identified.  In actual use, */
/* this would not be necessary since often arg pack values are already setup */
/* for multiple calls, where blt_?P.variable is already properly set up */

 say "Example: 02crd.cmd  (recommend output be redirected to a file)"

 call RxFuncAdd 'BulletLoadFuncs', 'BREXXI2', 'BulletLoadFuncs'
 call BulletLoadFuncs

 /* in case Bullet/REXX is still active, close it out */

 rez = blt_Exit()

 say
 say "calling blt_Init()"
 blt_IP.=NOVALUE
 blt_IP.JFTsize=5       /* must be 5 */
 rez = blt_Init()       /* init Bullet/REXX */
 say " blt_IP.func is" blt_IP.func
 say " blt_IP.stat is" blt_IP.stat  /* rez same as stat except for xactions */
 if rez = 0 then do

    say " blt_IP.versionDOS is" blt_IP.versionDOS
    say " blt_IP.versionOS is" blt_IP.versionOS
    say " blt_IP.versionBullet is" blt_IP.versionBullet
    /* say " blt_IP.exitPtr is" blt_IP.exitPtr */

    say
    say "calling blt_DeleteFileDos() x6 (02CRD.DB?, 02CRDcpy.DB?, 02BACKUP.?B?)"
    blt_DFP.=NOVALUE
    blt_DFP.filename = "02CRD.DBF"
    rez = blt_DeleteFileDos();
    say " blt_DFP.func is" blt_DFP.func
    say " blt_DFP.stat is" blt_DFP.stat "(02CRD.DBF) [stat=2, file not found, is possible]"

    blt_DFP.=NOVALUE
    blt_DFP.filename = "02CRD.DBT"  /* may use QuerySysVars for memo .EXT */
    rez = blt_DeleteFileDos();
    say " blt_DFP.stat is" blt_DFP.stat "(02CRD.DBT)"

    blt_DFP.=NOVALUE
    blt_DFP.filename = "02CRDcpy.DBF"  /* generated by blt_CopyDataHeader() */
    rez = blt_DeleteFileDos();
    say " blt_DFP.stat is" blt_DFP.stat "(02CRDcpy.DBF)"

    blt_DFP.=NOVALUE
    blt_DFP.filename = "02CRDcpy.DBT"  /* generated by blt_CopyDataHeader() */
    rez = blt_DeleteFileDos();
    say " blt_DFP.stat is" blt_DFP.stat "(02CRDcpy.DBT)"

    blt_DFP.=NOVALUE
    blt_DFP.filename = "02BACKUP.DBF"  /* generated by blt_BackupFile() */
    rez = blt_DeleteFileDos();
    say " blt_DFP.stat is" blt_DFP.stat "(02BACKUP.DBF)"

    blt_DFP.=NOVALUE
    blt_DFP.filename = "02BACKUP._BT"  /* generated by blt_BackupFile() */
    rez = blt_DeleteFileDos();
    say " blt_DFP.stat is" blt_DFP.stat "(02BACKUP._BT)"

    say
    say "calling blt_CreateData()"
    blt_CDP.=NOVALUE
    blt_CDP.filename = "02CRD.DBF"
    blt_CDP.noFields = 3
    blt_CDP.FD.1.fieldName = "SSN"
    blt_CDP.FD.1.fieldType = "N"
    blt_CDP.FD.1.fieldLen = 9
    blt_CDP.FD.1.fieldDC = 0
    blt_CDP.FD.2.fieldName = "NAME"
    blt_CDP.FD.2.fieldType = "C"
    blt_CDP.FD.2.fieldLen = 10
    blt_CDP.FD.2.fieldDC = 0
    blt_CDP.FD.3.fieldName = "ADDR"
    blt_CDP.FD.3.fieldType = "M"
    blt_CDP.FD.3.fieldLen = 10
    blt_CDP.FD.3.fieldDC = 0
    blt_CDP.fileID = 139        /* memo, too  (139 is 0x8B [hex]) */
    rez = blt_CreateData()      /* create data files: DBF and DBT */
    say " blt_CDP.func is" blt_CDP.func
    say " blt_CDP.stat is" blt_CDP.stat

    if rez = 0 then do
       say
       say "calling blt_OpenData()"
       blt_OP.=NOVALUE
       blt_OP.filename = blt_CDP.filename
       blt_OP.asMode = 18       /* 18 is 0x0012 [hex] DENYRW, R/W */
       rez = blt_OpenData()     /* see blt_Lock() for range locking */
       say " blt_OP.func is" blt_OP.func
       say " blt_OP.stat is" blt_OP.stat

       if rez = 0 then do
          say " blt_OP.handle is" blt_OP.handle
          blt_HP.=NOVALUE
          blt_HP.handle = blt_OP.handle
          say
          say "calling blt_FlushDataHeader()"  /* purely for demo purpose */
          rez = blt_FlushDataHeader()
          say " blt_HP.func is" blt_HP.func
          say " blt_HP.stat is" blt_HP.stat

          if rez = 0 then do
             blt_HP.=NOVALUE
             blt_HP.handle = blt_OP.handle
             say
             say "calling blt_ReadDataHeader()"  /* purely for demo purpose */
             rez = blt_ReadDataHeader()
             say " blt_HP.func is" blt_HP.func
             say " blt_HP.stat is" blt_HP.stat

             /* For blt_CopyData() when original handle has a memo file: */
             /*   must use different filename proper else memo create part */
             /*   of copy fails (err:80) [or use SetSysVars on memo .EXT] */

             if rez = 0 then do
                blt_CP.=NOVALUE
                blt_CP.handle = blt_OP.handle
                blt_CP.filename = "02CRDcpy.DBF"
                say
                say "calling blt_CopyDataHeader()"  /* purely for demo purpose */
                rez = blt_CopyDataHeader()
                say " blt_CP.func is" blt_CP.func
                say " blt_CP.stat is" blt_CP.stat

                if rez = 0 then do
                   blt_HP.=NOVALUE
                   blt_HP.handle = blt_OP.handle  /* zaps .DBF */
                   say
                   say "calling blt_ZapDataHeader()"  /* purely for demo purpose */
                   rez = blt_ZapDataHeader()
                   say " blt_HP.func is" blt_HP.func
                   say " blt_HP.stat is" blt_HP.stat

                   if rez = 0 then do
                      blt_SHP.=NOVALUE
                      blt_SHP.handle = blt_OP.handle
                      say
                      say "calling blt_StatHandle()"  /* purely for demo purpose */
                      rez = blt_StatHandle()
                      say " blt_SHP.func is" blt_SHP.func
                      say " blt_SHP.stat is" blt_SHP.stat

                      if rez = 0 then do
                         say " blt_SHP.ID is" blt_SHP.ID  /* unsigned */

                         /* generate backups of both 02CRD.DBF and 02CRD.DBT */

                         blt_CP.=NOVALUE
                         blt_CP.handle = blt_OP.handle
                         blt_CP.filename = "02BACKUP.DBF"
                         say
                         say "calling blt_BackupFile()"
                         rez = blt_BackupFile()
                         say " blt_CP.func is" blt_CP.func
                         say " blt_CP.stat is" blt_CP.stat

                         if rez = 0 then do
                            say
                            say "calling blt_StatData()"
                            blt_SDP.=NOVALUE
                            blt_SDP.handle = blt_OP.handle
                            rez = blt_StatData()
                            say " blt_SDP.func is" blt_SDP.func
                            say " blt_SDP.stat is" blt_SDP.stat
                            if rez = 0 then do

                               say " blt_SDP.handle is" blt_SDP.handle
                               say " blt_SDP.fileType is" blt_SDP.fileType
                               say " blt_SDP.flags is" blt_SDP.flags
                               say " blt_SDP.progress is" blt_SDP.progress
                               say " blt_SDP.morePtr is" blt_SDP.morePtr
                               say " blt_SDP.fields is" blt_SDP.fields
                               say " blt_SDP.asMode is" blt_SDP.asMode
                               say " blt_SDP.filename is '"blt_SDP.filename"'"
                               say " blt_SDP.fileID is" blt_SDP.fileID
                               say " blt_SDP.lastUpdate is '"blt_SDP.lastUpdate"'"
                               say " blt_SDP.records is" blt_SDP.records
                               say " blt_SDP.recordLength is" blt_SDP.recordLength
                               say " blt_SDP.xactionFlag is" blt_SDP.xactionFlag
                               say " blt_SDP.encryptFlag is" blt_SDP.encryptFlag
                               say " blt_SDP.herePtr is" blt_SDP.herePtr
                               say " blt_SDP.memoHandle is" blt_SDP.memoHandle
                               say " blt_SDP.memoBlockSize is" blt_SDP.memoBlockSize
                               say " blt_SDP.memoFlags is" blt_SDP.memoFlags
                               say " blt_SDP.memoLastRecord is" blt_SDP.memoLastRecord
                               say " blt_SDP.memoLastSize is" blt_SDP.memoLastSize
                               say " blt_SDP.lockCount is" blt_SDP.lockCount
                            end
                            else do
                               say "* ERROR * blt_StatData()"
                            end

                         end
                         else do
                            say "* ERROR * blt_BackupFile()"
                         end

                      end
                      else do
                         say "* ERROR * blt_StatHandle()"
                      end

                   end
                   else do
                      say "* ERROR * blt_ZapDataHeader()"
                   end

                end
                else do
                   say "* ERROR * blt_CopyDataHeader()"
                end

             end
             else do
                say "* ERROR * blt_ReadDataHeader()"
             end

          end
          else do
             say "* ERROR * blt_FlushDataHeader()"
          end

          /* if open, it's a good idea to close it (blt_Exit() if not) */

          blt_HP.=NOVALUE
          blt_HP.handle = blt_OP.handle
          say
          say "calling blt_CloseData()"
          rez = blt_CloseData()
          say " blt_HP.func is" blt_HP.func
          say " blt_HP.stat is" blt_HP.stat

       end
       else do
          say "* ERROR * blt_OpenData()"
       end

    end
    else do
       say
       say "* ERROR * blt_CreateData()"
    end

    say
    say "calling blt_Exit()"
    blt_EP.=NOVALUE
    rez = blt_Exit()
    say " blt_EP.func is" blt_EP.func
    say " blt_EP.stat is" blt_EP.stat
    say " blt_EP.rxAllocsLeft is" blt_EP.rxAllocsLeft
 end
 else do
    say
    say "* ERROR * blt_Init()"
 end

 exit 0
