/*         .c                       freeware                   xhunga@tiscali.fr
*/
/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
double f(
double x)
{
        return(x*x*x*x - x*x  + x - 2.0);
}
char  feq[] =    "x**4 - x**2 + x - 2.0";
/* -------------------------------------------------------------------------- */
double Df(
double x)
{
       return(4.0*x*x*x - 2.0*x + 1.0);
}
char Dfeq[] =  "4.0x**3 - 2.0*x + 1.0";
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */

/* --------------------------------- MAIN ----------------------------------- */
int main(void)
{
double (*Pfunct)     (double x);
double (*PfunctDeriv)(double x);

   int                  n = 7;

double                x_0;
double FirstApproximation = 1.5;
/*-------------------------------- PROGRAM ---------------------------------- */
 Pfunct      =  f;
 PfunctDeriv = Df;

 clrscrn();
 printf(" Use Newton's method to approximate .       \n\n");
 printf(" the largest positive real root of :\n\n");
 printf(" f : x-> %s\n\n", feq);
                       /* plot [xmin:xmax] [ymin:ymax] */
       gplt_f(-4,      /* xmin  */
               4,      /* xmax  */
              -4,      /* ymin  */
               4,      /* ymax  */
               feq
              );
 printf(" To see the graph of f, open the file \"f_Df.plt\" with Gnuplot.\n\n");
 printf(" You can see that, the largest positive real root\n");
 printf(" of f is between 1.0 and 2.0.\n\n");
 printf(" Choose x = %.1lf as a first approximation.\n\n",FirstApproximation);
 getchar();

 clrscrn();
 printf(" As a first approximation x = %.1lf \n\n",FirstApproximation);
 printf(" The Newton's method give :                \n\n");
 p_Newton_s_Method(FirstApproximation,
                   n,
           (*Pfunct),
           (*PfunctDeriv));
  getchar();

 clrscrn();
 x_0 = Newton_s_Method(FirstApproximation,
                                           n,
                                   (*Pfunct),
                                   (*PfunctDeriv));

                       /* plot [xmin:xmax] [ymin:ymax] */
    gplt_root(-4,      /* xmin  */
               4,      /* xmax  */
              -4,      /* ymin  */
               4,      /* ymax  */
               feq,
               (*Pfunct),
               x_0
              );

 printf(" To see the result, open the file \"f_Df.plt\" with Gnuplot.\n\n");

 printf("\n Press return to continue");
 getchar();

 return 0;
}

