/*         .c                       freeware                   xhunga@tiscali.fr
*/
/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
double f(
double x)
{
        return(x*x- cos(x));
}
char  feq [] = "x**2- cos(x)";
/* -------------------------------------------------------------------------- */
double Df(
double x)
{
          return(2.0*x + sin(x));
}
char  Dfeq [] = "2.0*x + sin(x)";
/* -------------------------------------------------------------------------- */
/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
double g(
double x)
{
        return(x*x);
}
char  geq [] = "x**2";
/* -------------------------------------------------------------------------- */
double Dg(
double x)
{
          return(2.0*x);
}
char  Dgeq [] = "2.0*x";
/* -------------------------------------------------------------------------- */
/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
double h(
double x)
{
        return(cos(x));
}
char  heq [] = "cos(x)";
/* -------------------------------------------------------------------------- */
double Dh(
double x)
{
          return(- sin(x));
}
char  Dheq [] = "- sin(x)";
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */

/* --------------------------------- MAIN ----------------------------------- */
int main(void)
{
double (*P_f)     (double x);
double (*PDf)(double x);

   int                  n = 6;
double                x_0;
double FirstApproximation = 0.8;
/*-------------------------------- PROGRAM ---------------------------------- */
 P_f      =  f;
 PDf = Df;


 clrscrn();
 printf(" Use Newton's method to approximate the intersection point of :\n\n");
 printf(" g : x-> %s\n\n", geq);
 printf(" and\n\n");
 printf(" h : x-> %s\n\n", heq);

                       /* plot [xmin:xmax] [ymin:ymax] */
      gplt_gh(-4,      /* xmin  */
               4,      /* xmax  */
              -4,      /* ymin  */
               4,      /* ymax  */
               geq,
               heq
              );
 printf(" To see the graphs of g and h, open the file \"f_Df.plt\" with Gnuplot.\n\n");
 printf(" You can see that, the intersection point is between 0.0 and 1.0.\n\n");
 printf(" Choose x = %.1lf as a first approximation.\n\n",FirstApproximation);
 getchar();


 clrscrn();
 printf(" In fact we want find x**2 = cos(x) or x**2 - cos(x) = 0.\n\n");
 printf(" We want find a root of\n\n");
 printf(" f : x-> %s\n\n", feq);
 getchar();

 clrscrn();
 printf(" As a first approximation x = %.1lf \n\n",FirstApproximation);
 printf(" The Newton's method give :                \n\n");
 p_Newton_s_Method(FirstApproximation,
                   n,
           (*P_f),
           (*PDf));
  getchar();

 clrscrn();
 x_0 = Newton_s_Method(FirstApproximation,
                                           n,
                                   (*P_f),
                                   (*PDf));

   P_f      =  g;
                       /* plot [xmin:xmax] [ymin:ymax] */
     gplt_gxh(-4,      /* xmin  */
               4,      /* xmax  */
              -4,      /* ymin  */
               4,      /* ymax  */
               geq,
               heq,
         (*P_f),
               x_0
              );

 printf(" To see the result, open the file \"f_Df.plt\" with Gnuplot.\n\n");

 printf("\n Press return to continue");
 getchar();

 return 0;
}

