/* f.h                    freeware                          xhunga@tiscali.fr */


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
double trapezoid(
double (*P_f)(double x),
double a,
double b,
   int n
)
{
   int i = 0;
double m = 0.;
double M = 0.;

 for(i = 0; i <= n; i++)
 {
    if(i ==0 || i== n){m = 1.;}
  else                {m = 2.;}

  M += m * (*P_f)(a + i*(b-a)/n);
 }

  return( ((b -a)*M) / (2*n) );
}


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
double simpson(
double (*P_f)(double x),
double a,
double b,
   int n
)
{
   int i = 0;
double m = 0.;
double M = 0.;

 for(i = 0; i <= n; i++)
 {
       if(i ==0 || i== n){m = 1.;}
  else if(fmod(i,2) == 0){m = 2.;}
  else                   {m = 4.;}

  M += m * (*P_f)(a + i*(b-a)/n);
 }

  return( ((b -a)*M) / (3*n) );
}


