/*
	Routine to provide interrupt driven I/O
	---------------------------------------
		Bill Hohensee
		Microcomputer Systems Lab
		1408 West University Avenue
		Urbana, Illinois  61801
		[217] 333-5272

	This routine is the basic bare minimum of a interrupt driven
	I/O scheme for the IBM-PC/XT.  It assumes communications thru
	COM1.  As characters come across the RS232 of COM1 they cause
	and interrupt which places the characters into a buffer.

	The main routine simply sits, and monitors any change in the
	in either the communications buffer, or from the keyboard. As
	characters are typed, they are sent up the line.  As they are
	received, they are displayed.  (Note things would be much faster
	if characters would put to the screen via the "write" function
	as opposed to the putchar.)  

	This code benefits greatly from the help of Computer Innovations
	staff, and Mr. Bob Kuphal at Bell Labs, Napier, Illinois.
*/

#include "stdio.h"

#define CTRL_C 3
#define COM1 0
#define COM2 1
#define BAUD_300 2
#define BAUD_600 3
#define BAUD_1200 4
#define BAUD_2400 5
#define BAUD_4800 6
#define BAUD_9600 7
#define ODD 1
#define NONE 2
#define EVEN 3
#define STOP_1 0
#define STOP_2 1
#define BITS_7 2
#define BITS_8 3

#define COMINT_VEC 12			/* Comm vector interrupt number */
#define COMBUF_SIZE 10240		/* Communications buffer size */
#define LCR	0x3fb			/* Line Control Register */
#define MCR	0x3fc			/* Modem Control Register */
#define MSR	0x3fe			/* Modem Status Register */
#define LSR	0x3fd			/* Line Status Register */
#ifdef skip
#define IOR	0x3f8			/* Communications I/O Register */
#define IER	0x3f9			/* Interrupt Enable Register */
#define RX_BUFFER 0x3f8			/* RX buffer (register) */
#endif
#define INTA00	0x20			/* 8259 Comm board COM1 Register 0 */
#define INTA01	0x21			/* 8259 Comm board COM1 Register 1 */
#define EOI 0x20			/* 8259 End of Interrupt */

struct regval { unsigned int ax,bx,cx,dx,si,di,ds,es; } ;

		/* External Declaractions */

char combuf[COMBUF_SIZE];	/* Communications buffer filled by comint */
int cptr,			/* Index into commuications buffer */
    head;			/* Current head of commuications buffer */
FILE *outp,*inp;	/* File ptrs for saving/sending files   */

int IOR,IER,RX_BUFFER;	/*  ints for defines as test */
int val_array[] = { 0x3f8,0x3f9,0x3f8 }; 
/* End of test */

	/***************************************************
	*        Allow Communications Interrupt            *
	***************************************************/

setcom()
{
	unsigned char bite, inportb();

	outportb(MCR, 0x0B);			/* Set MCR to allow ints */
	inportb (MSR, bite);			/* Clear Modem Status Reg */
	inportb (LSR, bite);			/* Clear Line Status Reg */
	inportb (val_array[0], bite);			/* Clear I/O Register */
	bite = inportb(LCR);
	bite &= 0x7f;
	outportb(LCR, bite);			/* Set DLAB to 0 */
	outportb(val_array[1], 0x01);			/* Enable Receive Data Ints */
	bite = inportb(INTA01);
	bite &= 0xef;
	outportb(INTA01, bite);			/* allow COM1 ints */
}


	/***************************************************
	*     Put character to the communications port     *
	***************************************************/

putrs(c)
char c;
{
	int flag;
	unsigned char inportb();


	outportb(MCR, 0x0b);	/* Request to send, and data terminal ready */
wait1:
	flag = inportb(LSR);
	if ((flag & 0x20) == 0) goto wait1;
	outportb(val_array[0], c);
	return(0);
}


	/***************************************************
	*  Get character from communications buffer ...    *
	*  Return it if available ... else return 0        *
	***************************************************/

getrs()
{
	int k;
	k = cptr;
	if (k == head)			/* No character in buffer */
		return(0);
	if (k > head) 			/* If tail > head, get character */
		return(combuf[head++]);
	if (head < COMBUF_SIZE)
		return(combuf[head++]);
	head = 0;			/* Reset head pointer */
	if (head < k)
		return(combuf[head++]);
	printf("ERROR is getrs()\n");
}


	/***************************************************
	*        Communications Interrupt Routine          *
	***************************************************/

comint()
{
	extern char combuf[];
	extern int cptr;
	unsigned char inportb(), cbuf;
	unsigned int  lsr_data;

	lsr_data = inportb(LSR);
	if ((lsr_data & 0x01) == 0) {		/* Check for char intrpt */
		outportb(MCR, 0x0b);		/* Reset MCR */
		outportb(INTA00, EOI);		/* Send EOI to 8259 */
		return;
	}
	cbuf = inportb(val_array[2]);	/* Read RBR for character */
	if (cptr >= COMBUF_SIZE)	/* Reset ring buffer pointer */
		cptr = 0;
	combuf[cptr++] = cbuf;		/* Add it to buffer */
	outportb(MCR, 0x0b);		/* Reset MCR */
	outportb(INTA00, EOI);		/* Send EOI to 8259 */
	return;
}



	/******************************************************
	*  Alternate between reading keyboard and com buffer  *
	******************************************************/

main()
{
   extern char combuf[];
	extern int  cptr;
	int index;
	int x;
	char rs, c;
	com_rst(COM1,BAUD_1200,NONE,STOP_1,BITS_8);
	setcom();	
	intrinit(comint, 5000, COMINT_VEC);	
	index = cptr = 0;		
	outp=fileget("out");
	for (;;) {
		if ((rs = getrs()) != 0) {	/* get char from com buffer */
	     putc(rs,outp);
	     putchar(rs);
		}
   	if (key_scan() != EOF) {	/* get char from keyboard */
			c = key_getc() & 0x00ff;
			if (c == CTRL_C)
				break;
			else {
				putrs(c);	/* send char over com port */
			}
		}
	}
	intrrest(COMINT_VEC);
}

/* PROGRAM TO OPEN AND/OR CREATE A FILE */
fileget(type)
char *type;

{
int retcode,c,i;
int inlen,outlen;
char inpf[15],outf[40],buff[80];
 	printf("\n%s is file type",type);

	if( *type == 'o' || *type == 'O') goto outfile;
	if (*type != 'i' || *type !='I') { printf ("\n bad file type");return (-1);}
/* Get input file name and check its existence  */

do {
printf("\n\n\n\tNAME OF TRANSMIT FILE?  : ");

retcode=fgets(inpf,15,stdin);
if (retcode==0) printf("\n\tINCORRECT READ OF FILE NAME");
		inpf[strlen(inpf)-1]='\0';


	if (!fexist(inpf))  
	   	{
	             printf("Cant open input file");
		     printf("\nDo you want to try to spell it right?");
		     printf("\nYES OR NO ?");   
	      		if(toupper(fgets(buff,80,stdin)=='N'))	{
	      		 printf("Let's go home");exit();	  }
              }
	else break;
     }     while(toupper(fgets(buff[0],80,stdin))!='N');
	/* File exists -- open it */

 	 inp=fopen(inpf,"r");

  return(inp);

outfile:  
  

/*  Get output file and check its existence  */
    do {

printf("\n\tNAME OF RECEIVE FILE? : ");
        retcode=fgets(outf,15,stdin);
   	if(retcode==0) printf("something  wrong"),exit(0);

		outf[strlen(outf)-1]='\0';

   	if (fexist(outf))  {	 
      printf("\n\tFILE EXISTS--DO YOU WANT TO OVERWRITE IT?");
		fgets(buff,80,stdin);
   }
   	else break;
   	}   while(toupper(buff[0])!='Y');

		outp=  fopen(outf,"w");

	  return (outp);
}

fexist(filname)
	char *filname;
	{
	char *fp;
	fp=fopen(filname,"r");
	if (fp) 
            {     fclose(fp);
                 return(1);
	         }
      else  return(0);
	}
  
















    