/* LADsoft C compiler Version 1.61 */

 



typedef unsigned size_t;

typedef long    fpos_t;


 
 

 

 

 

 

 
typedef struct  {
        int             level;           
        unsigned        flags;           
        char            fd;              
        unsigned char   hold;            
        int             bsize;           
        unsigned char   *buffer;    
        unsigned char   *curp;      
        unsigned        istemp;          
        short           token;           
}       FILE;                            

 


 

extern  FILE     *_pstreams[];   
extern  unsigned     _nfile;



void              clearerr(FILE *__stream);
int       fclose(FILE *__stream);
int       fflush(FILE *__stream);
int       fgetc(FILE *__stream);
int               fgetpos(FILE *__stream, fpos_t *__pos);
char   *  fgets(char *__s, int __n, FILE *__stream);
FILE   *  fopen(const char *__path, const char *__mode);
int       fprintf(FILE *__stream, const char *__format, ...);
int       fputc(int __c, FILE *__stream);
int       fputs(const char *__s, FILE *__stream);
size_t    fread(void *__ptr, size_t __size, size_t __n,
                     FILE *__stream);
FILE   *  freopen(const char *__path, const char *__mode,
                            FILE *__stream);
int       fscanf(FILE *__stream, const char *__format, ...);
int       fseek(FILE *__stream, long __offset, int __whence);
int               fsetpos(FILE *__stream, const fpos_t *__pos);
long      ftell(FILE *__stream);
size_t    fwrite(const void *__ptr, size_t __size, size_t __n,
                      FILE *__stream);
char   *     gets(char *__s);
void              perror(const char *__s);
int               printf(const char *__format, ...);
int               puts(const char *__s);
int              remove(const char *__path);
int       rename(const char *__oldname,const char *__newname);
void      rewind(FILE *__stream);
int               scanf(const char *__format, ...);
void              setbuf(FILE *__stream, char *__buf);
int       setvbuf(FILE *__stream, char *__buf,
                                   int __type, size_t __size);
int       sprintf(char *__buffer, const char *__format, ...);
int       sscanf(const char *__buffer,
                                  const char *__format, ...);
char   *  strerror(int __errnum);
FILE   *  tmpfile(void);
char   *  tmpnam(char *__s);
int       ungetc(int __c, FILE *__stream);
int       vfprintf(FILE *__stream, const char *__format,
                                    void *__arglist);
int       vfscanf(FILE *__stream, const char *__format,
                                   void *__arglist);
int              vprintf(const char *__format, void *__arglist);
int               vscanf(const char *__format, void *__arglist);
int       vsprintf(char *__buffer, const char *__format,
                                    void *__arglist);
int       vsscanf(const char *__buffer, const char *__format,
                                   void *__arglist);
int              unlink(const char *__path);
int               getc(FILE *__fp);

int               getchar(void);
int               putchar(const int __c);

int               putc(const int __c, FILE *__fp);
int               feof(FILE *__fp);
int               ferror(FILE *__fp);

int       fcloseall(void);
FILE    *  fdopen(int __handle, char *__type);
int       fgetchar(void);
int       flushall(void);
int       fputchar(int __c);
FILE    *    _fsopen (const char *__path, const char *__mode,
                  int __shflag);
int               getw(FILE *__stream);
int               putw(int __w, FILE *__stream);
int               rmtmp(void);
char    *   _strerror(const char *__s);
char    *   tempnam(char *__dir, char *__pfx);


int        _fgetc(FILE *__stream);            
int        _fputc(char __c, FILE *__stream);  
void      _InitEasyWin(void);   

 


 




typedef unsigned int uint;
typedef unsigned char BYTE;
typedef BYTE uchar;
typedef uint BOOL;
typedef unsigned short ushort;
typedef uint (* FUNC)();

 

typedef struct {
	BYTE *address;
	long size;
} EMSMEM;

 
typedef struct _list_ {
    struct _list_ *link;		 
		void *data;							 
} LIST;

 

typedef struct _hashrec_ {
   struct _hashrec_ *link;	 
   char *key;	 
} HASHREC;


 

                               

EMSMEM *AllocateEMSMemory(long size, BYTE fill);
void DeallocateEMSMemory(EMSMEM *mem);
void ResizeEMSMemory(EMSMEM *mem, long size);
BYTE *PtrToEMSMem(EMSMEM *mem, long offset);

                                

uint ComputeHash(char *string,int size);                           
HASHREC *AddHash(HASHREC **table, HASHREC *item);
HASHREC **LookupHash(HASHREC **table, char *key);
HASHREC **CreateHashTable(int size);
void RemoveHashTable(HASHREC ** t);

                              

void MemoryInit(uint size);
void MemoryRundown(void);
void release (void *buf);                                          
void *allocate(long size);                                         
void *ReallocateMemory(void *buf, uint size);
void *AllocateMemory(uint size);
void DeallocateMemory(void *pos);

                                

void AppendToList(LIST **list, void *data);
void *UnlinkFromList(LIST **list, LIST *loc);


typedef struct registry {
	struct registry *link;
	short *name;
	int canchange:1;
	int isdef:1;
	int isenv:1;
	int type;

	short *depends;
	struct {
		short *path;
		short *macro;
		short **commands;
	} x;
} REGISTRY;


 

                              

short *stripspaces(short *buf);                                    
void Redef(REGISTRY **r, int type, BOOL erronchange);               
void RegisterPath(short *buf,short *bufptr);
void RegisterTarget(short *name, BOOL infile);
void RegisterDest(short *name);
void RegisterMacro(short *name, short *value, BOOL def, BOOL canchange);
void RegisterImplicit(short *name, short **commands);
void RegisterExplicitName(short *name, short *value);
void RegisterExplicitCommands(short *name, short **commands);
void RegisterInit(void);

 

                               

void BadRepExt(void);                                              
REGISTRY *FindMacro(short *name);
short *ExpandString(short *string);



 

                                

BOOL openFile(char *string, char *path, char *mode);
void closeFile(void);
BOOL nextLine(char *buf, int len);
void NewLine(void);
int skipSpace(short **buf);
void Error(char *fmt,...);




typedef struct {
	int size;
	int style;
	int bgc;
	int fgc;
	int attrib;
	int bank;
	int cwb;
} PHITEXT;


 

                               

void PhiInit(void);
void BadString(void);
BOOL phichar(BYTE *ch, FILE *file);                                
BOOL philine(BYTE *buf, int len, FILE *file);
short parsechar(BYTE **buf);
void putphiback(short ch);
BOOL isstartchar(short val);
BOOL issymchar(short val);
BOOL iswhitespacechar(short val);
BOOL iscommentchar(short val);
BYTE *getstringchar(BYTE *rv,BYTE *bufptr);                        
short getphistring(BYTE *obuf, BYTE **ibuf, short endchar);
long getphichar(BYTE **ibuf);
void phifg(int color, BYTE *file);
short phiupper(short val);
int installphichar(short curchar, BYTE *buf, int i);
short phistreamtoflat(BYTE *out, BYTE *in, int size, BOOL useparms);
int phicmp(BYTE *str1, BYTE *str2);

                                

int pstrncmp(short *str1, short *str2,int n);
int pstrcmp(short *str1, short *str2);
void pstrcpy(short *str1, short *str2);
void pstrncpy(short *str1, short *str2, int len);
void pstrcat(short *str1,short *str2);
short *pstrchr(short *str, short ch);
short *pstrrchr(short *str, short ch);
int pstrlen(short *s);
short *pstrstr(short *str1, short *str2);

 


 

                                

uint ComputePhiHash(short *string,int size);                       
HASHREC *AddPhiHash(HASHREC **table, HASHREC *item);
HASHREC **LookupPhiHash(HASHREC **table, char *key);
HASHREC **CreateHashTable(int size);
void RemoveHashTable(HASHREC ** t);

extern HASHREC **hashtable;

static void BadRepExt(void)
{
	Error("Bad Replacement String");
}
REGISTRY *FindMacro(short *name)
{
	REGISTRY **r = LookupPhiHash(hashtable, name);
	if ((*r) && (*r)->type == 5 && (*r)->isdef)
		return(*r);
	return(0);
}
short *ExpandString(short *string)
{
	BOOL changed;
 do {
	short ibuf[4096],*d=ibuf,*s=string;
	short macname[100], ext1[100], ext2[100], *n;
	REGISTRY *r;
	changed = 0;
	while (*s) {
		if (*s == 0x24 && *(s+1) == 0x28) {
			s+=2;
			goto macroexpand;
		}
		else {
			if (*s == ((4 <<7) + 0x36)) {
				s++;
macroexpand:
				changed = 1;
				n = macname;
				while (*s && *s != 0x29 && *s != ((4 <<7) + 0x37) && *s != 0x3a
							&& *s != ((1<<7)+0x61))
					*n++ = *s++;
				*n = 0;
				switch (*s) {
					case 0x29:
					case ((4 <<7) + 0x37):
								s++;
							  r = FindMacro(macname);
								if (r) {
									short *s =r->x.macro;
									while(*s)
										*d++ = *s++;
								}
								break;
					case 0x3a:
					case ((1<<7)+0x61):
								s++;
							  r = FindMacro(macname);
								n = ext1;
								while(*s && (*s != 0x3d && *s != ((4 << 7) + 33) && n-ext1<19))
									*n++ = *s++;
								*n = 0;
								if (*s != 0x3d && *s != ((4 << 7) + 33))
									BadRepExt();
								if (*s) {
									s++;
									n = ext2;
									while(*s && (*s != 0x29 && *s != ((4 <<7) + 0x37) && n-ext1<19))
										*n++ = *s++;
									*n = 0;
								}
								if (*s)
									s++;
								n = d;
								if (r) {
									short *s =r->x.macro;
									while(*s) {
										if (!pstrncmp(s,ext1,pstrlen(ext1))) {
											pstrcpy(d,ext2);
											d+= pstrlen(ext2);
											s+= pstrlen(ext1);
										}
										else
											*d++ = *s++;
									}
								}
								*d = 0;
								break;
					default:
						Error("Unterminated macro");
				}
			}
			else {
				*d++ = *s++;
			}
		}
	}
	*d = 0;
	pstrcpy(string,ibuf);
 } while (changed);
  return(string);
}
