1.1) Introduccin general
1.2) Responsabilidad y autora
1.3) Cuestiones generales de configuracin
1.4) Parmetros de la lnea de comandos
1.5) Crditos
2.1) Compatibilidad ANSI
2.2) Caractersticas que faltan
2.3) Caractersticas del estilo de C++
2.4) Bugs conocidos
3.1) Libreras estndar en tiempo de ejecucin
3.2) Libreras DOS
4.1) Palabras clave dependientes de la implementacin
4.2) Funciones del preprocesador dependientes de la implementacin
4.3) Compatibilidad Phi-text
4.4) Ensamblador en lnea
5.1) Errores
6.1) Marcos de pila
6.2) Interfaz ASM
6.3) Segmentacin
6.4) Optimizaciones
6.5) Soporte de la unidad de coma flotante
7.1) Descripcin del rbol de directorios
7.2) Portando

----------------------------------------------------------------------

1.1) Introduccin general

CC386 es un compilador genrico de C para DOS 386. Todos los esfuerzos han sido
hechos para que reconozca una sintaxis ANSI estndar; sin embargo, NO debera
suponerse que produzca cdigo de acuerdo con el estndar ANSI, especialmente
respecto a la coma flotante. CC386 genera cdigo en lenguaje ensamblador
adecuado para TASM y NASM, y posiblemente funcionar con MASM.

Este paquete incluye varios programas de apoyo y las libreras requeridas para
construir cdigo que se ejecute bajo un servidor DPMI en DOS. El PMODE de Tran
se usa para el servidor; por eso, aunque no haya gestores de memoria los
programas generados por este paquete funcionarn de todos modos.

Necesitas TASM y TLINK para usar este paquete. Puedes conseguirlo con WLINK;
sin embargo TASM sigue siendo un requerimiento. El compilador en s generar
cdigo compatible con NASM, sin embargo este paquete no es suficiente para
que el cdigo ejecute bajo DOS.

Este paquete consiste en el compilador, algunas cosillas del DPMI de Borland
que actualmente se necesitan para el compilador, las libreras en tiempo de
ejecucin para el DOS y los ficheros de cabecera. Paquetes separados tienen
los fuentes del compilador y las libreras en tiempo de ejecucin.

Adicionalmente, el paquete incluye el programa 'CL386' que llamar al compilador
, al TASM, y al TLINK para crear programas para ti.

Aviso: debes tener una versin de TASM anterior a la 4.1; TASM 4.1 tiene
algunos bugs. El cdigo fue probado con la 4.0; posiblemente funcionar en la
3.0 y quizs en la 2.0.

Parte de las libreras en tiempo de ejecucin es una especie de debugger que
puede ser enlazado en el cdigo. Date cuenta que este debugger NO funcionar
en una ventana DOS desde Windows 95; sin embargo el resto del paquete s lo
har.

Nuevas caractersticas y bugs corregidos:

V1.50

Revisin de la coma flotante para conseguir que al menos funcione un poco.
Ahora que yo tengo coprocesador :).

Manejador de excepciones que funciona, incluyendo el manejo de la excepcin
de coma flotante que detectar si usas coma flotante cuando no hay coprocesador.

Revisin de todos los 'cast' implcitos para que funcionen correctamente.

Correccin de la generacin de cdigo de los punteros a funciones.

Correccin de las variables de tamao de bit usadas en las estructuras.

El ensamblador en lnea reconoce TODOS los cdigos de operacin del 486 (slo
en los modos de direccin de 32-bit).

Varias correcciones del debugger.

Adicin de las funciones SPAWN a las libreras en tiempo de ejecucin.

V1.52

Adicin de las funciones de coma flotante sprintf/scanf/atof para el x86.

Correcciones en algunas de las generaciones de coma flotante del x86.

Arreglos del compilador del 68K con lo que ahora construir correctamente las
libreras.

V1.63

Reconstruccin de herramientas de este paquete con herramientas de este
paquete. Han sido corregidos una variedad de bugs sutiles en el compilador.

Adicin de declaraciones pseudo-estticas de estructuras y arrays en la
seccin de variables auto de una funcin.

Reescritura del cdigo de librera para soportar NASM 097.

-----------------------------------------------------------------------

1.2) Responsabilidad y autora

Este compilador se presenta con unas bases 'tal cual' sin ningn tipo de
garanta de uso o conveniencia para ninguna aplicacin dada. Los riesgos
asociados a su uso, incluyendo tanto la prdida econmica como de vidas no
son responsabilidad de sus autores. Sin embargo, este compilador est destinado
a ser una herramienta educacional, y no debe ser usada comercialmente en ningn
caso sin el expreso consentimiento de los autores.

El autor original es Matthew Brandt. Segn l lo dej, era un compilador del
estilo de K&R sin coma flotante y un soporte mnimo de preprocesador, cuyo
objetivo slo era el m68k. La mayor parte del trabajo ha sido hecho en mquinas
Unix y ms tarde portado a DOS. Puedes encontrar su versin en uno de los
servidores de ficheros de Motorola por si quieres comparar. La versin actual
ha sido actualizada enormemente para soportar una variedad de construcciones
ANSI as como el i386 y mejores procesadores. Sin embargo, partes del programa
todava reflejan el trabajo de Matthew.

Yo he hecho parte de mi cdigo con compiladores de 16 y 32 bits de MS-DOS.
Esta versin del cdigo NO tiene caractersticas especficas de DOS y debera
ser portable a cualquier compilador ANSI de 16 o 32 bits.


----------------------------------------------------------------------

1.3) Cuestiones generales de configuracin

Para instalar la versin que crea los ejecutables de DOS, ejecuta el fichero
INSTALL.BAT. Necesitas darle un nombre de fichero:

install C:

Instalar los ficheros necesarios en la unidad C:. Se crear un rbol de
directorios bajo \CC386 y todos los ficheros necesarios se copiarn all.
Lee el fichero INTRO.DOS para ver rpidamente un resumen de cmo crear programas
para DOS.

La nica cosa realmente necesaria para que el compilador funcione es un puntero
a los directorios de include. Esto puede ser especificado en la variable de
entorno 'CCINCL' o con el comando /I en los parmetros de la lnea de comandos.
Yo normalmente establezco CCINCL=\cc386\include para coger las cabeceras ANSI
y entonces uso /I cuando necesito cualquier otro directorio. Si usas el fichero
INSTALL.BAT, CL386 se encargar de las cuestiones de include y libreras a
travs de su fichero de configuracin y no hay que hace nada ms que ejecutar
el programa INSTALL.

----------------------------------------------------------------------

1.4) Parmetros de la lnea de comandos

Los parmetros que lleven como prefijo un '+' o '-' son activados o desactivados
respectivamente. La ltima ocurrencia del parmetro es la que determina el
estado. Para estos parmetros '/' es equivalente a '-'. Ntese que los
parmetros de generacin de cdigo deben ser generalmente los mismos para todos
los mdulos, o si no, ocurrirn resultados impredecibles.


+e  - crea el fichero de errores
+i  - hace el fichero preprocesado
        por defecto est -i
/ffile - procesa los argumentos en el fichero 'file'
+l  - crea el fichero LST
        por defecto est -l
/w-all - no hay avisos, slo errores
         los avisos pueden ser suprimidos individualmente. Ver ERROR.DOC
-A  - desactiva la compatibilidad ANSI y permite algunas caractersticas no
      estndar
      por defecto est +A
/C  - parmetros de generacin de cdigo
        /C+d - muestra el diagnstico interno
        /C-b - no BSS
        /C-l - no pone cdigo C en el fichero ASM
        /C-m - no daa los smbolos que empiecen por un subrayado
        /C+p - agrupa variables para ahorrar espacio. En un 68020+ minimiza
               el alineamiento de la palabra
        /C+r - invierte el orden de las operaciones de bit
        /C+F - (386) fuerza la directiva .MODEL del TASM para usar el modo
               lineal. Esto podra estar por defecto en futuras versiones.
        /C+N - genera cdigo NASM
        /C-R - usa un puntero de pila en lugar de enlazar registros

        por defecto est /C+blmR-prFN
/Dxxx  - define el macro 'xxx'
/E##  - mximo nmero de errores para generar
/Idirs  - especifica los directorios include. Usa punto y coma para separar
          la especificacin de mltiples directorios. Los directorios
          especificados por la variable de entorno 'CCINCL' se buscan siempre
          primero.
/O  - parmetros del optimizador
        /O-Rxxx  desactiva las optimizaciones de los registros. En el lugar de
                 xxx pon cualquier combinacin de:

                 a - desactiva las optimizaciones de direccionamiento de
                     resgistros
                 f - desactiva las optimizaciones de los registros de coma
                     flotante
                 d - desactiva las optimizaciones de los registros de datos

        por defecto est que todas las optimizaciones de registros estn activas

+S  - reservado, no usado (todava)
        por defecto est -S

El compilador buscar el smbolo CC386 (o CC68K) en el entorno. Si lo encuentra,
evaluar cualquier argumento de la lnea de comandos que contenga con prioridad
a evaluar la lnea de comandos. Ntese que los parmetros de la lnea de
comandos predominarn a los de la variable de entorno; en particular,
especificar una bsqueda de path tanto en la variable de entorno como en la
lnea de comandos resultar en la prdida del entorno de bsqueda de path. Hay
una variable de entorno alternativa CCINCL que especifica los paths de los
include que sern aadidos a la especificacin de la lnea de comandos.

----------------------------------------------------------------------

1.5) Crditos

Las siguientes personas han contribuido con cdigo fuente en este paquete:

anakin@pobox.com  y  jules@earthcorp.com        - Ensamblador NASM
David Troendle      - Enlazador VAL
Kirill Joss         - Programa CL386
Kirill Joss         - Programa MK386
Kirill Joss         - Soporte del Watcom
TRAN (Thomas Pytel) - PMODE307 y PMODE/W para el soporte del DPMI
Charles Scheffold   - PMODE/W para el soporte del DPMI
Matthew Brandt      - Porciones del compilador de C
David Lindauer      - La utilidad de Make IMAKE e ITOUCH
David Lindauer      - Gestor de libreras XLIB
David Lindauer      - Compilador de C, libreras en tiempo de ejecucin y
                      hacerlo todo funcionar

Muchas personas colaboraron localizando bugs, me gustara mencionar a dos de
ellas que fueron especialmente tiles con *montones* de pruebas:

Johann Klockars
Kirill Joss

Y gracias a David Gurevich y Kirill Joss por las tiles sugerencias en el
empaquetamiento.

----------------------------------------------------------------------

2.1) Compatibilidad ANSI

Este compilador pretende ser compatible con ANSI a nivel de cdigo fuente.
Sin embargo nunca he visto la documentacin ANSI para lo que pretende; si
encuentras algo que no lo sea, hzmelo saber!

No obstante, no hay ninguna garanta de que el cdigo generado encuentre los
requerimientos ANSI en tiempo de ejecucin respecto al orden de evaluacin,
especialmente con los 'casts'. La coma flotante se hace usando el coprocesador,
y NO est ajustado para la compatibilidad ANSI/IEEE.

La librera en tiempo de ejecucin est diseada como una librera ANSI; de
cualquier manera internamente es un poco diferente. Especialmente desde que
me alej de los buffers estticos.


----------------------------------------------------------------------

2.2) Caractersticas que faltan

Lo siguiente se sabe que falta:

a) Las libreras no manejan operaciones matemticas con 'long double'
b) Operaciones de la forma:
        (T)

no son manejadas correctamente cuando T es un 'typedef'

-----------------------------------------------------------------------

2.3) Caractersticas del estilo de C++

El compilador de C tiene algn soporte rudimentario de C++. Reconoce:

1) Funciones sobrecargadas (pero no las palabras clave sobrecargadas)
2) Declaracin de variables en cualquier lugar
3) Variables de referencia
4) Parmetros de funcin por defecto
5) Comprobacin estricta de tipos
6) Inicializacin mejorada de punteros estticos y variables de referencia
7) Mensajes de error de C++ detallados

No estn soportadas todava las clases ni las palabras clave.

Para habilitar estas caractersticas usa la extensin .CPP en tu fichero de
entrada.

2.4) Bugs conocidos

Existen los siguientes bugs conocidos:

a) La evaluacin de expresiones es recursiva. Con una pila de compilador de 4K
el lmite es aproximadamente algo as:

        a = (b()+(c()+(d()+(e()+f()))));

El tamao por defecto de la pila tanto en el compilador como para los
ejecutables construidos es de 20K, por eso no deberas tener nunca problemas.
Por el momento no hay ningn modo para cambiar el valor por defecto salvo que
se alteren los fuentes del C0DOS?.OBJ.

b) Por el momento las sustituciones de macros NO se expanden a mltiples lneas.

c) Expresiones como:

        a = b = c;

Pueden no devolver el valor correcto para cualquier cosa que no sea la
asignacin ms a la derecha. En general funcionar, pero si hay 'casts'
implcitos mltiples yendo de una asignacin a la siguiente podra no funcionar
correctamente.

d) % podra no funcionar correctamente para divisiones con signo. El signo
podra ser errneo, pero el valor ser correcto. Esto podra o no ser un
problema. No lo he analizado.

e) El identificador 'pascal' es una palabra clave estndar antes que cualquier
cosa que el usuario pueda redefinir. Lo mismo para __abs__ y __fabs__ que son
las versiones en lnea de las funciones de valor absoluto.

f) El compilador todava se viene abajo bastante a menudo por secuencias de
cdigo no vlido. Esto ser direccionado en la siguiente versin; esto es
bastante estable cuando recibes errores externos al fuente.

----------------------------------------------------------------------

3.1) Libreras estndar en tiempo de ejecucin

Las libreras fueron implementadas de acuerdo con 'The Waite Group's Essential
Guide to ANSI C' - ISBN 0-672-22673-1. Mi copia es Circa 1989.

Todas las funciones en este libro fueron implementadas.
Sin embargo, la materia relacionada con los procesos de control est incompleta
por el momento. La mayor parte de las funciones de la librera de I/O, parte de
las de la librera time y de la librera malloc requieren soporte del sistema
operativo. La documentacin para esto se prove con los fuentes de la librera
en tiempo de ejecucin; sin embargo este paquete contiene suficiente cdigo
para usar el DPMI como el sistema operativo.

Podra haber una variedad de casos en los que las cosas no funcionen como se
espera. Por ejemplo, scanf slo leer una lnea, no importa qu..., cuando una
funcin como strftime requiere la longitud de un buffer para ser dada, los
resultados estn indefinidos si la longitud del texto excede la longitud del
buffer. Tambin he encontrado que abrir un fichero con el atributo 'a' supone
predominar cualquier intento de establecer la posicin para escribir en el
fichero... En esta implementacin todo ello lo que hace es posicionarse al final
del fichero al abrirlo.

Las libreras fueron originalmente diseadas de una manera reentrante; no
obstante esto rompe mucho cdigo estndar y la versin de las libreras
incluidas aqu tiene buffers estticos donde se las llama.

 Ahora se soporta ERRNO !

Muchas de las funciones de librera dependen de tener el cdigo startup/rundown
incluido. Este cdigo inicializa unas pocas variables globales y ejecuta
cualquier funcin startup/rundown que necesite la librera para la
inicializacin y borrado.

__MATHERR es soportado, sin embargo, algunas excepciones (OVERFLOW, UNDERFLOW,
STACK OVERFLOW) son enviadas a travs del manejador de excepciones del DPMI.

Para usar las libreras has de incluir dos ficheros en tu enlace. El primero es
el mdulo startup (C0DOS o C0DOSD) y el segundo es la librera en s misma
(CLDOS). Un ejemplo de construccin si _main est definida en q.c:

cc386 /C+N q.c
nasm -fobj q.asm
valx -use32 -nci \cc386\lib\c0dos q,q,q,\cc386\lib\cldos

Construir Q.EXE. Ntese que el mdulo de startup DEBE ser el primero mdulo
objeto especificado ya que define la configuracin de la segmentacin requerida.

Un camino alternativo para construir el programa es:

cl386 q
(o mk386 q)

Ambos programas son configurados por el programa de instalacin para usar NASM
y VALX; puedes modificar los ficheros .CFG en \cc386\bin  para elegir otra
combinacin de ensamblador/enlazador. CL386 es un programa shell estndar,
mientras que MK386 crea un fichero make y entonces ejecuta IMAKE.

Se proveen tres mdulos de puesta en marcha; C0DOS es un mdulo de inicio
estndar de C. C0DOSD es el mismo mdulo pero disear un debugger desde la
librera (aproximadamente unos 16K) y lo llamar cuando ejecutes tu cdigo. El
debugger es parecido al DEBUG. Cuando el debugger se ponga en marcha, el EIP y
los registros se establecern con los valores que deberan tener al principio
de tu funcin _main. El debugger atrapa varias excepciones incluyendo 'int 3'
por eso puedes poner int 3 en tu cdigo en aquellos lugares que quieras depurar.
El tercer mdulo de inicio, C0DOSW, est pensado para usarse con PMODE/W, y
adicionalmente podra funcionar con algunos otros extensores de PMODE cuando
uses WLINK.

Los fuentes de los mdulos de inicio de DOS estn incluidos en el directorio
\cc386\lib\startup en el caso que necesites modificarlos, pero en general esto
no ser necesario gracias a las directivas de inicio #pragma y a la directiva de
parada #pragma. Este fuente es tambin distribuido con el fuente RTL.

Los mdulos de inicio usan el PMODE de TRAN para gestionar los recursos del
PMODE. Yo uso la versin 3.07... He tenido que modificar el nombre de las clases
en sus declaraciones de segmentos para diferenciarlos de los segmentos de
cdigo de 32-bit, y he aadido tambin las funciones 0100, 0101, 0102 para
hacerlo ms compatible con otros extensores. Ahora lo llamo PMODE 308, y los
fuentes se distribuyen junto a los del RTL.

Gestiono varias excepciones; las que atrapan la 6, 13 y 14 son enviadas a travs
del cdigo de manejo de seales; por defecto imprime fallo de proteccin general
y sale, pero puedes atraparlas si quieres usando el mecanismo de seal.
Igualmente atrapa la 7, 8 y 16 relativas a coma flotante y son enviadas a travs
del cdigo de manejo de seal. Ests en una ventana DOS. El cdigo de manejo de
seal por defecto simplemente imprime un mensaje y salta al punto de salida del
programa...

Tambin gestiono la interrupcin CTRL-C desde el DOS (pero no CTRL-BRK desde
la BIOS, esto es manejado a travs de la interrupcin DOS) y sale del programa
limpiamente si se pulsa. Ntese que el CTRL-C no saldr del debugger. CTRL-C
SOLO ser cazado durante operaciones del sistema operativo, esto es, operaciones
de ficheros y de pantalla pero NO operaciones malloc/free. Puedes capturar el
CTRl-C si quieres a travs del manejador de excepciones.

----------------------------------------------------------------------

4.1) Palabras clave dependientes de la implementacin

a) Han sido aadidas las siguientes palabras claves dependientes de la
implementacin:

i386            uso
_interrupt      Genera una funcin que podra ser usada como una
                trampa/interrupcin.
_genbyte        Genera cdigo en el segmento de datos.
_absolute       Coloca una variable global en una direccin absoluta. Tales
                variables sern directamente direccionables y NO sern
                modificadas en el momento del enalce.
pascal          Fuerza a las declaraciones de funcin a usar las convenciones
                de llamada de Pascal.

b) Han sido aadidas las siguientes variables de implementacin. Estas variables
acceden directamente a los registros del lenguaje ensamblador cuyos nombres
coincidan con los suyos. Ntese que deberan ser usadas con precaucin y pueden
cambiar peridicamente a discrecin del compilador. Tambin, conversiones
forzadas de tipos o asignamientos con ellas pueden cambiar funcionalmente el
estado de la mquina... y arruinar el cdigo que ha generado el compilador.

i386
_EAX _EBX _ECX _EDX _ESP _EBP _ESI _EDI

El compilador de 386 tambin conoce la palabra clave 'asm' que es una salida
para permitir ensamblador en lnea. La sintaxis es:

asm mi_instruccin /* punto y coma opcional */

o

asm {
        mi lista de instrucciones /* punto y coma opcional */
    }

El compilador captura la mayora de los errores del cdigo en lnea de
ensamblador en tiempo de compilacin. Tambin traducir los nombres de las
variables locales en modos de direccionamiento propios basados en la pila.

----------------------------------------------------------------------

4.2) Funciones del preprocesador dependientes de la implementacin

El preprocesador es ms o menos compatible con ASNI.

Las siguientes declaraciones #pragma estn contempladas:

#pragma regopt xxx
        actualmente obsoleta

#pragma startup xxx #
        xxx debe ser el nombre de una funcin.
        # debera ser un valor de prioridad desde 20 - 90 (los otros valores
        son usados por la librera en tiempo de ejecucin). Funciones con mayor
        prioridad se ejecutan primero.

        Esta opcin le dice al compilador que informe a las rutinas de puesta
        en marcha que este funcin debera ejecutarse previamente a la llamada
        principal.

#pragma rundown xxx #
        xxx debe ser el nombre de un funcin.
        # deera ser un entero entre 20 y 90 (los otros valores son usados por
        las libreras en tiempo de ejecucin). Funciones con mayor prioridad se
        ejecutan primero.

        Esta opcin le dice al compilador que informe a las rutinas de puesta en
        marcha que esta funcin debera ser ejecutada despus de salir de main.

#pragma library(filename)
        Esta opcin da instrucciones al compilador de que inserte un
        recordatorio dicindole al enlazador que busque la librera llamada
        'filename'. Esto slo para cuando el ensamblador es el TASM.

#pragma packed
        Esta opcin fuerza a los nuevos miembros de estructura a que se agrupen,
        optimizado para ganar espacio en lugar de tiempo. En algunos caso, el
        agrupamiento es necesario, como por ejemplo, VALX necesita estructuras
        agrupadas para referenciar apropiadamente los 'records' OMF.

#pragma unpacked
        Esta opcin fuerza a los nuevos miembros de estructura a que se
        desagrupen, optimizando para ganar tiempo en lugar de espacio. Esta es
        la opcin por defecto y la mayor parte de las veces es suficiente, a
        menos que, por ejemplo, negociemos con una estructura de fichero
        comprimido como el OMF.

Las siguientes macros estn predefinidas:

        _i386_ (slo 386) el compilador est generando cdigo 386.
        _m68k_ (slo 68k) el compilador est generando cdigo 68K.

        __cplusplus si el compilador est permitiendo extensiones del C++
        __FILE__ el nombre de fichero del fichero fuente como una cadena.
        __DATE__ la fecha como una cadena.
        __TIME__ la hora como una cadena.
        __LINE__ el nmero de lnea como un nmero.

#if  las macros pueden usar define(xxx) para determinar si una macro est
     definida.

----------------------------------------------------------------------

4.3) Compatibilidad Phi-text

Este compilador es capaz de entender 'phi-text', que es un conjunto extendido de
caracteres de texto. Es algo preferible al UNICODE para los programadores
occidentales ya que no contempla cientos de caracteres que son poco usados por
la mayora de los occidentales.

Phi-text es un conjunto de caracteres por bancos. Cada carcter en su forma
completa es de 32-bit; esto contiene la siguiente informacin:

cwb:    un nmero entre 32 y 127 describiendo el carcter.
bank:   un banco desde 0 a 15. BANCO 0 es el conjunto de caracteres ASCII con
        con algunas modificaciones para controlar los caracteres.

Atributos bsicos: BOLD, UNDERLINE, ITALIC, HIDDEN y REVERSED. BLINKING puede
        sustituir a ITALIC, sin embargo normalmente usaremos ITALIC.

color:  16 definiciones de color. Los colores han sido elegidos para reflejar
        colores complementarios. Se puede especificar frente y fondo para cada
        carcter.

size:   atributo de 16 tamaos.
font:   atributo de 16 fuentes.


32 bits por cada carcter es demasiado para algunas aplicaciones; un aplicacin
puede elegir el ignorar ciertos campos. Este compilador ignora TODOS los campos
salvo 'bank' y 'cwb' (aunque podra mirar brevemente los atributos, no lo
recuerdo). Internamente, los caracteres son de este modo representados en este
compilador con campos de 16-bit.

Para facilitar los requerimientos de almacenamiento de cada uno de los conjuntos
de caracteres, existe una forma de phi-text en forma de 'flujo'. Esto toma
ventaja de la idea de que los atributos no suelen cambiar tan rpidamente como
la informacin del carcter. Bsicamente, si el bit ms alto de un byte en
forma de flujo est activado, indica que la informacin de control est
incrustada la cual indica los nuevos atributos. Hay tambin un cdigo de
repeticin, por eso las cadenas largas de caracteres repetidos (por ejemplo
espacios) se comprimen juntas. Esto no es tan eficiente como el tabular pero a
la larga esto funciona mejor puesto que hay varias situaciones en las que estas
cadenas pueden estar en phi-text  y NO siempre involucran espacios. En este
compilador, el texto entrante est en formato de flujo (el cual es por defecto
ASCII a menos que sea usado un editor apropiado). El formato de flujo es
convertido a un formato plano y toda la informacin es rayada excepto la
esencial para detectar el carcter. El preprocesado es hecho sobre la versin
plana... pero cuando la exploracin comienza a buscar seales se convierte de
nuevo la versin plana a la de flujo (menos los colores y los atributos) para
mayor eficiencia en el parser y acabado. Si el fichero fuente est en phi-text,
la lista y los ficheros en ensamblador sern tambin phi-text en forma de flujo;
la informacin del color es aadida al fichero de lista simplemente para hacerlo
un poco brillante, aunque yo tengo un monitor monocromo por eso los colores que
he cogido pueden ser desagradables.

Existe un problema con los fomatos de flujo: en caso de una situacin de error
es posible que se pierda una importante sincronizacin y por eso echar a perder
ms que un simple carcter. Por esta razn el phi-text en forma de flujo est
sincronizado parcialmente; al principio de cada lnea por defecto toda la
informacin de los atributos vuelve a la estndar por defecto. De esta forma
nunca se pierde ms de una lnea por la presencia de un simple error. E incluso
un editor inteligente podra ser diseado para ayudar a recuperar estos simples
errores... siempre que estos errores ocurran lo suficientemente a menudo como
para que valga la pena el esfuerzo.

Hemos visto que el phi-text est compuesto de 16 bancos con 96 caracteres por
banco, lo que da un total de 1536 caracteres. El primer banco es ASCII puro, con
unas pequeas modificaciones, pero qu son los otros bancos?. Casi la mitad de
ellos no se usan actualmente. De estos, algunos han sido deliberadamente
reservados por el diseador del phi-text para aplicaciones especficas y usos
especficos del sistema. Los caracteres definidos pueden dividirse a grosso modo
en los siguientes grupos:

1) Caracteres ASCII
2) Extensiones europeas (caracteres tildados)
3) Caracteres griegos
4) Caracteres cirlicos
5) Caracteres dibujados con lneas
6) Caracteres matemticos
7) Caracteres miscelneos

Minetras que ES posible extender ciertos operadores de C con representaciones
de caracteres ms compactas en un compilador como ste, el uso de phi-text ha
sido limitado para permitir caracteres griego y cirlicos en los nombres de las
variables, y para permitir cosas en cajas para ser tratadas como comentarios. El
editor principal de phi-text tiene una extensin que permite el uso de los
cursores para dibujar lneas en la pantalla, lo que hace generar cdigo ms
bonito en un momento.

Para ms informacin sobre el phi-text, contactar con:

Paul McKneely
P.O. BOX 5641
Pasadena, TX, 77508

E-Mail: gecko@onramp.net


----------------------------------------------------------------------

4.4) Ensamblador en lnea

        En ensamblador en lnea para el 386 est algo soportado;
La sintaxis es como sigue:

        asm mi_instruccin mi_lista_de_operandos ;

o
        asm {
                tantas lneas de cdigo como quieras ;
        }

Cada lnea de ensamblador DEBE ser seguida por un ';'. Puedes poner mltiples
lneas de cdigo en la misma lnea; sin embargo en caso de error, el ensamblador
en lnea saltar hasta la siguiente lnea a la del error encontrado.

La sintaxis se parece a la sintaxis del NASM para las instrucciones; esto es,
las palabras 'PTR' y 'OFFSET' no se usan. Puedes ponerlas, pero sern ignoradas
si lo haces. Adicionalmente, las variables DEBEN ser encerradas entre '[' y ']'
o el ensamblador en lnea considerar que te refieres a offsets.

Las optimizaciones estarn desactivadas para todas las variables que sean
usadas en cdigo del ensamblador en lnea.

Algunos modos de direccionamiento que parecen legales no lo son, por ejemplo:

myfunc()
{
       int a;
       asm {
                mov eax,[a+esi+eax];
       }
}

No es legal porque las variables locales estn referenciadas como offsets desde
ESP o EBP, y las instrucciones deberan ser cambiadas a:

mov eax,[EBP+const+esi+eax]

lo cual tiene demasidos registros ndice. La solucin aqu es hacer 'a' una
variable global, o hacer algo de la indexacin a mano.

Las variables indefinidas sern asumidas como declaraciones hacia delante de
etiquetas LOCALES. Se generar un error si la etiqueta no se define nunca. Si
necesitas acceder al nombre de una funcin que no ha sido declarada todava
debes prototiparla explcitamente previamente a usarla en el cdigo en lnea del
ensamblador.

El ensamblador en lnea NO hace ms cambios al cdigo que lanzarlo en ESP o
EBP para las variables locales.

La palabra clave 'short' se desconoce por el momento.

El ensamblador en lnea har una representacin interna del cdigo que escribas,
convirtindolo a la sintaxis del TASM o del NASM segn sea apropiado. La mayora
de las cosas se ensamblarn limpiamente; sin embargo, yo podra no haber sido lo
suficientemente estricto para cazar todos los errores que el TASM podra cazar
durante la fase de ensamblaje.

Se supone que el ensamblador en lnea conoce TODAS las instrucciones 486 y de
coma flotante del procesador disaponibles hasta el momento. Estoy escribiendo
un libro sobre el Pentium y podra aadir algunas instrucciones que no estn
disponibles en el 386, sobre todo algunas instrucciones de coma flotante del
Pentium. No puedo recordar qu procesador introduce AAD y AAM.

----------------------------------------------------------------------

5.1) Errores

Hay una lista de posibles errores. Hay dos tipos de errores... 'Errors' y
'Warnings'. Un 'error' significa una situacin que el compilador no puede
manejar, mientras que un 'warning' es un diagnstica que indica que algo est
posiblemente mal pero que el compilador lo asumir.

Esta lista est un poco atrasada; faltan algunos errores que puede generar el
ensamblador en lnea.

Cada 'warning' tiene un valor entre parntesis, este valor puede ser usado en
lnea de comandos para suprimir el 'warning'. El valor 'all' puede usarse para
suprimir todos los 'warning'. Los 'error' no pueden suprimirse.

Ejemplo

cc -w-ieq a.c  ; Suprime el aviso 'Possibly incorrect assignment'.
cc -w-all a.c  ; Suprime TODOS los 'warning'.

Algunos de los resultados de estos errores ocurren cuando el compilador est en
modo de C++.





Error: _int keyword not allowed in Pascal declarations

        Las declaraciones en Pascal no pueden ser usadas como trampas o
        interrupciones.

Error: Ambiguity between %s and %s

        C++. El compilador no puede elegir entre dos definiciones sobrecargadas
        casi equivalentes.

Warning: ('cln') Argument list too long %s

        La lista de argumentos para la llamada a funcin especificada es
        demasiado larga. El compilador ignora los argumentos extras.

Error: Argument list too long in redeclaration of function '%s'

        Una funcin prototipada ha sido redeclarada con una lista de argumentos
        diferente.

Error: Argument list too short %s
	
        Se han suministrado demasiado pocos parmetros en una llamada a funcin.

Error: Argument list too short in redeclaration of function '%s'

        Una funcin prototipada ha sido redeclarada con una lista de argumentos
        diferente.

Error: Bit field must be signed or unsigned int

        ANSI C requiere un campo de bit para ser uno de estos tipos.
        Si las extensiones estn permitidas, los campos de bit pueden ser de
        cualquier tipo entero.

Error: Bit field only allowed on scalar types

        Los campos de bit slo pueden ser usados en tipos enteros.
        Este error ocurrir si ests en un modo NO-ANSI y usas cualquier tipo
        no entero como base para un campo de bit.

Error: Bit field too big

        El campo de bit debe caber en el tamao dword del procesador.

Warning: ('pro') Call to function '%s' with no prototype 

        Una llamada a funcin ha sido hecha a una funcin que no ha sido
        previamente declarada. El compilador adivinar los tipos de los
        argumentos.

Error: Break or Continue outside loop

        'Break' y 'continue' no pueden ser usados fuera del mbito de un bucle.
        Use 'return' en su lugar.

Error: Cannot cast %s

        C++. Algunas conversiones de tipos no estn permitidas.

Error: Cannot define a pointer or reference to a reference

        C++. Las variabls de referencia son tratadas especialmente a este
        respecto.

Error: Cannot initialize '%s'

        Ha ocurrido un error mientras se intentaba procesar la inicializacin
        de una variable.

Error: Cannot modify a const val

        Un valor constante no puede ser modificado.

Error: Cannot open file \"%s\" for read access

        No se puede encontrar un fichero 'include'.

Error: Cannot overload 'main'

        C++. main() no puede ser sobrecargada.

Error: Cannot take address of bit field

        Los punteros a campos de bit no estn permitidos.

Error: Cannot use bit field as a non-member

        Slo miembros de estructura pueden tener un calificador de campo de bit.

Warning: ('cno') Code has no effect

        Esta lnea de cdigo compilado no hace nada.

Error: Constant value expected

        En inicializadores generales debe haber valores constantes. Algunos
        otros tambin podran.

Error: Constructor/destructor must be untyped

        C++ no puede tipar constructores/destructores.

Warning: ('cnv') Conversion may truncate significant digits

        Una conversin de tipos implcita podra resultar en la prdida de
        dgitos significantes. Este 'warning' NO se produce en las conversiones
        de tipos explcitas.

Error: Could not find a match for '%s'

        C++. Esta llamada a funcin no est prototipada, ya sea directamente o
        con una sobrecarga o un prototipo de funcin por defecto.

Warning: ('dpc') Dangerous pointer cast	

        Si recibes ste, pasar cuando el tamao de un puntero no es el mismo
        que el tamao del tipo (escalar) que ests usando con l.

Error: Declaration expected

        El 'parser' recibi una sentencia u otro valor cuando estaba esperando
        una declaracin.

Error: Declaration not allowed here

        El 'parser' encontr una declaracin cuando estaba esperando una
        sentencia.

Error: Default missing after parameter '%s'

        C++... Este parmetro se asumi que tena un valor por defecto que se
        ha perdido.

Error: Destructor for class '%s' expected

        C++. Se esperaba un destructor.

Error: Duplicate case %d

        Dos sentencias 'case' evalan el mismo valor.

Error: Duplicate label '%s'	

        La etiqueta aparece dos veces en el mismo procedimiento.

Error: Duplicate symbol '%s' 

        El smbolo ha sido redefinido.

Error: Ellipse (...) not allowed in Pascal declarations

        Declaraciones del estilo de Pascal no pueden tener argumentos variables.

Error: Expected '%c'

        El compilador esperaba una marca o carcter especfico.

Error: Expression expected

        El compilador estaba preparado para interpretar una expresin pero se
        encontr algo ms.

Error: File ended with comment in progress

        Los comentarios han de tener un punto final dentro del mismo fichero
        o fichero 'include'.

Error: File name expected in #include directive

        La directiva #include debe tener un nombre de fichero.

Error: Function declaration not allowed here

        Una declaracin de funcin ha sido intentada en un lugar no vlido,
        por ejemplo dentro de una estructura o dentro de otra funcin.

Warning: ('ret') Function should return a value

        Este error ocurre cuando una funcin no es del tipo 'void' y sale sin
        devolver un valor.

Error: Identifier expected

        El 'parser' estaba esperando un nombre de variable/funcin.

Error: Illegal call to main() from within program 

        C++. Los programas en C++ no pueden llamar a main().
												
Error: Illegal character '%c'

        El 'parser' detecto una secuencia de caracteres ilegal.

Error: Illegal pointer

        Se hizo un intento de usar un no-puntero en un contexto de puntero.

Error: Illegal pure declaration syntzx of '%s'

        C++. La sintaxis de una declaracin virtual es errnea.

Warning: ('irg')  Illegal register var '%s' 

        El tamao de la variable es demasiado grande para caber en un registro.

Error: Illegal storage class specifier '%s'

        Especificacin ilegal o conflictos en una declaracin.

Error: Illegal storage class specifier on '%s'

        Especificacin ilegal o conflictos en una declaracin.

Error: Illegal typedef of '%s'

        Intento de usar el nombre de un smbolo como un 'typedef'.

Error: Illegal use of reference operator

        Intento de usar '&' en un contexto en el cual no est permitido.

Error:  Illegal use of void pointer

        No se puede coger el tamao de un puntero 'void'.

Error: Inserted '%c'

        El 'parser' adivin un smbolo a insertar.

Error: Invalid '&' on register var '%s'	

        No se puede coger la direccin de un registro.

Error: Invalid floating point

        No se puede usar coma flotante en ciertos tipos de funciones matemticas
        (por ejemplo: funciones lgicas).

Error: Invalid preprocessor directive '%s'

        Directiva del preprocesador desconocida.

Error: Invalid trap id

        Especfica de la CPU. Indica que una operacin de la CPU (int o trampa)
        ha sido llamada con un identificador demasiado largo.

Error: '%s' is not a function

        No se puede llamar a algo que no es una funcin.

Error: '%s' is not a label

        No se puede saltar a algo que no es una etiqueta.

Error: Local class functions not supported

        C++. No se soportan definiciones de clases como variables locales.

Error: Local variables may not be used as parameter defaults

        C++. Los parmetros por defecto deben estar en un mbito previo a la
        llamada a la funcin.

Warning: ('lli') long long int type not supported, defaulting to long int

        El tipo 'long long int' ser interpretado correctamente pero no est
        implementado.

Error: Lvalue expected

        No se puede asignar a la direccin de una variable.

Error: Macro substitution error

        La expansin de macro est limitado a 4096 caracteres.

Error: Misplaced else

        Se ha encontrado un 'else' inesperado en una entrada de flujo.

Error: '%s' must be a predefined class or struct

        C++. No se puede trabajar con esta estructura/clase porque no ha sido
        definida totalmente.

Warning: ('zer') No memory allocated for '%s'	
	
        Un array no dimensionado no tiene inicializadores de todos modos.

Warning: ('nsf') Nonexistant static func '%s'	

        Un funcin esttica ha sido prototipada pero nunca declarada.

Warning: ('npo') Nonportable pointer conversion

        Una conversin implcita de puntero podra resultar en cdigo que
        compile incorrectamente con otros compiladores de C.

Error: Non-scalar array index

        Los ndices de arrays han de ser del tipo entero.

Error: Numeric constant is too large

        Una constante entera o hexadecimal era demasiado grande para el tipo
        base, o la parte no fraccional de un nmero en coma flotante podra no
        caber en un entero largo.

Error: Pointer type expected

        Se esperaba un puntero.

Warning: '(ieq') Possible incorrect assignment

        El smbolo '=' ha sido usado en un mbito diferente al de una expresin
        'if'.
        Esto podra ser deseado, pero a menudo es una equivocacin con el
        smbolo '==' por eso el compilador te avisa.

Warning: ('san') Possible superfluous &

        & no es necesario cuando se coge la direccin de un array. Este es un
        mensaje basura; ANSI C no lo tiene en cuenta de cualquier modo.

Warning: ('sud') Possible use of '%s' before assignment

        Una variable ha sido usada pero posiblemente no iniciada con un valor.

Warning: ('ipd') Preprocessor directive ignored

        Un reconocimiento #PRAGMA CC ha sido ignorado. Actualmente esto
        significa que el ensamblador/enlazador seleccionado no soporta el
        #pragma. Ntese que este error NO ser generado si el compilador no
        reconoce la sentencia #pragma en absoluto.

Error: Reference initialization needs lvalue

        C++. Llamadas de sintaxis de referencia para algo cuya direccin puede
        ser cogida.

Error: Reference member '%s' in a class with no constructors

        C++. La variable de referencia no puede ser iniciada como clase de
        inicio porque el constructor se supone que lo hace.

Error: Reference variable '%s' must be initialized

        C++. No se puede cambiar aquello a lo que es igual una variable de
        referencia en tiempo de ejecucin.

Error: Return type is void	

        Intento de devolver un valor desde una funcin 'void'.

Error: Size is unknown or zero

        Intento de usar el tamao de una variable con un tipo que ha sido
        declarado ms adelante.

Error: Size of '%s' is unknown or zero

        Intento de usar el tamao de una variable con un tipo que ha sido
        declarado ms adelante.

Error: Startup/rundown function '%s' is unknown or not a function

        Un nombre de funcin en el '#pragma startup' o '#pragma rundown' no es
        una funcin o no est definida.

Error: String constant too long

        Una cadena de mltiples lneas es muy larga.

Warning: ('spc') Suspicious pointer conversion

        Una operacin de punteros est siendo realizada en punteros que tienen
        diferentes tipos base.

Warning: ('fun') Static function '%s' is declared but never used

        Esta funcin esttica simplemente est desaprovechando espacio.

Warning: ('sud') Static variable '%s' is declared but never used
	
        Esta variable esttica simplemente est desaprovechando espacio.

Warning: '(fsu) Structure '%s' is undefined

        El compilador complet con una estructura cuyo tipo jams fue definido.

Error: Switch argument must be of integral type

        Los argumentos como parmetros han de ser enteros.

Warning: ('tua') Temporary used for parameter %s

        C++. Una constante ha sido pasada en un parmetro de referencia y el
        compilador automticamente cre una variable para que la funcin llamada
        est feliz.

Warning: ('tui') Temporary used to initialize %s

        La variable de referencia est inicializada con una constante; se ha de
        crear almacenamiento extra para ello.

Error: Too many initializers

        Una estructura/array tiene demasiados inicializadores.

Error: Type expected in sizeof

        El argumento de 'sizeof' no era un tipo o una variable.

Error: Type mismatch

        Tipos no coinciden.

Error: Type mismatch in arg '%s'

        Tipos no coinciden en las llamadas a funcin.

Error: Type mismatch in redeclaration of '%s'

        Una variable ha sido redeclarada con un tipo distinto al anterior.

Error: Type mismatch in return

        El valor que est siendo devuelto no coincide con el tipo de la funcin.

Error: Unbalanced preprocessor directives

        Las directivas #if - #endif no estn equilibradas.

Warning:   Undefined label '%s' 

        La etiqueta debera aparecer en algn lugar ya que hay un 'goto' hacia
        ella.

Error: Undefined symbol '%s' 

        Este es un smbolo desconocido.

Error: Unexpected '%s'

        Esta palabra clave era inesperada.

Warning: (' urc') Unreachable code

        El flujo de cdigo no puede llegar nunca aqu.

Warning: ('lun') Unused label '%s'	

        Una etiqueta fue declarada pero nunca usada.

Error: User error: %s

        La directiva #error es devuelte en ste.

Warning: ('sas') Variable '%s' is assigned a value which is never used

        Despus de la asignacin a la variable, no hay un uso subsiguiente.

Error: Variable '%s' cannot have a type qualifier

        C++. ???

Error: Variable '%s' is not a class instance

        C++. Se esperaba un ejemplo de clase.

Warning: ('sun') Variable '%s' is declared but never used

        Esta variable fue declarada pero nunca se hace referencia a ella.
        Espacio desaprovechado.
												
----------------------------------------------------------------------

6.1) Marcos de pila

Hay una variedad de opciones para los marcos de pila.

a) Marcos de pila con estilo de C estndar. Se usa un registro ndice (EBP o A6)
para apuntar a un valor entre los parmetros y las variables locales de la
funcin; todas las variables locales y los parmetros de la funcin estn
indexados desde este registro. Esto est por defecto.

b) El compilador puede liberar el registro de enlace e indexar todas las
variables locales y los parmetros de la funcin desde el puntero de pila.

c) (Slo 68K) Las listas de parmetros pueden ser localizadas en cualquier lugar
en la memoria; el puntero a la lista de parmetros es pasado en A0. Entonces A0
es transferido a A6 y los parmetros son indexados desde A6. Mientras tanto las
variables locales son indexadas desde el puntero de pila.

En el 68K, hay disponibles algunas opciones de generacin de cdigo. Por defecto
el compilador de 68K genera cdigo PIC basado en un modelo de memoria de 32K.
Hay disponibles el modo 68020 para caractersticas extendidas especficas del
68020 como los modos de direccionamiento mejorados e instrucciones
especializadas. Otra opcin es generar cdigo 68000 en vistas a que se pueda
usar una seccin de datos mayor que 32K. La ltima opcin permite desactivar
el modo PIC y generar cdigo que ser colocado en direcciones absolutas en
memoria.

El cdigo 386 es bastante sencillo. Es un poco ms complicado de lo necesario
porque necesita usar registros de funcin especial para algunas operaciones
como las multiplicaciones y los desplazamientos. El cdigo 386 ser un poco ms
voluminoso debido a esta necesidad.

Nota: el tamao por defecto de la pila para el extensor de DOS PMODE308 es 20K.
Debido a un bug en Windows estos 20K se incluye actualmente en cada uno de los
ejecutables. 20K es suficiente para las vasta mayora de las aplicaciones, sin
embargo, si necesitas ms que esto puedes modificar el equivalente a
"PROGRAM_STACK" en el fichero \LIB\C0DOS.ASM o C0DOS.NAS y reensamblarlo.
Entonces usa el nuevo fichero objeto en lugar del original. Si ests usando otro
extensor distinto del PMODE308, el mtodo para cambiar el tamao de la pila
depende del enlazador. En una futura versin de este compilador cogeremos el
equivalente de C0DOS.ASM y lo haremos una opcin del enlazador.

6.2) Interfaz ASM

El programa en lenguaje ensamblador no debe modificar ningn registro excepto
los registros:

386:    EAX, ECX, EDX

Los parmetros son pasados a la pila, con el parmetro ms a la izquierda en
la direccin ms baja.

En todas las situaciones de ensamblador es conveniente usar un registro ndice
para indexar los parmetros. El registro ndice debe ser cargado con la
direccin del primer parmetro (que ser el puntero de pila + 4 si no metes
el registro ndice, o el puntero de pila + 8 si lo haces). Los parmetros
ocupan normalmente 4 bytes para los tipos de dato estndar; sin embargo los
tipos 'double' y 'long double' ocupan 8 y 12 bytes respectivamente. Si pasa una
estructura por valor la cantidad de espacio de pila usado depende del tamao de
la estructura.

Nota: por defecto el compilador de C intenta alinear todos los datos en lmites
que haga las bsquedas de datos ms efectivas. Esto es, si defines una
estructura tanto en un cabecera C como ASM, deberas examinar el fichero LST
que produce el compilador de C para la estructura para ver el relleno correcto
en la versin ASM. Otra alternativa es empaquetar la estructura con la opcin
/C+p o el agrupamiento #pragma.

----------------------------------------------------------------------

6.3) Segmentacin

Los siguientes segmentos o secciones podran aparecer en el fichero de salida:

Nombre 386      uso
.CODE           Constantes de cdigo y de cadena
.DATA           Datos globales inicializados
.?DATA          Datos globales no inicializados
INITDATA        Enlaces #pragma de puesta en marcha
EXITDATA        Enalces #pragma de finalizacin
CPPDATA         Inicializaciones estticas de C++

Las siguientes opciones afectan a la generacin de cdigo:

/C-b            Combina el BSS con el DATA
/C-l            No pone los nmeros de lnea en le fichero ASM
/C-m            No mutila los subrayados
/C+p            Empaqueta las variables
/C+r            Usa orden inverso en los campos de bit.
                Ntese que esta opcin invierte el orden de colocacin pero no
                invierte el valor en el campo.

Las siguientes sentencias #pragma afectan a la generacin de cdigo:

#pragma regopt  - Activa/desactiva la distribucin de registros
#pragma startup - Nombra una rutina para ser ejecutada en la puesta en marcha
#pragma rundown - Nombra una rutina para ser ejecutada en la finalizacin

----------------------------------------------------------------------

6.4) Optimizaciones

El compilador realiza las siguientes optimizaciones:

a) Plegado de constantes

Cuando una operacin matemtica comn se realiza con constantes, el compilador
evaluar la expresin y la sustituir con una constante.

b) Reducciones a la fuerza

Multiplicar y dividir son convertidos en desplazamientos cuando sea apropiado.
Los mdulos se sustituyen por 'and' cuando sea apropiado.

c) Optimizacin de destino

Cuando el destino de una asignacin es conocido, no se utilizar un registro
temporal, si no que el destino ser usado directamente. Esto nos libra de
generar registros temporales muertos que tendrn que ser optimizados
innecesariamente ms tarde en el 'icode'.

d) Eliminacin del cdigo muerto

Borra saltos a saltos, saltos a la siguiente sentencia y cdigo muerto. Tambin
borra cualquier cosa temporal que llegue con aquello que actualmente no se use.

Ntese que las libreras SETJMP por ejemplo NO grabarn el estado de los
registros de coma flotante. Por eso hay una opcin para desactivar la
optimizacin de los registros de coma flotante en el caso que necesites
establecer un salto a una rutina que use coma flotante. Las optimizaciones de
direcciones y de registros de datos tambin pueden ser desactivadas. Ver
SWITCHES.DOC.

e) Reordenar expresiones

En algunos casos el compilador genera mejor cdigo si las expresiones estn
reordenadas, por ejemplo:

  a = a + 10;

Se puede cambiar a  a+=10  y se genera mejor cdigo. Tambin, se ha puesto mucho
empeo en optimizar el uso de los modos base/indexado del procesador cuando se
pueda. La versin actual usar incluso escalado del registro ndice cuando sea
posible!

f) Modos de direccionamiento base+ndice

Este compilador avanza un poco para identificar cundo se podra usar el modo de
direccionamiento base+ndice para generar una direccin.

6.5) Cdigo FPU

esta versin utiliza el procesador de coma flotante. No garantizo que los
algoritmos matemticos que he implementado estn optimizados para la mayor
precisin. Tambin, mientras se implementa el manejo de la excepcin de FPU no
estoy seguro de que lo haya hecho bien y por eso podra cambiar en la siguiente
versin.

----------------------------------------------------------------------

71.) Descripcin del rbol de directorios

Los fuentes de este compilador estn incluidos en paquetes separados.

Los fuentes deberan ser genricos; esto es, deberan funcionar en cualquier
arquitectura donde el tamao del byte sea 8. Sin embargo, he usado en mi editor
una configuracin extraa del tabulador. Si quieres comprender los fuentes coge
algn embellecedor o algo por el estilo y ejecuta los fuentes primero a travs
de l; o pon el tabulador de tu editor a 2 para ver lo que yo veo.


La estructura de directorios es:

CLIBS
        varios fuentes para la librera en tiempo de ejecucin
DOC
        documentacin
EXAMP
        un ejemplo simple
        (hay uno ms complejo en  clibs\startup\test )
INCLUDE
       ficheros de cabecera del compilador
OBJECT
       ficheros make/objeto del compilador
SOURCE
       ficheros fuente del compilador

Hay dos grupos de fuentes:
   1) el compilador, en los directorios SOURCE, INCLUDE y OBJECT .
   2) libreras que puedes usar en conjuncin con el compilador para generar
      programas (libreras en tiempo de ejecucin del fichero destino), en el
      directorio CLIBS.

A menudo uso el conjunto de los tres directorios:
        SOURCE
        OBJECT
        INCLUDE

Para un proyecto dado no llenar desordenadamente un simple directorio con
docenas de ficheros. Cuando uso estos tres, los fuentes estn en el directorio
SOURCE, las cabeceras de las que dependen los fuentes en el directorio INCLUDE,
y puedes esperar que cambie al directorio OBJECT para compilar el programa...
por eso encontrars los ficheros 'make' aqu.

Para estos tres tienes que usar un 'path' que incluya al directorio INCLUDE
cuando compiles los ficheros fuente.

PROTO.BAT genera el fichero INCLUDE\CC.P; que es un fichero prototipo como el
que estoy usando para mantener al compilador a mi gusto. No deberas tener que
cambiarlo a menos que hagas grandes cambios en los fuentes... aunque puedes
editar el CC.P directamente y poner los nuevos prototipos en l si quieres. A
menudo yo lo hago. Slo uso PROTO.BAT cuando estoy haciendo grandes cambios en
el compilador.

7.2) Portando

Se supone que esta versin del compilador es portable; slo se necesita
reescribir los retoques finales para un objetivo dado. Esta portabilidad
posiblemente slo se extienda a procesadores con una arquitectura de byte.

Los siguientes smbolos han de ser definidos en la lnea de comandos:

-DPROGNAME="CC386"              ; Nombre del programa que aparecer en la banda.
-DENVNAME="CC386"               ; Nombre de la variable de entorno a consultar
                                  para los parmetros de la lnea de comandos.
-DGLBDEFINE="_i386_"            ; Smbolo para definir en el fuente; puede ser
                                  usado para identificar las necesidades de un
                                  procesador especfico.
-DSOURCEXT=".ASM"               ; Extensin a usar para el fichero de salida.

Estas definiciones son importadas por CMAIN.C para definir el entorno del
programa. Te he mostrado las definiciones usadas por el compilador 386;
cmbialas segn sea necesario para tu objetivo.

Los siguientes ficheros comprenden el resultado del 386. Son todos los que
deberas cambiar para portar el compilador a un nuevo procesador. Te sugiero que
los renombres a algo ms antes de que los cambies:

an386.c         - Optimizacin de los registros.
reg386.c        - Distribucin de los registros para las expresiones.
conf386.c       - Configuracin; tamaos de los enteros, registros libres y
                  dems cosas.
outas386.c      - Da el cdigo ASM.
gexpr386.c      - Convierte los rboles de interpretacin de expresiones en
                  cdigo.
gstmt386.c      - Convierte los rboles de interpretacin de 'stmt' en cdigo.
peep386.c       - Anlisis de mirilla para este procesador.

Para ms informacin de portabilidad, contactar con el autor del cdigo.

David Lindauer (gclind01@starbase.spd.louisville.edu)
