#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <libp.h>

int fseek (FILE *stream, long offset, int origin)
{
	if (stream->token != FILTOK)
		return EOF;
	if (!(stream->flags & _F_APPEND)) {
		switch (origin) {
			case SEEK_CUR:
			case SEEK_SET:
			case SEEK_END:
				if (fflush(stream)) {
					stream->flags |= _F_ERR;
					return EOF;
				}
				if (_ll_seek(stream->fd,offset,origin)) {
					stream->flags |= _F_ERR;
					errno = EIO;
					return EOF;
				}
				
				break;
			default:
				return EOF;
		}
	}
	return 0;
}